/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.multilang.DrainChildSTDOUTTask;
import com.amazonaws.services.kinesis.multilang.GetNextMessageTask;
import com.amazonaws.services.kinesis.multilang.messages.Message;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class MessageReader {
    private BufferedReader reader;
    private String shardId;
    private ObjectMapper objectMapper;
    private ExecutorService executorService;

    MessageReader() {
    }

    Future<Message> getNextMessageFromSTDOUT() {
        GetNextMessageTask getNextMessageTask = new GetNextMessageTask(this.objectMapper);
        getNextMessageTask.initialize(this.reader, this.shardId);
        return this.executorService.submit(getNextMessageTask);
    }

    Future<Boolean> drainSTDOUT() {
        DrainChildSTDOUTTask drainTask = new DrainChildSTDOUTTask();
        drainTask.initialize(this.reader, this.shardId);
        return this.executorService.submit(drainTask);
    }

    MessageReader initialize(InputStream stream, String shardId, ObjectMapper objectMapper, ExecutorService executorService) {
        return this.initialize(new BufferedReader(new InputStreamReader(stream)), shardId, objectMapper, executorService);
    }

    MessageReader initialize(BufferedReader reader, String shardId, ObjectMapper objectMapper, ExecutorService executorService) {
        this.reader = reader;
        this.shardId = shardId;
        this.objectMapper = objectMapper;
        this.executorService = executorService;
        return this;
    }
}

