/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.RandomWalkOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class ClusterWalkOperator
extends AbstractAdaptableOperator {
    private Parameter parameter = null;
    private double windowSize = 0.01;
    private List<Integer> updateMap = null;
    private final BoundaryCondition condition;
    private final Double lowerOperatorBound;
    private final Double upperOperatorBound;

    public ClusterWalkOperator(Parameter parameter, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        this(parameter, null, d, boundaryCondition, d2, adaptationMode);
    }

    public ClusterWalkOperator(Parameter parameter, Parameter parameter2, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        this(parameter, parameter2, d, boundaryCondition, d2, adaptationMode, null, null);
    }

    public ClusterWalkOperator(Parameter parameter, Parameter parameter2, double d, BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode, Double d3, Double d4) {
        super(adaptationMode);
        this.parameter = parameter;
        this.windowSize = d;
        this.condition = boundaryCondition;
        this.setWeight(d2);
        if (parameter2 != null) {
            this.updateMap = new ArrayList<Integer>();
            for (int i = 0; i < parameter2.getDimension(); ++i) {
                if (parameter2.getParameterValue(i) != 1.0) continue;
                this.updateMap.add(i);
            }
        }
        this.lowerOperatorBound = d3;
        this.upperOperatorBound = d4;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public final double getWindowSize() {
        return this.windowSize;
    }

    @Override
    public final double doOperation() {
        double d;
        System.out.println("Walking cluster");
        int n = this.updateMap == null ? MathUtils.nextInt(this.parameter.getDimension()) : this.updateMap.get(MathUtils.nextInt(this.updateMap.size()));
        double d2 = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double d3 = this.parameter.getParameterValue(n) + d2;
        Bounds<Double> bounds = this.parameter.getBounds();
        double d4 = this.lowerOperatorBound == null ? bounds.getLowerLimit(n) : Math.max(bounds.getLowerLimit(n), this.lowerOperatorBound);
        double d5 = d = this.upperOperatorBound == null ? bounds.getUpperLimit(n) : Math.min(bounds.getUpperLimit(n), this.upperOperatorBound);
        if (this.condition == BoundaryCondition.reflecting) {
            d3 = RandomWalkOperator.reflectValue(d3, d4, d);
        } else if (d3 < d4 || d3 > d) {
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, d3);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    public String toString() {
        return "ClusterWalkOperator(" + this.parameter.getParameterName() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }

    public static enum BoundaryCondition {
        reflecting,
        absorbing;

    }
}

