/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.BooleanStatistic;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class MonotonicStatistic
extends Statistic.Abstract
implements BooleanStatistic {
    public static final String MONOTONIC_STATISTIC = "monotonicStatistic";
    public static final String STRICTLY = "strictlyMonotic";
    public static final String ORDER = "order";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("order", true), AttributeRule.newBooleanRule("strictlyMonotic", true), new ElementRule(Statistic.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return MonotonicStatistic.MONOTONIC_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = true;
            String string = xMLObject.getAttribute(MonotonicStatistic.ORDER, "increasing");
            if (string.compareToIgnoreCase("decreasing") == 0) {
                bl = false;
            }
            boolean bl2 = xMLObject.getAttribute(MonotonicStatistic.STRICTLY, false);
            MonotonicStatistic monotonicStatistic = new MonotonicStatistic(bl2, bl);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Statistic)) continue;
                monotonicStatistic.addStatistic((Statistic)xMLObject.getChild(i));
            }
            return monotonicStatistic;
        }

        @Override
        public String getParserDescription() {
            return "";
        }

        @Override
        public Class getReturnType() {
            return MonotonicStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean strict;
    private boolean increasing;
    protected ArrayList<Statistic> dataList = new ArrayList();

    public MonotonicStatistic(boolean bl, boolean bl2) {
        super(MONOTONIC_STATISTIC);
        this.strict = bl;
        this.increasing = bl2;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    public void addStatistic(Statistic statistic) {
        this.dataList.add(statistic);
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        double d = this.increasing ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (Statistic statistic : this.dataList) {
            for (int i = 0; i < statistic.getDimension(); ++i) {
                double d2 = statistic.getStatisticValue(i);
                if (this.strict ? this.increasing && d2 <= d || !this.increasing && d2 >= d : this.increasing && d2 < d || !this.increasing && d2 > d) {
                    return false;
                }
                d = d2;
            }
        }
        return true;
    }
}

