/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ErrorLogHandler
extends StreamHandler {
    private final int maxErrorCount;
    private int errorCount = 0;

    public ErrorLogHandler(int n) {
        this.setOutputStream(System.err);
        this.setFormatter(new MessageLogFormatter());
        this.maxErrorCount = n;
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
        if (logRecord.getLevel() == Level.SEVERE) {
            ++this.errorCount;
            if (this.errorCount > this.maxErrorCount) {
                if (this.errorCount > 1) {
                    throw new RuntimeException("ErrorLog: Maximum number of errors (" + (this.maxErrorCount + 1) + ") reached. Terminating BEAST");
                }
                throw new RuntimeException("An error was encountered. Terminating BEAST");
            }
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    private class MessageLogFormatter
    extends Formatter {
        private final String lineSeparator = System.getProperty("line.separator");

        private MessageLogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.formatMessage(logRecord);
            stringBuffer.append(string);
            stringBuffer.append(this.lineSeparator);
            return stringBuffer.toString();
        }
    }
}

