/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class SpecimenSqlBuilder<T extends Specimen>
extends CriteriaSqlBuilder<T> {
    private static final String SPECIMEN_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/specimen.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return SPECIMEN_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.specimen_concept_id";
            }
            case DURATION: {
                return "CAST(1 as int)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Specimen:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        String codesetClause = "";
        if (((Specimen)criteria).codesetId != null) {
            codesetClause = String.format("where s.specimen_concept_id in (SELECT concept_id from  #Codesets where codeset_id = %d)", ((Specimen)criteria).codesetId);
        }
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)codesetClause);
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((Specimen)criteria).first != null && ((Specimen)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY s.person_id ORDER BY s.specimen_date, s.specimen_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((Specimen)criteria).age != null || ((Specimen)criteria).gender != null && ((Specimen)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<Long> conceptIds;
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((Specimen)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.specimen_date", ((Specimen)criteria).occurrenceStartDate));
        }
        if (((Specimen)criteria).specimenType != null && ((Specimen)criteria).specimenType.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Specimen)criteria).specimenType);
            whereClauses.add(String.format("C.specimen_type_concept_id %s in (%s)", ((Specimen)criteria).specimenTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Specimen)criteria).quantity != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("C.quantity", ((Specimen)criteria).quantity, ".4f"));
        }
        if (((Specimen)criteria).unit != null && ((Specimen)criteria).unit.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Specimen)criteria).unit);
            whereClauses.add(String.format("C.unit_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Specimen)criteria).anatomicSite != null && ((Specimen)criteria).anatomicSite.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Specimen)criteria).anatomicSite);
            whereClauses.add(String.format("C.anatomic_site_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Specimen)criteria).diseaseStatus != null && ((Specimen)criteria).diseaseStatus.length > 0) {
            conceptIds = BuilderUtils.getConceptIdsFromConcepts(((Specimen)criteria).diseaseStatus);
            whereClauses.add(String.format("C.disease_status_concept_id in (%s)", StringUtils.join(conceptIds, (String)",")));
        }
        if (((Specimen)criteria).sourceId != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.specimen_source_id", ((Specimen)criteria).sourceId));
        }
        if (((Specimen)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.specimen_date) - P.year_of_birth", ((Specimen)criteria).age));
        }
        if (((Specimen)criteria).gender != null && ((Specimen)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((Specimen)criteria).gender), (String)",")));
        }
        return whereClauses;
    }
}

