/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;

public class DoubleDiagonal
implements DoublePreconditioner {
    private double[] invdiag;

    public DoubleDiagonal(int n) {
        this.invdiag = new double[n];
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        if (!(doubleMatrix1D2 instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            throw new IllegalArgumentException("a nad b must be dense vectors");
        }
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        for (int i = 0; i < this.invdiag.length; ++i) {
            dArray[i] = dArray2[i] * this.invdiag[i];
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        return this.apply(doubleMatrix1D, doubleMatrix1D2);
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        for (int i = 0; i < this.invdiag.length; ++i) {
            this.invdiag[i] = doubleMatrix2D.getQuick(i, i);
            if (this.invdiag[i] == 0.0) {
                throw new RuntimeException("Zero diagonal on row " + (i + 1));
            }
            this.invdiag[i] = 1.0 / this.invdiag[i];
        }
    }
}

