/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.arima.IArimaModel;

public abstract class AbstractArimaComponent<M extends IArimaModel> {
    private Parameter mean;

    public boolean isMean() {
        return this.mean != null;
    }

    public boolean isEstimatedMean() {
        return this.mean != null && !this.mean.isFixed();
    }

    public void setMean(boolean m) {
        this.mean = m ? new Parameter() : null;
    }

    public void setMu(Parameter value) {
        this.mean = value;
    }

    public Parameter getMu() {
        return this.mean;
    }

    public double getMeanCorrection() {
        return this.mean == null ? 0.0 : this.mean.getValue();
    }

    protected AbstractArimaComponent clone() throws CloneNotSupportedException {
        AbstractArimaComponent cl = (AbstractArimaComponent)super.clone();
        if (this.mean != null) {
            cl.mean = this.mean.clone();
        }
        return cl;
    }

    public abstract M getModel();

    public abstract void setModel(M var1);
}

