/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.api.SdmxMetaElement;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompactDataParser
implements Parser<DataParsingResult> {
    private static final String sourceClass = CompactDataParser.class.getSimpleName();
    protected static final Logger logger = Configuration.getSdmxLogger();
    private static final String DATASET = "DataSet";
    private static final String ACTION = "action";
    private static final String VALID_FROM = "validFromDate";
    private static final String VALID_TO = "validToDate";
    private static final String SERIES = "Series";
    private static final String OBS = "Obs";
    private static final String FOOTER = "Footer";
    private static final String MESSAGE = "Message";
    private static final String CODE = "code";
    private static final String SEVERITY = "severity";
    private static final String TEXT = "Text";
    private DataFlowStructure dsd;
    private Dataflow dataflow;
    private boolean data;

    public CompactDataParser(DataFlowStructure dataFlowStructure, Dataflow dataflow, boolean bl) {
        this.dsd = dataFlowStructure;
        this.dataflow = dataflow;
        this.data = bl;
    }

    @Override
    public DataParsingResult parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        DataParsingResult dataParsingResult = new DataParsingResult();
        String string = null;
        String string2 = null;
        String string3 = null;
        Map.Entry<Map<String, Map.Entry<String, String>>, Map<String, String>> entry = null;
        ArrayList<DoubleObservation> arrayList = new ArrayList<DoubleObservation>();
        Message message = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (object.getName().getLocalPart() == DATASET) {
                    logger.finer("Got new dataset");
                    for (Attribute attribute : ((StartElement)object)::getAttributes) {
                        String string4 = attribute.getName().getLocalPart().toString();
                        if (ACTION.equalsIgnoreCase(string4)) {
                            string = attribute.getValue();
                            continue;
                        }
                        if (VALID_FROM.equalsIgnoreCase(string4)) {
                            string2 = attribute.getValue();
                            continue;
                        }
                        if (!VALID_TO.equalsIgnoreCase(string4)) continue;
                        string3 = attribute.getValue();
                    }
                    continue;
                }
                if (object.getName().getLocalPart() == SERIES) {
                    logger.finer("Got new time series");
                    entry = this.getMetadata(((StartElement)object)::getAttributes);
                    continue;
                }
                if (object.getName().getLocalPart() == FOOTER) {
                    message = this.getMessage(xMLEventReader, list);
                    continue;
                }
                if (!object.getName().getLocalPart().equals(OBS) || !this.data) continue;
                arrayList.add(this.getObservation(xMLEventReader, string, string2, string3, () -> object.getAttributes()));
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != SERIES) continue;
            object = new PortableTimeSeries(this.dataflow, (Map)entry.getKey(), (Map)entry.getValue(), arrayList);
            linkedHashMap.putIfAbsent(((PortableTimeSeries)object).getName(), object);
            arrayList = new ArrayList();
        }
        for (Object object : dataParsingResult) {
            Collections.sort(object);
        }
        if (message != null) {
            dataParsingResult.setMessage(message);
        }
        dataParsingResult.setData(new ArrayList<PortableTimeSeries<Double>>(linkedHashMap.values()));
        logger.exiting(sourceClass, "parse");
        return dataParsingResult;
    }

    private DoubleObservation getObservation(XMLEventReader xMLEventReader, String string, String string2, String string3, Iterable<Attribute> iterable) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.nextEvent();
        logger.finest(xMLEvent.toString());
        String string4 = null;
        String string5 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Attribute attribute : iterable) {
            Codelist codelist;
            SdmxAttribute sdmxAttribute;
            String string6 = attribute.getName().toString();
            if (string6.equals(this.dsd.getTimeDimension())) {
                string4 = attribute.getValue();
                continue;
            }
            if (string6.equals("TIME") && string4 == null) {
                string4 = attribute.getValue();
                continue;
            }
            if (string6.equals(this.dsd.getMeasure())) {
                string5 = attribute.getValue();
                continue;
            }
            String string7 = attribute.getValue();
            String string8 = null;
            if (!Configuration.getCodesPolicy().equalsIgnoreCase(CODE) && (sdmxAttribute = this.dsd.getAttribute(string6)) != null && (codelist = sdmxAttribute.getCodeList()) != null && (string8 = codelist.get(string7)) != null) {
                string7 = Configuration.getCodesPolicy().equalsIgnoreCase("description") ? string8 : string7 + "(" + string8 + ")";
            }
            hashMap.put(string6, string7);
        }
        if (string != null) {
            hashMap.put(ACTION, string);
        }
        if (string2 != null) {
            hashMap.put(VALID_FROM, string2);
        }
        if (string3 != null) {
            hashMap.put(VALID_TO, string3);
        }
        try {
            return new DoubleObservation(string4, Double.valueOf(string5 != null ? string5 : ""), hashMap);
        }
        catch (NumberFormatException numberFormatException) {
            logger.fine("The date: " + string4 + "has an obs value that is not parseable to a numer: " + string5 + ". A NaN will be set.");
            return new DoubleObservation(string4, Double.NaN, hashMap);
        }
    }

    private Map.Entry<Map<String, Map.Entry<String, String>>, Map<String, String>> getMetadata(Iterable<Attribute> iterable) {
        logger.entering(sourceClass, "setMetadata");
        int n = this.dsd.getDimensions().size();
        String[] stringArray = new String[n];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<AbstractMap.SimpleEntry<String, String>> arrayList = new ArrayList<AbstractMap.SimpleEntry<String, String>>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        for (Attribute attribute : iterable) {
            Codelist codelist;
            SdmxMetaElement sdmxMetaElement;
            String string;
            String string2 = attribute.getName().toString();
            String string3 = attribute.getValue();
            if (this.dsd.isDimension(string2)) {
                string = null;
                stringArray[this.dsd.getDimensionPosition((String)string2) - 1] = string2;
                sdmxMetaElement = this.dsd.getDimension(string2);
                if (sdmxMetaElement != null && (codelist = sdmxMetaElement.getCodeList()) != null) {
                    string = codelist.get(string3);
                }
                arrayList.set(this.dsd.getDimensionPosition(string2) - 1, new AbstractMap.SimpleEntry<String, String>(string3, string));
                continue;
            }
            string = null;
            if (!Configuration.getCodesPolicy().equalsIgnoreCase(CODE) && (sdmxMetaElement = this.dsd.getAttribute(string2)) != null && (codelist = sdmxMetaElement.getCodeList()) != null && (string = codelist.get(string3)) != null) {
                string3 = Configuration.getCodesPolicy().equalsIgnoreCase("description") ? string : string3 + " (" + string + ")";
            }
            hashMap.put(string2, string3);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            linkedHashMap.put(stringArray[i], arrayList.get(i));
        }
        logger.exiting(sourceClass, "setMetadata");
        return new AbstractMap.SimpleEntry(linkedHashMap, hashMap);
    }

    private Message getMessage(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException {
        logger.entering(sourceClass, "setFooter");
        Message message = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Object object22;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == MESSAGE) {
                    message = new Message();
                    for (Object object22 : startElement::getAttributes) {
                        object = object22.getName().toString();
                        String string = object22.getValue();
                        if (((String)object).equalsIgnoreCase(CODE)) {
                            message.setCode(string);
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase(SEVERITY)) continue;
                        message.setSeverity(string);
                    }
                    continue;
                }
                if (startElement.getName().getLocalPart() != TEXT) continue;
                Object object3 = null;
                object22 = new LocalizedText(list);
                ((LocalizedText)object22).setText(startElement, xMLEventReader);
                object3 = ((LocalizedText)object22).getText();
                message.addText((String)object3);
                try {
                    object = new URL((String)object3);
                    message.setUrl((String)object3);
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != MESSAGE) continue;
            logger.finer("Adding footer message");
            return message;
        }
        return null;
    }
}

