/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractMutator;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeIndividual;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.ExprTreeSpecies;
import net.sourceforge.jclec.exprtree.IMutateExprTree;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class ExprTreeMutator
extends AbstractMutator
implements IConfigure {
    private static final long serialVersionUID = 1953891763454588982L;
    protected IMutateExprTree baseOp;
    protected transient ExprTreeSpecies species;
    protected transient ExprTreeSchema schema;

    public IMutateExprTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IMutateExprTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IMutateExprTree baseOp = (IMutateExprTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof ExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (ExprTreeSpecies)spc;
        this.schema = ((ExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        ExprTree pgenotype = (ExprTree)((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        ExprTree sonGenotype = this.baseOp.mutateExprTree(pgenotype, this.schema, this.randgen);
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }
}

