/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray.rec;

import net.sourceforge.jclec.realarray.rec.UniformCrossover2x2;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ArithmeticCrossover
extends UniformCrossover2x2 {
    private static final long serialVersionUID = -6654540764816675120L;
    protected double lambda;

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double lambda = settings.getDouble("[@lambda]", 0.8);
        this.setLambda(lambda);
    }

    public boolean equals(Object other) {
        if (other instanceof ArithmeticCrossover) {
            ArithmeticCrossover o = (ArithmeticCrossover)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusRecProb, o.locusRecProb);
            eb.append(this.lambda, o.lambda);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void recombineLocus(double[] p0_genome, double[] p1_genome, double[] s0_genome, double[] s1_genome, int locusIndex) {
        s0_genome[locusIndex] = this.lambda * p0_genome[locusIndex] + (1.0 - this.lambda) * p1_genome[locusIndex];
        s1_genome[locusIndex] = this.lambda * p1_genome[locusIndex] + (1.0 - this.lambda) * p0_genome[locusIndex];
    }

    @Override
    protected double defaultLocusRecProb() {
        return 0.5;
    }
}

