/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.Slipper.Mask;
import keel.Algorithms.Rule_Learning.Slipper.MyDataset;
import keel.Algorithms.Rule_Learning.Slipper.Rule;

public class Ruleset {
    private Vector rules = new Vector();
    private String type;
    private double defaultCr = 0.0;

    public boolean contains(Rule r) {
        boolean is_contained = false;
        for (int i = 0; i < this.rules.size() && !is_contained; ++i) {
            is_contained = r.isEqual((Rule)this.rules.elementAt(i));
        }
        return is_contained;
    }

    public int indexOf(Rule r) {
        boolean is_contained = false;
        int i = 0;
        for (i = 0; i < this.rules.size() && !is_contained; ++i) {
            is_contained = r.isEqual((Rule)this.rules.elementAt(i));
        }
        if (is_contained) {
            return i - 1;
        }
        return -1;
    }

    public void addRule(Rule r) {
        int index = this.indexOf(r);
        if (index != -1) {
            Rule prev = (Rule)this.rules.get(index);
            double newCr = prev.getCr() + r.getCr();
            prev.setCr(newCr);
        } else {
            this.rules.add(r);
        }
    }

    public void addToDefaultCr(double Cr) {
        this.defaultCr += Cr;
    }

    public double getDefaultCr(MyDataset data, Mask positives, Mask negatives, double[] distribution) {
        double w_plus = Rule.getDefaultW(data, positives, distribution);
        double w_minus = Rule.getDefaultW(data, negatives, distribution);
        int n = positives.getnActive() + negatives.getnActive();
        return 0.5 * Math.log((w_plus + 1.0 / (2.0 * (double)n)) / (w_minus + 1.0 / (2.0 * (double)n)));
    }

    public double getDefaultCr() {
        return this.defaultCr;
    }

    public Rule getRule(int pos) {
        return (Rule)this.rules.elementAt(pos);
    }

    public String getType() {
        return this.type;
    }

    public void insertRule(Rule r, int pos) {
        this.rules.insertElementAt(r, pos);
    }

    public void removeRule(int pos) {
        this.rules.remove(pos);
    }

    public void setType(String type) {
        this.type = type;
    }

    public int size() {
        return this.rules.size();
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.rules.size(); ++i) {
            output = output + ((Rule)this.rules.elementAt(i)).toString() + " -> " + this.type + "\n";
        }
        output = output + "Confianza regla por defecto: " + this.defaultCr;
        return output;
    }
}

