/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Item;

public class Itemset {
    private ArrayList<Item> itemset = new ArrayList();
    private double support;

    public Itemset clone() {
        Itemset item = new Itemset();
        for (int i = 0; i < this.itemset.size(); ++i) {
            item.add(this.itemset.get(i).clone());
        }
        item.support = this.support;
        return item;
    }

    public void add(Item item) {
        this.itemset.add(item);
    }

    public Item get(int pos) {
        return this.itemset.get(pos);
    }

    public Item remove(int pos) {
        return this.itemset.remove(pos);
    }

    public int size() {
        return this.itemset.size();
    }

    public double getSupport() {
        return this.support;
    }

    public ArrayList<Integer> calculateSupport(FuzzyDataset fuzzyDataset) {
        double[][][] fuzzyTransactions = fuzzyDataset.getFuzzyTransactions();
        ArrayList<Integer> covered_tids = new ArrayList<Integer>();
        this.support = 0.0;
        for (int i = 0; i < fuzzyTransactions.length; ++i) {
            double degree = this.doIntersection(fuzzyTransactions[i]);
            if (!(degree > 0.0)) continue;
            this.support += degree;
            covered_tids.add(i);
        }
        this.support /= (double)fuzzyTransactions.length;
        return covered_tids;
    }

    private double doIntersection(double[][] fuzzy_trans) {
        return this.computeMinimum(fuzzy_trans);
    }

    private double computeMinimum(double[][] fuzzy_trans) {
        double min = 1.0;
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            min = Math.min(min, fuzzy_trans[item.getIDAttribute()][item.getIDLabel()]);
        }
        return min;
    }

    public void changeIdAttr(FuzzyDataset fuzzyDataset) {
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            item.setIDAttribute(fuzzyDataset.getAttrib(item.getIDAttribute()));
        }
    }

    public boolean equals(Object obj) {
        Itemset its = (Itemset)obj;
        if (this.itemset.size() != its.size()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item it = this.itemset.get(i);
            if (it.equals(its.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        String str = "{";
        for (i = 0; i < this.itemset.size() - 1; ++i) {
            str = str + this.itemset.get(i) + ", ";
        }
        str = str + this.itemset.get(i) + "}";
        return str;
    }
}

