(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __reExport = (target, module, desc) => {
    if (module && typeof module === "object" || typeof module === "function") {
      for (let key of __getOwnPropNames(module))
        if (!__hasOwnProp.call(target, key) && key !== "default")
          __defProp(target, key, { get: () => module[key], enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable });
    }
    return target;
  };
  var __toModule = (module) => {
    return __reExport(__markAsModule(__defProp(module != null ? __create(__getProtoOf(module)) : {}, "default", module && module.__esModule && "default" in module ? { get: () => module.default, enumerable: true } : { value: module, enumerable: true })), module);
  };

  // ../loader-utils/src/lib/env-utils/assert.ts
  function assert(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert = __esm({
    "../loader-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../loader-utils/src/lib/env-utils/globals.ts
  var globals, self_, window_, global_, document_, isBrowser, matches, nodeVersion;
  var init_globals = __esm({
    "../loader-utils/src/lib/env-utils/globals.ts"() {
      globals = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_ = globals.self || globals.window || globals.global || {};
      window_ = globals.window || globals.self || globals.global || {};
      global_ = globals.global || globals.self || globals.window || {};
      document_ = globals.document || {};
      isBrowser = Boolean(typeof process !== "object" || String(process) !== "[object process]" || process.browser);
      matches = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion = matches && parseFloat(matches[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/env-utils/version.ts
  var DEFAULT_VERSION, VERSION;
  var init_version = __esm({
    "../worker-utils/src/lib/env-utils/version.ts"() {
      DEFAULT_VERSION = "latest";
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : DEFAULT_VERSION;
      if (typeof __VERSION__ === "undefined") {
        console.error("loaders.gl: The __VERSION__ variable is not injected using babel plugin. Latest unstable workers would be fetched from the CDN.");
      }
    }
  });

  // ../worker-utils/src/lib/env-utils/assert.ts
  function assert2(condition, message) {
    if (!condition) {
      throw new Error(message || "loaders.gl assertion failed.");
    }
  }
  var init_assert2 = __esm({
    "../worker-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../worker-utils/src/lib/env-utils/globals.ts
  var globals2, self_2, window_2, global_2, document_2, isBrowser2, isWorker, isMobile, matches2, nodeVersion2;
  var init_globals2 = __esm({
    "../worker-utils/src/lib/env-utils/globals.ts"() {
      globals2 = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_2 = globals2.self || globals2.window || globals2.global || {};
      window_2 = globals2.window || globals2.self || globals2.global || {};
      global_2 = globals2.global || globals2.self || globals2.window || {};
      document_2 = globals2.document || {};
      isBrowser2 = typeof process !== "object" || String(process) !== "[object process]" || process.browser;
      isWorker = typeof importScripts === "function";
      isMobile = typeof window !== "undefined" && typeof window.orientation !== "undefined";
      matches2 = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion2 = matches2 && parseFloat(matches2[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-job.ts
  var WorkerJob;
  var init_worker_job = __esm({
    "../worker-utils/src/lib/worker-farm/worker-job.ts"() {
      init_assert2();
      WorkerJob = class {
        constructor(jobName, workerThread) {
          this.isRunning = true;
          this._resolve = () => {
          };
          this._reject = () => {
          };
          this.name = jobName;
          this.workerThread = workerThread;
          this.result = new Promise((resolve2, reject) => {
            this._resolve = resolve2;
            this._reject = reject;
          });
        }
        postMessage(type, payload) {
          this.workerThread.postMessage({
            source: "loaders.gl",
            type,
            payload
          });
        }
        done(value) {
          assert2(this.isRunning);
          this.isRunning = false;
          this._resolve(value);
        }
        error(error) {
          assert2(this.isRunning);
          this.isRunning = false;
          this._reject(error);
        }
      };
    }
  });

  // ../worker-utils/src/lib/node/worker_threads-browser.ts
  var Worker2;
  var init_worker_threads_browser = __esm({
    "../worker-utils/src/lib/node/worker_threads-browser.ts"() {
      Worker2 = class {
        terminate() {
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts
  function getLoadableWorkerURL(props) {
    assert2(props.source && !props.url || !props.source && props.url);
    let workerURL = workerURLCache.get(props.source || props.url);
    if (!workerURL) {
      if (props.url) {
        workerURL = getLoadableWorkerURLFromURL(props.url);
        workerURLCache.set(props.url, workerURL);
      }
      if (props.source) {
        workerURL = getLoadableWorkerURLFromSource(props.source);
        workerURLCache.set(props.source, workerURL);
      }
    }
    assert2(workerURL);
    return workerURL;
  }
  function getLoadableWorkerURLFromURL(url) {
    if (!url.startsWith("http")) {
      return url;
    }
    const workerSource = buildScriptSource(url);
    return getLoadableWorkerURLFromSource(workerSource);
  }
  function getLoadableWorkerURLFromSource(workerSource) {
    const blob = new Blob([workerSource], { type: "application/javascript" });
    return URL.createObjectURL(blob);
  }
  function buildScriptSource(workerUrl) {
    return `try {
  importScripts('${workerUrl}');
} catch (error) {
  console.error(error);
  throw error;
}`;
  }
  var workerURLCache;
  var init_get_loadable_worker_url = __esm({
    "../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts"() {
      init_assert2();
      workerURLCache = new Map();
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-transfer-list.ts
  function getTransferList(object, recursive = true, transfers) {
    const transfersSet = transfers || new Set();
    if (!object) {
    } else if (isTransferable(object)) {
      transfersSet.add(object);
    } else if (isTransferable(object.buffer)) {
      transfersSet.add(object.buffer);
    } else if (ArrayBuffer.isView(object)) {
    } else if (recursive && typeof object === "object") {
      for (const key in object) {
        getTransferList(object[key], recursive, transfersSet);
      }
    }
    return transfers === void 0 ? Array.from(transfersSet) : [];
  }
  function isTransferable(object) {
    if (!object) {
      return false;
    }
    if (object instanceof ArrayBuffer) {
      return true;
    }
    if (typeof MessagePort !== "undefined" && object instanceof MessagePort) {
      return true;
    }
    if (typeof ImageBitmap !== "undefined" && object instanceof ImageBitmap) {
      return true;
    }
    if (typeof OffscreenCanvas !== "undefined" && object instanceof OffscreenCanvas) {
      return true;
    }
    return false;
  }
  function getTransferListForWriter(object) {
    if (object === null) {
      return {};
    }
    const clone3 = Object.assign({}, object);
    Object.keys(clone3).forEach((key) => {
      if (typeof object[key] === "object" && !ArrayBuffer.isView(object[key]) && !(object[key] instanceof Array)) {
        clone3[key] = getTransferListForWriter(object[key]);
      } else if (typeof clone3[key] === "function" || clone3[key] instanceof RegExp) {
        clone3[key] = {};
      } else {
        clone3[key] = object[key];
      }
    });
    return clone3;
  }
  var init_get_transfer_list = __esm({
    "../worker-utils/src/lib/worker-utils/get-transfer-list.ts"() {
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-thread.ts
  var NOOP, WorkerThread;
  var init_worker_thread = __esm({
    "../worker-utils/src/lib/worker-farm/worker-thread.ts"() {
      init_worker_threads_browser();
      init_globals2();
      init_assert2();
      init_get_loadable_worker_url();
      init_get_transfer_list();
      NOOP = () => {
      };
      WorkerThread = class {
        constructor(props) {
          this.terminated = false;
          this._loadableURL = "";
          const { name, source, url } = props;
          assert2(source || url);
          this.name = name;
          this.source = source;
          this.url = url;
          this.onMessage = NOOP;
          this.onError = (error) => console.log(error);
          this.worker = isBrowser2 ? this._createBrowserWorker() : this._createNodeWorker();
        }
        static isSupported() {
          return typeof Worker !== "undefined" && isBrowser2 || typeof Worker2 !== "undefined" && !isBrowser2;
        }
        destroy() {
          this.onMessage = NOOP;
          this.onError = NOOP;
          this.worker.terminate();
          this.terminated = true;
        }
        get isRunning() {
          return Boolean(this.onMessage);
        }
        postMessage(data, transferList) {
          transferList = transferList || getTransferList(data);
          this.worker.postMessage(data, transferList);
        }
        _getErrorFromErrorEvent(event) {
          let message = "Failed to load ";
          message += `worker ${this.name} from ${this.url}. `;
          if (event.message) {
            message += `${event.message} in `;
          }
          if (event.lineno) {
            message += `:${event.lineno}:${event.colno}`;
          }
          return new Error(message);
        }
        _createBrowserWorker() {
          this._loadableURL = getLoadableWorkerURL({ source: this.source, url: this.url });
          const worker = new Worker(this._loadableURL, { name: this.name });
          worker.onmessage = (event) => {
            if (!event.data) {
              this.onError(new Error("No data received"));
            } else {
              this.onMessage(event.data);
            }
          };
          worker.onerror = (error) => {
            this.onError(this._getErrorFromErrorEvent(error));
            this.terminated = true;
          };
          worker.onmessageerror = (event) => console.error(event);
          return worker;
        }
        _createNodeWorker() {
          let worker;
          if (this.url) {
            const absolute = this.url.includes(":/") || this.url.startsWith("/");
            const url = absolute ? this.url : `./${this.url}`;
            worker = new Worker2(url, { eval: false });
          } else if (this.source) {
            worker = new Worker2(this.source, { eval: true });
          } else {
            throw new Error("no worker");
          }
          worker.on("message", (data) => {
            this.onMessage(data);
          });
          worker.on("error", (error) => {
            this.onError(error);
          });
          worker.on("exit", (code) => {
          });
          return worker;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-pool.ts
  var WorkerPool;
  var init_worker_pool = __esm({
    "../worker-utils/src/lib/worker-farm/worker-pool.ts"() {
      init_globals2();
      init_worker_thread();
      init_worker_job();
      WorkerPool = class {
        constructor(props) {
          this.name = "unnamed";
          this.maxConcurrency = 1;
          this.maxMobileConcurrency = 1;
          this.onDebug = () => {
          };
          this.reuseWorkers = true;
          this.props = {};
          this.jobQueue = [];
          this.idleQueue = [];
          this.count = 0;
          this.isDestroyed = false;
          this.source = props.source;
          this.url = props.url;
          this.setProps(props);
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        destroy() {
          this.idleQueue.forEach((worker) => worker.destroy());
          this.isDestroyed = true;
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          if (props.name !== void 0) {
            this.name = props.name;
          }
          if (props.maxConcurrency !== void 0) {
            this.maxConcurrency = props.maxConcurrency;
          }
          if (props.maxMobileConcurrency !== void 0) {
            this.maxMobileConcurrency = props.maxMobileConcurrency;
          }
          if (props.reuseWorkers !== void 0) {
            this.reuseWorkers = props.reuseWorkers;
          }
          if (props.onDebug !== void 0) {
            this.onDebug = props.onDebug;
          }
        }
        async startJob(name, onMessage3 = (job, type, data) => job.done(data), onError = (job, error) => job.error(error)) {
          const startPromise = new Promise((onStart) => {
            this.jobQueue.push({ name, onMessage: onMessage3, onError, onStart });
            return this;
          });
          this._startQueuedJob();
          return await startPromise;
        }
        async _startQueuedJob() {
          if (!this.jobQueue.length) {
            return;
          }
          const workerThread = this._getAvailableWorker();
          if (!workerThread) {
            return;
          }
          const queuedJob = this.jobQueue.shift();
          if (queuedJob) {
            this.onDebug({
              message: "Starting job",
              name: queuedJob.name,
              workerThread,
              backlog: this.jobQueue.length
            });
            const job = new WorkerJob(queuedJob.name, workerThread);
            workerThread.onMessage = (data) => queuedJob.onMessage(job, data.type, data.payload);
            workerThread.onError = (error) => queuedJob.onError(job, error);
            queuedJob.onStart(job);
            try {
              await job.result;
            } finally {
              this.returnWorkerToQueue(workerThread);
            }
          }
        }
        returnWorkerToQueue(worker) {
          const shouldDestroyWorker = this.isDestroyed || !this.reuseWorkers || this.count > this._getMaxConcurrency();
          if (shouldDestroyWorker) {
            worker.destroy();
            this.count--;
          } else {
            this.idleQueue.push(worker);
          }
          if (!this.isDestroyed) {
            this._startQueuedJob();
          }
        }
        _getAvailableWorker() {
          if (this.idleQueue.length > 0) {
            return this.idleQueue.shift() || null;
          }
          if (this.count < this._getMaxConcurrency()) {
            this.count++;
            const name = `${this.name.toLowerCase()} (#${this.count} of ${this.maxConcurrency})`;
            return new WorkerThread({ name, source: this.source, url: this.url });
          }
          return null;
        }
        _getMaxConcurrency() {
          return isMobile ? this.maxMobileConcurrency : this.maxConcurrency;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-farm.ts
  var DEFAULT_PROPS, WorkerFarm;
  var init_worker_farm = __esm({
    "../worker-utils/src/lib/worker-farm/worker-farm.ts"() {
      init_worker_pool();
      init_worker_thread();
      DEFAULT_PROPS = {
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: true,
        onDebug: () => {
        }
      };
      WorkerFarm = class {
        constructor(props) {
          this.workerPools = new Map();
          this.props = { ...DEFAULT_PROPS };
          this.setProps(props);
          this.workerPools = new Map();
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        static getWorkerFarm(props = {}) {
          WorkerFarm._workerFarm = WorkerFarm._workerFarm || new WorkerFarm({});
          WorkerFarm._workerFarm.setProps(props);
          return WorkerFarm._workerFarm;
        }
        destroy() {
          for (const workerPool of this.workerPools.values()) {
            workerPool.destroy();
          }
          this.workerPools = new Map();
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          for (const workerPool of this.workerPools.values()) {
            workerPool.setProps(this._getWorkerPoolProps());
          }
        }
        getWorkerPool(options) {
          const { name, source, url } = options;
          let workerPool = this.workerPools.get(name);
          if (!workerPool) {
            workerPool = new WorkerPool({
              name,
              source,
              url
            });
            workerPool.setProps(this._getWorkerPoolProps());
            this.workerPools.set(name, workerPool);
          }
          return workerPool;
        }
        _getWorkerPoolProps() {
          return {
            maxConcurrency: this.props.maxConcurrency,
            maxMobileConcurrency: this.props.maxMobileConcurrency,
            reuseWorkers: this.props.reuseWorkers,
            onDebug: this.props.onDebug
          };
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-api/get-worker-url.ts
  function getWorkerName(worker) {
    const warning = worker.version !== VERSION2 ? ` (worker-utils@${VERSION2})` : "";
    return `${worker.name}@${worker.version}${warning}`;
  }
  function getWorkerURL(worker, options = {}) {
    const workerOptions = options[worker.id] || {};
    const workerFile = `${worker.id}-worker.js`;
    let url = workerOptions.workerUrl;
    if (!url && worker.id === "compression") {
      url = options.workerUrl;
    }
    if (options._workerType === "test") {
      url = `modules/${worker.module}/dist/${workerFile}`;
    }
    if (!url) {
      let version = worker.version;
      if (version === "latest") {
        version = NPM_TAG;
      }
      const versionTag = version ? `@${version}` : "";
      url = `https://unpkg.com/@loaders.gl/${worker.module}${versionTag}/dist/${workerFile}`;
    }
    assert2(url);
    return url;
  }
  var NPM_TAG, VERSION2;
  var init_get_worker_url = __esm({
    "../worker-utils/src/lib/worker-api/get-worker-url.ts"() {
      init_assert2();
      init_version();
      NPM_TAG = "latest";
      VERSION2 = typeof VERSION !== "undefined" ? VERSION : NPM_TAG;
    }
  });

  // ../worker-utils/src/lib/worker-api/process-on-worker.ts
  async function processOnWorker(worker, data, options = {}, context = {}) {
    const name = getWorkerName(worker);
    const workerFarm = WorkerFarm.getWorkerFarm(options);
    const { source } = options;
    const workerPoolProps = { name, source };
    if (!source) {
      workerPoolProps.url = getWorkerURL(worker, options);
    }
    const workerPool = workerFarm.getWorkerPool(workerPoolProps);
    const jobName = options.jobName || worker.name;
    const job = await workerPool.startJob(jobName, onMessage.bind(null, context));
    const transferableOptions = getTransferListForWriter(options);
    job.postMessage("process", { input: data, options: transferableOptions });
    const result = await job.result;
    return result.result;
  }
  async function onMessage(context, job, type, payload) {
    switch (type) {
      case "done":
        job.done(payload);
        break;
      case "error":
        job.error(new Error(payload.error));
        break;
      case "process":
        const { id, input, options } = payload;
        try {
          if (!context.process) {
            job.postMessage("error", { id, error: "Worker not set up to process on main thread" });
            return;
          }
          const result = await context.process(input, options);
          job.postMessage("done", { id, result });
        } catch (error) {
          const message = error instanceof Error ? error.message : "unknown error";
          job.postMessage("error", { id, error: message });
        }
        break;
      default:
        console.warn(`process-on-worker: unknown message ${type}`);
    }
  }
  var init_process_on_worker = __esm({
    "../worker-utils/src/lib/worker-api/process-on-worker.ts"() {
      init_worker_farm();
      init_get_worker_url();
      init_get_transfer_list();
    }
  });

  // ../worker-utils/src/lib/worker-api/validate-worker-version.ts
  function validateWorkerVersion(worker, coreVersion = VERSION) {
    assert2(worker, "no worker provided");
    const workerVersion = worker.version;
    if (!coreVersion || !workerVersion) {
      return false;
    }
    return true;
  }
  var init_validate_worker_version = __esm({
    "../worker-utils/src/lib/worker-api/validate-worker-version.ts"() {
      init_assert2();
      init_version();
    }
  });

  // (disabled):../worker-utils/src/lib/node/require-utils.node
  var require_require_utils = __commonJS({
    "(disabled):../worker-utils/src/lib/node/require-utils.node"() {
    }
  });

  // ../worker-utils/src/lib/library-utils/library-utils.ts
  async function loadLibrary(libraryUrl, moduleName = null, options = {}) {
    if (moduleName) {
      libraryUrl = getLibraryUrl(libraryUrl, moduleName, options);
    }
    loadLibraryPromises[libraryUrl] = loadLibraryPromises[libraryUrl] || loadLibraryFromFile(libraryUrl);
    return await loadLibraryPromises[libraryUrl];
  }
  function getLibraryUrl(library, moduleName, options) {
    if (library.startsWith("http")) {
      return library;
    }
    const modules = options.modules || {};
    if (modules[library]) {
      return modules[library];
    }
    if (!isBrowser2) {
      return `modules/${moduleName}/dist/libs/${library}`;
    }
    if (options.CDN) {
      assert2(options.CDN.startsWith("http"));
      return `${options.CDN}/${moduleName}@${VERSION3}/dist/libs/${library}`;
    }
    if (isWorker) {
      return `../src/libs/${library}`;
    }
    return `modules/${moduleName}/src/libs/${library}`;
  }
  async function loadLibraryFromFile(libraryUrl) {
    if (libraryUrl.endsWith("wasm")) {
      const response2 = await fetch(libraryUrl);
      return await response2.arrayBuffer();
    }
    if (!isBrowser2) {
      try {
        return node && node.requireFromFile && await node.requireFromFile(libraryUrl);
      } catch {
        return null;
      }
    }
    if (isWorker) {
      return importScripts(libraryUrl);
    }
    const response = await fetch(libraryUrl);
    const scriptSource = await response.text();
    return loadLibraryFromString(scriptSource, libraryUrl);
  }
  function loadLibraryFromString(scriptSource, id) {
    if (!isBrowser2) {
      return node.requireFromString && node.requireFromString(scriptSource, id);
    }
    if (isWorker) {
      eval.call(global_2, scriptSource);
      return null;
    }
    const script = document.createElement("script");
    script.id = id;
    try {
      script.appendChild(document.createTextNode(scriptSource));
    } catch (e2) {
      script.text = scriptSource;
    }
    document.body.appendChild(script);
    return null;
  }
  var node, LATEST, VERSION3, loadLibraryPromises;
  var init_library_utils = __esm({
    "../worker-utils/src/lib/library-utils/library-utils.ts"() {
      init_globals2();
      node = __toModule(require_require_utils());
      init_assert2();
      init_version();
      LATEST = "latest";
      VERSION3 = typeof VERSION !== "undefined" ? VERSION : LATEST;
      loadLibraryPromises = {};
    }
  });

  // ../worker-utils/src/index.ts
  var init_src = __esm({
    "../worker-utils/src/index.ts"() {
      init_assert2();
      init_globals2();
      init_worker_farm();
      init_process_on_worker();
      init_get_worker_url();
      init_validate_worker_version();
      init_library_utils();
    }
  });

  // ../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts
  function canParseWithWorker(loader, options) {
    if (!WorkerFarm.isSupported()) {
      return false;
    }
    if (!isBrowser2 && !options?._nodeWorkers) {
      return false;
    }
    return loader.worker && options?.worker;
  }
  async function parseWithWorker(loader, data, options, context, parseOnMainThread) {
    const name = loader.id;
    const url = getWorkerURL(loader, options);
    const workerFarm = WorkerFarm.getWorkerFarm(options);
    const workerPool = workerFarm.getWorkerPool({ name, url });
    options = JSON.parse(JSON.stringify(options));
    context = JSON.parse(JSON.stringify(context || {}));
    const job = await workerPool.startJob("process-on-worker", onMessage2.bind(null, parseOnMainThread));
    job.postMessage("process", {
      input: data,
      options,
      context
    });
    const result = await job.result;
    return await result.result;
  }
  async function onMessage2(parseOnMainThread, job, type, payload) {
    switch (type) {
      case "done":
        job.done(payload);
        break;
      case "error":
        job.error(new Error(payload.error));
        break;
      case "process":
        const { id, input, options } = payload;
        try {
          const result = await parseOnMainThread(input, options);
          job.postMessage("done", { id, result });
        } catch (error) {
          const message = error instanceof Error ? error.message : "unknown error";
          job.postMessage("error", { id, error: message });
        }
        break;
      default:
        console.warn(`parse-with-worker unknown message ${type}`);
    }
  }
  var init_parse_with_worker = __esm({
    "../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts"() {
      init_src();
      init_src();
    }
  });

  // ../loader-utils/src/lib/binary-utils/array-buffer-utils.ts
  function compareArrayBuffers(arrayBuffer1, arrayBuffer2, byteLength) {
    byteLength = byteLength || arrayBuffer1.byteLength;
    if (arrayBuffer1.byteLength < byteLength || arrayBuffer2.byteLength < byteLength) {
      return false;
    }
    const array1 = new Uint8Array(arrayBuffer1);
    const array2 = new Uint8Array(arrayBuffer2);
    for (let i2 = 0; i2 < array1.length; ++i2) {
      if (array1[i2] !== array2[i2]) {
        return false;
      }
    }
    return true;
  }
  function concatenateArrayBuffers(...sources) {
    const sourceArrays = sources.map((source2) => source2 instanceof ArrayBuffer ? new Uint8Array(source2) : source2);
    const byteLength = sourceArrays.reduce((length4, typedArray) => length4 + typedArray.byteLength, 0);
    const result = new Uint8Array(byteLength);
    let offset = 0;
    for (const sourceArray of sourceArrays) {
      result.set(sourceArray, offset);
      offset += sourceArray.byteLength;
    }
    return result.buffer;
  }
  var init_array_buffer_utils = __esm({
    "../loader-utils/src/lib/binary-utils/array-buffer-utils.ts"() {
    }
  });

  // ../loader-utils/src/lib/iterators/async-iteration.ts
  async function concatenateArrayBuffersAsync(asyncIterator) {
    const arrayBuffers = [];
    for await (const chunk of asyncIterator) {
      arrayBuffers.push(chunk);
    }
    return concatenateArrayBuffers(...arrayBuffers);
  }
  var init_async_iteration = __esm({
    "../loader-utils/src/lib/iterators/async-iteration.ts"() {
      init_array_buffer_utils();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/typeof.js
  function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && typeof Symbol == "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof(obj);
  }
  var init_typeof = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/typeof.js"() {
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js
  function _toPrimitive(input, hint) {
    if (_typeof(input) !== "object" || input === null)
      return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== void 0) {
      var res = prim.call(input, hint || "default");
      if (_typeof(res) !== "object")
        return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  var init_toPrimitive = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js"() {
      init_typeof();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return _typeof(key) === "symbol" ? key : String(key);
  }
  var init_toPropertyKey = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js"() {
      init_typeof();
      init_toPrimitive();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/defineProperty.js
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var init_defineProperty = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/defineProperty.js"() {
      init_toPropertyKey();
    }
  });

  // ../loader-utils/src/lib/path-utils/file-aliases.ts
  function resolvePath(filename2) {
    for (const alias in fileAliases) {
      if (filename2.startsWith(alias)) {
        const replacement = fileAliases[alias];
        filename2 = filename2.replace(alias, replacement);
      }
    }
    if (!filename2.startsWith("http://") && !filename2.startsWith("https://")) {
      filename2 = `${pathPrefix}${filename2}`;
    }
    return filename2;
  }
  var pathPrefix, fileAliases;
  var init_file_aliases = __esm({
    "../loader-utils/src/lib/path-utils/file-aliases.ts"() {
      pathPrefix = "";
      fileAliases = {};
    }
  });

  // ../loader-utils/src/json-loader.ts
  function parseTextSync(text) {
    return JSON.parse(text);
  }
  var VERSION4, JSONLoader;
  var init_json_loader = __esm({
    "../loader-utils/src/json-loader.ts"() {
      VERSION4 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      JSONLoader = {
        name: "JSON",
        id: "json",
        module: "json",
        version: VERSION4,
        extensions: ["json", "geojson"],
        mimeTypes: ["application/json"],
        category: "json",
        text: true,
        parseTextSync,
        parse: async (arrayBuffer) => parseTextSync(new TextDecoder().decode(arrayBuffer)),
        options: {}
      };
    }
  });

  // ../loader-utils/src/lib/node/buffer.browser.ts
  function toArrayBuffer(buffer) {
    return buffer;
  }
  var init_buffer_browser = __esm({
    "../loader-utils/src/lib/node/buffer.browser.ts"() {
    }
  });

  // ../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts
  function isBuffer(value) {
    return value && typeof value === "object" && value.isBuffer;
  }
  function toArrayBuffer2(data) {
    if (isBuffer(data)) {
      return toArrayBuffer(data);
    }
    if (data instanceof ArrayBuffer) {
      return data;
    }
    if (ArrayBuffer.isView(data)) {
      if (data.byteOffset === 0 && data.byteLength === data.buffer.byteLength) {
        return data.buffer;
      }
      return data.buffer.slice(data.byteOffset, data.byteOffset + data.byteLength);
    }
    if (typeof data === "string") {
      const text = data;
      const uint8Array = new TextEncoder().encode(text);
      return uint8Array.buffer;
    }
    if (data && typeof data === "object" && data._toArrayBuffer) {
      return data._toArrayBuffer();
    }
    throw new Error("toArrayBuffer");
  }
  var init_memory_conversion_utils = __esm({
    "../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts"() {
      init_buffer_browser();
    }
  });

  // ../loader-utils/src/lib/path-utils/get-cwd.ts
  function getCWD() {
    if (typeof process !== "undefined" && typeof process.cwd !== "undefined") {
      return process.cwd();
    }
    const pathname = window.location?.pathname;
    return pathname?.slice(0, pathname.lastIndexOf("/") + 1) || "";
  }
  var init_get_cwd = __esm({
    "../loader-utils/src/lib/path-utils/get-cwd.ts"() {
    }
  });

  // ../loader-utils/src/lib/path-utils/path.ts
  var path_exports = {};
  __export(path_exports, {
    dirname: () => dirname,
    filename: () => filename,
    join: () => join,
    resolve: () => resolve
  });
  function filename(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(slashIndex + 1) : "";
  }
  function dirname(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(0, slashIndex) : "";
  }
  function join(...parts) {
    const separator = "/";
    parts = parts.map((part, index) => {
      if (index) {
        part = part.replace(new RegExp(`^${separator}`), "");
      }
      if (index !== parts.length - 1) {
        part = part.replace(new RegExp(`${separator}$`), "");
      }
      return part;
    });
    return parts.join(separator);
  }
  function resolve(...components) {
    const paths = [];
    for (let _i = 0; _i < components.length; _i++) {
      paths[_i] = components[_i];
    }
    let resolvedPath = "";
    let resolvedAbsolute = false;
    let cwd;
    for (let i2 = paths.length - 1; i2 >= -1 && !resolvedAbsolute; i2--) {
      let path;
      if (i2 >= 0) {
        path = paths[i2];
      } else {
        if (cwd === void 0) {
          cwd = getCWD();
        }
        path = cwd;
      }
      if (path.length === 0) {
        continue;
      }
      resolvedPath = `${path}/${resolvedPath}`;
      resolvedAbsolute = path.charCodeAt(0) === SLASH;
    }
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      return `/${resolvedPath}`;
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    }
    return ".";
  }
  function normalizeStringPosix(path, allowAboveRoot) {
    let res = "";
    let lastSlash = -1;
    let dots = 0;
    let code;
    let isAboveRoot = false;
    for (let i2 = 0; i2 <= path.length; ++i2) {
      if (i2 < path.length) {
        code = path.charCodeAt(i2);
      } else if (code === SLASH) {
        break;
      } else {
        code = SLASH;
      }
      if (code === SLASH) {
        if (lastSlash === i2 - 1 || dots === 1) {
        } else if (lastSlash !== i2 - 1 && dots === 2) {
          if (res.length < 2 || !isAboveRoot || res.charCodeAt(res.length - 1) !== DOT || res.charCodeAt(res.length - 2) !== DOT) {
            if (res.length > 2) {
              const start = res.length - 1;
              let j = start;
              for (; j >= 0; --j) {
                if (res.charCodeAt(j) === SLASH) {
                  break;
                }
              }
              if (j !== start) {
                res = j === -1 ? "" : res.slice(0, j);
                lastSlash = i2;
                dots = 0;
                isAboveRoot = false;
                continue;
              }
            } else if (res.length === 2 || res.length === 1) {
              res = "";
              lastSlash = i2;
              dots = 0;
              isAboveRoot = false;
              continue;
            }
          }
          if (allowAboveRoot) {
            if (res.length > 0) {
              res += "/..";
            } else {
              res = "..";
            }
            isAboveRoot = true;
          }
        } else {
          const slice = path.slice(lastSlash + 1, i2);
          if (res.length > 0) {
            res += `/${slice}`;
          } else {
            res = slice;
          }
          isAboveRoot = false;
        }
        lastSlash = i2;
        dots = 0;
      } else if (code === DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  var SLASH, DOT;
  var init_path = __esm({
    "../loader-utils/src/lib/path-utils/path.ts"() {
      init_get_cwd();
      SLASH = 47;
      DOT = 46;
    }
  });

  // ../loader-utils/src/index.ts
  var init_src2 = __esm({
    "../loader-utils/src/index.ts"() {
      init_assert();
      init_globals();
      init_parse_with_worker();
      init_array_buffer_utils();
      init_async_iteration();
      init_file_aliases();
      init_json_loader();
      init_memory_conversion_utils();
      init_path();
    }
  });

  // ../core/src/javascript-utils/is-type.ts
  var isBoolean, isFunction, isObject, isPureObject, isIterable, isAsyncIterable, isResponse, isBlob, isBuffer2, isReadableDOMStream, isReadableNodeStream, isReadableStream;
  var init_is_type = __esm({
    "../core/src/javascript-utils/is-type.ts"() {
      isBoolean = (x) => typeof x === "boolean";
      isFunction = (x) => typeof x === "function";
      isObject = (x) => x !== null && typeof x === "object";
      isPureObject = (x) => isObject(x) && x.constructor === {}.constructor;
      isIterable = (x) => x && typeof x[Symbol.iterator] === "function";
      isAsyncIterable = (x) => x && typeof x[Symbol.asyncIterator] === "function";
      isResponse = (x) => typeof Response !== "undefined" && x instanceof Response || x && x.arrayBuffer && x.text && x.json;
      isBlob = (x) => typeof Blob !== "undefined" && x instanceof Blob;
      isBuffer2 = (x) => x && typeof x === "object" && x.isBuffer;
      isReadableDOMStream = (x) => typeof ReadableStream !== "undefined" && x instanceof ReadableStream || isObject(x) && isFunction(x.tee) && isFunction(x.cancel) && isFunction(x.getReader);
      isReadableNodeStream = (x) => isObject(x) && isFunction(x.read) && isFunction(x.pipe) && isBoolean(x.readable);
      isReadableStream = (x) => isReadableDOMStream(x) || isReadableNodeStream(x);
    }
  });

  // ../core/src/lib/utils/mime-type-utils.ts
  function parseMIMEType(mimeString) {
    const matches3 = MIME_TYPE_PATTERN.exec(mimeString);
    if (matches3) {
      return matches3[1];
    }
    return mimeString;
  }
  function parseMIMETypeFromURL(url) {
    const matches3 = DATA_URL_PATTERN.exec(url);
    if (matches3) {
      return matches3[1];
    }
    return "";
  }
  var DATA_URL_PATTERN, MIME_TYPE_PATTERN;
  var init_mime_type_utils = __esm({
    "../core/src/lib/utils/mime-type-utils.ts"() {
      DATA_URL_PATTERN = /^data:([-\w.]+\/[-\w.+]+)(;|,)/;
      MIME_TYPE_PATTERN = /^([-\w.]+\/[-\w.+]+)/;
    }
  });

  // ../core/src/lib/utils/url-utils.ts
  function extractQueryString(url) {
    const matches3 = url.match(QUERY_STRING_PATTERN);
    return matches3 && matches3[0];
  }
  function stripQueryString(url) {
    return url.replace(QUERY_STRING_PATTERN, "");
  }
  var QUERY_STRING_PATTERN;
  var init_url_utils = __esm({
    "../core/src/lib/utils/url-utils.ts"() {
      QUERY_STRING_PATTERN = /\?.*/;
    }
  });

  // ../core/src/lib/utils/resource-utils.ts
  function getResourceUrl(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.url;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.name || "";
    }
    if (typeof resource === "string") {
      return resource;
    }
    return "";
  }
  function getResourceMIMEType(resource) {
    if (isResponse(resource)) {
      const response = resource;
      const contentTypeHeader = response.headers.get("content-type") || "";
      const noQueryUrl = stripQueryString(response.url);
      return parseMIMEType(contentTypeHeader) || parseMIMETypeFromURL(noQueryUrl);
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.type || "";
    }
    if (typeof resource === "string") {
      return parseMIMETypeFromURL(resource);
    }
    return "";
  }
  function getResourceContentLength(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.headers["content-length"] || -1;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.size;
    }
    if (typeof resource === "string") {
      return resource.length;
    }
    if (resource instanceof ArrayBuffer) {
      return resource.byteLength;
    }
    if (ArrayBuffer.isView(resource)) {
      return resource.byteLength;
    }
    return -1;
  }
  var init_resource_utils = __esm({
    "../core/src/lib/utils/resource-utils.ts"() {
      init_is_type();
      init_mime_type_utils();
      init_url_utils();
    }
  });

  // ../core/src/lib/utils/response-utils.ts
  async function makeResponse(resource) {
    if (isResponse(resource)) {
      return resource;
    }
    const headers = {};
    const contentLength = getResourceContentLength(resource);
    if (contentLength >= 0) {
      headers["content-length"] = String(contentLength);
    }
    const url = getResourceUrl(resource);
    const type = getResourceMIMEType(resource);
    if (type) {
      headers["content-type"] = type;
    }
    const initialDataUrl = await getInitialDataUrl(resource);
    if (initialDataUrl) {
      headers["x-first-bytes"] = initialDataUrl;
    }
    if (typeof resource === "string") {
      resource = new TextEncoder().encode(resource);
    }
    const response = new Response(resource, { headers });
    Object.defineProperty(response, "url", { value: url });
    return response;
  }
  async function checkResponse(response) {
    if (!response.ok) {
      const message = await getResponseError(response);
      throw new Error(message);
    }
  }
  async function getResponseError(response) {
    let message = `Failed to fetch resource ${response.url} (${response.status}): `;
    try {
      const contentType = response.headers.get("Content-Type");
      let text = response.statusText;
      if (contentType.includes("application/json")) {
        text += ` ${await response.text()}`;
      }
      message += text;
      message = message.length > 60 ? `${message.slice(0, 60)}...` : message;
    } catch (error) {
    }
    return message;
  }
  async function getInitialDataUrl(resource) {
    const INITIAL_DATA_LENGTH = 5;
    if (typeof resource === "string") {
      return `data:,${resource.slice(0, INITIAL_DATA_LENGTH)}`;
    }
    if (resource instanceof Blob) {
      const blobSlice = resource.slice(0, 5);
      return await new Promise((resolve2) => {
        const reader = new FileReader();
        reader.onload = (event) => resolve2(event?.target?.result);
        reader.readAsDataURL(blobSlice);
      });
    }
    if (resource instanceof ArrayBuffer) {
      const slice = resource.slice(0, INITIAL_DATA_LENGTH);
      const base64 = arrayBufferToBase64(slice);
      return `data:base64,${base64}`;
    }
    return null;
  }
  function arrayBufferToBase64(buffer) {
    let binary = "";
    const bytes = new Uint8Array(buffer);
    for (let i2 = 0; i2 < bytes.byteLength; i2++) {
      binary += String.fromCharCode(bytes[i2]);
    }
    return btoa(binary);
  }
  var init_response_utils = __esm({
    "../core/src/lib/utils/response-utils.ts"() {
      init_is_type();
      init_resource_utils();
    }
  });

  // ../core/src/lib/fetch/fetch-file.ts
  async function fetchFile(url, options) {
    if (typeof url === "string") {
      url = resolvePath(url);
      let fetchOptions = options;
      if (options?.fetch && typeof options?.fetch !== "function") {
        fetchOptions = options.fetch;
      }
      return await fetch(url, fetchOptions);
    }
    return await makeResponse(url);
  }
  var init_fetch_file = __esm({
    "../core/src/lib/fetch/fetch-file.ts"() {
      init_src2();
      init_response_utils();
    }
  });

  // ../core/node_modules/@probe.gl/env/dist/lib/is-electron.js
  function isElectron(mockUserAgent) {
    if (typeof window !== "undefined" && typeof window.process === "object" && window.process.type === "renderer") {
      return true;
    }
    if (typeof process !== "undefined" && typeof process.versions === "object" && Boolean(process.versions["electron"])) {
      return true;
    }
    const realUserAgent = typeof navigator === "object" && typeof navigator.userAgent === "string" && navigator.userAgent;
    const userAgent = mockUserAgent || realUserAgent;
    if (userAgent && userAgent.indexOf("Electron") >= 0) {
      return true;
    }
    return false;
  }
  var init_is_electron = __esm({
    "../core/node_modules/@probe.gl/env/dist/lib/is-electron.js"() {
    }
  });

  // ../core/node_modules/@probe.gl/env/dist/lib/is-browser.js
  function isBrowser3() {
    const isNode = typeof process === "object" && String(process) === "[object process]" && !process.browser;
    return !isNode || isElectron();
  }
  var init_is_browser = __esm({
    "../core/node_modules/@probe.gl/env/dist/lib/is-browser.js"() {
      init_is_electron();
    }
  });

  // ../core/node_modules/@probe.gl/env/dist/lib/globals.js
  var self_3, window_3, document_3, process_, console_, navigator_;
  var init_globals3 = __esm({
    "../core/node_modules/@probe.gl/env/dist/lib/globals.js"() {
      self_3 = globalThis.self || globalThis.window || globalThis.global;
      window_3 = globalThis.window || globalThis.self || globalThis.global;
      document_3 = globalThis.document || {};
      process_ = globalThis.process || {};
      console_ = globalThis.console;
      navigator_ = globalThis.navigator || {};
    }
  });

  // ../core/node_modules/@probe.gl/env/dist/utils/globals.js
  var VERSION5, isBrowser4;
  var init_globals4 = __esm({
    "../core/node_modules/@probe.gl/env/dist/utils/globals.js"() {
      init_is_browser();
      VERSION5 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "untranspiled source";
      isBrowser4 = isBrowser3();
    }
  });

  // ../core/node_modules/@probe.gl/env/dist/index.js
  var init_dist = __esm({
    "../core/node_modules/@probe.gl/env/dist/index.js"() {
      init_globals4();
      init_globals3();
      init_is_browser();
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/local-storage.js
  function getStorage(type) {
    try {
      const storage = window[type];
      const x = "__storage_test__";
      storage.setItem(x, x);
      storage.removeItem(x);
      return storage;
    } catch (e2) {
      return null;
    }
  }
  var LocalStorage;
  var init_local_storage = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/local-storage.js"() {
      init_defineProperty();
      LocalStorage = class {
        constructor(id, defaultConfig) {
          let type = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "sessionStorage";
          _defineProperty(this, "storage", void 0);
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "config", void 0);
          this.storage = getStorage(type);
          this.id = id;
          this.config = defaultConfig;
          this._loadConfiguration();
        }
        getConfiguration() {
          return this.config;
        }
        setConfiguration(configuration) {
          Object.assign(this.config, configuration);
          if (this.storage) {
            const serialized = JSON.stringify(this.config);
            this.storage.setItem(this.id, serialized);
          }
        }
        _loadConfiguration() {
          let configuration = {};
          if (this.storage) {
            const serializedConfiguration = this.storage.getItem(this.id);
            configuration = serializedConfiguration ? JSON.parse(serializedConfiguration) : {};
          }
          Object.assign(this.config, configuration);
          return this;
        }
      };
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/formatters.js
  function formatTime(ms) {
    let formatted;
    if (ms < 10) {
      formatted = "".concat(ms.toFixed(2), "ms");
    } else if (ms < 100) {
      formatted = "".concat(ms.toFixed(1), "ms");
    } else if (ms < 1e3) {
      formatted = "".concat(ms.toFixed(0), "ms");
    } else {
      formatted = "".concat((ms / 1e3).toFixed(2), "s");
    }
    return formatted;
  }
  function leftPad(string) {
    let length4 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 8;
    const padLength = Math.max(length4 - string.length, 0);
    return "".concat(" ".repeat(padLength)).concat(string);
  }
  function formatImage(image, message, scale5) {
    let maxWidth = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 600;
    const imageUrl = image.src.replace(/\(/g, "%28").replace(/\)/g, "%29");
    if (image.width > maxWidth) {
      scale5 = Math.min(scale5, maxWidth / image.width);
    }
    const width = image.width * scale5;
    const height = image.height * scale5;
    const style = ["font-size:1px;", "padding:".concat(Math.floor(height / 2), "px ").concat(Math.floor(width / 2), "px;"), "line-height:".concat(height, "px;"), "background:url(".concat(imageUrl, ");"), "background-size:".concat(width, "px ").concat(height, "px;"), "color:transparent;"].join("");
    return ["".concat(message, " %c+"), style];
  }
  var init_formatters = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/formatters.js"() {
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/color.js
  function getColor(color) {
    if (typeof color !== "string") {
      return color;
    }
    color = color.toUpperCase();
    return COLOR[color] || COLOR.WHITE;
  }
  function addColor(string, color, background) {
    if (!isBrowser3 && typeof string === "string") {
      if (color) {
        const colorCode = getColor(color);
        string = "[".concat(colorCode, "m").concat(string, "[39m");
      }
      if (background) {
        const colorCode = getColor(background);
        string = "[".concat(colorCode + BACKGROUND_INCREMENT, "m").concat(string, "[49m");
      }
    }
    return string;
  }
  var COLOR, BACKGROUND_INCREMENT;
  var init_color = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/color.js"() {
      init_dist();
      (function(COLOR2) {
        COLOR2[COLOR2["BLACK"] = 30] = "BLACK";
        COLOR2[COLOR2["RED"] = 31] = "RED";
        COLOR2[COLOR2["GREEN"] = 32] = "GREEN";
        COLOR2[COLOR2["YELLOW"] = 33] = "YELLOW";
        COLOR2[COLOR2["BLUE"] = 34] = "BLUE";
        COLOR2[COLOR2["MAGENTA"] = 35] = "MAGENTA";
        COLOR2[COLOR2["CYAN"] = 36] = "CYAN";
        COLOR2[COLOR2["WHITE"] = 37] = "WHITE";
        COLOR2[COLOR2["BRIGHT_BLACK"] = 90] = "BRIGHT_BLACK";
        COLOR2[COLOR2["BRIGHT_RED"] = 91] = "BRIGHT_RED";
        COLOR2[COLOR2["BRIGHT_GREEN"] = 92] = "BRIGHT_GREEN";
        COLOR2[COLOR2["BRIGHT_YELLOW"] = 93] = "BRIGHT_YELLOW";
        COLOR2[COLOR2["BRIGHT_BLUE"] = 94] = "BRIGHT_BLUE";
        COLOR2[COLOR2["BRIGHT_MAGENTA"] = 95] = "BRIGHT_MAGENTA";
        COLOR2[COLOR2["BRIGHT_CYAN"] = 96] = "BRIGHT_CYAN";
        COLOR2[COLOR2["BRIGHT_WHITE"] = 97] = "BRIGHT_WHITE";
      })(COLOR || (COLOR = {}));
      BACKGROUND_INCREMENT = 10;
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/autobind.js
  function autobind(obj) {
    let predefined = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : ["constructor"];
    const proto = Object.getPrototypeOf(obj);
    const propNames = Object.getOwnPropertyNames(proto);
    const object = obj;
    for (const key of propNames) {
      const value = object[key];
      if (typeof value === "function") {
        if (!predefined.find((name) => key === name)) {
          object[key] = value.bind(obj);
        }
      }
    }
  }
  var init_autobind = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/autobind.js"() {
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/assert.js
  function assert3(condition, message) {
    if (!condition) {
      throw new Error(message || "Assertion failed");
    }
  }
  var init_assert3 = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/assert.js"() {
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/utils/hi-res-timestamp.js
  function getHiResTimestamp() {
    let timestamp;
    if (isBrowser3() && window_3.performance) {
      var _window$performance, _window$performance$n;
      timestamp = window_3 === null || window_3 === void 0 ? void 0 : (_window$performance = window_3.performance) === null || _window$performance === void 0 ? void 0 : (_window$performance$n = _window$performance.now) === null || _window$performance$n === void 0 ? void 0 : _window$performance$n.call(_window$performance);
    } else if ("hrtime" in process_) {
      var _process$hrtime;
      const timeParts = process_ === null || process_ === void 0 ? void 0 : (_process$hrtime = process_.hrtime) === null || _process$hrtime === void 0 ? void 0 : _process$hrtime.call(process_);
      timestamp = timeParts[0] * 1e3 + timeParts[1] / 1e6;
    } else {
      timestamp = Date.now();
    }
    return timestamp;
  }
  var init_hi_res_timestamp = __esm({
    "../core/node_modules/@probe.gl/log/dist/utils/hi-res-timestamp.js"() {
      init_dist();
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/log.js
  function noop() {
  }
  function normalizeLogLevel(logLevel) {
    if (!logLevel) {
      return 0;
    }
    let resolvedLevel;
    switch (typeof logLevel) {
      case "number":
        resolvedLevel = logLevel;
        break;
      case "object":
        resolvedLevel = logLevel.logLevel || logLevel.priority || 0;
        break;
      default:
        return 0;
    }
    assert3(Number.isFinite(resolvedLevel) && resolvedLevel >= 0);
    return resolvedLevel;
  }
  function normalizeArguments(opts) {
    const {
      logLevel,
      message
    } = opts;
    opts.logLevel = normalizeLogLevel(logLevel);
    const args = opts.args ? Array.from(opts.args) : [];
    while (args.length && args.shift() !== message) {
    }
    switch (typeof logLevel) {
      case "string":
      case "function":
        if (message !== void 0) {
          args.unshift(message);
        }
        opts.message = logLevel;
        break;
      case "object":
        Object.assign(opts, logLevel);
        break;
      default:
    }
    if (typeof opts.message === "function") {
      opts.message = opts.message();
    }
    const messageType = typeof opts.message;
    assert3(messageType === "string" || messageType === "object");
    return Object.assign(opts, {
      args
    }, opts.opts);
  }
  function decorateMessage(id, message, opts) {
    if (typeof message === "string") {
      const time = opts.time ? leftPad(formatTime(opts.total)) : "";
      message = opts.time ? "".concat(id, ": ").concat(time, "  ").concat(message) : "".concat(id, ": ").concat(message);
      message = addColor(message, opts.color, opts.background);
    }
    return message;
  }
  function logImageInNode(_ref2) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref2;
    console.warn("removed");
    return noop;
  }
  function logImageInBrowser(_ref3) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref3;
    if (typeof image === "string") {
      const img = new Image();
      img.onload = () => {
        const args = formatImage(img, message, scale5);
        console.log(...args);
      };
      img.src = image;
      return noop;
    }
    const element = image.nodeName || "";
    if (element.toLowerCase() === "img") {
      console.log(...formatImage(image, message, scale5));
      return noop;
    }
    if (element.toLowerCase() === "canvas") {
      const img = new Image();
      img.onload = () => console.log(...formatImage(img, message, scale5));
      img.src = image.toDataURL();
      return noop;
    }
    return noop;
  }
  function getTableHeader(table) {
    for (const key in table) {
      for (const title in table[key]) {
        return title || "untitled";
      }
    }
    return "empty";
  }
  var originalConsole, DEFAULT_LOG_CONFIGURATION, cache, ONCE, Log;
  var init_log = __esm({
    "../core/node_modules/@probe.gl/log/dist/log.js"() {
      init_defineProperty();
      init_dist();
      init_local_storage();
      init_formatters();
      init_color();
      init_autobind();
      init_assert3();
      init_hi_res_timestamp();
      originalConsole = {
        debug: isBrowser3() ? console.debug || console.log : console.log,
        log: console.log,
        info: console.info,
        warn: console.warn,
        error: console.error
      };
      DEFAULT_LOG_CONFIGURATION = {
        enabled: true,
        level: 0
      };
      cache = {};
      ONCE = {
        once: true
      };
      Log = class {
        constructor() {
          let {
            id
          } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {
            id: ""
          };
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "VERSION", VERSION5);
          _defineProperty(this, "_startTs", getHiResTimestamp());
          _defineProperty(this, "_deltaTs", getHiResTimestamp());
          _defineProperty(this, "_storage", void 0);
          _defineProperty(this, "userData", {});
          _defineProperty(this, "LOG_THROTTLE_TIMEOUT", 0);
          this.id = id;
          this.userData = {};
          this._storage = new LocalStorage("__probe-".concat(this.id, "__"), DEFAULT_LOG_CONFIGURATION);
          this.timeStamp("".concat(this.id, " started"));
          autobind(this);
          Object.seal(this);
        }
        set level(newLevel) {
          this.setLevel(newLevel);
        }
        get level() {
          return this.getLevel();
        }
        isEnabled() {
          return this._storage.config.enabled;
        }
        getLevel() {
          return this._storage.config.level;
        }
        getTotal() {
          return Number((getHiResTimestamp() - this._startTs).toPrecision(10));
        }
        getDelta() {
          return Number((getHiResTimestamp() - this._deltaTs).toPrecision(10));
        }
        set priority(newPriority) {
          this.level = newPriority;
        }
        get priority() {
          return this.level;
        }
        getPriority() {
          return this.level;
        }
        enable() {
          let enabled = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
          this._storage.setConfiguration({
            enabled
          });
          return this;
        }
        setLevel(level) {
          this._storage.setConfiguration({
            level
          });
          return this;
        }
        get(setting) {
          return this._storage.config[setting];
        }
        set(setting, value) {
          this._storage.setConfiguration({
            [setting]: value
          });
        }
        settings() {
          if (console.table) {
            console.table(this._storage.config);
          } else {
            console.log(this._storage.config);
          }
        }
        assert(condition, message) {
          assert3(condition, message);
        }
        warn(message) {
          return this._getLogFunction(0, message, originalConsole.warn, arguments, ONCE);
        }
        error(message) {
          return this._getLogFunction(0, message, originalConsole.error, arguments);
        }
        deprecated(oldUsage, newUsage) {
          return this.warn("`".concat(oldUsage, "` is deprecated and will be removed in a later version. Use `").concat(newUsage, "` instead"));
        }
        removed(oldUsage, newUsage) {
          return this.error("`".concat(oldUsage, "` has been removed. Use `").concat(newUsage, "` instead"));
        }
        probe(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.log, arguments, {
            time: true,
            once: true
          });
        }
        log(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.debug, arguments);
        }
        info(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.info, arguments);
        }
        once(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.debug || originalConsole.info, arguments, ONCE);
        }
        table(logLevel, table, columns) {
          if (table) {
            return this._getLogFunction(logLevel, table, console.table || noop, columns && [columns], {
              tag: getTableHeader(table)
            });
          }
          return noop;
        }
        image(_ref) {
          let {
            logLevel,
            priority,
            image,
            message = "",
            scale: scale5 = 1
          } = _ref;
          if (!this._shouldLog(logLevel || priority)) {
            return noop;
          }
          return isBrowser3() ? logImageInBrowser({
            image,
            message,
            scale: scale5
          }) : logImageInNode({
            image,
            message,
            scale: scale5
          });
        }
        time(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.time ? console.time : console.info);
        }
        timeEnd(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeEnd ? console.timeEnd : console.info);
        }
        timeStamp(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeStamp || noop);
        }
        group(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {
            collapsed: false
          };
          const options = normalizeArguments({
            logLevel,
            message,
            opts
          });
          const {
            collapsed
          } = opts;
          options.method = (collapsed ? console.groupCollapsed : console.group) || console.info;
          return this._getLogFunction(options);
        }
        groupCollapsed(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
          return this.group(logLevel, message, Object.assign({}, opts, {
            collapsed: true
          }));
        }
        groupEnd(logLevel) {
          return this._getLogFunction(logLevel, "", console.groupEnd || noop);
        }
        withGroup(logLevel, message, func) {
          this.group(logLevel, message)();
          try {
            func();
          } finally {
            this.groupEnd(logLevel)();
          }
        }
        trace() {
          if (console.trace) {
            console.trace();
          }
        }
        _shouldLog(logLevel) {
          return this.isEnabled() && this.getLevel() >= normalizeLogLevel(logLevel);
        }
        _getLogFunction(logLevel, message, method, args, opts) {
          if (this._shouldLog(logLevel)) {
            opts = normalizeArguments({
              logLevel,
              message,
              args,
              opts
            });
            method = method || opts.method;
            assert3(method);
            opts.total = this.getTotal();
            opts.delta = this.getDelta();
            this._deltaTs = getHiResTimestamp();
            const tag = opts.tag || opts.message;
            if (opts.once && tag) {
              if (!cache[tag]) {
                cache[tag] = getHiResTimestamp();
              } else {
                return noop;
              }
            }
            message = decorateMessage(this.id, opts.message, opts);
            return method.bind(console, message, ...opts.args);
          }
          return noop;
        }
      };
      _defineProperty(Log, "VERSION", VERSION5);
    }
  });

  // ../core/node_modules/@probe.gl/log/dist/index.js
  var dist_default;
  var init_dist2 = __esm({
    "../core/node_modules/@probe.gl/log/dist/index.js"() {
      init_log();
      init_log();
      dist_default = new Log({
        id: "@probe.gl/log"
      });
    }
  });

  // ../core/src/lib/loader-utils/loggers.ts
  var probeLog, NullLog, ConsoleLog;
  var init_loggers = __esm({
    "../core/src/lib/loader-utils/loggers.ts"() {
      init_dist2();
      probeLog = new Log({ id: "loaders.gl" });
      NullLog = class {
        log() {
          return () => {
          };
        }
        info() {
          return () => {
          };
        }
        warn() {
          return () => {
          };
        }
        error() {
          return () => {
          };
        }
      };
      ConsoleLog = class {
        constructor() {
          this.console = console;
        }
        log(...args) {
          return this.console.log.bind(this.console, ...args);
        }
        info(...args) {
          return this.console.info.bind(this.console, ...args);
        }
        warn(...args) {
          return this.console.warn.bind(this.console, ...args);
        }
        error(...args) {
          return this.console.error.bind(this.console, ...args);
        }
      };
    }
  });

  // ../core/src/lib/loader-utils/option-defaults.ts
  var DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS;
  var init_option_defaults = __esm({
    "../core/src/lib/loader-utils/option-defaults.ts"() {
      init_src2();
      init_loggers();
      DEFAULT_LOADER_OPTIONS = {
        fetch: null,
        mimeType: void 0,
        nothrow: false,
        log: new ConsoleLog(),
        CDN: "https://unpkg.com/@loaders.gl",
        worker: true,
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: isBrowser,
        _nodeWorkers: false,
        _workerType: "",
        limit: 0,
        _limitMB: 0,
        batchSize: "auto",
        batchDebounceMs: 0,
        metadata: false,
        transforms: []
      };
      REMOVED_LOADER_OPTIONS = {
        throws: "nothrow",
        dataType: "(no longer used)",
        uri: "baseUri",
        method: "fetch.method",
        headers: "fetch.headers",
        body: "fetch.body",
        mode: "fetch.mode",
        credentials: "fetch.credentials",
        cache: "fetch.cache",
        redirect: "fetch.redirect",
        referrer: "fetch.referrer",
        referrerPolicy: "fetch.referrerPolicy",
        integrity: "fetch.integrity",
        keepalive: "fetch.keepalive",
        signal: "fetch.signal"
      };
    }
  });

  // ../core/src/lib/loader-utils/option-utils.ts
  function getGlobalLoaderState() {
    globalThis.loaders = globalThis.loaders || {};
    const { loaders } = globalThis;
    loaders._state = loaders._state || {};
    return loaders._state;
  }
  function normalizeOptions(options, loader, loaders, url) {
    loaders = loaders || [];
    loaders = Array.isArray(loaders) ? loaders : [loaders];
    validateOptions(options, loaders);
    return normalizeOptionsInternal(loader, options, url);
  }
  function validateOptions(options, loaders) {
    validateOptionsObject(options, null, DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS, loaders);
    for (const loader of loaders) {
      const idOptions = options && options[loader.id] || {};
      const loaderOptions = loader.options && loader.options[loader.id] || {};
      const deprecatedOptions = loader.deprecatedOptions && loader.deprecatedOptions[loader.id] || {};
      validateOptionsObject(idOptions, loader.id, loaderOptions, deprecatedOptions, loaders);
    }
  }
  function validateOptionsObject(options, id, defaultOptions, deprecatedOptions, loaders) {
    const loaderName = id || "Top level";
    const prefix = id ? `${id}.` : "";
    for (const key in options) {
      const isSubOptions = !id && isObject(options[key]);
      const isBaseUriOption = key === "baseUri" && !id;
      const isWorkerUrlOption = key === "workerUrl" && id;
      if (!(key in defaultOptions) && !isBaseUriOption && !isWorkerUrlOption) {
        if (key in deprecatedOptions) {
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' no longer supported, use '${deprecatedOptions[key]}'`)();
        } else if (!isSubOptions) {
          const suggestion = findSimilarOption(key, loaders);
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' not recognized. ${suggestion}`)();
        }
      }
    }
  }
  function findSimilarOption(optionKey, loaders) {
    const lowerCaseOptionKey = optionKey.toLowerCase();
    let bestSuggestion = "";
    for (const loader of loaders) {
      for (const key in loader.options) {
        if (optionKey === key) {
          return `Did you mean '${loader.id}.${key}'?`;
        }
        const lowerCaseKey = key.toLowerCase();
        const isPartialMatch = lowerCaseOptionKey.startsWith(lowerCaseKey) || lowerCaseKey.startsWith(lowerCaseOptionKey);
        if (isPartialMatch) {
          bestSuggestion = bestSuggestion || `Did you mean '${loader.id}.${key}'?`;
        }
      }
    }
    return bestSuggestion;
  }
  function normalizeOptionsInternal(loader, options, url) {
    const loaderDefaultOptions = loader.options || {};
    const mergedOptions = { ...loaderDefaultOptions };
    addUrlOptions(mergedOptions, url);
    if (mergedOptions.log === null) {
      mergedOptions.log = new NullLog();
    }
    mergeNestedFields(mergedOptions, getGlobalLoaderOptions());
    mergeNestedFields(mergedOptions, options);
    return mergedOptions;
  }
  function mergeNestedFields(mergedOptions, options) {
    for (const key in options) {
      if (key in options) {
        const value = options[key];
        if (isPureObject(value) && isPureObject(mergedOptions[key])) {
          mergedOptions[key] = {
            ...mergedOptions[key],
            ...options[key]
          };
        } else {
          mergedOptions[key] = options[key];
        }
      }
    }
  }
  function addUrlOptions(options, url) {
    if (url && !("baseUri" in options)) {
      options.baseUri = url;
    }
  }
  var getGlobalLoaderOptions;
  var init_option_utils = __esm({
    "../core/src/lib/loader-utils/option-utils.ts"() {
      init_is_type();
      init_loggers();
      init_option_defaults();
      getGlobalLoaderOptions = () => {
        const state = getGlobalLoaderState();
        state.globalOptions = state.globalOptions || { ...DEFAULT_LOADER_OPTIONS };
        return state.globalOptions;
      };
    }
  });

  // ../core/src/lib/loader-utils/normalize-loader.ts
  function isLoaderObject(loader) {
    if (!loader) {
      return false;
    }
    if (Array.isArray(loader)) {
      loader = loader[0];
    }
    const hasExtensions = Array.isArray(loader?.extensions);
    return hasExtensions;
  }
  function normalizeLoader(loader) {
    assert(loader, "null loader");
    assert(isLoaderObject(loader), "invalid loader");
    let options;
    if (Array.isArray(loader)) {
      options = loader[1];
      loader = loader[0];
      loader = {
        ...loader,
        options: { ...loader.options, ...options }
      };
    }
    if (loader?.parseTextSync || loader?.parseText) {
      loader.text = true;
    }
    if (!loader.text) {
      loader.binary = true;
    }
    return loader;
  }
  var init_normalize_loader = __esm({
    "../core/src/lib/loader-utils/normalize-loader.ts"() {
      init_src2();
    }
  });

  // ../core/src/lib/api/register-loaders.ts
  function getRegisteredLoaders() {
    return getGlobalLoaderRegistry();
  }
  var getGlobalLoaderRegistry;
  var init_register_loaders = __esm({
    "../core/src/lib/api/register-loaders.ts"() {
      init_option_utils();
      getGlobalLoaderRegistry = () => {
        const state = getGlobalLoaderState();
        state.loaderRegistry = state.loaderRegistry || [];
        return state.loaderRegistry;
      };
    }
  });

  // ../core/src/lib/utils/log.ts
  var log;
  var init_log2 = __esm({
    "../core/src/lib/utils/log.ts"() {
      init_dist2();
      log = new Log({ id: "loaders.gl" });
    }
  });

  // ../core/src/lib/api/select-loader.ts
  async function selectLoader(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    let loader = selectLoaderSync(data, loaders, { ...options, nothrow: true }, context);
    if (loader) {
      return loader;
    }
    if (isBlob(data)) {
      data = await data.slice(0, 10).arrayBuffer();
      loader = selectLoaderSync(data, loaders, options, context);
    }
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderSync(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    if (loaders && !Array.isArray(loaders)) {
      return normalizeLoader(loaders);
    }
    let candidateLoaders = [];
    if (loaders) {
      candidateLoaders = candidateLoaders.concat(loaders);
    }
    if (!options?.ignoreRegisteredLoaders) {
      candidateLoaders.push(...getRegisteredLoaders());
    }
    normalizeLoaders(candidateLoaders);
    const loader = selectLoaderInternal(data, candidateLoaders, options, context);
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderInternal(data, loaders, options, context) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    const testUrl = stripQueryString(url) || context?.url;
    let loader = null;
    let reason = "";
    if (options?.mimeType) {
      loader = findLoaderByMIMEType(loaders, options?.mimeType);
      reason = `match forced by supplied MIME type ${options?.mimeType}`;
    }
    loader = loader || findLoaderByUrl(loaders, testUrl);
    reason = reason || (loader ? `matched url ${testUrl}` : "");
    loader = loader || findLoaderByMIMEType(loaders, type);
    reason = reason || (loader ? `matched MIME type ${type}` : "");
    loader = loader || findLoaderByInitialBytes(loaders, data);
    reason = reason || (loader ? `matched initial data ${getFirstCharacters(data)}` : "");
    loader = loader || findLoaderByMIMEType(loaders, options?.fallbackMimeType);
    reason = reason || (loader ? `matched fallback MIME type ${type}` : "");
    if (reason) {
      log.log(1, `selectLoader selected ${loader?.name}: ${reason}.`);
    }
    return loader;
  }
  function validHTTPResponse(data) {
    if (data instanceof Response) {
      if (data.status === 204) {
        return false;
      }
    }
    return true;
  }
  function getNoValidLoaderMessage(data) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    let message = "No valid loader found (";
    message += url ? `${path_exports.filename(url)}, ` : "no url provided, ";
    message += `MIME type: ${type ? `"${type}"` : "not provided"}, `;
    const firstCharacters = data ? getFirstCharacters(data) : "";
    message += firstCharacters ? ` first bytes: "${firstCharacters}"` : "first bytes: not available";
    message += ")";
    return message;
  }
  function normalizeLoaders(loaders) {
    for (const loader of loaders) {
      normalizeLoader(loader);
    }
  }
  function findLoaderByUrl(loaders, url) {
    const match = url && EXT_PATTERN.exec(url);
    const extension = match && match[1];
    return extension ? findLoaderByExtension(loaders, extension) : null;
  }
  function findLoaderByExtension(loaders, extension) {
    extension = extension.toLowerCase();
    for (const loader of loaders) {
      for (const loaderExtension of loader.extensions) {
        if (loaderExtension.toLowerCase() === extension) {
          return loader;
        }
      }
    }
    return null;
  }
  function findLoaderByMIMEType(loaders, mimeType) {
    for (const loader of loaders) {
      if (loader.mimeTypes && loader.mimeTypes.includes(mimeType)) {
        return loader;
      }
      if (mimeType === `application/x.${loader.id}`) {
        return loader;
      }
    }
    return null;
  }
  function findLoaderByInitialBytes(loaders, data) {
    if (!data) {
      return null;
    }
    for (const loader of loaders) {
      if (typeof data === "string") {
        if (testDataAgainstText(data, loader)) {
          return loader;
        }
      } else if (ArrayBuffer.isView(data)) {
        if (testDataAgainstBinary(data.buffer, data.byteOffset, loader)) {
          return loader;
        }
      } else if (data instanceof ArrayBuffer) {
        const byteOffset = 0;
        if (testDataAgainstBinary(data, byteOffset, loader)) {
          return loader;
        }
      }
    }
    return null;
  }
  function testDataAgainstText(data, loader) {
    if (loader.testText) {
      return loader.testText(data);
    }
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => data.startsWith(test));
  }
  function testDataAgainstBinary(data, byteOffset, loader) {
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => testBinary(data, byteOffset, loader, test));
  }
  function testBinary(data, byteOffset, loader, test) {
    if (test instanceof ArrayBuffer) {
      return compareArrayBuffers(test, data, test.byteLength);
    }
    switch (typeof test) {
      case "function":
        return test(data, loader);
      case "string":
        const magic = getMagicString(data, byteOffset, test.length);
        return test === magic;
      default:
        return false;
    }
  }
  function getFirstCharacters(data, length4 = 5) {
    if (typeof data === "string") {
      return data.slice(0, length4);
    } else if (ArrayBuffer.isView(data)) {
      return getMagicString(data.buffer, data.byteOffset, length4);
    } else if (data instanceof ArrayBuffer) {
      const byteOffset = 0;
      return getMagicString(data, byteOffset, length4);
    }
    return "";
  }
  function getMagicString(arrayBuffer, byteOffset, length4) {
    if (arrayBuffer.byteLength < byteOffset + length4) {
      return "";
    }
    const dataView = new DataView(arrayBuffer);
    let magic = "";
    for (let i2 = 0; i2 < length4; i2++) {
      magic += String.fromCharCode(dataView.getUint8(byteOffset + i2));
    }
    return magic;
  }
  var EXT_PATTERN;
  var init_select_loader = __esm({
    "../core/src/lib/api/select-loader.ts"() {
      init_src2();
      init_normalize_loader();
      init_log2();
      init_resource_utils();
      init_register_loaders();
      init_is_type();
      init_url_utils();
      EXT_PATTERN = /\.([^.]+)$/;
    }
  });

  // ../core/src/iterators/make-iterator/make-string-iterator.ts
  function* makeStringIterator(string, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE;
    let offset = 0;
    const textEncoder = new TextEncoder();
    while (offset < string.length) {
      const chunkLength = Math.min(string.length - offset, chunkSize);
      const chunk = string.slice(offset, offset + chunkLength);
      offset += chunkLength;
      yield textEncoder.encode(chunk);
    }
  }
  var DEFAULT_CHUNK_SIZE;
  var init_make_string_iterator = __esm({
    "../core/src/iterators/make-iterator/make-string-iterator.ts"() {
      DEFAULT_CHUNK_SIZE = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-array-buffer-iterator.ts
  function* makeArrayBufferIterator(arrayBuffer, options = {}) {
    const { chunkSize = DEFAULT_CHUNK_SIZE2 } = options;
    let byteOffset = 0;
    while (byteOffset < arrayBuffer.byteLength) {
      const chunkByteLength = Math.min(arrayBuffer.byteLength - byteOffset, chunkSize);
      const chunk = new ArrayBuffer(chunkByteLength);
      const sourceArray = new Uint8Array(arrayBuffer, byteOffset, chunkByteLength);
      const chunkArray = new Uint8Array(chunk);
      chunkArray.set(sourceArray);
      byteOffset += chunkByteLength;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE2;
  var init_make_array_buffer_iterator = __esm({
    "../core/src/iterators/make-iterator/make-array-buffer-iterator.ts"() {
      DEFAULT_CHUNK_SIZE2 = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-blob-iterator.ts
  async function* makeBlobIterator(blob, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE3;
    let offset = 0;
    while (offset < blob.size) {
      const end = offset + chunkSize;
      const chunk = await blob.slice(offset, end).arrayBuffer();
      offset = end;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE3;
  var init_make_blob_iterator = __esm({
    "../core/src/iterators/make-iterator/make-blob-iterator.ts"() {
      DEFAULT_CHUNK_SIZE3 = 1024 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-stream-iterator.ts
  function makeStreamIterator(stream, options) {
    return isBrowser ? makeBrowserStreamIterator(stream, options) : makeNodeStreamIterator(stream, options);
  }
  async function* makeBrowserStreamIterator(stream, options) {
    const reader = stream.getReader();
    let nextBatchPromise;
    try {
      while (true) {
        const currentBatchPromise = nextBatchPromise || reader.read();
        if (options?._streamReadAhead) {
          nextBatchPromise = reader.read();
        }
        const { done, value } = await currentBatchPromise;
        if (done) {
          return;
        }
        yield toArrayBuffer2(value);
      }
    } catch (error) {
      reader.releaseLock();
    }
  }
  async function* makeNodeStreamIterator(stream, options) {
    for await (const chunk of stream) {
      yield toArrayBuffer2(chunk);
    }
  }
  var init_make_stream_iterator = __esm({
    "../core/src/iterators/make-iterator/make-stream-iterator.ts"() {
      init_src2();
    }
  });

  // ../core/src/iterators/make-iterator/make-iterator.ts
  function makeIterator(data, options) {
    if (typeof data === "string") {
      return makeStringIterator(data, options);
    }
    if (data instanceof ArrayBuffer) {
      return makeArrayBufferIterator(data, options);
    }
    if (isBlob(data)) {
      return makeBlobIterator(data, options);
    }
    if (isReadableStream(data)) {
      return makeStreamIterator(data, options);
    }
    if (isResponse(data)) {
      const response = data;
      return makeStreamIterator(response.body, options);
    }
    throw new Error("makeIterator");
  }
  var init_make_iterator = __esm({
    "../core/src/iterators/make-iterator/make-iterator.ts"() {
      init_make_string_iterator();
      init_make_array_buffer_iterator();
      init_make_blob_iterator();
      init_make_stream_iterator();
      init_is_type();
    }
  });

  // ../core/src/lib/loader-utils/get-data.ts
  function getArrayBufferOrStringFromDataSync(data, loader, options) {
    if (loader.text && typeof data === "string") {
      return data;
    }
    if (isBuffer2(data)) {
      data = data.buffer;
    }
    if (data instanceof ArrayBuffer) {
      const arrayBuffer = data;
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(arrayBuffer);
      }
      return arrayBuffer;
    }
    if (ArrayBuffer.isView(data)) {
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(data);
      }
      let arrayBuffer = data.buffer;
      const byteLength = data.byteLength || data.length;
      if (data.byteOffset !== 0 || byteLength !== arrayBuffer.byteLength) {
        arrayBuffer = arrayBuffer.slice(data.byteOffset, data.byteOffset + byteLength);
      }
      return arrayBuffer;
    }
    throw new Error(ERR_DATA);
  }
  async function getArrayBufferOrStringFromData(data, loader, options) {
    const isArrayBuffer = data instanceof ArrayBuffer || ArrayBuffer.isView(data);
    if (typeof data === "string" || isArrayBuffer) {
      return getArrayBufferOrStringFromDataSync(data, loader, options);
    }
    if (isBlob(data)) {
      data = await makeResponse(data);
    }
    if (isResponse(data)) {
      const response = data;
      await checkResponse(response);
      return loader.binary ? await response.arrayBuffer() : await response.text();
    }
    if (isReadableStream(data)) {
      data = makeIterator(data, options);
    }
    if (isIterable(data) || isAsyncIterable(data)) {
      return concatenateArrayBuffersAsync(data);
    }
    throw new Error(ERR_DATA);
  }
  var ERR_DATA;
  var init_get_data = __esm({
    "../core/src/lib/loader-utils/get-data.ts"() {
      init_src2();
      init_is_type();
      init_make_iterator();
      init_response_utils();
      ERR_DATA = "Cannot convert supplied data type";
    }
  });

  // ../core/src/lib/loader-utils/get-fetch-function.ts
  function getFetchFunction(options, context) {
    const globalOptions = getGlobalLoaderOptions();
    const fetchOptions = options || globalOptions;
    if (typeof fetchOptions.fetch === "function") {
      return fetchOptions.fetch;
    }
    if (isObject(fetchOptions.fetch)) {
      return (url) => fetchFile(url, fetchOptions);
    }
    if (context?.fetch) {
      return context?.fetch;
    }
    return fetchFile;
  }
  var init_get_fetch_function = __esm({
    "../core/src/lib/loader-utils/get-fetch-function.ts"() {
      init_is_type();
      init_fetch_file();
      init_option_utils();
    }
  });

  // ../core/src/lib/loader-utils/loader-context.ts
  function getLoaderContext(context, options, parentContext) {
    if (parentContext) {
      return parentContext;
    }
    const newContext = {
      fetch: getFetchFunction(options, context),
      ...context
    };
    if (newContext.url) {
      const baseUrl = stripQueryString(newContext.url);
      newContext.baseUrl = baseUrl;
      newContext.queryString = extractQueryString(newContext.url);
      newContext.filename = path_exports.filename(baseUrl);
      newContext.baseUrl = path_exports.dirname(baseUrl);
    }
    if (!Array.isArray(newContext.loaders)) {
      newContext.loaders = null;
    }
    return newContext;
  }
  function getLoadersFromContext(loaders, context) {
    if (!context && loaders && !Array.isArray(loaders)) {
      return loaders;
    }
    let candidateLoaders;
    if (loaders) {
      candidateLoaders = Array.isArray(loaders) ? loaders : [loaders];
    }
    if (context && context.loaders) {
      const contextLoaders = Array.isArray(context.loaders) ? context.loaders : [context.loaders];
      candidateLoaders = candidateLoaders ? [...candidateLoaders, ...contextLoaders] : contextLoaders;
    }
    return candidateLoaders && candidateLoaders.length ? candidateLoaders : null;
  }
  var init_loader_context = __esm({
    "../core/src/lib/loader-utils/loader-context.ts"() {
      init_get_fetch_function();
      init_url_utils();
      init_src2();
    }
  });

  // ../core/src/lib/api/parse.ts
  async function parse(data, loaders, options, context) {
    assert2(!context || typeof context === "object");
    if (loaders && !Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    data = await data;
    options = options || {};
    const url = getResourceUrl(data);
    const typedLoaders = loaders;
    const candidateLoaders = getLoadersFromContext(typedLoaders, context);
    const loader = await selectLoader(data, candidateLoaders, options);
    if (!loader) {
      return null;
    }
    options = normalizeOptions(options, loader, candidateLoaders, url);
    context = getLoaderContext({ url, parse, loaders: candidateLoaders }, options, context || null);
    return await parseWithLoader(loader, data, options, context);
  }
  async function parseWithLoader(loader, data, options, context) {
    validateWorkerVersion(loader);
    if (isResponse(data)) {
      const response = data;
      const { ok, redirected, status, statusText, type, url } = response;
      const headers = Object.fromEntries(response.headers.entries());
      context.response = { headers, ok, redirected, status, statusText, type, url };
    }
    data = await getArrayBufferOrStringFromData(data, loader, options);
    if (loader.parseTextSync && typeof data === "string") {
      options.dataType = "text";
      return loader.parseTextSync(data, options, context, loader);
    }
    if (canParseWithWorker(loader, options)) {
      return await parseWithWorker(loader, data, options, context, parse);
    }
    if (loader.parseText && typeof data === "string") {
      return await loader.parseText(data, options, context, loader);
    }
    if (loader.parse) {
      return await loader.parse(data, options, context, loader);
    }
    assert2(!loader.parseSync);
    throw new Error(`${loader.id} loader - no parser found and worker is disabled`);
  }
  var init_parse = __esm({
    "../core/src/lib/api/parse.ts"() {
      init_src();
      init_src2();
      init_normalize_loader();
      init_is_type();
      init_option_utils();
      init_get_data();
      init_loader_context();
      init_resource_utils();
      init_select_loader();
    }
  });

  // ../core/src/lib/api/load.ts
  async function load(url, loaders, options, context) {
    if (!Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    const fetch2 = getFetchFunction(options);
    let data = url;
    if (typeof url === "string") {
      data = await fetch2(url);
    }
    if (isBlob(url)) {
      data = await fetch2(url);
    }
    return await parse(data, loaders, options);
  }
  var init_load = __esm({
    "../core/src/lib/api/load.ts"() {
      init_is_type();
      init_normalize_loader();
      init_get_fetch_function();
      init_parse();
    }
  });

  // ../core/src/index.ts
  var init_src3 = __esm({
    "../core/src/index.ts"() {
      init_parse();
      init_load();
      init_src2();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/assert.js
  function assert4(condition, message) {
    if (!condition) {
      throw new Error("math.gl assertion ".concat(message));
    }
  }
  var init_assert4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/assert.js"() {
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/common.js
  function formatValue(value, {
    precision = config.precision
  } = {}) {
    value = round(value);
    return "".concat(parseFloat(value.toPrecision(precision)));
  }
  function isArray(value) {
    return Array.isArray(value) || ArrayBuffer.isView(value) && !(value instanceof DataView);
  }
  function toRadians(degrees2) {
    return radians(degrees2);
  }
  function toDegrees(radians2) {
    return degrees(radians2);
  }
  function radians(degrees2, result) {
    return map(degrees2, (degrees3) => degrees3 * DEGREES_TO_RADIANS, result);
  }
  function degrees(radians2, result) {
    return map(radians2, (radians3) => radians3 * RADIANS_TO_DEGREES, result);
  }
  function equals(a2, b, epsilon) {
    const oldEpsilon = config.EPSILON;
    if (epsilon) {
      config.EPSILON = epsilon;
    }
    try {
      if (a2 === b) {
        return true;
      }
      if (isArray(a2) && isArray(b)) {
        if (a2.length !== b.length) {
          return false;
        }
        for (let i2 = 0; i2 < a2.length; ++i2) {
          if (!equals(a2[i2], b[i2])) {
            return false;
          }
        }
        return true;
      }
      if (a2 && a2.equals) {
        return a2.equals(b);
      }
      if (b && b.equals) {
        return b.equals(a2);
      }
      if (typeof a2 === "number" && typeof b === "number") {
        return Math.abs(a2 - b) <= config.EPSILON * Math.max(1, Math.abs(a2), Math.abs(b));
      }
      return false;
    } finally {
      config.EPSILON = oldEpsilon;
    }
  }
  function round(value) {
    return Math.round(value / config.EPSILON) * config.EPSILON;
  }
  function duplicateArray(array) {
    return array.clone ? array.clone() : new Array(array.length);
  }
  function map(value, func, result) {
    if (isArray(value)) {
      const array = value;
      result = result || duplicateArray(array);
      for (let i2 = 0; i2 < result.length && i2 < array.length; ++i2) {
        result[i2] = func(value[i2], i2, result);
      }
      return result;
    }
    return func(value);
  }
  var RADIANS_TO_DEGREES, DEGREES_TO_RADIANS, config;
  var init_common = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/common.js"() {
      RADIANS_TO_DEGREES = 1 / Math.PI * 180;
      DEGREES_TO_RADIANS = 1 / 180 * Math.PI;
      config = {
        EPSILON: 1e-12,
        debug: false,
        precision: 4,
        printTypes: false,
        printDegrees: false,
        printRowMajor: true
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js
  function _extendableBuiltin(cls) {
    function ExtendableBuiltin() {
      var instance = Reflect.construct(cls, Array.from(arguments));
      Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
      return instance;
    }
    ExtendableBuiltin.prototype = Object.create(cls.prototype, {
      constructor: {
        value: cls,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(ExtendableBuiltin, cls);
    } else {
      ExtendableBuiltin.__proto__ = cls;
    }
    return ExtendableBuiltin;
  }
  var MathArray;
  var init_math_array = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js"() {
      init_common();
      MathArray = class extends _extendableBuiltin(Array) {
        clone() {
          return new this.constructor().copy(this);
        }
        fromArray(array, offset = 0) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = array[i2 + offset];
          }
          return this.check();
        }
        toArray(targetArray = [], offset = 0) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            targetArray[offset + i2] = this[i2];
          }
          return targetArray;
        }
        from(arrayOrObject) {
          return Array.isArray(arrayOrObject) ? this.copy(arrayOrObject) : this.fromObject(arrayOrObject);
        }
        to(arrayOrObject) {
          if (arrayOrObject === this) {
            return this;
          }
          return isArray(arrayOrObject) ? this.toArray(arrayOrObject) : this.toObject(arrayOrObject);
        }
        toTarget(target) {
          return target ? this.to(target) : this;
        }
        toFloat32Array() {
          return new Float32Array(this);
        }
        toString() {
          return this.formatString(config);
        }
        formatString(opts) {
          let string = "";
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            string += (i2 > 0 ? ", " : "") + formatValue(this[i2], opts);
          }
          return "".concat(opts.printTypes ? this.constructor.name : "", "[").concat(string, "]");
        }
        equals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            if (!equals(this[i2], array[i2])) {
              return false;
            }
          }
          return true;
        }
        exactEquals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            if (this[i2] !== array[i2]) {
              return false;
            }
          }
          return true;
        }
        negate() {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = -this[i2];
          }
          return this.check();
        }
        lerp(a2, b, t2) {
          if (t2 === void 0) {
            return this.lerp(this, a2, b);
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            const ai = a2[i2];
            this[i2] = ai + t2 * (b[i2] - ai);
          }
          return this.check();
        }
        min(vector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(vector[i2], this[i2]);
          }
          return this.check();
        }
        max(vector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.max(vector[i2], this[i2]);
          }
          return this.check();
        }
        clamp(minVector, maxVector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(Math.max(this[i2], minVector[i2]), maxVector[i2]);
          }
          return this.check();
        }
        add(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] += vector[i2];
            }
          }
          return this.check();
        }
        subtract(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] -= vector[i2];
            }
          }
          return this.check();
        }
        scale(scale5) {
          if (typeof scale5 === "number") {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] *= scale5;
            }
          } else {
            for (let i2 = 0; i2 < this.ELEMENTS && i2 < scale5.length; ++i2) {
              this[i2] *= scale5[i2];
            }
          }
          return this.check();
        }
        multiplyByScalar(scalar) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] *= scalar;
          }
          return this.check();
        }
        check() {
          if (config.debug && !this.validate()) {
            throw new Error("math.gl: ".concat(this.constructor.name, " some fields set to invalid numbers'"));
          }
          return this;
        }
        validate() {
          let valid = this.length === this.ELEMENTS;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            valid = valid && Number.isFinite(this[i2]);
          }
          return valid;
        }
        sub(a2) {
          return this.subtract(a2);
        }
        setScalar(a2) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = a2;
          }
          return this.check();
        }
        addScalar(a2) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] += a2;
          }
          return this.check();
        }
        subScalar(a2) {
          return this.addScalar(-a2);
        }
        multiplyScalar(scalar) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] *= scalar;
          }
          return this.check();
        }
        divideScalar(a2) {
          return this.multiplyByScalar(1 / a2);
        }
        clampScalar(min, max) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(Math.max(this[i2], min), max);
          }
          return this.check();
        }
        get elements() {
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/validators.js
  function validateVector(v, length4) {
    if (v.length !== length4) {
      return false;
    }
    for (let i2 = 0; i2 < v.length; ++i2) {
      if (!Number.isFinite(v[i2])) {
        return false;
      }
    }
    return true;
  }
  function checkNumber(value) {
    if (!Number.isFinite(value)) {
      throw new Error("Invalid number ".concat(value));
    }
    return value;
  }
  function checkVector(v, length4, callerName = "") {
    if (config.debug && !validateVector(v, length4)) {
      throw new Error("math.gl: ".concat(callerName, " some fields set to invalid numbers'"));
    }
    return v;
  }
  var init_validators = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/validators.js"() {
      init_common();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js
  var Vector;
  var init_vector = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js"() {
      init_math_array();
      init_validators();
      init_assert4();
      Vector = class extends MathArray {
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        len() {
          return Math.sqrt(this.lengthSquared());
        }
        magnitude() {
          return this.len();
        }
        lengthSquared() {
          let length4 = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            length4 += this[i2] * this[i2];
          }
          return length4;
        }
        magnitudeSquared() {
          return this.lengthSquared();
        }
        distance(mathArray) {
          return Math.sqrt(this.distanceSquared(mathArray));
        }
        distanceSquared(mathArray) {
          let length4 = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            const dist = this[i2] - mathArray[i2];
            length4 += dist * dist;
          }
          return checkNumber(length4);
        }
        dot(mathArray) {
          let product = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            product += this[i2] * mathArray[i2];
          }
          return checkNumber(product);
        }
        normalize() {
          const length4 = this.magnitude();
          if (length4 !== 0) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] /= length4;
            }
          }
          return this.check();
        }
        multiply(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] *= vector[i2];
            }
          }
          return this.check();
        }
        divide(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] /= vector[i2];
            }
          }
          return this.check();
        }
        lengthSq() {
          return this.lengthSquared();
        }
        distanceTo(vector) {
          return this.distance(vector);
        }
        distanceToSquared(vector) {
          return this.distanceSquared(vector);
        }
        getComponent(i2) {
          assert4(i2 >= 0 && i2 < this.ELEMENTS, "index is out of range");
          return checkNumber(this[i2]);
        }
        setComponent(i2, value) {
          assert4(i2 >= 0 && i2 < this.ELEMENTS, "index is out of range");
          this[i2] = value;
          return this.check();
        }
        addVectors(a2, b) {
          return this.copy(a2).add(b);
        }
        subVectors(a2, b) {
          return this.copy(a2).subtract(b);
        }
        multiplyVectors(a2, b) {
          return this.copy(a2).multiply(b);
        }
        addScaledVector(a2, b) {
          return this.add(new this.constructor(a2).multiplyScalar(b));
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/common.js
  var EPSILON, ARRAY_TYPE, degree;
  var init_common2 = __esm({
    "../../node_modules/gl-matrix/esm/common.js"() {
      EPSILON = 1e-6;
      ARRAY_TYPE = typeof Float32Array !== "undefined" ? Float32Array : Array;
      degree = Math.PI / 180;
      if (!Math.hypot)
        Math.hypot = function() {
          var y = 0, i2 = arguments.length;
          while (i2--) {
            y += arguments[i2] * arguments[i2];
          }
          return Math.sqrt(y);
        };
    }
  });

  // ../../node_modules/gl-matrix/esm/vec2.js
  function create() {
    var out = new ARRAY_TYPE(2);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
    }
    return out;
  }
  function transformMat3(out, a2, m) {
    var x = a2[0], y = a2[1];
    out[0] = m[0] * x + m[3] * y + m[6];
    out[1] = m[1] * x + m[4] * y + m[7];
    return out;
  }
  function transformMat4(out, a2, m) {
    var x = a2[0];
    var y = a2[1];
    out[0] = m[0] * x + m[4] * y + m[12];
    out[1] = m[1] * x + m[5] * y + m[13];
    return out;
  }
  var forEach2;
  var init_vec2 = __esm({
    "../../node_modules/gl-matrix/esm/vec2.js"() {
      init_common2();
      forEach2 = function() {
        var vec = create();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 2;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js
  function vec2_transformMat4AsVector(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const w = m[3] * x + m[7] * y || 1;
    out[0] = (m[0] * x + m[4] * y) / w;
    out[1] = (m[1] * x + m[5] * y) / w;
    return out;
  }
  function vec3_transformMat4AsVector(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const z = a2[2];
    const w = m[3] * x + m[7] * y + m[11] * z || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z) / w;
    return out;
  }
  function vec3_transformMat2(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a2[2];
    return out;
  }
  function vec4_transformMat2(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a2[2];
    out[3] = a2[3];
    return out;
  }
  function vec4_transformMat3(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const z = a2[2];
    out[0] = m[0] * x + m[3] * y + m[6] * z;
    out[1] = m[1] * x + m[4] * y + m[7] * z;
    out[2] = m[2] * x + m[5] * y + m[8] * z;
    out[3] = a2[3];
    return out;
  }
  var init_gl_matrix_extras = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js"() {
    }
  });

  // ../../node_modules/gl-matrix/esm/vec3.js
  function create2() {
    var out = new ARRAY_TYPE(3);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    return out;
  }
  function length(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    return Math.hypot(x, y, z);
  }
  function fromValues(x, y, z) {
    var out = new ARRAY_TYPE(3);
    out[0] = x;
    out[1] = y;
    out[2] = z;
    return out;
  }
  function normalize(out, a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var len2 = x * x + y * y + z * z;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = a2[0] * len2;
    out[1] = a2[1] * len2;
    out[2] = a2[2] * len2;
    return out;
  }
  function dot(a2, b) {
    return a2[0] * b[0] + a2[1] * b[1] + a2[2] * b[2];
  }
  function cross(out, a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2];
    var bx = b[0], by = b[1], bz = b[2];
    out[0] = ay * bz - az * by;
    out[1] = az * bx - ax * bz;
    out[2] = ax * by - ay * bx;
    return out;
  }
  function transformMat42(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2];
    var w = m[3] * x + m[7] * y + m[11] * z + m[15];
    w = w || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z + m[12]) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z + m[13]) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z + m[14]) / w;
    return out;
  }
  function transformMat32(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2];
    out[0] = x * m[0] + y * m[3] + z * m[6];
    out[1] = x * m[1] + y * m[4] + z * m[7];
    out[2] = x * m[2] + y * m[5] + z * m[8];
    return out;
  }
  function transformQuat(out, a2, q) {
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var x = a2[0], y = a2[1], z = a2[2];
    var uvx = qy * z - qz * y, uvy = qz * x - qx * z, uvz = qx * y - qy * x;
    var uuvx = qy * uvz - qz * uvy, uuvy = qz * uvx - qx * uvz, uuvz = qx * uvy - qy * uvx;
    var w2 = qw * 2;
    uvx *= w2;
    uvy *= w2;
    uvz *= w2;
    uuvx *= 2;
    uuvy *= 2;
    uuvz *= 2;
    out[0] = x + uvx + uuvx;
    out[1] = y + uvy + uuvy;
    out[2] = z + uvz + uuvz;
    return out;
  }
  function rotateX(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[0];
    r2[1] = p2[1] * Math.cos(rad) - p2[2] * Math.sin(rad);
    r2[2] = p2[1] * Math.sin(rad) + p2[2] * Math.cos(rad);
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function rotateY(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[2] * Math.sin(rad) + p2[0] * Math.cos(rad);
    r2[1] = p2[1];
    r2[2] = p2[2] * Math.cos(rad) - p2[0] * Math.sin(rad);
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function rotateZ(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[0] * Math.cos(rad) - p2[1] * Math.sin(rad);
    r2[1] = p2[0] * Math.sin(rad) + p2[1] * Math.cos(rad);
    r2[2] = p2[2];
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function angle(a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2], bx = b[0], by = b[1], bz = b[2], mag1 = Math.sqrt(ax * ax + ay * ay + az * az), mag2 = Math.sqrt(bx * bx + by * by + bz * bz), mag = mag1 * mag2, cosine = mag && dot(a2, b) / mag;
    return Math.acos(Math.min(Math.max(cosine, -1), 1));
  }
  var len, forEach3;
  var init_vec3 = __esm({
    "../../node_modules/gl-matrix/esm/vec3.js"() {
      init_common2();
      len = length;
      forEach3 = function() {
        var vec = create2();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 3;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            vec[2] = a2[i2 + 2];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
            a2[i2 + 2] = vec[2];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector3.js
  var ORIGIN, ZERO, Vector3;
  var init_vector3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector3.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      ORIGIN = [0, 0, 0];
      Vector3 = class extends Vector {
        static get ZERO() {
          if (!ZERO) {
            ZERO = new Vector3(0, 0, 0);
            Object.freeze(ZERO);
          }
          return ZERO;
        }
        constructor(x = 0, y = 0, z = 0) {
          super(-0, -0, -0);
          if (arguments.length === 1 && isArray(x)) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
          }
        }
        set(x, y, z) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          return this.check();
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          return object;
        }
        get ELEMENTS() {
          return 3;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        angle(vector) {
          return angle(this, vector);
        }
        cross(vector) {
          cross(this, this, vector);
          return this.check();
        }
        rotateX({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateX(this, this, origin, radians2);
          return this.check();
        }
        rotateY({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateY(this, this, origin, radians2);
          return this.check();
        }
        rotateZ({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateZ(this, this, origin, radians2);
          return this.check();
        }
        transform(matrix4) {
          return this.transformAsPoint(matrix4);
        }
        transformAsPoint(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformAsVector(matrix4) {
          vec3_transformMat4AsVector(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          transformMat32(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec3_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector4.js
  var ZERO2, Vector4;
  var init_vector4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector4.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      Vector4 = class extends Vector {
        static get ZERO() {
          if (!ZERO2) {
            ZERO2 = new Vector4(0, 0, 0, 0);
            Object.freeze(ZERO2);
          }
          return ZERO2;
        }
        constructor(x = 0, y = 0, z = 0, w = 0) {
          super(-0, -0, -0, -0);
          if (isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
              checkNumber(w);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
            this[3] = w;
          }
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
            checkNumber(object.w);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this;
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          object.w = this[3];
          return object;
        }
        get ELEMENTS() {
          return 4;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        transform(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          vec4_transformMat3(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec4_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
        applyMatrix4(m) {
          m.transform(this, this);
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js
  var Matrix;
  var init_matrix = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js"() {
      init_math_array();
      init_validators();
      init_common();
      Matrix = class extends MathArray {
        toString() {
          let string = "[";
          if (config.printRowMajor) {
            string += "row-major:";
            for (let row = 0; row < this.RANK; ++row) {
              for (let col = 0; col < this.RANK; ++col) {
                string += " ".concat(this[col * this.RANK + row]);
              }
            }
          } else {
            string += "column-major:";
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              string += " ".concat(this[i2]);
            }
          }
          string += "]";
          return string;
        }
        getElementIndex(row, col) {
          return col * this.RANK + row;
        }
        getElement(row, col) {
          return this[col * this.RANK + row];
        }
        setElement(row, col, value) {
          this[col * this.RANK + row] = checkNumber(value);
          return this;
        }
        getColumn(columnIndex, result = new Array(this.RANK).fill(-0)) {
          const firstIndex = columnIndex * this.RANK;
          for (let i2 = 0; i2 < this.RANK; ++i2) {
            result[i2] = this[firstIndex + i2];
          }
          return result;
        }
        setColumn(columnIndex, columnVector) {
          const firstIndex = columnIndex * this.RANK;
          for (let i2 = 0; i2 < this.RANK; ++i2) {
            this[firstIndex + i2] = columnVector[i2];
          }
          return this;
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat3.js
  function create3() {
    var out = new ARRAY_TYPE(9);
    if (ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[5] = 0;
      out[6] = 0;
      out[7] = 0;
    }
    out[0] = 1;
    out[4] = 1;
    out[8] = 1;
    return out;
  }
  function transpose(out, a2) {
    if (out === a2) {
      var a01 = a2[1], a02 = a2[2], a12 = a2[5];
      out[1] = a2[3];
      out[2] = a2[6];
      out[3] = a01;
      out[5] = a2[7];
      out[6] = a02;
      out[7] = a12;
    } else {
      out[0] = a2[0];
      out[1] = a2[3];
      out[2] = a2[6];
      out[3] = a2[1];
      out[4] = a2[4];
      out[5] = a2[7];
      out[6] = a2[2];
      out[7] = a2[5];
      out[8] = a2[8];
    }
    return out;
  }
  function invert(out, a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    var b01 = a22 * a11 - a12 * a21;
    var b11 = -a22 * a10 + a12 * a20;
    var b21 = a21 * a10 - a11 * a20;
    var det = a00 * b01 + a01 * b11 + a02 * b21;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = b01 * det;
    out[1] = (-a22 * a01 + a02 * a21) * det;
    out[2] = (a12 * a01 - a02 * a11) * det;
    out[3] = b11 * det;
    out[4] = (a22 * a00 - a02 * a20) * det;
    out[5] = (-a12 * a00 + a02 * a10) * det;
    out[6] = b21 * det;
    out[7] = (-a21 * a00 + a01 * a20) * det;
    out[8] = (a11 * a00 - a01 * a10) * det;
    return out;
  }
  function determinant(a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    return a00 * (a22 * a11 - a12 * a21) + a01 * (-a22 * a10 + a12 * a20) + a02 * (a21 * a10 - a11 * a20);
  }
  function multiply(out, a2, b) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    var b00 = b[0], b01 = b[1], b02 = b[2];
    var b10 = b[3], b11 = b[4], b12 = b[5];
    var b20 = b[6], b21 = b[7], b22 = b[8];
    out[0] = b00 * a00 + b01 * a10 + b02 * a20;
    out[1] = b00 * a01 + b01 * a11 + b02 * a21;
    out[2] = b00 * a02 + b01 * a12 + b02 * a22;
    out[3] = b10 * a00 + b11 * a10 + b12 * a20;
    out[4] = b10 * a01 + b11 * a11 + b12 * a21;
    out[5] = b10 * a02 + b11 * a12 + b12 * a22;
    out[6] = b20 * a00 + b21 * a10 + b22 * a20;
    out[7] = b20 * a01 + b21 * a11 + b22 * a21;
    out[8] = b20 * a02 + b21 * a12 + b22 * a22;
    return out;
  }
  function translate(out, a2, v) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a10 = a2[3], a11 = a2[4], a12 = a2[5], a20 = a2[6], a21 = a2[7], a22 = a2[8], x = v[0], y = v[1];
    out[0] = a00;
    out[1] = a01;
    out[2] = a02;
    out[3] = a10;
    out[4] = a11;
    out[5] = a12;
    out[6] = x * a00 + y * a10 + a20;
    out[7] = x * a01 + y * a11 + a21;
    out[8] = x * a02 + y * a12 + a22;
    return out;
  }
  function rotate(out, a2, rad) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a10 = a2[3], a11 = a2[4], a12 = a2[5], a20 = a2[6], a21 = a2[7], a22 = a2[8], s2 = Math.sin(rad), c2 = Math.cos(rad);
    out[0] = c2 * a00 + s2 * a10;
    out[1] = c2 * a01 + s2 * a11;
    out[2] = c2 * a02 + s2 * a12;
    out[3] = c2 * a10 - s2 * a00;
    out[4] = c2 * a11 - s2 * a01;
    out[5] = c2 * a12 - s2 * a02;
    out[6] = a20;
    out[7] = a21;
    out[8] = a22;
    return out;
  }
  function scale(out, a2, v) {
    var x = v[0], y = v[1];
    out[0] = x * a2[0];
    out[1] = x * a2[1];
    out[2] = x * a2[2];
    out[3] = y * a2[3];
    out[4] = y * a2[4];
    out[5] = y * a2[5];
    out[6] = a2[6];
    out[7] = a2[7];
    out[8] = a2[8];
    return out;
  }
  function fromQuat(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[3] = yx - wz;
    out[6] = zx + wy;
    out[1] = yx + wz;
    out[4] = 1 - xx - zz;
    out[7] = zy - wx;
    out[2] = zx - wy;
    out[5] = zy + wx;
    out[8] = 1 - xx - yy;
    return out;
  }
  var init_mat3 = __esm({
    "../../node_modules/gl-matrix/esm/mat3.js"() {
      init_common2();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js
  function getZeroMatrix() {
    if (!ZERO_MATRIX3) {
      ZERO_MATRIX3 = new Matrix3([0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO_MATRIX3);
    }
    return ZERO_MATRIX3;
  }
  function getIdentityMatrix() {
    if (!IDENTITY_MATRIX3) {
      IDENTITY_MATRIX3 = new Matrix3();
      Object.freeze(IDENTITY_MATRIX3);
    }
    return IDENTITY_MATRIX3;
  }
  var INDICES, IDENTITY_MATRIX, Matrix3, ZERO_MATRIX3, IDENTITY_MATRIX3;
  var init_matrix3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat3();
      init_vec2();
      init_vec3();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL1ROW0"] = 3] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 4] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 5] = "COL1ROW2";
        INDICES3[INDICES3["COL2ROW0"] = 6] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 7] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 8] = "COL2ROW2";
      })(INDICES || (INDICES = {}));
      IDENTITY_MATRIX = Object.freeze([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      Matrix3 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix();
        }
        static get ZERO() {
          return getZeroMatrix();
        }
        get ELEMENTS() {
          return 9;
        }
        get RANK() {
          return 3;
        }
        get INDICES() {
          return INDICES;
        }
        constructor(array, ...args) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else if (args.length > 0) {
            this.copy([array, ...args]);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          return this.check();
        }
        identity() {
          return this.copy(IDENTITY_MATRIX);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(q) {
          fromQuat(this, q);
          return this.check();
        }
        set(m00, m10, m20, m01, m11, m21, m02, m12, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        determinant() {
          return determinant(this);
        }
        transpose() {
          transpose(this, this);
          return this.check();
        }
        invert() {
          invert(this, this);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply(this, a2, this);
          return this.check();
        }
        multiplyRight(a2) {
          multiply(this, this, a2);
          return this.check();
        }
        rotate(radians2) {
          rotate(this, this, radians2);
          return this.check();
        }
        scale(factor) {
          if (Array.isArray(factor)) {
            scale(this, this, factor);
          } else {
            scale(this, this, [factor, factor]);
          }
          return this.check();
        }
        translate(vec) {
          translate(this, this, vec);
          return this.check();
        }
        transform(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = transformMat3(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat32(result || [-0, -0, -0], vector, this);
              break;
            case 4:
              out = vec4_transformMat3(result || [-0, -0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformVector(vector, result) {
          return this.transform(vector, result);
        }
        transformVector2(vector, result) {
          return this.transform(vector, result);
        }
        transformVector3(vector, result) {
          return this.transform(vector, result);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat4.js
  function identity(out) {
    out[0] = 1;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = 1;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 1;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function transpose2(out, a2) {
    if (out === a2) {
      var a01 = a2[1], a02 = a2[2], a03 = a2[3];
      var a12 = a2[6], a13 = a2[7];
      var a23 = a2[11];
      out[1] = a2[4];
      out[2] = a2[8];
      out[3] = a2[12];
      out[4] = a01;
      out[6] = a2[9];
      out[7] = a2[13];
      out[8] = a02;
      out[9] = a12;
      out[11] = a2[14];
      out[12] = a03;
      out[13] = a13;
      out[14] = a23;
    } else {
      out[0] = a2[0];
      out[1] = a2[4];
      out[2] = a2[8];
      out[3] = a2[12];
      out[4] = a2[1];
      out[5] = a2[5];
      out[6] = a2[9];
      out[7] = a2[13];
      out[8] = a2[2];
      out[9] = a2[6];
      out[10] = a2[10];
      out[11] = a2[14];
      out[12] = a2[3];
      out[13] = a2[7];
      out[14] = a2[11];
      out[15] = a2[15];
    }
    return out;
  }
  function invert2(out, a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
    out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
    out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
    out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
    out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
    out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
    out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
    out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
    out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
    out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
    out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
    out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
    out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
    out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
    out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
    out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
    return out;
  }
  function determinant2(a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
  }
  function multiply2(out, a2, b) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b0 = b[0], b1 = b[1], b2 = b[2], b3 = b[3];
    out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[4];
    b1 = b[5];
    b2 = b[6];
    b3 = b[7];
    out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[8];
    b1 = b[9];
    b2 = b[10];
    b3 = b[11];
    out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[12];
    b1 = b[13];
    b2 = b[14];
    b3 = b[15];
    out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    return out;
  }
  function translate2(out, a2, v) {
    var x = v[0], y = v[1], z = v[2];
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    if (a2 === out) {
      out[12] = a2[0] * x + a2[4] * y + a2[8] * z + a2[12];
      out[13] = a2[1] * x + a2[5] * y + a2[9] * z + a2[13];
      out[14] = a2[2] * x + a2[6] * y + a2[10] * z + a2[14];
      out[15] = a2[3] * x + a2[7] * y + a2[11] * z + a2[15];
    } else {
      a00 = a2[0];
      a01 = a2[1];
      a02 = a2[2];
      a03 = a2[3];
      a10 = a2[4];
      a11 = a2[5];
      a12 = a2[6];
      a13 = a2[7];
      a20 = a2[8];
      a21 = a2[9];
      a22 = a2[10];
      a23 = a2[11];
      out[0] = a00;
      out[1] = a01;
      out[2] = a02;
      out[3] = a03;
      out[4] = a10;
      out[5] = a11;
      out[6] = a12;
      out[7] = a13;
      out[8] = a20;
      out[9] = a21;
      out[10] = a22;
      out[11] = a23;
      out[12] = a00 * x + a10 * y + a20 * z + a2[12];
      out[13] = a01 * x + a11 * y + a21 * z + a2[13];
      out[14] = a02 * x + a12 * y + a22 * z + a2[14];
      out[15] = a03 * x + a13 * y + a23 * z + a2[15];
    }
    return out;
  }
  function scale2(out, a2, v) {
    var x = v[0], y = v[1], z = v[2];
    out[0] = a2[0] * x;
    out[1] = a2[1] * x;
    out[2] = a2[2] * x;
    out[3] = a2[3] * x;
    out[4] = a2[4] * y;
    out[5] = a2[5] * y;
    out[6] = a2[6] * y;
    out[7] = a2[7] * y;
    out[8] = a2[8] * z;
    out[9] = a2[9] * z;
    out[10] = a2[10] * z;
    out[11] = a2[11] * z;
    out[12] = a2[12];
    out[13] = a2[13];
    out[14] = a2[14];
    out[15] = a2[15];
    return out;
  }
  function rotate2(out, a2, rad, axis) {
    var x = axis[0], y = axis[1], z = axis[2];
    var len2 = Math.hypot(x, y, z);
    var s2, c2, t2;
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    var b00, b01, b02;
    var b10, b11, b12;
    var b20, b21, b22;
    if (len2 < EPSILON) {
      return null;
    }
    len2 = 1 / len2;
    x *= len2;
    y *= len2;
    z *= len2;
    s2 = Math.sin(rad);
    c2 = Math.cos(rad);
    t2 = 1 - c2;
    a00 = a2[0];
    a01 = a2[1];
    a02 = a2[2];
    a03 = a2[3];
    a10 = a2[4];
    a11 = a2[5];
    a12 = a2[6];
    a13 = a2[7];
    a20 = a2[8];
    a21 = a2[9];
    a22 = a2[10];
    a23 = a2[11];
    b00 = x * x * t2 + c2;
    b01 = y * x * t2 + z * s2;
    b02 = z * x * t2 - y * s2;
    b10 = x * y * t2 - z * s2;
    b11 = y * y * t2 + c2;
    b12 = z * y * t2 + x * s2;
    b20 = x * z * t2 + y * s2;
    b21 = y * z * t2 - x * s2;
    b22 = z * z * t2 + c2;
    out[0] = a00 * b00 + a10 * b01 + a20 * b02;
    out[1] = a01 * b00 + a11 * b01 + a21 * b02;
    out[2] = a02 * b00 + a12 * b01 + a22 * b02;
    out[3] = a03 * b00 + a13 * b01 + a23 * b02;
    out[4] = a00 * b10 + a10 * b11 + a20 * b12;
    out[5] = a01 * b10 + a11 * b11 + a21 * b12;
    out[6] = a02 * b10 + a12 * b11 + a22 * b12;
    out[7] = a03 * b10 + a13 * b11 + a23 * b12;
    out[8] = a00 * b20 + a10 * b21 + a20 * b22;
    out[9] = a01 * b20 + a11 * b21 + a21 * b22;
    out[10] = a02 * b20 + a12 * b21 + a22 * b22;
    out[11] = a03 * b20 + a13 * b21 + a23 * b22;
    if (a2 !== out) {
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    return out;
  }
  function rotateX2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c2 = Math.cos(rad);
    var a10 = a2[4];
    var a11 = a2[5];
    var a12 = a2[6];
    var a13 = a2[7];
    var a20 = a2[8];
    var a21 = a2[9];
    var a22 = a2[10];
    var a23 = a2[11];
    if (a2 !== out) {
      out[0] = a2[0];
      out[1] = a2[1];
      out[2] = a2[2];
      out[3] = a2[3];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[4] = a10 * c2 + a20 * s2;
    out[5] = a11 * c2 + a21 * s2;
    out[6] = a12 * c2 + a22 * s2;
    out[7] = a13 * c2 + a23 * s2;
    out[8] = a20 * c2 - a10 * s2;
    out[9] = a21 * c2 - a11 * s2;
    out[10] = a22 * c2 - a12 * s2;
    out[11] = a23 * c2 - a13 * s2;
    return out;
  }
  function rotateY2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c2 = Math.cos(rad);
    var a00 = a2[0];
    var a01 = a2[1];
    var a02 = a2[2];
    var a03 = a2[3];
    var a20 = a2[8];
    var a21 = a2[9];
    var a22 = a2[10];
    var a23 = a2[11];
    if (a2 !== out) {
      out[4] = a2[4];
      out[5] = a2[5];
      out[6] = a2[6];
      out[7] = a2[7];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[0] = a00 * c2 - a20 * s2;
    out[1] = a01 * c2 - a21 * s2;
    out[2] = a02 * c2 - a22 * s2;
    out[3] = a03 * c2 - a23 * s2;
    out[8] = a00 * s2 + a20 * c2;
    out[9] = a01 * s2 + a21 * c2;
    out[10] = a02 * s2 + a22 * c2;
    out[11] = a03 * s2 + a23 * c2;
    return out;
  }
  function rotateZ2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c2 = Math.cos(rad);
    var a00 = a2[0];
    var a01 = a2[1];
    var a02 = a2[2];
    var a03 = a2[3];
    var a10 = a2[4];
    var a11 = a2[5];
    var a12 = a2[6];
    var a13 = a2[7];
    if (a2 !== out) {
      out[8] = a2[8];
      out[9] = a2[9];
      out[10] = a2[10];
      out[11] = a2[11];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[0] = a00 * c2 + a10 * s2;
    out[1] = a01 * c2 + a11 * s2;
    out[2] = a02 * c2 + a12 * s2;
    out[3] = a03 * c2 + a13 * s2;
    out[4] = a10 * c2 - a00 * s2;
    out[5] = a11 * c2 - a01 * s2;
    out[6] = a12 * c2 - a02 * s2;
    out[7] = a13 * c2 - a03 * s2;
    return out;
  }
  function getScaling(out, mat) {
    var m11 = mat[0];
    var m12 = mat[1];
    var m13 = mat[2];
    var m21 = mat[4];
    var m22 = mat[5];
    var m23 = mat[6];
    var m31 = mat[8];
    var m32 = mat[9];
    var m33 = mat[10];
    out[0] = Math.hypot(m11, m12, m13);
    out[1] = Math.hypot(m21, m22, m23);
    out[2] = Math.hypot(m31, m32, m33);
    return out;
  }
  function fromQuat2(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[1] = yx + wz;
    out[2] = zx - wy;
    out[3] = 0;
    out[4] = yx - wz;
    out[5] = 1 - xx - zz;
    out[6] = zy + wx;
    out[7] = 0;
    out[8] = zx + wy;
    out[9] = zy - wx;
    out[10] = 1 - xx - yy;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function frustum(out, left, right, bottom, top, near, far) {
    var rl = 1 / (right - left);
    var tb = 1 / (top - bottom);
    var nf = 1 / (near - far);
    out[0] = near * 2 * rl;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = near * 2 * tb;
    out[6] = 0;
    out[7] = 0;
    out[8] = (right + left) * rl;
    out[9] = (top + bottom) * tb;
    out[10] = (far + near) * nf;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[14] = far * near * 2 * nf;
    out[15] = 0;
    return out;
  }
  function perspectiveNO(out, fovy, aspect, near, far) {
    var f2 = 1 / Math.tan(fovy / 2), nf;
    out[0] = f2 / aspect;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = f2;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[15] = 0;
    if (far != null && far !== Infinity) {
      nf = 1 / (near - far);
      out[10] = (far + near) * nf;
      out[14] = 2 * far * near * nf;
    } else {
      out[10] = -1;
      out[14] = -2 * near;
    }
    return out;
  }
  function orthoNO(out, left, right, bottom, top, near, far) {
    var lr = 1 / (left - right);
    var bt = 1 / (bottom - top);
    var nf = 1 / (near - far);
    out[0] = -2 * lr;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = -2 * bt;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 2 * nf;
    out[11] = 0;
    out[12] = (left + right) * lr;
    out[13] = (top + bottom) * bt;
    out[14] = (far + near) * nf;
    out[15] = 1;
    return out;
  }
  function lookAt(out, eye, center, up) {
    var x0, x1, x2, y0, y1, y2, z0, z1, z2, len2;
    var eyex = eye[0];
    var eyey = eye[1];
    var eyez = eye[2];
    var upx = up[0];
    var upy = up[1];
    var upz = up[2];
    var centerx = center[0];
    var centery = center[1];
    var centerz = center[2];
    if (Math.abs(eyex - centerx) < EPSILON && Math.abs(eyey - centery) < EPSILON && Math.abs(eyez - centerz) < EPSILON) {
      return identity(out);
    }
    z0 = eyex - centerx;
    z1 = eyey - centery;
    z2 = eyez - centerz;
    len2 = 1 / Math.hypot(z0, z1, z2);
    z0 *= len2;
    z1 *= len2;
    z2 *= len2;
    x0 = upy * z2 - upz * z1;
    x1 = upz * z0 - upx * z2;
    x2 = upx * z1 - upy * z0;
    len2 = Math.hypot(x0, x1, x2);
    if (!len2) {
      x0 = 0;
      x1 = 0;
      x2 = 0;
    } else {
      len2 = 1 / len2;
      x0 *= len2;
      x1 *= len2;
      x2 *= len2;
    }
    y0 = z1 * x2 - z2 * x1;
    y1 = z2 * x0 - z0 * x2;
    y2 = z0 * x1 - z1 * x0;
    len2 = Math.hypot(y0, y1, y2);
    if (!len2) {
      y0 = 0;
      y1 = 0;
      y2 = 0;
    } else {
      len2 = 1 / len2;
      y0 *= len2;
      y1 *= len2;
      y2 *= len2;
    }
    out[0] = x0;
    out[1] = y0;
    out[2] = z0;
    out[3] = 0;
    out[4] = x1;
    out[5] = y1;
    out[6] = z1;
    out[7] = 0;
    out[8] = x2;
    out[9] = y2;
    out[10] = z2;
    out[11] = 0;
    out[12] = -(x0 * eyex + x1 * eyey + x2 * eyez);
    out[13] = -(y0 * eyex + y1 * eyey + y2 * eyez);
    out[14] = -(z0 * eyex + z1 * eyey + z2 * eyez);
    out[15] = 1;
    return out;
  }
  var perspective, ortho;
  var init_mat4 = __esm({
    "../../node_modules/gl-matrix/esm/mat4.js"() {
      init_common2();
      perspective = perspectiveNO;
      ortho = orthoNO;
    }
  });

  // ../../node_modules/gl-matrix/esm/vec4.js
  function create4() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
    }
    return out;
  }
  function add(out, a2, b) {
    out[0] = a2[0] + b[0];
    out[1] = a2[1] + b[1];
    out[2] = a2[2] + b[2];
    out[3] = a2[3] + b[3];
    return out;
  }
  function scale3(out, a2, b) {
    out[0] = a2[0] * b;
    out[1] = a2[1] * b;
    out[2] = a2[2] * b;
    out[3] = a2[3] * b;
    return out;
  }
  function length2(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    return Math.hypot(x, y, z, w);
  }
  function squaredLength(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    return x * x + y * y + z * z + w * w;
  }
  function normalize2(out, a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    var len2 = x * x + y * y + z * z + w * w;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = x * len2;
    out[1] = y * len2;
    out[2] = z * len2;
    out[3] = w * len2;
    return out;
  }
  function dot2(a2, b) {
    return a2[0] * b[0] + a2[1] * b[1] + a2[2] * b[2] + a2[3] * b[3];
  }
  function lerp(out, a2, b, t2) {
    var ax = a2[0];
    var ay = a2[1];
    var az = a2[2];
    var aw = a2[3];
    out[0] = ax + t2 * (b[0] - ax);
    out[1] = ay + t2 * (b[1] - ay);
    out[2] = az + t2 * (b[2] - az);
    out[3] = aw + t2 * (b[3] - aw);
    return out;
  }
  function transformMat43(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2], w = a2[3];
    out[0] = m[0] * x + m[4] * y + m[8] * z + m[12] * w;
    out[1] = m[1] * x + m[5] * y + m[9] * z + m[13] * w;
    out[2] = m[2] * x + m[6] * y + m[10] * z + m[14] * w;
    out[3] = m[3] * x + m[7] * y + m[11] * z + m[15] * w;
    return out;
  }
  function transformQuat2(out, a2, q) {
    var x = a2[0], y = a2[1], z = a2[2];
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var ix = qw * x + qy * z - qz * y;
    var iy = qw * y + qz * x - qx * z;
    var iz = qw * z + qx * y - qy * x;
    var iw = -qx * x - qy * y - qz * z;
    out[0] = ix * qw + iw * -qx + iy * -qz - iz * -qy;
    out[1] = iy * qw + iw * -qy + iz * -qx - ix * -qz;
    out[2] = iz * qw + iw * -qz + ix * -qy - iy * -qx;
    out[3] = a2[3];
    return out;
  }
  var forEach4;
  var init_vec4 = __esm({
    "../../node_modules/gl-matrix/esm/vec4.js"() {
      init_common2();
      forEach4 = function() {
        var vec = create4();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 4;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            vec[2] = a2[i2 + 2];
            vec[3] = a2[i2 + 3];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
            a2[i2 + 2] = vec[2];
            a2[i2 + 3] = vec[3];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js
  function getZeroMatrix2() {
    if (!ZERO3) {
      ZERO3 = new Matrix4([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO3);
    }
    return ZERO3;
  }
  function getIdentityMatrix2() {
    if (!IDENTITY) {
      IDENTITY = new Matrix4();
      Object.freeze(IDENTITY);
    }
    return IDENTITY;
  }
  function checkRadians(possiblyDegrees) {
    if (possiblyDegrees > Math.PI * 2) {
      throw Error("expected radians");
    }
  }
  function computeInfinitePerspectiveOffCenter(result, left, right, bottom, top, near) {
    const column0Row0 = 2 * near / (right - left);
    const column1Row1 = 2 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -1;
    const column2Row3 = -1;
    const column3Row2 = -2 * near;
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  }
  var INDICES2, DEFAULT_FOVY, DEFAULT_ASPECT, DEFAULT_NEAR, DEFAULT_FAR, IDENTITY_MATRIX2, Matrix4, ZERO3, IDENTITY;
  var init_matrix4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat4();
      init_vec2();
      init_vec3();
      init_vec4();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL0ROW3"] = 3] = "COL0ROW3";
        INDICES3[INDICES3["COL1ROW0"] = 4] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 5] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 6] = "COL1ROW2";
        INDICES3[INDICES3["COL1ROW3"] = 7] = "COL1ROW3";
        INDICES3[INDICES3["COL2ROW0"] = 8] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 9] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 10] = "COL2ROW2";
        INDICES3[INDICES3["COL2ROW3"] = 11] = "COL2ROW3";
        INDICES3[INDICES3["COL3ROW0"] = 12] = "COL3ROW0";
        INDICES3[INDICES3["COL3ROW1"] = 13] = "COL3ROW1";
        INDICES3[INDICES3["COL3ROW2"] = 14] = "COL3ROW2";
        INDICES3[INDICES3["COL3ROW3"] = 15] = "COL3ROW3";
      })(INDICES2 || (INDICES2 = {}));
      DEFAULT_FOVY = 45 * Math.PI / 180;
      DEFAULT_ASPECT = 1;
      DEFAULT_NEAR = 0.1;
      DEFAULT_FAR = 500;
      IDENTITY_MATRIX2 = Object.freeze([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
      Matrix4 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix2();
        }
        static get ZERO() {
          return getZeroMatrix2();
        }
        get ELEMENTS() {
          return 16;
        }
        get RANK() {
          return 4;
        }
        get INDICES() {
          return INDICES2;
        }
        constructor(array) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          this[9] = array[9];
          this[10] = array[10];
          this[11] = array[11];
          this[12] = array[12];
          this[13] = array[13];
          this[14] = array[14];
          this[15] = array[15];
          return this.check();
        }
        set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        toRowMajor(result) {
          result[0] = this[0];
          result[1] = this[4];
          result[2] = this[8];
          result[3] = this[12];
          result[4] = this[1];
          result[5] = this[5];
          result[6] = this[9];
          result[7] = this[13];
          result[8] = this[2];
          result[9] = this[6];
          result[10] = this[10];
          result[11] = this[14];
          result[12] = this[3];
          result[13] = this[7];
          result[14] = this[11];
          result[15] = this[15];
          return result;
        }
        identity() {
          return this.copy(IDENTITY_MATRIX2);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(quaternion) {
          fromQuat2(this, quaternion);
          return this.check();
        }
        frustum(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          if (far === Infinity) {
            computeInfinitePerspectiveOffCenter(this, left, right, bottom, top, near);
          } else {
            frustum(this, left, right, bottom, top, near, far);
          }
          return this.check();
        }
        lookAt(view) {
          const {
            eye,
            center = [0, 0, 0],
            up = [0, 1, 0]
          } = view;
          lookAt(this, eye, center, up);
          return this.check();
        }
        ortho(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          ortho(this, left, right, bottom, top, near, far);
          return this.check();
        }
        orthographic(view) {
          const {
            fovy = DEFAULT_FOVY,
            aspect = DEFAULT_ASPECT,
            focalDistance = 1,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          checkRadians(fovy);
          const halfY = fovy / 2;
          const top = focalDistance * Math.tan(halfY);
          const right = top * aspect;
          return this.ortho({
            left: -right,
            right,
            bottom: -top,
            top,
            near,
            far
          });
        }
        perspective(view) {
          const {
            fovy = 45 * Math.PI / 180,
            aspect = 1,
            near = 0.1,
            far = 500
          } = view;
          checkRadians(fovy);
          perspective(this, fovy, aspect, near, far);
          return this.check();
        }
        determinant() {
          return determinant2(this);
        }
        getScale(result = [-0, -0, -0]) {
          result[0] = Math.sqrt(this[0] * this[0] + this[1] * this[1] + this[2] * this[2]);
          result[1] = Math.sqrt(this[4] * this[4] + this[5] * this[5] + this[6] * this[6]);
          result[2] = Math.sqrt(this[8] * this[8] + this[9] * this[9] + this[10] * this[10]);
          return result;
        }
        getTranslation(result = [-0, -0, -0]) {
          result[0] = this[12];
          result[1] = this[13];
          result[2] = this[14];
          return result;
        }
        getRotation(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = 0;
          result[4] = this[4] * inverseScale0;
          result[5] = this[5] * inverseScale1;
          result[6] = this[6] * inverseScale2;
          result[7] = 0;
          result[8] = this[8] * inverseScale0;
          result[9] = this[9] * inverseScale1;
          result[10] = this[10] * inverseScale2;
          result[11] = 0;
          result[12] = 0;
          result[13] = 0;
          result[14] = 0;
          result[15] = 1;
          return result;
        }
        getRotationMatrix3(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = this[4] * inverseScale0;
          result[4] = this[5] * inverseScale1;
          result[5] = this[6] * inverseScale2;
          result[6] = this[8] * inverseScale0;
          result[7] = this[9] * inverseScale1;
          result[8] = this[10] * inverseScale2;
          return result;
        }
        transpose() {
          transpose2(this, this);
          return this.check();
        }
        invert() {
          invert2(this, this);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply2(this, a2, this);
          return this.check();
        }
        multiplyRight(a2) {
          multiply2(this, this, a2);
          return this.check();
        }
        rotateX(radians2) {
          rotateX2(this, this, radians2);
          return this.check();
        }
        rotateY(radians2) {
          rotateY2(this, this, radians2);
          return this.check();
        }
        rotateZ(radians2) {
          rotateZ2(this, this, radians2);
          return this.check();
        }
        rotateXYZ(angleXYZ) {
          return this.rotateX(angleXYZ[0]).rotateY(angleXYZ[1]).rotateZ(angleXYZ[2]);
        }
        rotateAxis(radians2, axis) {
          rotate2(this, this, radians2, axis);
          return this.check();
        }
        scale(factor) {
          scale2(this, this, Array.isArray(factor) ? factor : [factor, factor, factor]);
          return this.check();
        }
        translate(vector) {
          translate2(this, this, vector);
          return this.check();
        }
        transform(vector, result) {
          if (vector.length === 4) {
            result = transformMat43(result || [-0, -0, -0, -0], vector, this);
            checkVector(result, 4);
            return result;
          }
          return this.transformAsPoint(vector, result);
        }
        transformAsPoint(vector, result) {
          const {
            length: length4
          } = vector;
          let out;
          switch (length4) {
            case 2:
              out = transformMat4(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat42(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformAsVector(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = vec2_transformMat4AsVector(result || [-0, -0], vector, this);
              break;
            case 3:
              out = vec3_transformMat4AsVector(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformPoint(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformVector(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformDirection(vector, result) {
          return this.transformAsVector(vector, result);
        }
        makeRotationX(radians2) {
          return this.identity().rotateX(radians2);
        }
        makeTranslation(x, y, z) {
          return this.identity().translate([x, y, z]);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/quat.js
  function create5() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    out[3] = 1;
    return out;
  }
  function identity2(out) {
    out[0] = 0;
    out[1] = 0;
    out[2] = 0;
    out[3] = 1;
    return out;
  }
  function setAxisAngle(out, axis, rad) {
    rad = rad * 0.5;
    var s2 = Math.sin(rad);
    out[0] = s2 * axis[0];
    out[1] = s2 * axis[1];
    out[2] = s2 * axis[2];
    out[3] = Math.cos(rad);
    return out;
  }
  function multiply3(out, a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    out[0] = ax * bw + aw * bx + ay * bz - az * by;
    out[1] = ay * bw + aw * by + az * bx - ax * bz;
    out[2] = az * bw + aw * bz + ax * by - ay * bx;
    out[3] = aw * bw - ax * bx - ay * by - az * bz;
    return out;
  }
  function rotateX3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + aw * bx;
    out[1] = ay * bw + az * bx;
    out[2] = az * bw - ay * bx;
    out[3] = aw * bw - ax * bx;
    return out;
  }
  function rotateY3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var by = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw - az * by;
    out[1] = ay * bw + aw * by;
    out[2] = az * bw + ax * by;
    out[3] = aw * bw - ay * by;
    return out;
  }
  function rotateZ3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bz = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + ay * bz;
    out[1] = ay * bw - ax * bz;
    out[2] = az * bw + aw * bz;
    out[3] = aw * bw - az * bz;
    return out;
  }
  function calculateW(out, a2) {
    var x = a2[0], y = a2[1], z = a2[2];
    out[0] = x;
    out[1] = y;
    out[2] = z;
    out[3] = Math.sqrt(Math.abs(1 - x * x - y * y - z * z));
    return out;
  }
  function slerp(out, a2, b, t2) {
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    var omega, cosom, sinom, scale0, scale1;
    cosom = ax * bx + ay * by + az * bz + aw * bw;
    if (cosom < 0) {
      cosom = -cosom;
      bx = -bx;
      by = -by;
      bz = -bz;
      bw = -bw;
    }
    if (1 - cosom > EPSILON) {
      omega = Math.acos(cosom);
      sinom = Math.sin(omega);
      scale0 = Math.sin((1 - t2) * omega) / sinom;
      scale1 = Math.sin(t2 * omega) / sinom;
    } else {
      scale0 = 1 - t2;
      scale1 = t2;
    }
    out[0] = scale0 * ax + scale1 * bx;
    out[1] = scale0 * ay + scale1 * by;
    out[2] = scale0 * az + scale1 * bz;
    out[3] = scale0 * aw + scale1 * bw;
    return out;
  }
  function invert3(out, a2) {
    var a0 = a2[0], a1 = a2[1], a22 = a2[2], a3 = a2[3];
    var dot4 = a0 * a0 + a1 * a1 + a22 * a22 + a3 * a3;
    var invDot = dot4 ? 1 / dot4 : 0;
    out[0] = -a0 * invDot;
    out[1] = -a1 * invDot;
    out[2] = -a22 * invDot;
    out[3] = a3 * invDot;
    return out;
  }
  function conjugate(out, a2) {
    out[0] = -a2[0];
    out[1] = -a2[1];
    out[2] = -a2[2];
    out[3] = a2[3];
    return out;
  }
  function fromMat3(out, m) {
    var fTrace = m[0] + m[4] + m[8];
    var fRoot;
    if (fTrace > 0) {
      fRoot = Math.sqrt(fTrace + 1);
      out[3] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[0] = (m[5] - m[7]) * fRoot;
      out[1] = (m[6] - m[2]) * fRoot;
      out[2] = (m[1] - m[3]) * fRoot;
    } else {
      var i2 = 0;
      if (m[4] > m[0])
        i2 = 1;
      if (m[8] > m[i2 * 3 + i2])
        i2 = 2;
      var j = (i2 + 1) % 3;
      var k = (i2 + 2) % 3;
      fRoot = Math.sqrt(m[i2 * 3 + i2] - m[j * 3 + j] - m[k * 3 + k] + 1);
      out[i2] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[3] = (m[j * 3 + k] - m[k * 3 + j]) * fRoot;
      out[j] = (m[j * 3 + i2] + m[i2 * 3 + j]) * fRoot;
      out[k] = (m[k * 3 + i2] + m[i2 * 3 + k]) * fRoot;
    }
    return out;
  }
  var add2, scale4, dot3, lerp2, length3, squaredLength2, normalize3, rotationTo, sqlerp, setAxes;
  var init_quat = __esm({
    "../../node_modules/gl-matrix/esm/quat.js"() {
      init_common2();
      init_mat3();
      init_vec3();
      init_vec4();
      add2 = add;
      scale4 = scale3;
      dot3 = dot2;
      lerp2 = lerp;
      length3 = length2;
      squaredLength2 = squaredLength;
      normalize3 = normalize2;
      rotationTo = function() {
        var tmpvec3 = create2();
        var xUnitVec3 = fromValues(1, 0, 0);
        var yUnitVec3 = fromValues(0, 1, 0);
        return function(out, a2, b) {
          var dot4 = dot(a2, b);
          if (dot4 < -0.999999) {
            cross(tmpvec3, xUnitVec3, a2);
            if (len(tmpvec3) < 1e-6)
              cross(tmpvec3, yUnitVec3, a2);
            normalize(tmpvec3, tmpvec3);
            setAxisAngle(out, tmpvec3, Math.PI);
            return out;
          } else if (dot4 > 0.999999) {
            out[0] = 0;
            out[1] = 0;
            out[2] = 0;
            out[3] = 1;
            return out;
          } else {
            cross(tmpvec3, a2, b);
            out[0] = tmpvec3[0];
            out[1] = tmpvec3[1];
            out[2] = tmpvec3[2];
            out[3] = 1 + dot4;
            return normalize3(out, out);
          }
        };
      }();
      sqlerp = function() {
        var temp1 = create5();
        var temp2 = create5();
        return function(out, a2, b, c2, d, t2) {
          slerp(temp1, a2, d, t2);
          slerp(temp2, b, c2, t2);
          slerp(out, temp1, temp2, 2 * t2 * (1 - t2));
          return out;
        };
      }();
      setAxes = function() {
        var matr = create3();
        return function(out, view, right, up) {
          matr[0] = right[0];
          matr[3] = right[1];
          matr[6] = right[2];
          matr[1] = up[0];
          matr[4] = up[1];
          matr[7] = up[2];
          matr[2] = -view[0];
          matr[5] = -view[1];
          matr[8] = -view[2];
          return normalize3(out, fromMat3(out, matr));
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js
  var IDENTITY_QUATERNION, Quaternion;
  var init_quaternion = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js"() {
      init_math_array();
      init_validators();
      init_vector4();
      init_quat();
      init_vec4();
      IDENTITY_QUATERNION = [0, 0, 0, 1];
      Quaternion = class extends MathArray {
        constructor(x = 0, y = 0, z = 0, w = 1) {
          super(-0, -0, -0, -0);
          if (Array.isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            this.set(x, y, z, w);
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        fromObject(object) {
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this.check();
        }
        fromMatrix3(m) {
          fromMat3(this, m);
          return this.check();
        }
        fromAxisRotation(axis, rad) {
          setAxisAngle(this, axis, rad);
          return this.check();
        }
        identity() {
          identity2(this);
          return this.check();
        }
        setAxisAngle(axis, rad) {
          return this.fromAxisRotation(axis, rad);
        }
        get ELEMENTS() {
          return 4;
        }
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        len() {
          return length3(this);
        }
        lengthSquared() {
          return squaredLength2(this);
        }
        dot(a2) {
          return dot3(this, a2);
        }
        rotationTo(vectorA, vectorB) {
          rotationTo(this, vectorA, vectorB);
          return this.check();
        }
        add(a2) {
          add2(this, this, a2);
          return this.check();
        }
        calculateW() {
          calculateW(this, this);
          return this.check();
        }
        conjugate() {
          conjugate(this, this);
          return this.check();
        }
        invert() {
          invert3(this, this);
          return this.check();
        }
        lerp(a2, b, t2) {
          if (t2 === void 0) {
            return this.lerp(this, a2, b);
          }
          lerp2(this, a2, b, t2);
          return this.check();
        }
        multiplyRight(a2) {
          multiply3(this, this, a2);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply3(this, a2, this);
          return this.check();
        }
        normalize() {
          const length4 = this.len();
          const l2 = length4 > 0 ? 1 / length4 : 0;
          this[0] = this[0] * l2;
          this[1] = this[1] * l2;
          this[2] = this[2] * l2;
          this[3] = this[3] * l2;
          if (length4 === 0) {
            this[3] = 1;
          }
          return this.check();
        }
        rotateX(rad) {
          rotateX3(this, this, rad);
          return this.check();
        }
        rotateY(rad) {
          rotateY3(this, this, rad);
          return this.check();
        }
        rotateZ(rad) {
          rotateZ3(this, this, rad);
          return this.check();
        }
        scale(b) {
          scale4(this, this, b);
          return this.check();
        }
        slerp(arg0, arg1, arg2) {
          let start;
          let target;
          let ratio;
          switch (arguments.length) {
            case 1:
              ({
                start = IDENTITY_QUATERNION,
                target,
                ratio
              } = arg0);
              break;
            case 2:
              start = this;
              target = arg0;
              ratio = arg1;
              break;
            default:
              start = arg0;
              target = arg1;
              ratio = arg2;
          }
          slerp(this, start, target, ratio);
          return this.check();
        }
        transformVector4(vector, result = new Vector4()) {
          transformQuat2(result, vector, this);
          return checkVector(result, 4);
        }
        lengthSq() {
          return this.lengthSquared();
        }
        setFromAxisAngle(axis, rad) {
          return this.setAxisAngle(axis, rad);
        }
        premultiply(a2) {
          return this.multiplyLeft(a2);
        }
        multiply(a2) {
          return this.multiplyRight(a2);
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js
  var math_utils_default;
  var init_math_utils = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js"() {
      math_utils_default = {
        EPSILON1: 0.1,
        EPSILON2: 0.01,
        EPSILON3: 1e-3,
        EPSILON4: 1e-4,
        EPSILON5: 1e-5,
        EPSILON6: 1e-6,
        EPSILON7: 1e-7,
        EPSILON8: 1e-8,
        EPSILON9: 1e-9,
        EPSILON10: 1e-10,
        EPSILON11: 1e-11,
        EPSILON12: 1e-12,
        EPSILON13: 1e-13,
        EPSILON14: 1e-14,
        EPSILON15: 1e-15,
        EPSILON16: 1e-16,
        EPSILON17: 1e-17,
        EPSILON18: 1e-18,
        EPSILON19: 1e-19,
        EPSILON20: 1e-20,
        PI_OVER_TWO: Math.PI / 2,
        PI_OVER_FOUR: Math.PI / 4,
        PI_OVER_SIX: Math.PI / 6,
        TWO_PI: Math.PI * 2
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/index.js
  var init_esm = __esm({
    "../../node_modules/@math.gl/core/dist/esm/index.js"() {
      init_vector3();
      init_matrix3();
      init_matrix4();
      init_quaternion();
      init_math_utils();
      init_assert4();
      init_common();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/constants.js
  var WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z, WGS84_CONSTANTS;
  var init_constants = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/constants.js"() {
      WGS84_RADIUS_X = 6378137;
      WGS84_RADIUS_Y = 6378137;
      WGS84_RADIUS_Z = 6356752314245179e-9;
      WGS84_CONSTANTS = {
        radii: [WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z],
        radiiSquared: [WGS84_RADIUS_X * WGS84_RADIUS_X, WGS84_RADIUS_Y * WGS84_RADIUS_Y, WGS84_RADIUS_Z * WGS84_RADIUS_Z],
        oneOverRadii: [1 / WGS84_RADIUS_X, 1 / WGS84_RADIUS_Y, 1 / WGS84_RADIUS_Z],
        oneOverRadiiSquared: [1 / (WGS84_RADIUS_X * WGS84_RADIUS_X), 1 / (WGS84_RADIUS_Y * WGS84_RADIUS_Y), 1 / (WGS84_RADIUS_Z * WGS84_RADIUS_Z)],
        maximumRadius: Math.max(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z),
        centerToleranceSquared: 0.1
      };
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js
  function identity3(x) {
    return x;
  }
  function fromCartographic(cartographic, result = [], map2 = identity3) {
    if ("longitude" in cartographic) {
      result[0] = map2(cartographic.longitude);
      result[1] = map2(cartographic.latitude);
      result[2] = cartographic.height;
    } else if ("x" in cartographic) {
      result[0] = map2(cartographic.x);
      result[1] = map2(cartographic.y);
      result[2] = cartographic.z;
    } else {
      result[0] = map2(cartographic[0]);
      result[1] = map2(cartographic[1]);
      result[2] = cartographic[2];
    }
    return result;
  }
  function fromCartographicToRadians(cartographic, vector = []) {
    return fromCartographic(cartographic, vector, config._cartographicRadians ? identity3 : toRadians);
  }
  function toCartographic(vector, cartographic, map2 = identity3) {
    if ("longitude" in cartographic) {
      cartographic.longitude = map2(vector[0]);
      cartographic.latitude = map2(vector[1]);
      cartographic.height = vector[2];
    } else if ("x" in cartographic) {
      cartographic.x = map2(vector[0]);
      cartographic.y = map2(vector[1]);
      cartographic.z = vector[2];
    } else {
      cartographic[0] = map2(vector[0]);
      cartographic[1] = map2(vector[1]);
      cartographic[2] = vector[2];
    }
    return cartographic;
  }
  function toCartographicFromRadians(vector, cartographic) {
    return toCartographic(vector, cartographic, config._cartographicRadians ? identity3 : toDegrees);
  }
  var scratchVector;
  var init_type_utils = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js"() {
      init_esm();
      init_constants();
      scratchVector = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js
  function scaleToGeodeticSurface(cartesian, ellipsoid, result = []) {
    const {
      oneOverRadii,
      oneOverRadiiSquared,
      centerToleranceSquared
    } = ellipsoid;
    scratchVector2.from(cartesian);
    const positionX = scratchVector2.x;
    const positionY = scratchVector2.y;
    const positionZ = scratchVector2.z;
    const oneOverRadiiX = oneOverRadii.x;
    const oneOverRadiiY = oneOverRadii.y;
    const oneOverRadiiZ = oneOverRadii.z;
    const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
    const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
    const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
    const squaredNorm = x2 + y2 + z2;
    const ratio = Math.sqrt(1 / squaredNorm);
    if (!Number.isFinite(ratio)) {
      return void 0;
    }
    const intersection = scaleToGeodeticSurfaceIntersection;
    intersection.copy(cartesian).scale(ratio);
    if (squaredNorm < centerToleranceSquared) {
      return intersection.to(result);
    }
    const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
    const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
    const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
    const gradient = scaleToGeodeticSurfaceGradient;
    gradient.set(intersection.x * oneOverRadiiSquaredX * 2, intersection.y * oneOverRadiiSquaredY * 2, intersection.z * oneOverRadiiSquaredZ * 2);
    let lambda = (1 - ratio) * scratchVector2.len() / (0.5 * gradient.len());
    let correction = 0;
    let xMultiplier;
    let yMultiplier;
    let zMultiplier;
    let func;
    do {
      lambda -= correction;
      xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
      yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
      zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
      const xMultiplier2 = xMultiplier * xMultiplier;
      const yMultiplier2 = yMultiplier * yMultiplier;
      const zMultiplier2 = zMultiplier * zMultiplier;
      const xMultiplier3 = xMultiplier2 * xMultiplier;
      const yMultiplier3 = yMultiplier2 * yMultiplier;
      const zMultiplier3 = zMultiplier2 * zMultiplier;
      func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
      const denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
      const derivative = -2 * denominator;
      correction = func / derivative;
    } while (Math.abs(func) > math_utils_default.EPSILON12);
    return scratchVector2.scale([xMultiplier, yMultiplier, zMultiplier]).to(result);
  }
  var scratchVector2, scaleToGeodeticSurfaceIntersection, scaleToGeodeticSurfaceGradient;
  var init_scale_to_geodetic_surface = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js"() {
      init_esm();
      scratchVector2 = new Vector3();
      scaleToGeodeticSurfaceIntersection = new Vector3();
      scaleToGeodeticSurfaceGradient = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js
  function localFrameToFixedFrame(ellipsoid, firstAxis, secondAxis, thirdAxis, cartesianOrigin, result) {
    const thirdAxisInferred = VECTOR_PRODUCT_LOCAL_FRAME[firstAxis] && VECTOR_PRODUCT_LOCAL_FRAME[firstAxis][secondAxis];
    assert4(thirdAxisInferred && (!thirdAxis || thirdAxis === thirdAxisInferred));
    let firstAxisVector;
    let secondAxisVector;
    let thirdAxisVector;
    const origin = scratchOrigin.copy(cartesianOrigin);
    const atPole = equals(origin.x, 0, EPSILON14) && equals(origin.y, 0, EPSILON14);
    if (atPole) {
      const sign = Math.sign(origin.z);
      firstAxisVector = scratchVector1.fromArray(degeneratePositionLocalFrame[firstAxis]);
      if (firstAxis !== "east" && firstAxis !== "west") {
        firstAxisVector.scale(sign);
      }
      secondAxisVector = scratchVector22.fromArray(degeneratePositionLocalFrame[secondAxis]);
      if (secondAxis !== "east" && secondAxis !== "west") {
        secondAxisVector.scale(sign);
      }
      thirdAxisVector = scratchVector3.fromArray(degeneratePositionLocalFrame[thirdAxis]);
      if (thirdAxis !== "east" && thirdAxis !== "west") {
        thirdAxisVector.scale(sign);
      }
    } else {
      const {
        up,
        east,
        north
      } = scratchAxisVectors;
      east.set(-origin.y, origin.x, 0).normalize();
      ellipsoid.geodeticSurfaceNormal(origin, up);
      north.copy(up).cross(east);
      const {
        down,
        west,
        south
      } = scratchAxisVectors;
      down.copy(up).scale(-1);
      west.copy(east).scale(-1);
      south.copy(north).scale(-1);
      firstAxisVector = scratchAxisVectors[firstAxis];
      secondAxisVector = scratchAxisVectors[secondAxis];
      thirdAxisVector = scratchAxisVectors[thirdAxis];
    }
    result[0] = firstAxisVector.x;
    result[1] = firstAxisVector.y;
    result[2] = firstAxisVector.z;
    result[3] = 0;
    result[4] = secondAxisVector.x;
    result[5] = secondAxisVector.y;
    result[6] = secondAxisVector.z;
    result[7] = 0;
    result[8] = thirdAxisVector.x;
    result[9] = thirdAxisVector.y;
    result[10] = thirdAxisVector.z;
    result[11] = 0;
    result[12] = origin.x;
    result[13] = origin.y;
    result[14] = origin.z;
    result[15] = 1;
    return result;
  }
  var EPSILON14, scratchOrigin, VECTOR_PRODUCT_LOCAL_FRAME, degeneratePositionLocalFrame, scratchAxisVectors, scratchVector1, scratchVector22, scratchVector3;
  var init_ellipsoid_transform = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js"() {
      init_esm();
      EPSILON14 = 1e-14;
      scratchOrigin = new Vector3();
      VECTOR_PRODUCT_LOCAL_FRAME = {
        up: {
          south: "east",
          north: "west",
          west: "south",
          east: "north"
        },
        down: {
          south: "west",
          north: "east",
          west: "north",
          east: "south"
        },
        south: {
          up: "west",
          down: "east",
          west: "down",
          east: "up"
        },
        north: {
          up: "east",
          down: "west",
          west: "up",
          east: "down"
        },
        west: {
          up: "north",
          down: "south",
          north: "down",
          south: "up"
        },
        east: {
          up: "south",
          down: "north",
          north: "up",
          south: "down"
        }
      };
      degeneratePositionLocalFrame = {
        north: [-1, 0, 0],
        east: [0, 1, 0],
        up: [0, 0, 1],
        south: [1, 0, 0],
        west: [0, -1, 0],
        down: [0, 0, -1]
      };
      scratchAxisVectors = {
        east: new Vector3(),
        north: new Vector3(),
        up: new Vector3(),
        west: new Vector3(),
        south: new Vector3(),
        down: new Vector3()
      };
      scratchVector1 = new Vector3();
      scratchVector22 = new Vector3();
      scratchVector3 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js
  var scratchVector4, scratchNormal, scratchK, scratchPosition, scratchHeight, scratchCartesian, Ellipsoid;
  var init_ellipsoid = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js"() {
      init_defineProperty();
      init_esm();
      init_vec3();
      init_constants();
      init_type_utils();
      init_scale_to_geodetic_surface();
      init_ellipsoid_transform();
      scratchVector4 = new Vector3();
      scratchNormal = new Vector3();
      scratchK = new Vector3();
      scratchPosition = new Vector3();
      scratchHeight = new Vector3();
      scratchCartesian = new Vector3();
      Ellipsoid = class {
        constructor(x = 0, y = 0, z = 0) {
          _defineProperty(this, "radii", void 0);
          _defineProperty(this, "radiiSquared", void 0);
          _defineProperty(this, "radiiToTheFourth", void 0);
          _defineProperty(this, "oneOverRadii", void 0);
          _defineProperty(this, "oneOverRadiiSquared", void 0);
          _defineProperty(this, "minimumRadius", void 0);
          _defineProperty(this, "maximumRadius", void 0);
          _defineProperty(this, "centerToleranceSquared", math_utils_default.EPSILON1);
          _defineProperty(this, "squaredXOverSquaredZ", void 0);
          assert4(x >= 0);
          assert4(y >= 0);
          assert4(z >= 0);
          this.radii = new Vector3(x, y, z);
          this.radiiSquared = new Vector3(x * x, y * y, z * z);
          this.radiiToTheFourth = new Vector3(x * x * x * x, y * y * y * y, z * z * z * z);
          this.oneOverRadii = new Vector3(x === 0 ? 0 : 1 / x, y === 0 ? 0 : 1 / y, z === 0 ? 0 : 1 / z);
          this.oneOverRadiiSquared = new Vector3(x === 0 ? 0 : 1 / (x * x), y === 0 ? 0 : 1 / (y * y), z === 0 ? 0 : 1 / (z * z));
          this.minimumRadius = Math.min(x, y, z);
          this.maximumRadius = Math.max(x, y, z);
          if (this.radiiSquared.z !== 0) {
            this.squaredXOverSquaredZ = this.radiiSquared.x / this.radiiSquared.z;
          }
          Object.freeze(this);
        }
        equals(right) {
          return this === right || Boolean(right && this.radii.equals(right.radii));
        }
        toString() {
          return this.radii.toString();
        }
        cartographicToCartesian(cartographic, result = [0, 0, 0]) {
          const normal = scratchNormal;
          const k = scratchK;
          const [, , height] = cartographic;
          this.geodeticSurfaceNormalCartographic(cartographic, normal);
          k.copy(this.radiiSquared).scale(normal);
          const gamma = Math.sqrt(normal.dot(k));
          k.scale(1 / gamma);
          normal.scale(height);
          k.add(normal);
          return k.to(result);
        }
        cartesianToCartographic(cartesian, result = [0, 0, 0]) {
          scratchCartesian.from(cartesian);
          const point = this.scaleToGeodeticSurface(scratchCartesian, scratchPosition);
          if (!point) {
            return void 0;
          }
          const normal = this.geodeticSurfaceNormal(point, scratchNormal);
          const h = scratchHeight;
          h.copy(scratchCartesian).subtract(point);
          const longitude = Math.atan2(normal.y, normal.x);
          const latitude = Math.asin(normal.z);
          const height = Math.sign(dot(h, scratchCartesian)) * length(h);
          return toCartographicFromRadians([longitude, latitude, height], result);
        }
        eastNorthUpToFixedFrame(origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, "east", "north", "up", origin, result);
        }
        localFrameToFixedFrame(firstAxis, secondAxis, thirdAxis, origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, firstAxis, secondAxis, thirdAxis, origin, result);
        }
        geocentricSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).normalize().to(result);
        }
        geodeticSurfaceNormalCartographic(cartographic, result = [0, 0, 0]) {
          const cartographicVectorRadians = fromCartographicToRadians(cartographic);
          const longitude = cartographicVectorRadians[0];
          const latitude = cartographicVectorRadians[1];
          const cosLatitude = Math.cos(latitude);
          scratchVector4.set(cosLatitude * Math.cos(longitude), cosLatitude * Math.sin(longitude), Math.sin(latitude)).normalize();
          return scratchVector4.to(result);
        }
        geodeticSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).scale(this.oneOverRadiiSquared).normalize().to(result);
        }
        scaleToGeodeticSurface(cartesian, result) {
          return scaleToGeodeticSurface(cartesian, this, result);
        }
        scaleToGeocentricSurface(cartesian, result = [0, 0, 0]) {
          scratchPosition.from(cartesian);
          const positionX = scratchPosition.x;
          const positionY = scratchPosition.y;
          const positionZ = scratchPosition.z;
          const oneOverRadiiSquared = this.oneOverRadiiSquared;
          const beta = 1 / Math.sqrt(positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z);
          return scratchPosition.multiplyScalar(beta).to(result);
        }
        transformPositionToScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.oneOverRadii).to(result);
        }
        transformPositionFromScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.radii).to(result);
        }
        getSurfaceNormalIntersectionWithZAxis(position, buffer = 0, result = [0, 0, 0]) {
          assert4(equals(this.radii.x, this.radii.y, math_utils_default.EPSILON15));
          assert4(this.radii.z > 0);
          scratchPosition.from(position);
          const z = scratchPosition.z * (1 - this.squaredXOverSquaredZ);
          if (Math.abs(z) >= this.radii.z - buffer) {
            return void 0;
          }
          return scratchPosition.set(0, 0, z).to(result);
        }
      };
      _defineProperty(Ellipsoid, "WGS84", new Ellipsoid(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z));
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/index.js
  var init_esm2 = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/index.js"() {
      init_ellipsoid();
      init_type_utils();
    }
  });

  // ../images/src/lib/utils/version.ts
  var VERSION6;
  var init_version2 = __esm({
    "../images/src/lib/utils/version.ts"() {
      VERSION6 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../images/src/lib/category-api/image-type.ts
  function isImageTypeSupported(type) {
    switch (type) {
      case "auto":
        return IMAGE_BITMAP_SUPPORTED || IMAGE_SUPPORTED || DATA_SUPPORTED;
      case "imagebitmap":
        return IMAGE_BITMAP_SUPPORTED;
      case "image":
        return IMAGE_SUPPORTED;
      case "data":
        return DATA_SUPPORTED;
      default:
        throw new Error(`@loaders.gl/images: image ${type} not supported in this environment`);
    }
  }
  function getDefaultImageType() {
    if (IMAGE_BITMAP_SUPPORTED) {
      return "imagebitmap";
    }
    if (IMAGE_SUPPORTED) {
      return "image";
    }
    if (DATA_SUPPORTED) {
      return "data";
    }
    throw new Error("Install '@loaders.gl/polyfills' to parse images under Node.js");
  }
  var _parseImageNode, IMAGE_SUPPORTED, IMAGE_BITMAP_SUPPORTED, NODE_IMAGE_SUPPORTED, DATA_SUPPORTED;
  var init_image_type = __esm({
    "../images/src/lib/category-api/image-type.ts"() {
      init_src2();
      ({ _parseImageNode } = globalThis);
      IMAGE_SUPPORTED = typeof Image !== "undefined";
      IMAGE_BITMAP_SUPPORTED = typeof ImageBitmap !== "undefined";
      NODE_IMAGE_SUPPORTED = Boolean(_parseImageNode);
      DATA_SUPPORTED = isBrowser ? true : NODE_IMAGE_SUPPORTED;
    }
  });

  // ../images/src/lib/category-api/parsed-image-api.ts
  function getImageType(image) {
    const format = getImageTypeOrNull(image);
    if (!format) {
      throw new Error("Not an image");
    }
    return format;
  }
  function getImageData(image) {
    switch (getImageType(image)) {
      case "data":
        return image;
      case "image":
      case "imagebitmap":
        const canvas = document.createElement("canvas");
        const context = canvas.getContext("2d");
        if (!context) {
          throw new Error("getImageData");
        }
        canvas.width = image.width;
        canvas.height = image.height;
        context.drawImage(image, 0, 0);
        return context.getImageData(0, 0, image.width, image.height);
      default:
        throw new Error("getImageData");
    }
  }
  function getImageTypeOrNull(image) {
    if (typeof ImageBitmap !== "undefined" && image instanceof ImageBitmap) {
      return "imagebitmap";
    }
    if (typeof Image !== "undefined" && image instanceof Image) {
      return "image";
    }
    if (image && typeof image === "object" && image.data && image.width && image.height) {
      return "data";
    }
    return null;
  }
  var init_parsed_image_api = __esm({
    "../images/src/lib/category-api/parsed-image-api.ts"() {
    }
  });

  // ../images/src/lib/parsers/svg-utils.ts
  function isSVG(url) {
    return url && (SVG_DATA_URL_PATTERN.test(url) || SVG_URL_PATTERN.test(url));
  }
  function getBlobOrSVGDataUrl(arrayBuffer, url) {
    if (isSVG(url)) {
      const textDecoder = new TextDecoder();
      let xmlText = textDecoder.decode(arrayBuffer);
      try {
        if (typeof unescape === "function" && typeof encodeURIComponent === "function") {
          xmlText = unescape(encodeURIComponent(xmlText));
        }
      } catch (error) {
        throw new Error(error.message);
      }
      const src = `data:image/svg+xml;base64,${btoa(xmlText)}`;
      return src;
    }
    return getBlob(arrayBuffer, url);
  }
  function getBlob(arrayBuffer, url) {
    if (isSVG(url)) {
      throw new Error("SVG cannot be parsed directly to imagebitmap");
    }
    return new Blob([new Uint8Array(arrayBuffer)]);
  }
  var SVG_DATA_URL_PATTERN, SVG_URL_PATTERN;
  var init_svg_utils = __esm({
    "../images/src/lib/parsers/svg-utils.ts"() {
      SVG_DATA_URL_PATTERN = /^data:image\/svg\+xml/;
      SVG_URL_PATTERN = /\.svg((\?|#).*)?$/;
    }
  });

  // ../images/src/lib/parsers/parse-to-image.ts
  async function parseToImage(arrayBuffer, options, url) {
    const blobOrDataUrl = getBlobOrSVGDataUrl(arrayBuffer, url);
    const URL2 = self.URL || self.webkitURL;
    const objectUrl = typeof blobOrDataUrl !== "string" && URL2.createObjectURL(blobOrDataUrl);
    try {
      return await loadToImage(objectUrl || blobOrDataUrl, options);
    } finally {
      if (objectUrl) {
        URL2.revokeObjectURL(objectUrl);
      }
    }
  }
  async function loadToImage(url, options) {
    const image = new Image();
    image.src = url;
    if (options.image && options.image.decode && image.decode) {
      await image.decode();
      return image;
    }
    return await new Promise((resolve2, reject) => {
      try {
        image.onload = () => resolve2(image);
        image.onerror = (err) => reject(new Error(`Could not load image ${url}: ${err}`));
      } catch (error) {
        reject(error);
      }
    });
  }
  var init_parse_to_image = __esm({
    "../images/src/lib/parsers/parse-to-image.ts"() {
      init_svg_utils();
    }
  });

  // ../images/src/lib/parsers/parse-to-image-bitmap.ts
  async function parseToImageBitmap(arrayBuffer, options, url) {
    let blob;
    if (isSVG(url)) {
      const image = await parseToImage(arrayBuffer, options, url);
      blob = image;
    } else {
      blob = getBlob(arrayBuffer, url);
    }
    const imagebitmapOptions = options && options.imagebitmap;
    return await safeCreateImageBitmap(blob, imagebitmapOptions);
  }
  async function safeCreateImageBitmap(blob, imagebitmapOptions = null) {
    if (isEmptyObject(imagebitmapOptions) || !imagebitmapOptionsSupported) {
      imagebitmapOptions = null;
    }
    if (imagebitmapOptions) {
      try {
        return await createImageBitmap(blob, imagebitmapOptions);
      } catch (error) {
        console.warn(error);
        imagebitmapOptionsSupported = false;
      }
    }
    return await createImageBitmap(blob);
  }
  function isEmptyObject(object) {
    for (const key in object || EMPTY_OBJECT) {
      return false;
    }
    return true;
  }
  var EMPTY_OBJECT, imagebitmapOptionsSupported;
  var init_parse_to_image_bitmap = __esm({
    "../images/src/lib/parsers/parse-to-image-bitmap.ts"() {
      init_svg_utils();
      init_parse_to_image();
      EMPTY_OBJECT = {};
      imagebitmapOptionsSupported = true;
    }
  });

  // ../images/src/lib/category-api/parse-isobmff-binary.ts
  function getISOBMFFMediaType(buffer) {
    if (!checkString(buffer, "ftyp", 4)) {
      return null;
    }
    if ((buffer[8] & 96) === 0) {
      return null;
    }
    return decodeMajorBrand(buffer);
  }
  function decodeMajorBrand(buffer) {
    const brandMajor = getUTF8String(buffer, 8, 12).replace("\0", " ").trim();
    switch (brandMajor) {
      case "avif":
      case "avis":
        return { extension: "avif", mimeType: "image/avif" };
      default:
        return null;
    }
  }
  function getUTF8String(array, start, end) {
    return String.fromCharCode(...array.slice(start, end));
  }
  function stringToBytes(string) {
    return [...string].map((character) => character.charCodeAt(0));
  }
  function checkString(buffer, header, offset = 0) {
    const headerBytes = stringToBytes(header);
    for (let i2 = 0; i2 < headerBytes.length; ++i2) {
      if (headerBytes[i2] !== buffer[i2 + offset]) {
        return false;
      }
    }
    return true;
  }
  var init_parse_isobmff_binary = __esm({
    "../images/src/lib/category-api/parse-isobmff-binary.ts"() {
    }
  });

  // ../images/src/lib/category-api/binary-image-api.ts
  function getBinaryImageMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    return getPngMetadata(dataView) || getJpegMetadata(dataView) || getGifMetadata(dataView) || getBmpMetadata(dataView) || getISOBMFFMetadata(dataView);
  }
  function getISOBMFFMetadata(binaryData) {
    const buffer = new Uint8Array(binaryData instanceof DataView ? binaryData.buffer : binaryData);
    const mediaType = getISOBMFFMediaType(buffer);
    if (!mediaType) {
      return null;
    }
    return {
      mimeType: mediaType.mimeType,
      width: 0,
      height: 0
    };
  }
  function getPngMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isPng = dataView.byteLength >= 24 && dataView.getUint32(0, BIG_ENDIAN) === 2303741511;
    if (!isPng) {
      return null;
    }
    return {
      mimeType: "image/png",
      width: dataView.getUint32(16, BIG_ENDIAN),
      height: dataView.getUint32(20, BIG_ENDIAN)
    };
  }
  function getGifMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isGif = dataView.byteLength >= 10 && dataView.getUint32(0, BIG_ENDIAN) === 1195984440;
    if (!isGif) {
      return null;
    }
    return {
      mimeType: "image/gif",
      width: dataView.getUint16(6, LITTLE_ENDIAN),
      height: dataView.getUint16(8, LITTLE_ENDIAN)
    };
  }
  function getBmpMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isBmp = dataView.byteLength >= 14 && dataView.getUint16(0, BIG_ENDIAN) === 16973 && dataView.getUint32(2, LITTLE_ENDIAN) === dataView.byteLength;
    if (!isBmp) {
      return null;
    }
    return {
      mimeType: "image/bmp",
      width: dataView.getUint32(18, LITTLE_ENDIAN),
      height: dataView.getUint32(22, LITTLE_ENDIAN)
    };
  }
  function getJpegMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isJpeg = dataView.byteLength >= 3 && dataView.getUint16(0, BIG_ENDIAN) === 65496 && dataView.getUint8(2) === 255;
    if (!isJpeg) {
      return null;
    }
    const { tableMarkers, sofMarkers } = getJpegMarkers();
    let i2 = 2;
    while (i2 + 9 < dataView.byteLength) {
      const marker = dataView.getUint16(i2, BIG_ENDIAN);
      if (sofMarkers.has(marker)) {
        return {
          mimeType: "image/jpeg",
          height: dataView.getUint16(i2 + 5, BIG_ENDIAN),
          width: dataView.getUint16(i2 + 7, BIG_ENDIAN)
        };
      }
      if (!tableMarkers.has(marker)) {
        return null;
      }
      i2 += 2;
      i2 += dataView.getUint16(i2, BIG_ENDIAN);
    }
    return null;
  }
  function getJpegMarkers() {
    const tableMarkers = new Set([65499, 65476, 65484, 65501, 65534]);
    for (let i2 = 65504; i2 < 65520; ++i2) {
      tableMarkers.add(i2);
    }
    const sofMarkers = new Set([
      65472,
      65473,
      65474,
      65475,
      65477,
      65478,
      65479,
      65481,
      65482,
      65483,
      65485,
      65486,
      65487,
      65502
    ]);
    return { tableMarkers, sofMarkers };
  }
  function toDataView(data) {
    if (data instanceof DataView) {
      return data;
    }
    if (ArrayBuffer.isView(data)) {
      return new DataView(data.buffer);
    }
    if (data instanceof ArrayBuffer) {
      return new DataView(data);
    }
    throw new Error("toDataView");
  }
  var BIG_ENDIAN, LITTLE_ENDIAN;
  var init_binary_image_api = __esm({
    "../images/src/lib/category-api/binary-image-api.ts"() {
      init_parse_isobmff_binary();
      BIG_ENDIAN = false;
      LITTLE_ENDIAN = true;
    }
  });

  // ../images/src/lib/parsers/parse-to-node-image.ts
  async function parseToNodeImage(arrayBuffer, options) {
    const { mimeType } = getBinaryImageMetadata(arrayBuffer) || {};
    const _parseImageNode2 = globalThis._parseImageNode;
    assert(_parseImageNode2);
    return await _parseImageNode2(arrayBuffer, mimeType);
  }
  var init_parse_to_node_image = __esm({
    "../images/src/lib/parsers/parse-to-node-image.ts"() {
      init_src2();
      init_binary_image_api();
    }
  });

  // ../images/src/lib/parsers/parse-image.ts
  async function parseImage(arrayBuffer, options, context) {
    options = options || {};
    const imageOptions = options.image || {};
    const imageType = imageOptions.type || "auto";
    const { url } = context || {};
    const loadType = getLoadableImageType(imageType);
    let image;
    switch (loadType) {
      case "imagebitmap":
        image = await parseToImageBitmap(arrayBuffer, options, url);
        break;
      case "image":
        image = await parseToImage(arrayBuffer, options, url);
        break;
      case "data":
        image = await parseToNodeImage(arrayBuffer, options);
        break;
      default:
        assert(false);
    }
    if (imageType === "data") {
      image = getImageData(image);
    }
    return image;
  }
  function getLoadableImageType(type) {
    switch (type) {
      case "auto":
      case "data":
        return getDefaultImageType();
      default:
        isImageTypeSupported(type);
        return type;
    }
  }
  var init_parse_image = __esm({
    "../images/src/lib/parsers/parse-image.ts"() {
      init_src2();
      init_image_type();
      init_parsed_image_api();
      init_parse_to_image();
      init_parse_to_image_bitmap();
      init_parse_to_node_image();
    }
  });

  // ../images/src/image-loader.ts
  var EXTENSIONS, MIME_TYPES, DEFAULT_IMAGE_LOADER_OPTIONS, ImageLoader;
  var init_image_loader = __esm({
    "../images/src/image-loader.ts"() {
      init_version2();
      init_parse_image();
      init_binary_image_api();
      EXTENSIONS = ["png", "jpg", "jpeg", "gif", "webp", "bmp", "ico", "svg", "avif"];
      MIME_TYPES = [
        "image/png",
        "image/jpeg",
        "image/gif",
        "image/webp",
        "image/avif",
        "image/bmp",
        "image/vnd.microsoft.icon",
        "image/svg+xml"
      ];
      DEFAULT_IMAGE_LOADER_OPTIONS = {
        image: {
          type: "auto",
          decode: true
        }
      };
      ImageLoader = {
        id: "image",
        module: "images",
        name: "Images",
        version: VERSION6,
        mimeTypes: MIME_TYPES,
        extensions: EXTENSIONS,
        parse: parseImage,
        tests: [(arrayBuffer) => Boolean(getBinaryImageMetadata(new DataView(arrayBuffer)))],
        options: DEFAULT_IMAGE_LOADER_OPTIONS
      };
    }
  });

  // ../images/src/index.ts
  var init_src4 = __esm({
    "../images/src/index.ts"() {
      init_image_loader();
    }
  });

  // ../draco/src/lib/utils/version.ts
  var VERSION7;
  var init_version3 = __esm({
    "../draco/src/lib/utils/version.ts"() {
      VERSION7 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../draco/src/draco-loader.ts
  var DEFAULT_DRACO_OPTIONS, DracoLoader;
  var init_draco_loader = __esm({
    "../draco/src/draco-loader.ts"() {
      init_src();
      init_version3();
      DEFAULT_DRACO_OPTIONS = {
        draco: {
          decoderType: typeof WebAssembly === "object" ? "wasm" : "js",
          libraryPath: "libs/",
          extraAttributes: {},
          attributeNameEntry: void 0
        }
      };
      DracoLoader = {
        name: "Draco",
        id: isBrowser2 ? "draco" : "draco-nodejs",
        module: "draco",
        shapes: ["mesh"],
        version: VERSION7,
        worker: true,
        extensions: ["drc"],
        mimeTypes: ["application/octet-stream"],
        binary: true,
        tests: ["DRACO"],
        options: DEFAULT_DRACO_OPTIONS
      };
    }
  });

  // ../schema/src/category/mesh/mesh-utils.ts
  function getMeshBoundingBox(attributes) {
    let minX = Infinity;
    let minY = Infinity;
    let minZ = Infinity;
    let maxX = -Infinity;
    let maxY = -Infinity;
    let maxZ = -Infinity;
    const positions = attributes.POSITION ? attributes.POSITION.value : [];
    const len2 = positions && positions.length;
    for (let i2 = 0; i2 < len2; i2 += 3) {
      const x = positions[i2];
      const y = positions[i2 + 1];
      const z = positions[i2 + 2];
      minX = x < minX ? x : minX;
      minY = y < minY ? y : minY;
      minZ = z < minZ ? z : minZ;
      maxX = x > maxX ? x : maxX;
      maxY = y > maxY ? y : maxY;
      maxZ = z > maxZ ? z : maxZ;
    }
    return [
      [minX, minY, minZ],
      [maxX, maxY, maxZ]
    ];
  }
  var init_mesh_utils = __esm({
    "../schema/src/category/mesh/mesh-utils.ts"() {
    }
  });

  // ../schema/src/lib/utils/assert.ts
  function assert5(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert5 = __esm({
    "../schema/src/lib/utils/assert.ts"() {
    }
  });

  // ../schema/src/lib/schema/impl/schema.ts
  function checkNames(fields) {
    const usedNames = {};
    for (const field of fields) {
      if (usedNames[field.name]) {
        console.warn("Schema: duplicated field name", field.name, field);
      }
      usedNames[field.name] = true;
    }
  }
  function mergeMaps(m1, m2) {
    return new Map([...m1 || new Map(), ...m2 || new Map()]);
  }
  var Schema;
  var init_schema = __esm({
    "../schema/src/lib/schema/impl/schema.ts"() {
      init_assert5();
      Schema = class {
        constructor(fields, metadata) {
          assert5(Array.isArray(fields));
          checkNames(fields);
          this.fields = fields;
          this.metadata = metadata || new Map();
        }
        compareTo(other) {
          if (this.metadata !== other.metadata) {
            return false;
          }
          if (this.fields.length !== other.fields.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.fields.length; ++i2) {
            if (!this.fields[i2].compareTo(other.fields[i2])) {
              return false;
            }
          }
          return true;
        }
        select(...columnNames) {
          const nameMap = Object.create(null);
          for (const name of columnNames) {
            nameMap[name] = true;
          }
          const selectedFields = this.fields.filter((field) => nameMap[field.name]);
          return new Schema(selectedFields, this.metadata);
        }
        selectAt(...columnIndices) {
          const selectedFields = columnIndices.map((index) => this.fields[index]).filter(Boolean);
          return new Schema(selectedFields, this.metadata);
        }
        assign(schemaOrFields) {
          let fields;
          let metadata = this.metadata;
          if (schemaOrFields instanceof Schema) {
            const otherSchema = schemaOrFields;
            fields = otherSchema.fields;
            metadata = mergeMaps(mergeMaps(new Map(), this.metadata), otherSchema.metadata);
          } else {
            fields = schemaOrFields;
          }
          const fieldMap = Object.create(null);
          for (const field of this.fields) {
            fieldMap[field.name] = field;
          }
          for (const field of fields) {
            fieldMap[field.name] = field;
          }
          const mergedFields = Object.values(fieldMap);
          return new Schema(mergedFields, metadata);
        }
      };
    }
  });

  // ../schema/src/lib/schema/impl/field.ts
  var Field;
  var init_field = __esm({
    "../schema/src/lib/schema/impl/field.ts"() {
      Field = class {
        constructor(name, type, nullable = false, metadata = new Map()) {
          this.name = name;
          this.type = type;
          this.nullable = nullable;
          this.metadata = metadata;
        }
        get typeId() {
          return this.type && this.type.typeId;
        }
        clone() {
          return new Field(this.name, this.type, this.nullable, this.metadata);
        }
        compareTo(other) {
          return this.name === other.name && this.type === other.type && this.nullable === other.nullable && this.metadata === other.metadata;
        }
        toString() {
          return `${this.type}${this.nullable ? ", nullable" : ""}${this.metadata ? `, metadata: ${this.metadata}` : ""}`;
        }
      };
    }
  });

  // ../schema/src/lib/schema/impl/enum.ts
  var Type;
  var init_enum = __esm({
    "../schema/src/lib/schema/impl/enum.ts"() {
      (function(Type2) {
        Type2[Type2["NONE"] = 0] = "NONE";
        Type2[Type2["Null"] = 1] = "Null";
        Type2[Type2["Int"] = 2] = "Int";
        Type2[Type2["Float"] = 3] = "Float";
        Type2[Type2["Binary"] = 4] = "Binary";
        Type2[Type2["Utf8"] = 5] = "Utf8";
        Type2[Type2["Bool"] = 6] = "Bool";
        Type2[Type2["Decimal"] = 7] = "Decimal";
        Type2[Type2["Date"] = 8] = "Date";
        Type2[Type2["Time"] = 9] = "Time";
        Type2[Type2["Timestamp"] = 10] = "Timestamp";
        Type2[Type2["Interval"] = 11] = "Interval";
        Type2[Type2["List"] = 12] = "List";
        Type2[Type2["Struct"] = 13] = "Struct";
        Type2[Type2["Union"] = 14] = "Union";
        Type2[Type2["FixedSizeBinary"] = 15] = "FixedSizeBinary";
        Type2[Type2["FixedSizeList"] = 16] = "FixedSizeList";
        Type2[Type2["Map"] = 17] = "Map";
        Type2[Type2["Dictionary"] = -1] = "Dictionary";
        Type2[Type2["Int8"] = -2] = "Int8";
        Type2[Type2["Int16"] = -3] = "Int16";
        Type2[Type2["Int32"] = -4] = "Int32";
        Type2[Type2["Int64"] = -5] = "Int64";
        Type2[Type2["Uint8"] = -6] = "Uint8";
        Type2[Type2["Uint16"] = -7] = "Uint16";
        Type2[Type2["Uint32"] = -8] = "Uint32";
        Type2[Type2["Uint64"] = -9] = "Uint64";
        Type2[Type2["Float16"] = -10] = "Float16";
        Type2[Type2["Float32"] = -11] = "Float32";
        Type2[Type2["Float64"] = -12] = "Float64";
        Type2[Type2["DateDay"] = -13] = "DateDay";
        Type2[Type2["DateMillisecond"] = -14] = "DateMillisecond";
        Type2[Type2["TimestampSecond"] = -15] = "TimestampSecond";
        Type2[Type2["TimestampMillisecond"] = -16] = "TimestampMillisecond";
        Type2[Type2["TimestampMicrosecond"] = -17] = "TimestampMicrosecond";
        Type2[Type2["TimestampNanosecond"] = -18] = "TimestampNanosecond";
        Type2[Type2["TimeSecond"] = -19] = "TimeSecond";
        Type2[Type2["TimeMillisecond"] = -20] = "TimeMillisecond";
        Type2[Type2["TimeMicrosecond"] = -21] = "TimeMicrosecond";
        Type2[Type2["TimeNanosecond"] = -22] = "TimeNanosecond";
        Type2[Type2["DenseUnion"] = -23] = "DenseUnion";
        Type2[Type2["SparseUnion"] = -24] = "SparseUnion";
        Type2[Type2["IntervalDayTime"] = -25] = "IntervalDayTime";
        Type2[Type2["IntervalYearMonth"] = -26] = "IntervalYearMonth";
      })(Type || (Type = {}));
    }
  });

  // ../schema/src/lib/schema/impl/type.ts
  var DataType, Null, Bool, Int, Int8, Int16, Int32, Uint8, Uint16, Uint32, Precision, Float, Float32, Float64, Binary, Utf8, DateUnit, Date2, TimeUnit, Time, Timestamp, IntervalUnit, Interval, FixedSizeList, Struct;
  var init_type = __esm({
    "../schema/src/lib/schema/impl/type.ts"() {
      init_enum();
      DataType = class {
        static isNull(x) {
          return x && x.typeId === Type.Null;
        }
        static isInt(x) {
          return x && x.typeId === Type.Int;
        }
        static isFloat(x) {
          return x && x.typeId === Type.Float;
        }
        static isBinary(x) {
          return x && x.typeId === Type.Binary;
        }
        static isUtf8(x) {
          return x && x.typeId === Type.Utf8;
        }
        static isBool(x) {
          return x && x.typeId === Type.Bool;
        }
        static isDecimal(x) {
          return x && x.typeId === Type.Decimal;
        }
        static isDate(x) {
          return x && x.typeId === Type.Date;
        }
        static isTime(x) {
          return x && x.typeId === Type.Time;
        }
        static isTimestamp(x) {
          return x && x.typeId === Type.Timestamp;
        }
        static isInterval(x) {
          return x && x.typeId === Type.Interval;
        }
        static isList(x) {
          return x && x.typeId === Type.List;
        }
        static isStruct(x) {
          return x && x.typeId === Type.Struct;
        }
        static isUnion(x) {
          return x && x.typeId === Type.Union;
        }
        static isFixedSizeBinary(x) {
          return x && x.typeId === Type.FixedSizeBinary;
        }
        static isFixedSizeList(x) {
          return x && x.typeId === Type.FixedSizeList;
        }
        static isMap(x) {
          return x && x.typeId === Type.Map;
        }
        static isDictionary(x) {
          return x && x.typeId === Type.Dictionary;
        }
        get typeId() {
          return Type.NONE;
        }
        compareTo(other) {
          return this === other;
        }
      };
      Null = class extends DataType {
        get typeId() {
          return Type.Null;
        }
        get [Symbol.toStringTag]() {
          return "Null";
        }
        toString() {
          return "Null";
        }
      };
      Bool = class extends DataType {
        get typeId() {
          return Type.Bool;
        }
        get [Symbol.toStringTag]() {
          return "Bool";
        }
        toString() {
          return "Bool";
        }
      };
      Int = class extends DataType {
        constructor(isSigned, bitWidth) {
          super();
          this.isSigned = isSigned;
          this.bitWidth = bitWidth;
        }
        get typeId() {
          return Type.Int;
        }
        get [Symbol.toStringTag]() {
          return "Int";
        }
        toString() {
          return `${this.isSigned ? "I" : "Ui"}nt${this.bitWidth}`;
        }
      };
      Int8 = class extends Int {
        constructor() {
          super(true, 8);
        }
      };
      Int16 = class extends Int {
        constructor() {
          super(true, 16);
        }
      };
      Int32 = class extends Int {
        constructor() {
          super(true, 32);
        }
      };
      Uint8 = class extends Int {
        constructor() {
          super(false, 8);
        }
      };
      Uint16 = class extends Int {
        constructor() {
          super(false, 16);
        }
      };
      Uint32 = class extends Int {
        constructor() {
          super(false, 32);
        }
      };
      Precision = {
        HALF: 16,
        SINGLE: 32,
        DOUBLE: 64
      };
      Float = class extends DataType {
        constructor(precision) {
          super();
          this.precision = precision;
        }
        get typeId() {
          return Type.Float;
        }
        get [Symbol.toStringTag]() {
          return "Float";
        }
        toString() {
          return `Float${this.precision}`;
        }
      };
      Float32 = class extends Float {
        constructor() {
          super(Precision.SINGLE);
        }
      };
      Float64 = class extends Float {
        constructor() {
          super(Precision.DOUBLE);
        }
      };
      Binary = class extends DataType {
        constructor() {
          super();
        }
        get typeId() {
          return Type.Binary;
        }
        toString() {
          return "Binary";
        }
        get [Symbol.toStringTag]() {
          return "Binary";
        }
      };
      Utf8 = class extends DataType {
        get typeId() {
          return Type.Utf8;
        }
        get [Symbol.toStringTag]() {
          return "Utf8";
        }
        toString() {
          return "Utf8";
        }
      };
      DateUnit = {
        DAY: 0,
        MILLISECOND: 1
      };
      Date2 = class extends DataType {
        constructor(unit) {
          super();
          this.unit = unit;
        }
        get typeId() {
          return Type.Date;
        }
        get [Symbol.toStringTag]() {
          return "Date";
        }
        toString() {
          return `Date${(this.unit + 1) * 32}<${DateUnit[this.unit]}>`;
        }
      };
      TimeUnit = {
        SECOND: 1,
        MILLISECOND: 1e3,
        MICROSECOND: 1e6,
        NANOSECOND: 1e9
      };
      Time = class extends DataType {
        constructor(unit, bitWidth) {
          super();
          this.unit = unit;
          this.bitWidth = bitWidth;
        }
        get typeId() {
          return Type.Time;
        }
        toString() {
          return `Time${this.bitWidth}<${TimeUnit[this.unit]}>`;
        }
        get [Symbol.toStringTag]() {
          return "Time";
        }
      };
      Timestamp = class extends DataType {
        constructor(unit, timezone = null) {
          super();
          this.unit = unit;
          this.timezone = timezone;
        }
        get typeId() {
          return Type.Timestamp;
        }
        get [Symbol.toStringTag]() {
          return "Timestamp";
        }
        toString() {
          return `Timestamp<${TimeUnit[this.unit]}${this.timezone ? `, ${this.timezone}` : ""}>`;
        }
      };
      IntervalUnit = {
        DAY_TIME: 0,
        YEAR_MONTH: 1
      };
      Interval = class extends DataType {
        constructor(unit) {
          super();
          this.unit = unit;
        }
        get typeId() {
          return Type.Interval;
        }
        get [Symbol.toStringTag]() {
          return "Interval";
        }
        toString() {
          return `Interval<${IntervalUnit[this.unit]}>`;
        }
      };
      FixedSizeList = class extends DataType {
        constructor(listSize, child) {
          super();
          this.listSize = listSize;
          this.children = [child];
        }
        get typeId() {
          return Type.FixedSizeList;
        }
        get valueType() {
          return this.children[0].type;
        }
        get valueField() {
          return this.children[0];
        }
        get [Symbol.toStringTag]() {
          return "FixedSizeList";
        }
        toString() {
          return `FixedSizeList[${this.listSize}]<${this.valueType}>`;
        }
      };
      Struct = class extends DataType {
        constructor(children) {
          super();
          this.children = children;
        }
        get typeId() {
          return Type.Struct;
        }
        toString() {
          return `Struct<{${this.children.map((f2) => `${f2.name}:${f2.type}`).join(", ")}}>`;
        }
        get [Symbol.toStringTag]() {
          return "Struct";
        }
      };
    }
  });

  // ../schema/src/lib/schema/schema.ts
  var init_schema2 = __esm({
    "../schema/src/lib/schema/schema.ts"() {
      init_schema();
      init_field();
      init_type();
    }
  });

  // ../schema/src/lib/arrow/arrow-like-type-utils.ts
  function getArrowTypeFromTypedArray(array) {
    switch (array.constructor) {
      case Int8Array:
        return new Int8();
      case Uint8Array:
        return new Uint8();
      case Int16Array:
        return new Int16();
      case Uint16Array:
        return new Uint16();
      case Int32Array:
        return new Int32();
      case Uint32Array:
        return new Uint32();
      case Float32Array:
        return new Float32();
      case Float64Array:
        return new Float64();
      default:
        throw new Error("array type not supported");
    }
  }
  var init_arrow_like_type_utils = __esm({
    "../schema/src/lib/arrow/arrow-like-type-utils.ts"() {
      init_schema2();
    }
  });

  // ../schema/src/category/mesh/deduce-mesh-schema.ts
  function deduceMeshField(attributeName, attribute, optionalMetadata) {
    const type = getArrowTypeFromTypedArray(attribute.value);
    const metadata = optionalMetadata ? optionalMetadata : makeMeshAttributeMetadata(attribute);
    const field = new Field(attributeName, new FixedSizeList(attribute.size, new Field("value", type)), false, metadata);
    return field;
  }
  function makeMeshAttributeMetadata(attribute) {
    const result = new Map();
    if ("byteOffset" in attribute) {
      result.set("byteOffset", attribute.byteOffset.toString(10));
    }
    if ("byteStride" in attribute) {
      result.set("byteStride", attribute.byteStride.toString(10));
    }
    if ("normalized" in attribute) {
      result.set("normalized", attribute.normalized.toString());
    }
    return result;
  }
  var init_deduce_mesh_schema = __esm({
    "../schema/src/category/mesh/deduce-mesh-schema.ts"() {
      init_schema2();
      init_arrow_like_type_utils();
    }
  });

  // ../schema/src/index.ts
  var init_src5 = __esm({
    "../schema/src/index.ts"() {
      init_mesh_utils();
      init_deduce_mesh_schema();
      init_schema2();
    }
  });

  // ../draco/src/lib/utils/get-draco-schema.ts
  function getDracoSchema(attributes, loaderData, indices) {
    const metadataMap = makeMetadata(loaderData.metadata);
    const fields = [];
    const namedLoaderDataAttributes = transformAttributesLoaderData(loaderData.attributes);
    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];
      const field = getArrowFieldFromAttribute(attributeName, attribute, namedLoaderDataAttributes[attributeName]);
      fields.push(field);
    }
    if (indices) {
      const indicesField = getArrowFieldFromAttribute("indices", indices);
      fields.push(indicesField);
    }
    return new Schema(fields, metadataMap);
  }
  function transformAttributesLoaderData(loaderData) {
    const result = {};
    for (const key in loaderData) {
      const dracoAttribute = loaderData[key];
      result[dracoAttribute.name || "undefined"] = dracoAttribute;
    }
    return result;
  }
  function getArrowFieldFromAttribute(attributeName, attribute, loaderData) {
    const metadataMap = loaderData ? makeMetadata(loaderData.metadata) : void 0;
    const field = deduceMeshField(attributeName, attribute, metadataMap);
    return field;
  }
  function makeMetadata(metadata) {
    const metadataMap = new Map();
    for (const key in metadata) {
      metadataMap.set(`${key}.string`, JSON.stringify(metadata[key]));
    }
    return metadataMap;
  }
  var init_get_draco_schema = __esm({
    "../draco/src/lib/utils/get-draco-schema.ts"() {
      init_src5();
      init_src5();
    }
  });

  // ../draco/src/lib/draco-parser.ts
  function getDracoDataType(draco, attributeType) {
    switch (attributeType) {
      case Float32Array:
        return draco.DT_FLOAT32;
      case Int8Array:
        return draco.DT_INT8;
      case Int16Array:
        return draco.DT_INT16;
      case Int32Array:
        return draco.DT_INT32;
      case Uint8Array:
        return draco.DT_UINT8;
      case Uint16Array:
        return draco.DT_UINT16;
      case Uint32Array:
        return draco.DT_UINT32;
      default:
        return draco.DT_INVALID;
    }
  }
  function getInt32Array(dracoArray) {
    const numValues = dracoArray.size();
    const intArray = new Int32Array(numValues);
    for (let i2 = 0; i2 < numValues; i2++) {
      intArray[i2] = dracoArray.GetValue(i2);
    }
    return intArray;
  }
  function getUint32Array(dracoArray) {
    const numValues = dracoArray.size();
    const intArray = new Int32Array(numValues);
    for (let i2 = 0; i2 < numValues; i2++) {
      intArray[i2] = dracoArray.GetValue(i2);
    }
    return intArray;
  }
  var DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP, DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP, INDEX_ITEM_SIZE, DracoParser;
  var init_draco_parser = __esm({
    "../draco/src/lib/draco-parser.ts"() {
      init_src5();
      init_get_draco_schema();
      DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP = {
        POSITION: "POSITION",
        NORMAL: "NORMAL",
        COLOR: "COLOR_0",
        TEX_COORD: "TEXCOORD_0"
      };
      DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP = {
        1: Int8Array,
        2: Uint8Array,
        3: Int16Array,
        4: Uint16Array,
        5: Int32Array,
        6: Uint32Array,
        9: Float32Array
      };
      INDEX_ITEM_SIZE = 4;
      DracoParser = class {
        constructor(draco) {
          this.draco = draco;
          this.decoder = new this.draco.Decoder();
          this.metadataQuerier = new this.draco.MetadataQuerier();
        }
        destroy() {
          this.draco.destroy(this.decoder);
          this.draco.destroy(this.metadataQuerier);
        }
        parseSync(arrayBuffer, options = {}) {
          const buffer = new this.draco.DecoderBuffer();
          buffer.Init(new Int8Array(arrayBuffer), arrayBuffer.byteLength);
          this._disableAttributeTransforms(options);
          const geometry_type = this.decoder.GetEncodedGeometryType(buffer);
          const dracoGeometry = geometry_type === this.draco.TRIANGULAR_MESH ? new this.draco.Mesh() : new this.draco.PointCloud();
          try {
            let dracoStatus;
            switch (geometry_type) {
              case this.draco.TRIANGULAR_MESH:
                dracoStatus = this.decoder.DecodeBufferToMesh(buffer, dracoGeometry);
                break;
              case this.draco.POINT_CLOUD:
                dracoStatus = this.decoder.DecodeBufferToPointCloud(buffer, dracoGeometry);
                break;
              default:
                throw new Error("DRACO: Unknown geometry type.");
            }
            if (!dracoStatus.ok() || !dracoGeometry.ptr) {
              const message = `DRACO decompression failed: ${dracoStatus.error_msg()}`;
              throw new Error(message);
            }
            const loaderData = this._getDracoLoaderData(dracoGeometry, geometry_type, options);
            const geometry = this._getMeshData(dracoGeometry, loaderData, options);
            const boundingBox = getMeshBoundingBox(geometry.attributes);
            const schema = getDracoSchema(geometry.attributes, loaderData, geometry.indices);
            const data = {
              loader: "draco",
              loaderData,
              header: {
                vertexCount: dracoGeometry.num_points(),
                boundingBox
              },
              ...geometry,
              schema
            };
            return data;
          } finally {
            this.draco.destroy(buffer);
            if (dracoGeometry) {
              this.draco.destroy(dracoGeometry);
            }
          }
        }
        _getDracoLoaderData(dracoGeometry, geometry_type, options) {
          const metadata = this._getTopLevelMetadata(dracoGeometry);
          const attributes = this._getDracoAttributes(dracoGeometry, options);
          return {
            geometry_type,
            num_attributes: dracoGeometry.num_attributes(),
            num_points: dracoGeometry.num_points(),
            num_faces: dracoGeometry instanceof this.draco.Mesh ? dracoGeometry.num_faces() : 0,
            metadata,
            attributes
          };
        }
        _getDracoAttributes(dracoGeometry, options) {
          const dracoAttributes = {};
          for (let attributeId = 0; attributeId < dracoGeometry.num_attributes(); attributeId++) {
            const dracoAttribute = this.decoder.GetAttribute(dracoGeometry, attributeId);
            const metadata = this._getAttributeMetadata(dracoGeometry, attributeId);
            dracoAttributes[dracoAttribute.unique_id()] = {
              unique_id: dracoAttribute.unique_id(),
              attribute_type: dracoAttribute.attribute_type(),
              data_type: dracoAttribute.data_type(),
              num_components: dracoAttribute.num_components(),
              byte_offset: dracoAttribute.byte_offset(),
              byte_stride: dracoAttribute.byte_stride(),
              normalized: dracoAttribute.normalized(),
              attribute_index: attributeId,
              metadata
            };
            const quantization = this._getQuantizationTransform(dracoAttribute, options);
            if (quantization) {
              dracoAttributes[dracoAttribute.unique_id()].quantization_transform = quantization;
            }
            const octahedron = this._getOctahedronTransform(dracoAttribute, options);
            if (octahedron) {
              dracoAttributes[dracoAttribute.unique_id()].octahedron_transform = octahedron;
            }
          }
          return dracoAttributes;
        }
        _getMeshData(dracoGeometry, loaderData, options) {
          const attributes = this._getMeshAttributes(loaderData, dracoGeometry, options);
          const positionAttribute = attributes.POSITION;
          if (!positionAttribute) {
            throw new Error("DRACO: No position attribute found.");
          }
          if (dracoGeometry instanceof this.draco.Mesh) {
            switch (options.topology) {
              case "triangle-strip":
                return {
                  topology: "triangle-strip",
                  mode: 4,
                  attributes,
                  indices: {
                    value: this._getTriangleStripIndices(dracoGeometry),
                    size: 1
                  }
                };
              case "triangle-list":
              default:
                return {
                  topology: "triangle-list",
                  mode: 5,
                  attributes,
                  indices: {
                    value: this._getTriangleListIndices(dracoGeometry),
                    size: 1
                  }
                };
            }
          }
          return {
            topology: "point-list",
            mode: 0,
            attributes
          };
        }
        _getMeshAttributes(loaderData, dracoGeometry, options) {
          const attributes = {};
          for (const loaderAttribute of Object.values(loaderData.attributes)) {
            const attributeName = this._deduceAttributeName(loaderAttribute, options);
            loaderAttribute.name = attributeName;
            const { value, size } = this._getAttributeValues(dracoGeometry, loaderAttribute);
            attributes[attributeName] = {
              value,
              size,
              byteOffset: loaderAttribute.byte_offset,
              byteStride: loaderAttribute.byte_stride,
              normalized: loaderAttribute.normalized
            };
          }
          return attributes;
        }
        _getTriangleListIndices(dracoGeometry) {
          const numFaces = dracoGeometry.num_faces();
          const numIndices = numFaces * 3;
          const byteLength = numIndices * INDEX_ITEM_SIZE;
          const ptr = this.draco._malloc(byteLength);
          try {
            this.decoder.GetTrianglesUInt32Array(dracoGeometry, byteLength, ptr);
            return new Uint32Array(this.draco.HEAPF32.buffer, ptr, numIndices).slice();
          } finally {
            this.draco._free(ptr);
          }
        }
        _getTriangleStripIndices(dracoGeometry) {
          const dracoArray = new this.draco.DracoInt32Array();
          try {
            this.decoder.GetTriangleStripsFromMesh(dracoGeometry, dracoArray);
            return getUint32Array(dracoArray);
          } finally {
            this.draco.destroy(dracoArray);
          }
        }
        _getAttributeValues(dracoGeometry, attribute) {
          const TypedArrayCtor = DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP[attribute.data_type];
          const numComponents = attribute.num_components;
          const numPoints = dracoGeometry.num_points();
          const numValues = numPoints * numComponents;
          const byteLength = numValues * TypedArrayCtor.BYTES_PER_ELEMENT;
          const dataType = getDracoDataType(this.draco, TypedArrayCtor);
          let value;
          const ptr = this.draco._malloc(byteLength);
          try {
            const dracoAttribute = this.decoder.GetAttribute(dracoGeometry, attribute.attribute_index);
            this.decoder.GetAttributeDataArrayForAllPoints(dracoGeometry, dracoAttribute, dataType, byteLength, ptr);
            value = new TypedArrayCtor(this.draco.HEAPF32.buffer, ptr, numValues).slice();
          } finally {
            this.draco._free(ptr);
          }
          return { value, size: numComponents };
        }
        _deduceAttributeName(attribute, options) {
          const uniqueId = attribute.unique_id;
          for (const [attributeName, attributeUniqueId] of Object.entries(options.extraAttributes || {})) {
            if (attributeUniqueId === uniqueId) {
              return attributeName;
            }
          }
          const thisAttributeType = attribute.attribute_type;
          for (const dracoAttributeConstant in DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP) {
            const attributeType = this.draco[dracoAttributeConstant];
            if (attributeType === thisAttributeType) {
              return DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP[dracoAttributeConstant];
            }
          }
          const entryName = options.attributeNameEntry || "name";
          if (attribute.metadata[entryName]) {
            return attribute.metadata[entryName].string;
          }
          return `CUSTOM_ATTRIBUTE_${uniqueId}`;
        }
        _getTopLevelMetadata(dracoGeometry) {
          const dracoMetadata = this.decoder.GetMetadata(dracoGeometry);
          return this._getDracoMetadata(dracoMetadata);
        }
        _getAttributeMetadata(dracoGeometry, attributeId) {
          const dracoMetadata = this.decoder.GetAttributeMetadata(dracoGeometry, attributeId);
          return this._getDracoMetadata(dracoMetadata);
        }
        _getDracoMetadata(dracoMetadata) {
          if (!dracoMetadata || !dracoMetadata.ptr) {
            return {};
          }
          const result = {};
          const numEntries = this.metadataQuerier.NumEntries(dracoMetadata);
          for (let entryIndex = 0; entryIndex < numEntries; entryIndex++) {
            const entryName = this.metadataQuerier.GetEntryName(dracoMetadata, entryIndex);
            result[entryName] = this._getDracoMetadataField(dracoMetadata, entryName);
          }
          return result;
        }
        _getDracoMetadataField(dracoMetadata, entryName) {
          const dracoArray = new this.draco.DracoInt32Array();
          try {
            this.metadataQuerier.GetIntEntryArray(dracoMetadata, entryName, dracoArray);
            const intArray = getInt32Array(dracoArray);
            return {
              int: this.metadataQuerier.GetIntEntry(dracoMetadata, entryName),
              string: this.metadataQuerier.GetStringEntry(dracoMetadata, entryName),
              double: this.metadataQuerier.GetDoubleEntry(dracoMetadata, entryName),
              intArray
            };
          } finally {
            this.draco.destroy(dracoArray);
          }
        }
        _disableAttributeTransforms(options) {
          const { quantizedAttributes = [], octahedronAttributes = [] } = options;
          const skipAttributes = [...quantizedAttributes, ...octahedronAttributes];
          for (const dracoAttributeName of skipAttributes) {
            this.decoder.SkipAttributeTransform(this.draco[dracoAttributeName]);
          }
        }
        _getQuantizationTransform(dracoAttribute, options) {
          const { quantizedAttributes = [] } = options;
          const attribute_type = dracoAttribute.attribute_type();
          const skip = quantizedAttributes.map((type) => this.decoder[type]).includes(attribute_type);
          if (skip) {
            const transform = new this.draco.AttributeQuantizationTransform();
            try {
              if (transform.InitFromAttribute(dracoAttribute)) {
                return {
                  quantization_bits: transform.quantization_bits(),
                  range: transform.range(),
                  min_values: new Float32Array([1, 2, 3]).map((i2) => transform.min_value(i2))
                };
              }
            } finally {
              this.draco.destroy(transform);
            }
          }
          return null;
        }
        _getOctahedronTransform(dracoAttribute, options) {
          const { octahedronAttributes = [] } = options;
          const attribute_type = dracoAttribute.attribute_type();
          const octahedron = octahedronAttributes.map((type) => this.decoder[type]).includes(attribute_type);
          if (octahedron) {
            const transform = new this.draco.AttributeQuantizationTransform();
            try {
              if (transform.InitFromAttribute(dracoAttribute)) {
                return {
                  quantization_bits: transform.quantization_bits()
                };
              }
            } finally {
              this.draco.destroy(transform);
            }
          }
          return null;
        }
      };
    }
  });

  // ../draco/src/lib/draco-module-loader.ts
  async function loadDracoDecoderModule(options) {
    const modules = options.modules || {};
    if (modules.draco3d) {
      loadDecoderPromise = loadDecoderPromise || modules.draco3d.createDecoderModule({}).then((draco) => {
        return { draco };
      });
    } else {
      loadDecoderPromise = loadDecoderPromise || loadDracoDecoder(options);
    }
    return await loadDecoderPromise;
  }
  async function loadDracoDecoder(options) {
    let DracoDecoderModule;
    let wasmBinary;
    switch (options.draco && options.draco.decoderType) {
      case "js":
        DracoDecoderModule = await loadLibrary(DRACO_JS_DECODER_URL, "draco", options);
        break;
      case "wasm":
      default:
        [DracoDecoderModule, wasmBinary] = await Promise.all([
          await loadLibrary(DRACO_WASM_WRAPPER_URL, "draco", options),
          await loadLibrary(DRACO_WASM_DECODER_URL, "draco", options)
        ]);
    }
    DracoDecoderModule = DracoDecoderModule || globalThis.DracoDecoderModule;
    return await initializeDracoDecoder(DracoDecoderModule, wasmBinary);
  }
  function initializeDracoDecoder(DracoDecoderModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      DracoDecoderModule({
        ...options,
        onModuleLoaded: (draco) => resolve2({ draco })
      });
    });
  }
  var DRACO_DECODER_VERSION, DRACO_ENCODER_VERSION, STATIC_DECODER_URL, DRACO_JS_DECODER_URL, DRACO_WASM_WRAPPER_URL, DRACO_WASM_DECODER_URL, DRACO_ENCODER_URL, loadDecoderPromise;
  var init_draco_module_loader = __esm({
    "../draco/src/lib/draco-module-loader.ts"() {
      init_src();
      DRACO_DECODER_VERSION = "1.5.5";
      DRACO_ENCODER_VERSION = "1.4.1";
      STATIC_DECODER_URL = `https://www.gstatic.com/draco/versioned/decoders/${DRACO_DECODER_VERSION}`;
      DRACO_JS_DECODER_URL = `${STATIC_DECODER_URL}/draco_decoder.js`;
      DRACO_WASM_WRAPPER_URL = `${STATIC_DECODER_URL}/draco_wasm_wrapper.js`;
      DRACO_WASM_DECODER_URL = `${STATIC_DECODER_URL}/draco_decoder.wasm`;
      DRACO_ENCODER_URL = `https://raw.githubusercontent.com/google/draco/${DRACO_ENCODER_VERSION}/javascript/draco_encoder.js`;
    }
  });

  // ../draco/src/index.ts
  async function parse2(arrayBuffer, options) {
    const { draco } = await loadDracoDecoderModule(options);
    const dracoParser = new DracoParser(draco);
    try {
      return dracoParser.parseSync(arrayBuffer, options?.draco);
    } finally {
      dracoParser.destroy();
    }
  }
  var DracoLoader2;
  var init_src6 = __esm({
    "../draco/src/index.ts"() {
      init_draco_loader();
      init_draco_parser();
      init_draco_module_loader();
      DracoLoader2 = {
        ...DracoLoader,
        parse: parse2
      };
    }
  });

  // ../textures/src/lib/utils/version.ts
  var VERSION8;
  var init_version4 = __esm({
    "../textures/src/lib/utils/version.ts"() {
      VERSION8 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../textures/src/lib/parsers/basis-module-loader.ts
  async function loadBasisTrascoderModule(options) {
    const modules = options.modules || {};
    if (modules.basis) {
      return modules.basis;
    }
    loadBasisTranscoderPromise = loadBasisTranscoderPromise || loadBasisTrascoder(options);
    return await loadBasisTranscoderPromise;
  }
  async function loadBasisTrascoder(options) {
    let BASIS = null;
    let wasmBinary = null;
    [BASIS, wasmBinary] = await Promise.all([
      await loadLibrary("basis_transcoder.js", "textures", options),
      await loadLibrary("basis_transcoder.wasm", "textures", options)
    ]);
    BASIS = BASIS || globalThis.BASIS;
    return await initializeBasisTrascoderModule(BASIS, wasmBinary);
  }
  function initializeBasisTrascoderModule(BasisModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      BasisModule(options).then((module) => {
        const { BasisFile, initializeBasis } = module;
        initializeBasis();
        resolve2({ BasisFile });
      });
    });
  }
  async function loadBasisEncoderModule(options) {
    const modules = options.modules || {};
    if (modules.basisEncoder) {
      return modules.basisEncoder;
    }
    loadBasisEncoderPromise = loadBasisEncoderPromise || loadBasisEncoder(options);
    return await loadBasisEncoderPromise;
  }
  async function loadBasisEncoder(options) {
    let BASIS_ENCODER = null;
    let wasmBinary = null;
    [BASIS_ENCODER, wasmBinary] = await Promise.all([
      await loadLibrary(BASIS_CDN_ENCODER_JS, "textures", options),
      await loadLibrary(BASIS_CDN_ENCODER_WASM, "textures", options)
    ]);
    BASIS_ENCODER = BASIS_ENCODER || globalThis.BASIS;
    return await initializeBasisEncoderModule(BASIS_ENCODER, wasmBinary);
  }
  function initializeBasisEncoderModule(BasisEncoderModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      BasisEncoderModule(options).then((module) => {
        const { BasisFile, KTX2File, initializeBasis, BasisEncoder } = module;
        initializeBasis();
        resolve2({ BasisFile, KTX2File, BasisEncoder });
      });
    });
  }
  var VERSION9, BASIS_CDN_ENCODER_WASM, BASIS_CDN_ENCODER_JS, loadBasisTranscoderPromise, loadBasisEncoderPromise;
  var init_basis_module_loader = __esm({
    "../textures/src/lib/parsers/basis-module-loader.ts"() {
      init_src();
      VERSION9 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      BASIS_CDN_ENCODER_WASM = `https://unpkg.com/@loaders.gl/textures@${VERSION9}/dist/libs/basis_encoder.wasm`;
      BASIS_CDN_ENCODER_JS = `https://unpkg.com/@loaders.gl/textures@${VERSION9}/dist/libs/basis_encoder.js`;
    }
  });

  // ../textures/src/lib/gl-extensions.ts
  var GL_EXTENSIONS_CONSTANTS;
  var init_gl_extensions = __esm({
    "../textures/src/lib/gl-extensions.ts"() {
      GL_EXTENSIONS_CONSTANTS = {
        COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
        COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
        COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
        COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
        COMPRESSED_R11_EAC: 37488,
        COMPRESSED_SIGNED_R11_EAC: 37489,
        COMPRESSED_RG11_EAC: 37490,
        COMPRESSED_SIGNED_RG11_EAC: 37491,
        COMPRESSED_RGB8_ETC2: 37492,
        COMPRESSED_RGBA8_ETC2_EAC: 37493,
        COMPRESSED_SRGB8_ETC2: 37494,
        COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37495,
        COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37496,
        COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37497,
        COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
        COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
        COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
        COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
        COMPRESSED_RGB_ETC1_WEBGL: 36196,
        COMPRESSED_RGB_ATC_WEBGL: 35986,
        COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL: 35987,
        COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL: 34798,
        COMPRESSED_RGBA_ASTC_4X4_KHR: 37808,
        COMPRESSED_RGBA_ASTC_5X4_KHR: 37809,
        COMPRESSED_RGBA_ASTC_5X5_KHR: 37810,
        COMPRESSED_RGBA_ASTC_6X5_KHR: 37811,
        COMPRESSED_RGBA_ASTC_6X6_KHR: 37812,
        COMPRESSED_RGBA_ASTC_8X5_KHR: 37813,
        COMPRESSED_RGBA_ASTC_8X6_KHR: 37814,
        COMPRESSED_RGBA_ASTC_8X8_KHR: 37815,
        COMPRESSED_RGBA_ASTC_10X5_KHR: 37816,
        COMPRESSED_RGBA_ASTC_10X6_KHR: 37817,
        COMPRESSED_RGBA_ASTC_10X8_KHR: 37818,
        COMPRESSED_RGBA_ASTC_10X10_KHR: 37819,
        COMPRESSED_RGBA_ASTC_12X10_KHR: 37820,
        COMPRESSED_RGBA_ASTC_12X12_KHR: 37821,
        COMPRESSED_SRGB8_ALPHA8_ASTC_4X4_KHR: 37840,
        COMPRESSED_SRGB8_ALPHA8_ASTC_5X4_KHR: 37841,
        COMPRESSED_SRGB8_ALPHA8_ASTC_5X5_KHR: 37842,
        COMPRESSED_SRGB8_ALPHA8_ASTC_6X5_KHR: 37843,
        COMPRESSED_SRGB8_ALPHA8_ASTC_6X6_KHR: 37844,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X5_KHR: 37845,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X6_KHR: 37846,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X8_KHR: 37847,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X5_KHR: 37848,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X6_KHR: 37849,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X8_KHR: 37850,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X10_KHR: 37851,
        COMPRESSED_SRGB8_ALPHA8_ASTC_12X10_KHR: 37852,
        COMPRESSED_SRGB8_ALPHA8_ASTC_12X12_KHR: 37853,
        COMPRESSED_RED_RGTC1_EXT: 36283,
        COMPRESSED_SIGNED_RED_RGTC1_EXT: 36284,
        COMPRESSED_RED_GREEN_RGTC2_EXT: 36285,
        COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT: 36286,
        COMPRESSED_SRGB_S3TC_DXT1_EXT: 35916,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT: 35917,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT: 35918,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT: 35919
      };
    }
  });

  // ../textures/src/lib/utils/texture-formats.ts
  function getSupportedGPUTextureFormats(gl) {
    if (!formats) {
      gl = gl || getWebGLContext() || void 0;
      formats = new Set();
      for (const prefix of BROWSER_PREFIXES) {
        for (const extension in WEBGL_EXTENSIONS) {
          if (gl && gl.getExtension(`${prefix}${extension}`)) {
            const gpuTextureFormat = WEBGL_EXTENSIONS[extension];
            formats.add(gpuTextureFormat);
          }
        }
      }
    }
    return formats;
  }
  function getWebGLContext() {
    try {
      const canvas = document.createElement("canvas");
      return canvas.getContext("webgl");
    } catch (error) {
      return null;
    }
  }
  var BROWSER_PREFIXES, WEBGL_EXTENSIONS, formats;
  var init_texture_formats = __esm({
    "../textures/src/lib/utils/texture-formats.ts"() {
      BROWSER_PREFIXES = ["", "WEBKIT_", "MOZ_"];
      WEBGL_EXTENSIONS = {
        WEBGL_compressed_texture_s3tc: "dxt",
        WEBGL_compressed_texture_s3tc_srgb: "dxt-srgb",
        WEBGL_compressed_texture_etc1: "etc1",
        WEBGL_compressed_texture_etc: "etc2",
        WEBGL_compressed_texture_pvrtc: "pvrtc",
        WEBGL_compressed_texture_atc: "atc",
        WEBGL_compressed_texture_astc: "astc",
        EXT_texture_compression_rgtc: "rgtc"
      };
      formats = null;
    }
  });

  // ../../node_modules/ktx-parse/dist/ktx-parse.modern.js
  function _(t2) {
    return typeof TextDecoder != "undefined" ? new TextDecoder().decode(t2) : Buffer.from(t2).toString("utf8");
  }
  function p(t2) {
    const n2 = new Uint8Array(t2.buffer, t2.byteOffset, e.length);
    if (n2[0] !== e[0] || n2[1] !== e[1] || n2[2] !== e[2] || n2[3] !== e[3] || n2[4] !== e[4] || n2[5] !== e[5] || n2[6] !== e[6] || n2[7] !== e[7] || n2[8] !== e[8] || n2[9] !== e[9] || n2[10] !== e[10] || n2[11] !== e[11])
      throw new Error("Missing KTX 2.0 identifier.");
    const i2 = new U(), s2 = 17 * Uint32Array.BYTES_PER_ELEMENT, a2 = new c(t2, e.length, s2, true);
    i2.vkFormat = a2._nextUint32(), i2.typeSize = a2._nextUint32(), i2.pixelWidth = a2._nextUint32(), i2.pixelHeight = a2._nextUint32(), i2.pixelDepth = a2._nextUint32(), i2.layerCount = a2._nextUint32(), i2.faceCount = a2._nextUint32();
    const r2 = a2._nextUint32();
    i2.supercompressionScheme = a2._nextUint32();
    const o2 = a2._nextUint32(), l2 = a2._nextUint32(), f2 = a2._nextUint32(), h = a2._nextUint32(), g = a2._nextUint64(), p2 = a2._nextUint64(), x = new c(t2, e.length + s2, 3 * r2 * 8, true);
    for (let e2 = 0; e2 < r2; e2++)
      i2.levels.push({ levelData: new Uint8Array(t2.buffer, t2.byteOffset + x._nextUint64(), x._nextUint64()), uncompressedByteLength: x._nextUint64() });
    const u = new c(t2, o2, l2, true), y = { vendorId: u._skip(4)._nextUint16(), descriptorType: u._nextUint16(), versionNumber: u._nextUint16(), descriptorBlockSize: u._nextUint16(), colorModel: u._nextUint8(), colorPrimaries: u._nextUint8(), transferFunction: u._nextUint8(), flags: u._nextUint8(), texelBlockDimension: { x: u._nextUint8() + 1, y: u._nextUint8() + 1, z: u._nextUint8() + 1, w: u._nextUint8() + 1 }, bytesPlane: [u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8()], samples: [] }, D = (y.descriptorBlockSize / 4 - 6) / 4;
    for (let t3 = 0; t3 < D; t3++)
      y.samples[t3] = { bitOffset: u._nextUint16(), bitLength: u._nextUint8(), channelID: u._nextUint8(), samplePosition: [u._nextUint8(), u._nextUint8(), u._nextUint8(), u._nextUint8()], sampleLower: u._nextUint32(), sampleUpper: u._nextUint32() };
    i2.dataFormatDescriptor.length = 0, i2.dataFormatDescriptor.push(y);
    const b = new c(t2, f2, h, true);
    for (; b._offset < h; ) {
      const t3 = b._nextUint32(), e2 = b._scan(t3), n3 = _(e2), s3 = b._scan(t3 - e2.byteLength);
      i2.keyValue[n3] = n3.match(/^ktx/i) ? _(s3) : s3, t3 % 4 && b._skip(4 - t3 % 4);
    }
    if (p2 <= 0)
      return i2;
    const d = new c(t2, g, p2, true), B = d._nextUint16(), w = d._nextUint16(), A = d._nextUint32(), S = d._nextUint32(), m = d._nextUint32(), L = d._nextUint32(), I = [];
    for (let t3 = 0; t3 < r2; t3++)
      I.push({ imageFlags: d._nextUint32(), rgbSliceByteOffset: d._nextUint32(), rgbSliceByteLength: d._nextUint32(), alphaSliceByteOffset: d._nextUint32(), alphaSliceByteLength: d._nextUint32() });
    const R = g + d._offset, E = R + A, T = E + S, O = T + m, P = new Uint8Array(t2.buffer, t2.byteOffset + R, A), C = new Uint8Array(t2.buffer, t2.byteOffset + E, S), F = new Uint8Array(t2.buffer, t2.byteOffset + T, m), G = new Uint8Array(t2.buffer, t2.byteOffset + O, L);
    return i2.globalData = { endpointCount: B, selectorCount: w, imageDescs: I, endpointsData: P, selectorsData: C, tablesData: F, extendedData: G }, i2;
  }
  var t, e, n, i, s, a, r, o, l, f, U, c;
  var init_ktx_parse_modern = __esm({
    "../../node_modules/ktx-parse/dist/ktx-parse.modern.js"() {
      t = new Uint8Array([0]);
      e = [171, 75, 84, 88, 32, 50, 48, 187, 13, 10, 26, 10];
      !function(t2) {
        t2[t2.NONE = 0] = "NONE", t2[t2.BASISLZ = 1] = "BASISLZ", t2[t2.ZSTD = 2] = "ZSTD", t2[t2.ZLIB = 3] = "ZLIB";
      }(n || (n = {})), function(t2) {
        t2[t2.BASICFORMAT = 0] = "BASICFORMAT";
      }(i || (i = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.ETC1S = 163] = "ETC1S", t2[t2.UASTC = 166] = "UASTC";
      }(s || (s = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.SRGB = 1] = "SRGB";
      }(a || (a = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.LINEAR = 1] = "LINEAR", t2[t2.SRGB = 2] = "SRGB", t2[t2.ITU = 3] = "ITU", t2[t2.NTSC = 4] = "NTSC", t2[t2.SLOG = 5] = "SLOG", t2[t2.SLOG2 = 6] = "SLOG2";
      }(r || (r = {})), function(t2) {
        t2[t2.ALPHA_STRAIGHT = 0] = "ALPHA_STRAIGHT", t2[t2.ALPHA_PREMULTIPLIED = 1] = "ALPHA_PREMULTIPLIED";
      }(o || (o = {})), function(t2) {
        t2[t2.RGB = 0] = "RGB", t2[t2.RRR = 3] = "RRR", t2[t2.GGG = 4] = "GGG", t2[t2.AAA = 15] = "AAA";
      }(l || (l = {})), function(t2) {
        t2[t2.RGB = 0] = "RGB", t2[t2.RGBA = 3] = "RGBA", t2[t2.RRR = 4] = "RRR", t2[t2.RRRG = 5] = "RRRG";
      }(f || (f = {}));
      U = class {
        constructor() {
          this.vkFormat = 0, this.typeSize = 1, this.pixelWidth = 0, this.pixelHeight = 0, this.pixelDepth = 0, this.layerCount = 0, this.faceCount = 1, this.supercompressionScheme = n.NONE, this.levels = [], this.dataFormatDescriptor = [{ vendorId: 0, descriptorType: i.BASICFORMAT, versionNumber: 2, descriptorBlockSize: 40, colorModel: s.UNSPECIFIED, colorPrimaries: a.SRGB, transferFunction: a.SRGB, flags: o.ALPHA_STRAIGHT, texelBlockDimension: { x: 4, y: 4, z: 1, w: 1 }, bytesPlane: [], samples: [] }], this.keyValue = {}, this.globalData = null;
        }
      };
      c = class {
        constructor(t2, e2, n2, i2) {
          this._dataView = new DataView(t2.buffer, t2.byteOffset + e2, n2), this._littleEndian = i2, this._offset = 0;
        }
        _nextUint8() {
          const t2 = this._dataView.getUint8(this._offset);
          return this._offset += 1, t2;
        }
        _nextUint16() {
          const t2 = this._dataView.getUint16(this._offset, this._littleEndian);
          return this._offset += 2, t2;
        }
        _nextUint32() {
          const t2 = this._dataView.getUint32(this._offset, this._littleEndian);
          return this._offset += 4, t2;
        }
        _nextUint64() {
          const t2 = this._dataView.getUint32(this._offset, this._littleEndian) + 2 ** 32 * this._dataView.getUint32(this._offset + 4, this._littleEndian);
          return this._offset += 8, t2;
        }
        _skip(t2) {
          return this._offset += t2, this;
        }
        _scan(t2, e2 = 0) {
          const n2 = this._offset;
          let i2 = 0;
          for (; this._dataView.getUint8(this._offset) !== e2 && i2 < t2; )
            i2++, this._offset++;
          return i2 < t2 && this._offset++, new Uint8Array(this._dataView.buffer, this._dataView.byteOffset + n2, i2);
        }
      };
    }
  });

  // ../textures/src/lib/utils/extract-mipmap-images.ts
  function extractMipmapImages(data, options) {
    const images = new Array(options.mipMapLevels);
    let levelWidth = options.width;
    let levelHeight = options.height;
    let offset = 0;
    for (let i2 = 0; i2 < options.mipMapLevels; ++i2) {
      const levelSize = getLevelSize(options, levelWidth, levelHeight, data, i2);
      const levelData = getLevelData(data, i2, offset, levelSize);
      images[i2] = {
        compressed: true,
        format: options.internalFormat,
        data: levelData,
        width: levelWidth,
        height: levelHeight,
        levelSize
      };
      levelWidth = Math.max(1, levelWidth >> 1);
      levelHeight = Math.max(1, levelHeight >> 1);
      offset += levelSize;
    }
    return images;
  }
  function getLevelData(data, index, offset, levelSize) {
    if (!Array.isArray(data)) {
      return new Uint8Array(data.buffer, data.byteOffset + offset, levelSize);
    }
    return data[index].levelData;
  }
  function getLevelSize(options, levelWidth, levelHeight, data, index) {
    if (!Array.isArray(data)) {
      return options.sizeFunction(levelWidth, levelHeight);
    }
    return options.sizeFunction(data[index]);
  }
  var init_extract_mipmap_images = __esm({
    "../textures/src/lib/utils/extract-mipmap-images.ts"() {
    }
  });

  // ../textures/src/lib/utils/ktx-format-helper.ts
  function mapVkFormatToWebGL(vkFormat) {
    return VULKAN_TO_WEBGL_FORMAT_MAP[vkFormat];
  }
  var VULKAN_TO_WEBGL_FORMAT_MAP;
  var init_ktx_format_helper = __esm({
    "../textures/src/lib/utils/ktx-format-helper.ts"() {
      init_gl_extensions();
      VULKAN_TO_WEBGL_FORMAT_MAP = {
        131: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_S3TC_DXT1_EXT,
        132: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB_S3TC_DXT1_EXT,
        133: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT1_EXT,
        134: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT,
        135: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT3_EXT,
        136: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT,
        137: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT5_EXT,
        138: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT,
        139: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RED_RGTC1_EXT,
        140: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SIGNED_RED_RGTC1_EXT,
        141: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RED_GREEN_RGTC2_EXT,
        142: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT,
        147: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB8_ETC2,
        148: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ETC2,
        149: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2,
        150: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2,
        151: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA8_ETC2_EAC,
        152: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC,
        153: GL_EXTENSIONS_CONSTANTS.COMPRESSED_R11_EAC,
        154: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SIGNED_R11_EAC,
        155: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RG11_EAC,
        156: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SIGNED_RG11_EAC,
        157: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_4x4_KHR,
        158: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR,
        159: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5x4_KHR,
        160: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_5X4_KHR,
        161: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5x5_KHR,
        162: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR,
        163: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6x5_KHR,
        164: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR,
        165: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6x6_KHR,
        166: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR,
        167: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x5_KHR,
        168: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR,
        169: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x6_KHR,
        170: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR,
        171: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x8_KHR,
        172: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR,
        173: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x5_KHR,
        174: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR,
        175: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x6_KHR,
        176: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR,
        177: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x8_KHR,
        178: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR,
        179: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x10_KHR,
        180: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR,
        181: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12x10_KHR,
        182: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR,
        183: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12x12_KHR,
        184: GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR,
        1000054e3: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,
        1000054001: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
        1000066e3: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_4x4_KHR,
        1000066001: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5x4_KHR,
        1000066002: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5x5_KHR,
        1000066003: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6x5_KHR,
        1000066004: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6x6_KHR,
        1000066005: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x5_KHR,
        1000066006: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x6_KHR,
        1000066007: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8x8_KHR,
        1000066008: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x5_KHR,
        1000066009: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x6_KHR,
        1000066010: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x8_KHR,
        1000066011: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10x10_KHR,
        1000066012: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12x10_KHR,
        1000066013: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12x12_KHR
      };
    }
  });

  // ../textures/src/lib/parsers/parse-ktx.ts
  function isKTX(data) {
    const id = new Uint8Array(data);
    const notKTX = id.byteLength < KTX2_ID.length || id[0] !== KTX2_ID[0] || id[1] !== KTX2_ID[1] || id[2] !== KTX2_ID[2] || id[3] !== KTX2_ID[3] || id[4] !== KTX2_ID[4] || id[5] !== KTX2_ID[5] || id[6] !== KTX2_ID[6] || id[7] !== KTX2_ID[7] || id[8] !== KTX2_ID[8] || id[9] !== KTX2_ID[9] || id[10] !== KTX2_ID[10] || id[11] !== KTX2_ID[11];
    return !notKTX;
  }
  function parseKTX(arrayBuffer) {
    const uint8Array = new Uint8Array(arrayBuffer);
    const ktx = p(uint8Array);
    const mipMapLevels = Math.max(1, ktx.levels.length);
    const width = ktx.pixelWidth;
    const height = ktx.pixelHeight;
    const internalFormat = mapVkFormatToWebGL(ktx.vkFormat);
    return extractMipmapImages(ktx.levels, {
      mipMapLevels,
      width,
      height,
      sizeFunction: (level) => level.uncompressedByteLength,
      internalFormat
    });
  }
  var KTX2_ID;
  var init_parse_ktx = __esm({
    "../textures/src/lib/parsers/parse-ktx.ts"() {
      init_ktx_parse_modern();
      init_extract_mipmap_images();
      init_ktx_format_helper();
      KTX2_ID = [
        171,
        75,
        84,
        88,
        32,
        50,
        48,
        187,
        13,
        10,
        26,
        10
      ];
    }
  });

  // ../textures/src/lib/parsers/parse-basis.ts
  async function parseBasis(data, options) {
    if (options.basis.containerFormat === "auto") {
      if (isKTX(data)) {
        const fileConstructors = await loadBasisEncoderModule(options);
        return parseKTX2File(fileConstructors.KTX2File, data, options);
      }
      const { BasisFile } = await loadBasisTrascoderModule(options);
      return parseBasisFile(BasisFile, data, options);
    }
    switch (options.basis.module) {
      case "encoder":
        const fileConstructors = await loadBasisEncoderModule(options);
        switch (options.basis.containerFormat) {
          case "ktx2":
            return parseKTX2File(fileConstructors.KTX2File, data, options);
          case "basis":
          default:
            return parseBasisFile(fileConstructors.BasisFile, data, options);
        }
      case "transcoder":
      default:
        const { BasisFile } = await loadBasisTrascoderModule(options);
        return parseBasisFile(BasisFile, data, options);
    }
  }
  function parseBasisFile(BasisFile, data, options) {
    const basisFile = new BasisFile(new Uint8Array(data));
    try {
      if (!basisFile.startTranscoding()) {
        throw new Error("Failed to start basis transcoding");
      }
      const imageCount = basisFile.getNumImages();
      const images = [];
      for (let imageIndex = 0; imageIndex < imageCount; imageIndex++) {
        const levelsCount = basisFile.getNumLevels(imageIndex);
        const levels = [];
        for (let levelIndex = 0; levelIndex < levelsCount; levelIndex++) {
          levels.push(transcodeImage(basisFile, imageIndex, levelIndex, options));
        }
        images.push(levels);
      }
      return images;
    } finally {
      basisFile.close();
      basisFile.delete();
    }
  }
  function transcodeImage(basisFile, imageIndex, levelIndex, options) {
    const width = basisFile.getImageWidth(imageIndex, levelIndex);
    const height = basisFile.getImageHeight(imageIndex, levelIndex);
    const hasAlpha = basisFile.getHasAlpha();
    const { compressed, format, basisFormat } = getBasisOptions(options, hasAlpha);
    const decodedSize = basisFile.getImageTranscodedSizeInBytes(imageIndex, levelIndex, basisFormat);
    const decodedData = new Uint8Array(decodedSize);
    if (!basisFile.transcodeImage(decodedData, imageIndex, levelIndex, basisFormat, 0, 0)) {
      throw new Error("failed to start Basis transcoding");
    }
    return {
      width,
      height,
      data: decodedData,
      compressed,
      format,
      hasAlpha
    };
  }
  function parseKTX2File(KTX2File, data, options) {
    const ktx2File = new KTX2File(new Uint8Array(data));
    try {
      if (!ktx2File.startTranscoding()) {
        throw new Error("failed to start KTX2 transcoding");
      }
      const levelsCount = ktx2File.getLevels();
      const levels = [];
      for (let levelIndex = 0; levelIndex < levelsCount; levelIndex++) {
        levels.push(transcodeKTX2Image(ktx2File, levelIndex, options));
        break;
      }
      return [levels];
    } finally {
      ktx2File.close();
      ktx2File.delete();
    }
  }
  function transcodeKTX2Image(ktx2File, levelIndex, options) {
    const { alphaFlag, height, width } = ktx2File.getImageLevelInfo(levelIndex, 0, 0);
    const { compressed, format, basisFormat } = getBasisOptions(options, alphaFlag);
    const decodedSize = ktx2File.getImageTranscodedSizeInBytes(levelIndex, 0, 0, basisFormat);
    const decodedData = new Uint8Array(decodedSize);
    if (!ktx2File.transcodeImage(decodedData, levelIndex, 0, 0, basisFormat, 0, -1, -1)) {
      throw new Error("Failed to transcode KTX2 image");
    }
    return {
      width,
      height,
      data: decodedData,
      compressed,
      levelSize: decodedSize,
      hasAlpha: alphaFlag,
      format
    };
  }
  function getBasisOptions(options, hasAlpha) {
    let format = options && options.basis && options.basis.format;
    if (format === "auto") {
      format = selectSupportedBasisFormat();
    }
    if (typeof format === "object") {
      format = hasAlpha ? format.alpha : format.noAlpha;
    }
    format = format.toLowerCase();
    return OutputFormat[format];
  }
  function selectSupportedBasisFormat() {
    const supportedFormats = getSupportedGPUTextureFormats();
    if (supportedFormats.has("astc")) {
      return "astc-4x4";
    } else if (supportedFormats.has("dxt")) {
      return {
        alpha: "bc3",
        noAlpha: "bc1"
      };
    } else if (supportedFormats.has("pvrtc")) {
      return {
        alpha: "pvrtc1-4-rgba",
        noAlpha: "pvrtc1-4-rgb"
      };
    } else if (supportedFormats.has("etc1")) {
      return "etc1";
    } else if (supportedFormats.has("etc2")) {
      return "etc2";
    }
    return "rgb565";
  }
  var OutputFormat;
  var init_parse_basis = __esm({
    "../textures/src/lib/parsers/parse-basis.ts"() {
      init_basis_module_loader();
      init_gl_extensions();
      init_texture_formats();
      init_parse_ktx();
      OutputFormat = {
        etc1: {
          basisFormat: 0,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_ETC1_WEBGL
        },
        etc2: { basisFormat: 1, compressed: true },
        bc1: {
          basisFormat: 2,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_S3TC_DXT1_EXT
        },
        bc3: {
          basisFormat: 3,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT5_EXT
        },
        bc4: { basisFormat: 4, compressed: true },
        bc5: { basisFormat: 5, compressed: true },
        "bc7-m6-opaque-only": { basisFormat: 6, compressed: true },
        "bc7-m5": { basisFormat: 7, compressed: true },
        "pvrtc1-4-rgb": {
          basisFormat: 8,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_PVRTC_4BPPV1_IMG
        },
        "pvrtc1-4-rgba": {
          basisFormat: 9,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG
        },
        "astc-4x4": {
          basisFormat: 10,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_4X4_KHR
        },
        "atc-rgb": { basisFormat: 11, compressed: true },
        "atc-rgba-interpolated-alpha": { basisFormat: 12, compressed: true },
        rgba32: { basisFormat: 13, compressed: false },
        rgb565: { basisFormat: 14, compressed: false },
        bgr565: { basisFormat: 15, compressed: false },
        rgba4444: { basisFormat: 16, compressed: false }
      };
    }
  });

  // ../textures/src/basis-loader.ts
  var BasisWorkerLoader, BasisLoader;
  var init_basis_loader = __esm({
    "../textures/src/basis-loader.ts"() {
      init_src();
      init_version4();
      init_parse_basis();
      BasisWorkerLoader = {
        name: "Basis",
        id: isBrowser2 ? "basis" : "basis-nodejs",
        module: "textures",
        version: VERSION8,
        worker: true,
        extensions: ["basis", "ktx2"],
        mimeTypes: ["application/octet-stream", "image/ktx2"],
        tests: ["sB"],
        binary: true,
        options: {
          basis: {
            format: "auto",
            libraryPath: "libs/",
            containerFormat: "auto",
            module: "transcoder"
          }
        }
      };
      BasisLoader = {
        ...BasisWorkerLoader,
        parse: parseBasis
      };
    }
  });

  // ../textures/src/lib/parsers/parse-dds.ts
  function isDDS(data) {
    const header = new Uint32Array(data, 0, DDS_CONSTANTS.HEADER_LENGTH);
    const magic = header[DDS_CONSTANTS.MAGIC_NUMBER_INDEX];
    return magic === DDS_CONSTANTS.MAGIC_NUMBER;
  }
  function parseDDS(data) {
    const header = new Int32Array(data, 0, DDS_CONSTANTS.HEADER_LENGTH);
    const pixelFormatNumber = header[DDS_CONSTANTS.HEADER_PF_FOURCC_INDEX];
    assert(Boolean(header[DDS_CONSTANTS.HEADER_PF_FLAGS_INDEX] & DDS_CONSTANTS.DDPF_FOURCC), "DDS: Unsupported format, must contain a FourCC code");
    const fourCC = int32ToFourCC(pixelFormatNumber);
    const internalFormat = DDS_PIXEL_FORMATS[fourCC];
    const sizeFunction = DDS_SIZE_FUNCTIONS[fourCC];
    assert(internalFormat && sizeFunction, `DDS: Unknown pixel format ${pixelFormatNumber}`);
    let mipMapLevels = 1;
    if (header[DDS_CONSTANTS.HEADER_FLAGS_INDEX] & DDS_CONSTANTS.DDSD_MIPMAPCOUNT) {
      mipMapLevels = Math.max(1, header[DDS_CONSTANTS.MIPMAPCOUNT_INDEX]);
    }
    const width = header[DDS_CONSTANTS.HEADER_WIDTH_INDEX];
    const height = header[DDS_CONSTANTS.HEADER_HEIGHT_INDEX];
    const dataOffset = header[DDS_CONSTANTS.HEADER_SIZE_INDEX] + 4;
    const image = new Uint8Array(data, dataOffset);
    return extractMipmapImages(image, {
      mipMapLevels,
      width,
      height,
      sizeFunction,
      internalFormat
    });
  }
  function getDxt1LevelSize(width, height) {
    return (width + 3 >> 2) * (height + 3 >> 2) * 8;
  }
  function getDxtXLevelSize(width, height) {
    return (width + 3 >> 2) * (height + 3 >> 2) * 16;
  }
  function int32ToFourCC(value) {
    return String.fromCharCode(value & 255, value >> 8 & 255, value >> 16 & 255, value >> 24 & 255);
  }
  var DDS_CONSTANTS, DDS_PIXEL_FORMATS, getATCLevelSize, getATCALevelSize, getATCILevelSize, DDS_SIZE_FUNCTIONS;
  var init_parse_dds = __esm({
    "../textures/src/lib/parsers/parse-dds.ts"() {
      init_src2();
      init_gl_extensions();
      init_extract_mipmap_images();
      DDS_CONSTANTS = {
        MAGIC_NUMBER: 542327876,
        HEADER_LENGTH: 31,
        MAGIC_NUMBER_INDEX: 0,
        HEADER_SIZE_INDEX: 1,
        HEADER_FLAGS_INDEX: 2,
        HEADER_HEIGHT_INDEX: 3,
        HEADER_WIDTH_INDEX: 4,
        MIPMAPCOUNT_INDEX: 7,
        HEADER_PF_FLAGS_INDEX: 20,
        HEADER_PF_FOURCC_INDEX: 21,
        DDSD_MIPMAPCOUNT: 131072,
        DDPF_FOURCC: 4
      };
      DDS_PIXEL_FORMATS = {
        DXT1: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_S3TC_DXT1_EXT,
        DXT3: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT3_EXT,
        DXT5: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT5_EXT,
        "ATC ": GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_ATC_WEBGL,
        ATCA: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL,
        ATCI: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL
      };
      getATCLevelSize = getDxt1LevelSize;
      getATCALevelSize = getDxtXLevelSize;
      getATCILevelSize = getDxtXLevelSize;
      DDS_SIZE_FUNCTIONS = {
        DXT1: getDxt1LevelSize,
        DXT3: getDxtXLevelSize,
        DXT5: getDxtXLevelSize,
        "ATC ": getATCLevelSize,
        ATCA: getATCALevelSize,
        ATCI: getATCILevelSize
      };
    }
  });

  // ../textures/src/lib/parsers/parse-pvr.ts
  function isPVR(data) {
    const header = new Uint32Array(data, 0, PVR_CONSTANTS.HEADER_LENGTH);
    const version = header[PVR_CONSTANTS.MAGIC_NUMBER_INDEX];
    return version === PVR_CONSTANTS.MAGIC_NUMBER || version === PVR_CONSTANTS.MAGIC_NUMBER_EXTRA;
  }
  function parsePVR(data) {
    const header = new Uint32Array(data, 0, PVR_CONSTANTS.HEADER_LENGTH);
    const pvrFormat = header[PVR_CONSTANTS.PIXEL_FORMAT_INDEX];
    const colourSpace = header[PVR_CONSTANTS.COLOUR_SPACE_INDEX];
    const pixelFormats = PVR_PIXEL_FORMATS[pvrFormat] || [];
    const internalFormat = pixelFormats.length > 1 && colourSpace ? pixelFormats[1] : pixelFormats[0];
    const sizeFunction = PVR_SIZE_FUNCTIONS[pvrFormat];
    const mipMapLevels = header[PVR_CONSTANTS.MIPMAPCOUNT_INDEX];
    const width = header[PVR_CONSTANTS.WIDTH_INDEX];
    const height = header[PVR_CONSTANTS.HEIGHT_INDEX];
    const dataOffset = PVR_CONSTANTS.HEADER_SIZE + header[PVR_CONSTANTS.METADATA_SIZE_INDEX];
    const image = new Uint8Array(data, dataOffset);
    return extractMipmapImages(image, {
      mipMapLevels,
      width,
      height,
      sizeFunction,
      internalFormat
    });
  }
  function pvrtc2bppSize(width, height) {
    width = Math.max(width, 16);
    height = Math.max(height, 8);
    return width * height / 4;
  }
  function pvrtc4bppSize(width, height) {
    width = Math.max(width, 8);
    height = Math.max(height, 8);
    return width * height / 2;
  }
  function dxtEtcSmallSize(width, height) {
    return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 8;
  }
  function dxtEtcAstcBigSize(width, height) {
    return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 16;
  }
  function atc5x4Size(width, height) {
    return Math.floor((width + 4) / 5) * Math.floor((height + 3) / 4) * 16;
  }
  function atc5x5Size(width, height) {
    return Math.floor((width + 4) / 5) * Math.floor((height + 4) / 5) * 16;
  }
  function atc6x5Size(width, height) {
    return Math.floor((width + 5) / 6) * Math.floor((height + 4) / 5) * 16;
  }
  function atc6x6Size(width, height) {
    return Math.floor((width + 5) / 6) * Math.floor((height + 5) / 6) * 16;
  }
  function atc8x5Size(width, height) {
    return Math.floor((width + 7) / 8) * Math.floor((height + 4) / 5) * 16;
  }
  function atc8x6Size(width, height) {
    return Math.floor((width + 7) / 8) * Math.floor((height + 5) / 6) * 16;
  }
  function atc8x8Size(width, height) {
    return Math.floor((width + 7) / 8) * Math.floor((height + 7) / 8) * 16;
  }
  function atc10x5Size(width, height) {
    return Math.floor((width + 9) / 10) * Math.floor((height + 4) / 5) * 16;
  }
  function atc10x6Size(width, height) {
    return Math.floor((width + 9) / 10) * Math.floor((height + 5) / 6) * 16;
  }
  function atc10x8Size(width, height) {
    return Math.floor((width + 9) / 10) * Math.floor((height + 7) / 8) * 16;
  }
  function atc10x10Size(width, height) {
    return Math.floor((width + 9) / 10) * Math.floor((height + 9) / 10) * 16;
  }
  function atc12x10Size(width, height) {
    return Math.floor((width + 11) / 12) * Math.floor((height + 9) / 10) * 16;
  }
  function atc12x12Size(width, height) {
    return Math.floor((width + 11) / 12) * Math.floor((height + 11) / 12) * 16;
  }
  var PVR_CONSTANTS, PVR_PIXEL_FORMATS, PVR_SIZE_FUNCTIONS;
  var init_parse_pvr = __esm({
    "../textures/src/lib/parsers/parse-pvr.ts"() {
      init_gl_extensions();
      init_extract_mipmap_images();
      PVR_CONSTANTS = {
        MAGIC_NUMBER: 55727696,
        MAGIC_NUMBER_EXTRA: 1347834371,
        HEADER_LENGTH: 13,
        HEADER_SIZE: 52,
        MAGIC_NUMBER_INDEX: 0,
        PIXEL_FORMAT_INDEX: 2,
        COLOUR_SPACE_INDEX: 4,
        HEIGHT_INDEX: 6,
        WIDTH_INDEX: 7,
        MIPMAPCOUNT_INDEX: 11,
        METADATA_SIZE_INDEX: 12
      };
      PVR_PIXEL_FORMATS = {
        0: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_PVRTC_2BPPV1_IMG],
        1: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG],
        2: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_PVRTC_4BPPV1_IMG],
        3: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG],
        6: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_ETC1_WEBGL],
        7: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_S3TC_DXT1_EXT],
        9: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT3_EXT],
        11: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT5_EXT],
        22: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB8_ETC2],
        23: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA8_ETC2_EAC],
        24: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2],
        25: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_R11_EAC],
        26: [GL_EXTENSIONS_CONSTANTS.COMPRESSED_RG11_EAC],
        27: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_4X4_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_4X4_KHR
        ],
        28: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5X4_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_5X4_KHR
        ],
        29: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_5X5_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_5X5_KHR
        ],
        30: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6X5_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_6X5_KHR
        ],
        31: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_6X6_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_6X6_KHR
        ],
        32: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8X5_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8X5_KHR
        ],
        33: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8X6_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8X6_KHR
        ],
        34: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_8X8_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_8X8_KHR
        ],
        35: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10X5_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10X5_KHR
        ],
        36: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10X6_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10X6_KHR
        ],
        37: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10X8_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10X8_KHR
        ],
        38: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_10X10_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_10X10_KHR
        ],
        39: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12X10_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_12X10_KHR
        ],
        40: [
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_12X12_KHR,
          GL_EXTENSIONS_CONSTANTS.COMPRESSED_SRGB8_ALPHA8_ASTC_12X12_KHR
        ]
      };
      PVR_SIZE_FUNCTIONS = {
        0: pvrtc2bppSize,
        1: pvrtc2bppSize,
        2: pvrtc4bppSize,
        3: pvrtc4bppSize,
        6: dxtEtcSmallSize,
        7: dxtEtcSmallSize,
        9: dxtEtcAstcBigSize,
        11: dxtEtcAstcBigSize,
        22: dxtEtcSmallSize,
        23: dxtEtcAstcBigSize,
        24: dxtEtcSmallSize,
        25: dxtEtcSmallSize,
        26: dxtEtcAstcBigSize,
        27: dxtEtcAstcBigSize,
        28: atc5x4Size,
        29: atc5x5Size,
        30: atc6x5Size,
        31: atc6x6Size,
        32: atc8x5Size,
        33: atc8x6Size,
        34: atc8x8Size,
        35: atc10x5Size,
        36: atc10x6Size,
        37: atc10x8Size,
        38: atc10x10Size,
        39: atc12x10Size,
        40: atc12x12Size
      };
    }
  });

  // ../textures/src/lib/parsers/parse-compressed-texture.ts
  function parseCompressedTexture(data) {
    if (isKTX(data)) {
      return parseKTX(data);
    }
    if (isDDS(data)) {
      return parseDDS(data);
    }
    if (isPVR(data)) {
      return parsePVR(data);
    }
    throw new Error("Texture container format not recognized");
  }
  var init_parse_compressed_texture = __esm({
    "../textures/src/lib/parsers/parse-compressed-texture.ts"() {
      init_parse_ktx();
      init_parse_dds();
      init_parse_pvr();
    }
  });

  // ../textures/src/compressed-texture-loader.ts
  var DEFAULT_TEXTURE_LOADER_OPTIONS, CompressedTextureWorkerLoader, CompressedTextureLoader;
  var init_compressed_texture_loader = __esm({
    "../textures/src/compressed-texture-loader.ts"() {
      init_version4();
      init_parse_compressed_texture();
      init_parse_basis();
      DEFAULT_TEXTURE_LOADER_OPTIONS = {
        "compressed-texture": {
          libraryPath: "libs/",
          useBasis: false
        }
      };
      CompressedTextureWorkerLoader = {
        name: "Texture Containers",
        id: "compressed-texture",
        module: "textures",
        version: VERSION8,
        worker: true,
        extensions: [
          "ktx",
          "ktx2",
          "dds",
          "pvr"
        ],
        mimeTypes: [
          "image/ktx2",
          "image/ktx",
          "image/vnd-ms.dds",
          "image/x-dds",
          "application/octet-stream"
        ],
        binary: true,
        options: DEFAULT_TEXTURE_LOADER_OPTIONS
      };
      CompressedTextureLoader = {
        ...CompressedTextureWorkerLoader,
        parse: async (arrayBuffer, options) => {
          if (options["compressed-texture"].useBasis) {
            options.basis = {
              format: {
                alpha: "BC3",
                noAlpha: "BC1"
              },
              ...options.basis,
              containerFormat: "ktx2",
              module: "encoder"
            };
            return (await parseBasis(arrayBuffer, options))[0];
          }
          return parseCompressedTexture(arrayBuffer);
        }
      };
    }
  });

  // ../textures/src/index.ts
  var init_src7 = __esm({
    "../textures/src/index.ts"() {
      init_basis_loader();
      init_compressed_texture_loader();
      init_parse_basis();
      init_texture_formats();
    }
  });

  // src/types.ts
  var DATA_TYPE, HeaderAttributeProperty;
  var init_types = __esm({
    "src/types.ts"() {
      (function(DATA_TYPE2) {
        DATA_TYPE2["UInt8"] = "UInt8";
        DATA_TYPE2["UInt16"] = "UInt16";
        DATA_TYPE2["UInt32"] = "UInt32";
        DATA_TYPE2["UInt64"] = "UInt64";
        DATA_TYPE2["Int16"] = "Int16";
        DATA_TYPE2["Int32"] = "Int32";
        DATA_TYPE2["Int64"] = "Int64";
        DATA_TYPE2["Float32"] = "Float32";
        DATA_TYPE2["Float64"] = "Float64";
      })(DATA_TYPE || (DATA_TYPE = {}));
      (function(HeaderAttributeProperty2) {
        HeaderAttributeProperty2["vertexCount"] = "vertexCount";
        HeaderAttributeProperty2["featureCount"] = "featureCount";
      })(HeaderAttributeProperty || (HeaderAttributeProperty = {}));
    }
  });

  // src/lib/utils/url-utils.ts
  function getUrlWithToken(url, token = null) {
    return token ? `${url}?token=${token}` : url;
  }
  function generateTileAttributeUrls(url, tile) {
    const { attributeData = [] } = tile;
    const attributeUrls = [];
    for (let index = 0; index < attributeData.length; index++) {
      const attributeUrl = attributeData[index].href.replace("./", "");
      attributeUrls.push(`${url}/${attributeUrl}`);
    }
    return attributeUrls;
  }
  function generateTilesetAttributeUrls(tileset, resource) {
    const attributeUrls = [];
    const { attributeStorageInfo, url } = tileset;
    for (let index = 0; index < attributeStorageInfo.length; index++) {
      const fileName = attributeStorageInfo[index].key;
      attributeUrls.push(`${url}/nodes/${resource}/attributes/${fileName}/0`);
    }
    return attributeUrls;
  }
  var init_url_utils2 = __esm({
    "src/lib/utils/url-utils.ts"() {
    }
  });

  // ../../node_modules/@luma.gl/constants/dist/esm/index.js
  var esm_default;
  var init_esm3 = __esm({
    "../../node_modules/@luma.gl/constants/dist/esm/index.js"() {
      esm_default = {
        DEPTH_BUFFER_BIT: 256,
        STENCIL_BUFFER_BIT: 1024,
        COLOR_BUFFER_BIT: 16384,
        POINTS: 0,
        LINES: 1,
        LINE_LOOP: 2,
        LINE_STRIP: 3,
        TRIANGLES: 4,
        TRIANGLE_STRIP: 5,
        TRIANGLE_FAN: 6,
        ZERO: 0,
        ONE: 1,
        SRC_COLOR: 768,
        ONE_MINUS_SRC_COLOR: 769,
        SRC_ALPHA: 770,
        ONE_MINUS_SRC_ALPHA: 771,
        DST_ALPHA: 772,
        ONE_MINUS_DST_ALPHA: 773,
        DST_COLOR: 774,
        ONE_MINUS_DST_COLOR: 775,
        SRC_ALPHA_SATURATE: 776,
        CONSTANT_COLOR: 32769,
        ONE_MINUS_CONSTANT_COLOR: 32770,
        CONSTANT_ALPHA: 32771,
        ONE_MINUS_CONSTANT_ALPHA: 32772,
        FUNC_ADD: 32774,
        FUNC_SUBTRACT: 32778,
        FUNC_REVERSE_SUBTRACT: 32779,
        BLEND_EQUATION: 32777,
        BLEND_EQUATION_RGB: 32777,
        BLEND_EQUATION_ALPHA: 34877,
        BLEND_DST_RGB: 32968,
        BLEND_SRC_RGB: 32969,
        BLEND_DST_ALPHA: 32970,
        BLEND_SRC_ALPHA: 32971,
        BLEND_COLOR: 32773,
        ARRAY_BUFFER_BINDING: 34964,
        ELEMENT_ARRAY_BUFFER_BINDING: 34965,
        LINE_WIDTH: 2849,
        ALIASED_POINT_SIZE_RANGE: 33901,
        ALIASED_LINE_WIDTH_RANGE: 33902,
        CULL_FACE_MODE: 2885,
        FRONT_FACE: 2886,
        DEPTH_RANGE: 2928,
        DEPTH_WRITEMASK: 2930,
        DEPTH_CLEAR_VALUE: 2931,
        DEPTH_FUNC: 2932,
        STENCIL_CLEAR_VALUE: 2961,
        STENCIL_FUNC: 2962,
        STENCIL_FAIL: 2964,
        STENCIL_PASS_DEPTH_FAIL: 2965,
        STENCIL_PASS_DEPTH_PASS: 2966,
        STENCIL_REF: 2967,
        STENCIL_VALUE_MASK: 2963,
        STENCIL_WRITEMASK: 2968,
        STENCIL_BACK_FUNC: 34816,
        STENCIL_BACK_FAIL: 34817,
        STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
        STENCIL_BACK_PASS_DEPTH_PASS: 34819,
        STENCIL_BACK_REF: 36003,
        STENCIL_BACK_VALUE_MASK: 36004,
        STENCIL_BACK_WRITEMASK: 36005,
        VIEWPORT: 2978,
        SCISSOR_BOX: 3088,
        COLOR_CLEAR_VALUE: 3106,
        COLOR_WRITEMASK: 3107,
        UNPACK_ALIGNMENT: 3317,
        PACK_ALIGNMENT: 3333,
        MAX_TEXTURE_SIZE: 3379,
        MAX_VIEWPORT_DIMS: 3386,
        SUBPIXEL_BITS: 3408,
        RED_BITS: 3410,
        GREEN_BITS: 3411,
        BLUE_BITS: 3412,
        ALPHA_BITS: 3413,
        DEPTH_BITS: 3414,
        STENCIL_BITS: 3415,
        POLYGON_OFFSET_UNITS: 10752,
        POLYGON_OFFSET_FACTOR: 32824,
        TEXTURE_BINDING_2D: 32873,
        SAMPLE_BUFFERS: 32936,
        SAMPLES: 32937,
        SAMPLE_COVERAGE_VALUE: 32938,
        SAMPLE_COVERAGE_INVERT: 32939,
        COMPRESSED_TEXTURE_FORMATS: 34467,
        VENDOR: 7936,
        RENDERER: 7937,
        VERSION: 7938,
        IMPLEMENTATION_COLOR_READ_TYPE: 35738,
        IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
        BROWSER_DEFAULT_WEBGL: 37444,
        STATIC_DRAW: 35044,
        STREAM_DRAW: 35040,
        DYNAMIC_DRAW: 35048,
        ARRAY_BUFFER: 34962,
        ELEMENT_ARRAY_BUFFER: 34963,
        BUFFER_SIZE: 34660,
        BUFFER_USAGE: 34661,
        CURRENT_VERTEX_ATTRIB: 34342,
        VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
        VERTEX_ATTRIB_ARRAY_SIZE: 34339,
        VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
        VERTEX_ATTRIB_ARRAY_TYPE: 34341,
        VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
        VERTEX_ATTRIB_ARRAY_POINTER: 34373,
        VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
        CULL_FACE: 2884,
        FRONT: 1028,
        BACK: 1029,
        FRONT_AND_BACK: 1032,
        BLEND: 3042,
        DEPTH_TEST: 2929,
        DITHER: 3024,
        POLYGON_OFFSET_FILL: 32823,
        SAMPLE_ALPHA_TO_COVERAGE: 32926,
        SAMPLE_COVERAGE: 32928,
        SCISSOR_TEST: 3089,
        STENCIL_TEST: 2960,
        NO_ERROR: 0,
        INVALID_ENUM: 1280,
        INVALID_VALUE: 1281,
        INVALID_OPERATION: 1282,
        OUT_OF_MEMORY: 1285,
        CONTEXT_LOST_WEBGL: 37442,
        CW: 2304,
        CCW: 2305,
        DONT_CARE: 4352,
        FASTEST: 4353,
        NICEST: 4354,
        GENERATE_MIPMAP_HINT: 33170,
        BYTE: 5120,
        UNSIGNED_BYTE: 5121,
        SHORT: 5122,
        UNSIGNED_SHORT: 5123,
        INT: 5124,
        UNSIGNED_INT: 5125,
        FLOAT: 5126,
        DOUBLE: 5130,
        DEPTH_COMPONENT: 6402,
        ALPHA: 6406,
        RGB: 6407,
        RGBA: 6408,
        LUMINANCE: 6409,
        LUMINANCE_ALPHA: 6410,
        UNSIGNED_SHORT_4_4_4_4: 32819,
        UNSIGNED_SHORT_5_5_5_1: 32820,
        UNSIGNED_SHORT_5_6_5: 33635,
        FRAGMENT_SHADER: 35632,
        VERTEX_SHADER: 35633,
        COMPILE_STATUS: 35713,
        DELETE_STATUS: 35712,
        LINK_STATUS: 35714,
        VALIDATE_STATUS: 35715,
        ATTACHED_SHADERS: 35717,
        ACTIVE_ATTRIBUTES: 35721,
        ACTIVE_UNIFORMS: 35718,
        MAX_VERTEX_ATTRIBS: 34921,
        MAX_VERTEX_UNIFORM_VECTORS: 36347,
        MAX_VARYING_VECTORS: 36348,
        MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
        MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
        MAX_TEXTURE_IMAGE_UNITS: 34930,
        MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
        SHADER_TYPE: 35663,
        SHADING_LANGUAGE_VERSION: 35724,
        CURRENT_PROGRAM: 35725,
        NEVER: 512,
        ALWAYS: 519,
        LESS: 513,
        EQUAL: 514,
        LEQUAL: 515,
        GREATER: 516,
        GEQUAL: 518,
        NOTEQUAL: 517,
        KEEP: 7680,
        REPLACE: 7681,
        INCR: 7682,
        DECR: 7683,
        INVERT: 5386,
        INCR_WRAP: 34055,
        DECR_WRAP: 34056,
        NEAREST: 9728,
        LINEAR: 9729,
        NEAREST_MIPMAP_NEAREST: 9984,
        LINEAR_MIPMAP_NEAREST: 9985,
        NEAREST_MIPMAP_LINEAR: 9986,
        LINEAR_MIPMAP_LINEAR: 9987,
        TEXTURE_MAG_FILTER: 10240,
        TEXTURE_MIN_FILTER: 10241,
        TEXTURE_WRAP_S: 10242,
        TEXTURE_WRAP_T: 10243,
        TEXTURE_2D: 3553,
        TEXTURE: 5890,
        TEXTURE_CUBE_MAP: 34067,
        TEXTURE_BINDING_CUBE_MAP: 34068,
        TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
        TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
        TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
        TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
        TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
        TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
        MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
        TEXTURE0: 33984,
        ACTIVE_TEXTURE: 34016,
        REPEAT: 10497,
        CLAMP_TO_EDGE: 33071,
        MIRRORED_REPEAT: 33648,
        TEXTURE_WIDTH: 4096,
        TEXTURE_HEIGHT: 4097,
        FLOAT_VEC2: 35664,
        FLOAT_VEC3: 35665,
        FLOAT_VEC4: 35666,
        INT_VEC2: 35667,
        INT_VEC3: 35668,
        INT_VEC4: 35669,
        BOOL: 35670,
        BOOL_VEC2: 35671,
        BOOL_VEC3: 35672,
        BOOL_VEC4: 35673,
        FLOAT_MAT2: 35674,
        FLOAT_MAT3: 35675,
        FLOAT_MAT4: 35676,
        SAMPLER_2D: 35678,
        SAMPLER_CUBE: 35680,
        LOW_FLOAT: 36336,
        MEDIUM_FLOAT: 36337,
        HIGH_FLOAT: 36338,
        LOW_INT: 36339,
        MEDIUM_INT: 36340,
        HIGH_INT: 36341,
        FRAMEBUFFER: 36160,
        RENDERBUFFER: 36161,
        RGBA4: 32854,
        RGB5_A1: 32855,
        RGB565: 36194,
        DEPTH_COMPONENT16: 33189,
        STENCIL_INDEX: 6401,
        STENCIL_INDEX8: 36168,
        DEPTH_STENCIL: 34041,
        RENDERBUFFER_WIDTH: 36162,
        RENDERBUFFER_HEIGHT: 36163,
        RENDERBUFFER_INTERNAL_FORMAT: 36164,
        RENDERBUFFER_RED_SIZE: 36176,
        RENDERBUFFER_GREEN_SIZE: 36177,
        RENDERBUFFER_BLUE_SIZE: 36178,
        RENDERBUFFER_ALPHA_SIZE: 36179,
        RENDERBUFFER_DEPTH_SIZE: 36180,
        RENDERBUFFER_STENCIL_SIZE: 36181,
        FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
        FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
        FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
        FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
        COLOR_ATTACHMENT0: 36064,
        DEPTH_ATTACHMENT: 36096,
        STENCIL_ATTACHMENT: 36128,
        DEPTH_STENCIL_ATTACHMENT: 33306,
        NONE: 0,
        FRAMEBUFFER_COMPLETE: 36053,
        FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
        FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
        FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
        FRAMEBUFFER_UNSUPPORTED: 36061,
        FRAMEBUFFER_BINDING: 36006,
        RENDERBUFFER_BINDING: 36007,
        READ_FRAMEBUFFER: 36008,
        DRAW_FRAMEBUFFER: 36009,
        MAX_RENDERBUFFER_SIZE: 34024,
        INVALID_FRAMEBUFFER_OPERATION: 1286,
        UNPACK_FLIP_Y_WEBGL: 37440,
        UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
        UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
        READ_BUFFER: 3074,
        UNPACK_ROW_LENGTH: 3314,
        UNPACK_SKIP_ROWS: 3315,
        UNPACK_SKIP_PIXELS: 3316,
        PACK_ROW_LENGTH: 3330,
        PACK_SKIP_ROWS: 3331,
        PACK_SKIP_PIXELS: 3332,
        TEXTURE_BINDING_3D: 32874,
        UNPACK_SKIP_IMAGES: 32877,
        UNPACK_IMAGE_HEIGHT: 32878,
        MAX_3D_TEXTURE_SIZE: 32883,
        MAX_ELEMENTS_VERTICES: 33e3,
        MAX_ELEMENTS_INDICES: 33001,
        MAX_TEXTURE_LOD_BIAS: 34045,
        MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
        MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
        MAX_ARRAY_TEXTURE_LAYERS: 35071,
        MIN_PROGRAM_TEXEL_OFFSET: 35076,
        MAX_PROGRAM_TEXEL_OFFSET: 35077,
        MAX_VARYING_COMPONENTS: 35659,
        FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
        RASTERIZER_DISCARD: 35977,
        VERTEX_ARRAY_BINDING: 34229,
        MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
        MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
        MAX_SERVER_WAIT_TIMEOUT: 37137,
        MAX_ELEMENT_INDEX: 36203,
        RED: 6403,
        RGB8: 32849,
        RGBA8: 32856,
        RGB10_A2: 32857,
        TEXTURE_3D: 32879,
        TEXTURE_WRAP_R: 32882,
        TEXTURE_MIN_LOD: 33082,
        TEXTURE_MAX_LOD: 33083,
        TEXTURE_BASE_LEVEL: 33084,
        TEXTURE_MAX_LEVEL: 33085,
        TEXTURE_COMPARE_MODE: 34892,
        TEXTURE_COMPARE_FUNC: 34893,
        SRGB: 35904,
        SRGB8: 35905,
        SRGB8_ALPHA8: 35907,
        COMPARE_REF_TO_TEXTURE: 34894,
        RGBA32F: 34836,
        RGB32F: 34837,
        RGBA16F: 34842,
        RGB16F: 34843,
        TEXTURE_2D_ARRAY: 35866,
        TEXTURE_BINDING_2D_ARRAY: 35869,
        R11F_G11F_B10F: 35898,
        RGB9_E5: 35901,
        RGBA32UI: 36208,
        RGB32UI: 36209,
        RGBA16UI: 36214,
        RGB16UI: 36215,
        RGBA8UI: 36220,
        RGB8UI: 36221,
        RGBA32I: 36226,
        RGB32I: 36227,
        RGBA16I: 36232,
        RGB16I: 36233,
        RGBA8I: 36238,
        RGB8I: 36239,
        RED_INTEGER: 36244,
        RGB_INTEGER: 36248,
        RGBA_INTEGER: 36249,
        R8: 33321,
        RG8: 33323,
        R16F: 33325,
        R32F: 33326,
        RG16F: 33327,
        RG32F: 33328,
        R8I: 33329,
        R8UI: 33330,
        R16I: 33331,
        R16UI: 33332,
        R32I: 33333,
        R32UI: 33334,
        RG8I: 33335,
        RG8UI: 33336,
        RG16I: 33337,
        RG16UI: 33338,
        RG32I: 33339,
        RG32UI: 33340,
        R8_SNORM: 36756,
        RG8_SNORM: 36757,
        RGB8_SNORM: 36758,
        RGBA8_SNORM: 36759,
        RGB10_A2UI: 36975,
        TEXTURE_IMMUTABLE_FORMAT: 37167,
        TEXTURE_IMMUTABLE_LEVELS: 33503,
        UNSIGNED_INT_2_10_10_10_REV: 33640,
        UNSIGNED_INT_10F_11F_11F_REV: 35899,
        UNSIGNED_INT_5_9_9_9_REV: 35902,
        FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
        UNSIGNED_INT_24_8: 34042,
        HALF_FLOAT: 5131,
        RG: 33319,
        RG_INTEGER: 33320,
        INT_2_10_10_10_REV: 36255,
        CURRENT_QUERY: 34917,
        QUERY_RESULT: 34918,
        QUERY_RESULT_AVAILABLE: 34919,
        ANY_SAMPLES_PASSED: 35887,
        ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
        MAX_DRAW_BUFFERS: 34852,
        DRAW_BUFFER0: 34853,
        DRAW_BUFFER1: 34854,
        DRAW_BUFFER2: 34855,
        DRAW_BUFFER3: 34856,
        DRAW_BUFFER4: 34857,
        DRAW_BUFFER5: 34858,
        DRAW_BUFFER6: 34859,
        DRAW_BUFFER7: 34860,
        DRAW_BUFFER8: 34861,
        DRAW_BUFFER9: 34862,
        DRAW_BUFFER10: 34863,
        DRAW_BUFFER11: 34864,
        DRAW_BUFFER12: 34865,
        DRAW_BUFFER13: 34866,
        DRAW_BUFFER14: 34867,
        DRAW_BUFFER15: 34868,
        MAX_COLOR_ATTACHMENTS: 36063,
        COLOR_ATTACHMENT1: 36065,
        COLOR_ATTACHMENT2: 36066,
        COLOR_ATTACHMENT3: 36067,
        COLOR_ATTACHMENT4: 36068,
        COLOR_ATTACHMENT5: 36069,
        COLOR_ATTACHMENT6: 36070,
        COLOR_ATTACHMENT7: 36071,
        COLOR_ATTACHMENT8: 36072,
        COLOR_ATTACHMENT9: 36073,
        COLOR_ATTACHMENT10: 36074,
        COLOR_ATTACHMENT11: 36075,
        COLOR_ATTACHMENT12: 36076,
        COLOR_ATTACHMENT13: 36077,
        COLOR_ATTACHMENT14: 36078,
        COLOR_ATTACHMENT15: 36079,
        SAMPLER_3D: 35679,
        SAMPLER_2D_SHADOW: 35682,
        SAMPLER_2D_ARRAY: 36289,
        SAMPLER_2D_ARRAY_SHADOW: 36292,
        SAMPLER_CUBE_SHADOW: 36293,
        INT_SAMPLER_2D: 36298,
        INT_SAMPLER_3D: 36299,
        INT_SAMPLER_CUBE: 36300,
        INT_SAMPLER_2D_ARRAY: 36303,
        UNSIGNED_INT_SAMPLER_2D: 36306,
        UNSIGNED_INT_SAMPLER_3D: 36307,
        UNSIGNED_INT_SAMPLER_CUBE: 36308,
        UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
        MAX_SAMPLES: 36183,
        SAMPLER_BINDING: 35097,
        PIXEL_PACK_BUFFER: 35051,
        PIXEL_UNPACK_BUFFER: 35052,
        PIXEL_PACK_BUFFER_BINDING: 35053,
        PIXEL_UNPACK_BUFFER_BINDING: 35055,
        COPY_READ_BUFFER: 36662,
        COPY_WRITE_BUFFER: 36663,
        COPY_READ_BUFFER_BINDING: 36662,
        COPY_WRITE_BUFFER_BINDING: 36663,
        FLOAT_MAT2x3: 35685,
        FLOAT_MAT2x4: 35686,
        FLOAT_MAT3x2: 35687,
        FLOAT_MAT3x4: 35688,
        FLOAT_MAT4x2: 35689,
        FLOAT_MAT4x3: 35690,
        UNSIGNED_INT_VEC2: 36294,
        UNSIGNED_INT_VEC3: 36295,
        UNSIGNED_INT_VEC4: 36296,
        UNSIGNED_NORMALIZED: 35863,
        SIGNED_NORMALIZED: 36764,
        VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
        VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
        TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
        MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
        TRANSFORM_FEEDBACK_VARYINGS: 35971,
        TRANSFORM_FEEDBACK_BUFFER_START: 35972,
        TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
        TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
        MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
        MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
        INTERLEAVED_ATTRIBS: 35980,
        SEPARATE_ATTRIBS: 35981,
        TRANSFORM_FEEDBACK_BUFFER: 35982,
        TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
        TRANSFORM_FEEDBACK: 36386,
        TRANSFORM_FEEDBACK_PAUSED: 36387,
        TRANSFORM_FEEDBACK_ACTIVE: 36388,
        TRANSFORM_FEEDBACK_BINDING: 36389,
        FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
        FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
        FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
        FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
        FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
        FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
        FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
        FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
        FRAMEBUFFER_DEFAULT: 33304,
        DEPTH24_STENCIL8: 35056,
        DRAW_FRAMEBUFFER_BINDING: 36006,
        READ_FRAMEBUFFER_BINDING: 36010,
        RENDERBUFFER_SAMPLES: 36011,
        FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
        FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
        UNIFORM_BUFFER: 35345,
        UNIFORM_BUFFER_BINDING: 35368,
        UNIFORM_BUFFER_START: 35369,
        UNIFORM_BUFFER_SIZE: 35370,
        MAX_VERTEX_UNIFORM_BLOCKS: 35371,
        MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
        MAX_COMBINED_UNIFORM_BLOCKS: 35374,
        MAX_UNIFORM_BUFFER_BINDINGS: 35375,
        MAX_UNIFORM_BLOCK_SIZE: 35376,
        MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
        MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
        UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
        ACTIVE_UNIFORM_BLOCKS: 35382,
        UNIFORM_TYPE: 35383,
        UNIFORM_SIZE: 35384,
        UNIFORM_BLOCK_INDEX: 35386,
        UNIFORM_OFFSET: 35387,
        UNIFORM_ARRAY_STRIDE: 35388,
        UNIFORM_MATRIX_STRIDE: 35389,
        UNIFORM_IS_ROW_MAJOR: 35390,
        UNIFORM_BLOCK_BINDING: 35391,
        UNIFORM_BLOCK_DATA_SIZE: 35392,
        UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
        UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
        UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
        UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
        OBJECT_TYPE: 37138,
        SYNC_CONDITION: 37139,
        SYNC_STATUS: 37140,
        SYNC_FLAGS: 37141,
        SYNC_FENCE: 37142,
        SYNC_GPU_COMMANDS_COMPLETE: 37143,
        UNSIGNALED: 37144,
        SIGNALED: 37145,
        ALREADY_SIGNALED: 37146,
        TIMEOUT_EXPIRED: 37147,
        CONDITION_SATISFIED: 37148,
        WAIT_FAILED: 37149,
        SYNC_FLUSH_COMMANDS_BIT: 1,
        COLOR: 6144,
        DEPTH: 6145,
        STENCIL: 6146,
        MIN: 32775,
        MAX: 32776,
        DEPTH_COMPONENT24: 33190,
        STREAM_READ: 35041,
        STREAM_COPY: 35042,
        STATIC_READ: 35045,
        STATIC_COPY: 35046,
        DYNAMIC_READ: 35049,
        DYNAMIC_COPY: 35050,
        DEPTH_COMPONENT32F: 36012,
        DEPTH32F_STENCIL8: 36013,
        INVALID_INDEX: 4294967295,
        TIMEOUT_IGNORED: -1,
        MAX_CLIENT_WAIT_TIMEOUT_WEBGL: 37447,
        VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 35070,
        UNMASKED_VENDOR_WEBGL: 37445,
        UNMASKED_RENDERER_WEBGL: 37446,
        MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047,
        TEXTURE_MAX_ANISOTROPY_EXT: 34046,
        COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
        COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
        COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
        COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
        COMPRESSED_R11_EAC: 37488,
        COMPRESSED_SIGNED_R11_EAC: 37489,
        COMPRESSED_RG11_EAC: 37490,
        COMPRESSED_SIGNED_RG11_EAC: 37491,
        COMPRESSED_RGB8_ETC2: 37492,
        COMPRESSED_RGBA8_ETC2_EAC: 37493,
        COMPRESSED_SRGB8_ETC2: 37494,
        COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37495,
        COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37496,
        COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37497,
        COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
        COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
        COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
        COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
        COMPRESSED_RGB_ETC1_WEBGL: 36196,
        COMPRESSED_RGB_ATC_WEBGL: 35986,
        COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL: 35986,
        COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL: 34798,
        UNSIGNED_INT_24_8_WEBGL: 34042,
        HALF_FLOAT_OES: 36193,
        RGBA32F_EXT: 34836,
        RGB32F_EXT: 34837,
        FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 33297,
        UNSIGNED_NORMALIZED_EXT: 35863,
        MIN_EXT: 32775,
        MAX_EXT: 32776,
        SRGB_EXT: 35904,
        SRGB_ALPHA_EXT: 35906,
        SRGB8_ALPHA8_EXT: 35907,
        FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 33296,
        FRAGMENT_SHADER_DERIVATIVE_HINT_OES: 35723,
        COLOR_ATTACHMENT0_WEBGL: 36064,
        COLOR_ATTACHMENT1_WEBGL: 36065,
        COLOR_ATTACHMENT2_WEBGL: 36066,
        COLOR_ATTACHMENT3_WEBGL: 36067,
        COLOR_ATTACHMENT4_WEBGL: 36068,
        COLOR_ATTACHMENT5_WEBGL: 36069,
        COLOR_ATTACHMENT6_WEBGL: 36070,
        COLOR_ATTACHMENT7_WEBGL: 36071,
        COLOR_ATTACHMENT8_WEBGL: 36072,
        COLOR_ATTACHMENT9_WEBGL: 36073,
        COLOR_ATTACHMENT10_WEBGL: 36074,
        COLOR_ATTACHMENT11_WEBGL: 36075,
        COLOR_ATTACHMENT12_WEBGL: 36076,
        COLOR_ATTACHMENT13_WEBGL: 36077,
        COLOR_ATTACHMENT14_WEBGL: 36078,
        COLOR_ATTACHMENT15_WEBGL: 36079,
        DRAW_BUFFER0_WEBGL: 34853,
        DRAW_BUFFER1_WEBGL: 34854,
        DRAW_BUFFER2_WEBGL: 34855,
        DRAW_BUFFER3_WEBGL: 34856,
        DRAW_BUFFER4_WEBGL: 34857,
        DRAW_BUFFER5_WEBGL: 34858,
        DRAW_BUFFER6_WEBGL: 34859,
        DRAW_BUFFER7_WEBGL: 34860,
        DRAW_BUFFER8_WEBGL: 34861,
        DRAW_BUFFER9_WEBGL: 34862,
        DRAW_BUFFER10_WEBGL: 34863,
        DRAW_BUFFER11_WEBGL: 34864,
        DRAW_BUFFER12_WEBGL: 34865,
        DRAW_BUFFER13_WEBGL: 34866,
        DRAW_BUFFER14_WEBGL: 34867,
        DRAW_BUFFER15_WEBGL: 34868,
        MAX_COLOR_ATTACHMENTS_WEBGL: 36063,
        MAX_DRAW_BUFFERS_WEBGL: 34852,
        VERTEX_ARRAY_BINDING_OES: 34229,
        QUERY_COUNTER_BITS_EXT: 34916,
        CURRENT_QUERY_EXT: 34917,
        QUERY_RESULT_EXT: 34918,
        QUERY_RESULT_AVAILABLE_EXT: 34919,
        TIME_ELAPSED_EXT: 35007,
        TIMESTAMP_EXT: 36392,
        GPU_DISJOINT_EXT: 36795
      };
    }
  });

  // src/lib/parsers/constants.ts
  function getConstructorForDataFormat(dataType) {
    switch (dataType) {
      case DATA_TYPE.UInt8:
        return Uint8Array;
      case DATA_TYPE.UInt16:
        return Uint16Array;
      case DATA_TYPE.UInt32:
        return Uint32Array;
      case DATA_TYPE.Float32:
        return Float32Array;
      case DATA_TYPE.UInt64:
        return Float64Array;
      default:
        throw new Error(`parse i3s tile content: unknown type of data: ${dataType}`);
    }
  }
  function sizeOf(dataType) {
    switch (dataType) {
      case DATA_TYPE.UInt8:
        return 1;
      case DATA_TYPE.UInt16:
      case DATA_TYPE.Int16:
        return 2;
      case DATA_TYPE.UInt32:
      case DATA_TYPE.Int32:
      case DATA_TYPE.Float32:
        return 4;
      case DATA_TYPE.UInt64:
      case DATA_TYPE.Int64:
      case DATA_TYPE.Float64:
        return 8;
      default:
        throw new Error(`parse i3s tile content: unknown size of data: ${dataType}`);
    }
  }
  var GL_TYPE_MAP, STRING_ATTRIBUTE_TYPE, OBJECT_ID_ATTRIBUTE_TYPE, FLOAT_64_TYPE, INT_16_ATTRIBUTE_TYPE, COORDINATE_SYSTEM;
  var init_constants2 = __esm({
    "src/lib/parsers/constants.ts"() {
      init_esm3();
      init_types();
      GL_TYPE_MAP = {
        UInt8: esm_default.UNSIGNED_BYTE,
        UInt16: esm_default.UNSIGNED_SHORT,
        Float32: esm_default.FLOAT,
        UInt32: esm_default.UNSIGNED_INT,
        UInt64: esm_default.DOUBLE
      };
      STRING_ATTRIBUTE_TYPE = "String";
      OBJECT_ID_ATTRIBUTE_TYPE = "Oid32";
      FLOAT_64_TYPE = "Float64";
      INT_16_ATTRIBUTE_TYPE = "Int16";
      (function(COORDINATE_SYSTEM2) {
        COORDINATE_SYSTEM2[COORDINATE_SYSTEM2["DEFAULT"] = -1] = "DEFAULT";
        COORDINATE_SYSTEM2[COORDINATE_SYSTEM2["LNGLAT"] = 1] = "LNGLAT";
        COORDINATE_SYSTEM2[COORDINATE_SYSTEM2["METER_OFFSETS"] = 2] = "METER_OFFSETS";
        COORDINATE_SYSTEM2[COORDINATE_SYSTEM2["LNGLAT_OFFSETS"] = 3] = "LNGLAT_OFFSETS";
        COORDINATE_SYSTEM2[COORDINATE_SYSTEM2["CARTESIAN"] = 0] = "CARTESIAN";
      })(COORDINATE_SYSTEM || (COORDINATE_SYSTEM = {}));
    }
  });

  // src/lib/parsers/parse-i3s-attribute.ts
  async function parseI3STileAttribute(arrayBuffer, options) {
    const { attributeName, attributeType } = options;
    if (!attributeName) {
      return {};
    }
    return {
      [attributeName]: attributeType ? parseAttribute(attributeType, arrayBuffer) : null
    };
  }
  function parseAttribute(attributeType, arrayBuffer) {
    switch (attributeType) {
      case STRING_ATTRIBUTE_TYPE:
        return parseStringsAttribute(arrayBuffer);
      case OBJECT_ID_ATTRIBUTE_TYPE:
        return parseShortNumberAttribute(arrayBuffer);
      case FLOAT_64_TYPE:
        return parseFloatAttribute(arrayBuffer);
      case INT_16_ATTRIBUTE_TYPE:
        return parseInt16ShortNumberAttribute(arrayBuffer);
      default:
        return parseShortNumberAttribute(arrayBuffer);
    }
  }
  function parseShortNumberAttribute(arrayBuffer) {
    const countOffset = 4;
    return new Uint32Array(arrayBuffer, countOffset);
  }
  function parseInt16ShortNumberAttribute(arrayBuffer) {
    const countOffset = 4;
    return new Int16Array(arrayBuffer, countOffset);
  }
  function parseFloatAttribute(arrayBuffer) {
    const countOffset = 8;
    return new Float64Array(arrayBuffer, countOffset);
  }
  function parseStringsAttribute(arrayBuffer) {
    const stringsCountOffset = 0;
    const dataOffset = 8;
    const bytesPerStringSize = 4;
    const stringsArray = [];
    try {
      const stringsCount = new DataView(arrayBuffer, stringsCountOffset, bytesPerStringSize).getUint32(stringsCountOffset, true);
      const stringSizes = new Uint32Array(arrayBuffer, dataOffset, stringsCount);
      let stringOffset = dataOffset + stringsCount * bytesPerStringSize;
      for (const stringByteSize of stringSizes) {
        const textDecoder = new TextDecoder("utf-8");
        const stringAttribute = new Uint8Array(arrayBuffer, stringOffset, stringByteSize);
        stringsArray.push(textDecoder.decode(stringAttribute));
        stringOffset += stringByteSize;
      }
    } catch (error) {
      console.error("Parse string attribute error: ", error.message);
    }
    return stringsArray;
  }
  var init_parse_i3s_attribute = __esm({
    "src/lib/parsers/parse-i3s-attribute.ts"() {
      init_constants2();
    }
  });

  // src/i3s-attribute-loader.ts
  async function parse3(data, options) {
    data = parseI3STileAttribute(data, options);
    return data;
  }
  async function loadFeatureAttributes(tile, featureId, options = {}) {
    const { attributeStorageInfo, attributeUrls, tilesetFields } = getAttributesData(tile);
    if (!attributeStorageInfo || !attributeUrls || featureId < 0) {
      return null;
    }
    let attributes = [];
    const attributeLoadPromises = [];
    for (let index = 0; index < attributeStorageInfo.length; index++) {
      const url = getUrlWithToken(attributeUrls[index], options.i3s?.token);
      const attributeName = attributeStorageInfo[index].name;
      const attributeType = getAttributeValueType(attributeStorageInfo[index]);
      const loadOptions = { ...options, attributeName, attributeType };
      const promise = load(url, I3SAttributeLoader, loadOptions);
      attributeLoadPromises.push(promise);
    }
    try {
      attributes = await Promise.allSettled(attributeLoadPromises);
    } catch (error) {
    }
    if (!attributes.length) {
      return null;
    }
    return generateAttributesByFeatureId(attributes, attributeStorageInfo, featureId, tilesetFields);
  }
  function getAttributesData(tile) {
    const attributeStorageInfo = tile.tileset?.tileset?.attributeStorageInfo;
    const attributeUrls = tile.header?.attributeUrls;
    const tilesetFields = tile.tileset?.tileset?.fields || [];
    return { attributeStorageInfo, attributeUrls, tilesetFields };
  }
  function getAttributeValueType(attribute) {
    if (attribute.hasOwnProperty("objectIds")) {
      return "Oid32";
    } else if (attribute.hasOwnProperty("attributeValues")) {
      return attribute.attributeValues.valueType;
    }
    return "";
  }
  function getFeatureIdsAttributeName(attributeStorageInfo) {
    const objectIdsAttribute = attributeStorageInfo.find((attribute) => attribute.name.includes("OBJECTID"));
    return objectIdsAttribute?.name;
  }
  function generateAttributesByFeatureId(attributes, attributeStorageInfo, featureId, tilesetFields) {
    const objectIdsAttributeName = getFeatureIdsAttributeName(attributeStorageInfo);
    const objectIds = attributes.find((attribute) => attribute.value[objectIdsAttributeName]);
    if (!objectIds) {
      return null;
    }
    const attributeIndex = objectIds.value[objectIdsAttributeName].indexOf(featureId);
    if (attributeIndex < 0) {
      return null;
    }
    return getFeatureAttributesByIndex(attributes, attributeIndex, attributeStorageInfo, tilesetFields);
  }
  function getFeatureAttributesByIndex(attributes, featureIdIndex, attributeStorageInfo, tilesetFields) {
    const attributesObject = {};
    for (let index = 0; index < attributeStorageInfo.length; index++) {
      const attributeName = attributeStorageInfo[index].name;
      const codedValues = getAttributeCodedValues(attributeName, tilesetFields);
      const attribute = getAttributeByIndexAndAttributeName(attributes, index, attributeName);
      attributesObject[attributeName] = formatAttributeValue(attribute, featureIdIndex, codedValues);
    }
    return attributesObject;
  }
  function getAttributeCodedValues(attributeName, tilesetFields) {
    const attributeField = tilesetFields.find((field) => field.name === attributeName || field.alias === attributeName);
    return attributeField?.domain?.codedValues || [];
  }
  function getAttributeByIndexAndAttributeName(attributes, index, attributesName) {
    const attributeObject = attributes[index];
    if (attributeObject.status === REJECTED_STATUS) {
      return null;
    }
    return attributeObject.value[attributesName];
  }
  function formatAttributeValue(attribute, featureIdIndex, codedValues) {
    let value = EMPTY_VALUE;
    if (attribute && featureIdIndex in attribute) {
      value = String(attribute[featureIdIndex]).replace(/\u0000|NaN/g, "").trim();
    }
    if (codedValues.length) {
      const codeValue = codedValues.find((codedValue) => codedValue.code === Number(value));
      value = codeValue?.name || EMPTY_VALUE;
    }
    return value;
  }
  var VERSION10, EMPTY_VALUE, REJECTED_STATUS, I3SAttributeLoader;
  var init_i3s_attribute_loader = __esm({
    "src/i3s-attribute-loader.ts"() {
      init_src3();
      init_parse_i3s_attribute();
      init_url_utils2();
      VERSION10 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      EMPTY_VALUE = "";
      REJECTED_STATUS = "rejected";
      I3SAttributeLoader = {
        name: "I3S Attribute",
        id: "i3s-attribute",
        module: "i3s",
        version: VERSION10,
        mimeTypes: ["application/binary"],
        parse: parse3,
        extensions: ["bin"],
        options: {},
        binary: true
      };
    }
  });

  // src/lib/utils/customizeColors.ts
  async function customizeColors(colors, featureIds, tileOptions, tilesetOptions, options) {
    if (!options?.i3s?.colorsByAttribute) {
      return colors;
    }
    const colorizeAttributeField = tilesetOptions.fields.find(({ name }) => name === options?.i3s?.colorsByAttribute?.attributeName);
    if (!colorizeAttributeField || !["esriFieldTypeDouble", "esriFieldTypeInteger", "esriFieldTypeSmallInteger"].includes(colorizeAttributeField.type)) {
      return colors;
    }
    const colorizeAttributeData = await loadFeatureAttributeData(colorizeAttributeField.name, tileOptions, tilesetOptions, options);
    if (!colorizeAttributeData) {
      return colors;
    }
    const objectIdField = tilesetOptions.fields.find(({ type }) => type === "esriFieldTypeOID");
    if (!objectIdField) {
      return colors;
    }
    const objectIdAttributeData = await loadFeatureAttributeData(objectIdField.name, tileOptions, tilesetOptions, options);
    if (!objectIdAttributeData) {
      return colors;
    }
    const attributeValuesMap = {};
    for (let i2 = 0; i2 < objectIdAttributeData[objectIdField.name].length; i2++) {
      attributeValuesMap[objectIdAttributeData[objectIdField.name][i2]] = calculateColorForAttribute(colorizeAttributeData[colorizeAttributeField.name][i2], options);
    }
    for (let i2 = 0; i2 < featureIds.value.length; i2++) {
      const color = attributeValuesMap[featureIds.value[i2]];
      if (!color) {
        continue;
      }
      colors.value.set(color, i2 * 4);
    }
    return colors;
  }
  function calculateColorForAttribute(attributeValue, options) {
    if (!options?.i3s?.colorsByAttribute) {
      return [255, 255, 255, 255];
    }
    const { minValue, maxValue, minColor, maxColor } = options.i3s.colorsByAttribute;
    const rate = (attributeValue - minValue) / (maxValue - minValue);
    const color = [255, 255, 255, 255];
    for (let i2 = 0; i2 < minColor.length; i2++) {
      color[i2] = Math.round((maxColor[i2] - minColor[i2]) * rate + minColor[i2]);
    }
    return color;
  }
  async function loadFeatureAttributeData(attributeName, { attributeUrls }, { attributeStorageInfo }, options) {
    const attributeIndex = attributeStorageInfo.findIndex(({ name }) => attributeName === name);
    if (attributeIndex === -1) {
      return null;
    }
    const objectIdAttributeUrl = getUrlWithToken(attributeUrls[attributeIndex], options?.i3s?.token);
    const attributeType = getAttributeValueType(attributeStorageInfo[attributeIndex]);
    const objectIdAttributeData = await load(objectIdAttributeUrl, I3SAttributeLoader, {
      attributeName,
      attributeType
    });
    return objectIdAttributeData;
  }
  var init_customizeColors = __esm({
    "src/lib/utils/customizeColors.ts"() {
      init_src3();
      init_i3s_attribute_loader();
      init_url_utils2();
    }
  });

  // src/lib/parsers/parse-i3s-tile-content.ts
  function getLoaderForTextureFormat(textureFormat) {
    switch (textureFormat) {
      case "ktx-etc2":
      case "dds":
        return CompressedTextureLoader;
      case "ktx2":
        return BasisLoader;
      case "jpg":
      case "png":
      default:
        return ImageLoader;
    }
  }
  async function parseI3STileContent(arrayBuffer, tileOptions, tilesetOptions, options, context) {
    const content = {
      attributes: {},
      indices: null,
      featureIds: [],
      vertexCount: 0,
      modelMatrix: new Matrix4(),
      coordinateSystem: 0,
      byteLength: 0,
      texture: null
    };
    if (tileOptions.textureUrl) {
      const url = getUrlWithToken(tileOptions.textureUrl, options?.i3s?.token);
      const loader = getLoaderForTextureFormat(tileOptions.textureFormat);
      const response = await fetch(url, options?.fetch);
      const arrayBuffer2 = await response.arrayBuffer();
      if (options?.i3s.decodeTextures) {
        if (loader === ImageLoader) {
          const options2 = { ...tileOptions.textureLoaderOptions, image: { type: "data" } };
          try {
            content.texture = await context.parse(arrayBuffer2, options2);
          } catch (e2) {
            content.texture = await parse(arrayBuffer2, loader, options2);
          }
        } else if (loader === CompressedTextureLoader || loader === BasisLoader) {
          let texture = await load(arrayBuffer2, loader, tileOptions.textureLoaderOptions);
          if (loader === BasisLoader) {
            texture = texture[0];
          }
          content.texture = {
            compressed: true,
            mipmaps: false,
            width: texture[0].width,
            height: texture[0].height,
            data: texture
          };
        }
      } else {
        content.texture = arrayBuffer2;
      }
    }
    content.material = makePbrMaterial(tileOptions.materialDefinition, content.texture);
    if (content.material) {
      content.texture = null;
    }
    return await parseI3SNodeGeometry(arrayBuffer, content, tileOptions, tilesetOptions, options);
  }
  async function parseI3SNodeGeometry(arrayBuffer, content, tileOptions, tilesetOptions, options) {
    const contentByteLength = arrayBuffer.byteLength;
    let attributes;
    let vertexCount;
    let byteOffset = 0;
    let featureCount = 0;
    let indices;
    if (tileOptions.isDracoGeometry) {
      const decompressedGeometry = await parse(arrayBuffer, DracoLoader2, {
        draco: {
          attributeNameEntry: I3S_ATTRIBUTE_TYPE
        }
      });
      vertexCount = decompressedGeometry.header.vertexCount;
      indices = decompressedGeometry.indices?.value;
      const {
        POSITION,
        NORMAL,
        COLOR_0,
        TEXCOORD_0,
        ["feature-index"]: featureIndex,
        ["uv-region"]: uvRegion
      } = decompressedGeometry.attributes;
      attributes = {
        position: POSITION,
        normal: NORMAL,
        color: COLOR_0,
        uv0: TEXCOORD_0,
        uvRegion,
        id: featureIndex
      };
      updateAttributesMetadata(attributes, decompressedGeometry);
      const featureIds = getFeatureIdsFromFeatureIndexMetadata(featureIndex);
      if (featureIds) {
        flattenFeatureIdsByFeatureIndices(attributes, featureIds);
      }
    } else {
      const {
        vertexAttributes,
        ordering: attributesOrder,
        featureAttributes,
        featureAttributeOrder
      } = tilesetOptions.store.defaultGeometrySchema;
      const headers = parseHeaders(arrayBuffer, tilesetOptions);
      byteOffset = headers.byteOffset;
      vertexCount = headers.vertexCount;
      featureCount = headers.featureCount;
      const { attributes: normalizedVertexAttributes, byteOffset: offset } = normalizeAttributes(arrayBuffer, byteOffset, vertexAttributes, vertexCount, attributesOrder);
      const { attributes: normalizedFeatureAttributes } = normalizeAttributes(arrayBuffer, offset, featureAttributes, featureCount, featureAttributeOrder);
      flattenFeatureIdsByFaceRanges(normalizedFeatureAttributes);
      attributes = concatAttributes(normalizedVertexAttributes, normalizedFeatureAttributes);
    }
    if (!options?.i3s?.coordinateSystem || options.i3s.coordinateSystem === COORDINATE_SYSTEM.METER_OFFSETS) {
      const enuMatrix = parsePositions(attributes.position, tileOptions);
      content.modelMatrix = enuMatrix.invert();
      content.coordinateSystem = COORDINATE_SYSTEM.METER_OFFSETS;
    } else {
      content.modelMatrix = getModelMatrix(attributes.position);
      content.coordinateSystem = COORDINATE_SYSTEM.LNGLAT_OFFSETS;
    }
    attributes.color = await customizeColors(attributes.color, attributes.id, tileOptions, tilesetOptions, options);
    content.attributes = {
      positions: attributes.position,
      normals: attributes.normal,
      colors: normalizeAttribute(attributes.color),
      texCoords: attributes.uv0,
      uvRegions: normalizeAttribute(attributes.uvRegion || attributes.region)
    };
    content.indices = indices || null;
    if (attributes.id && attributes.id.value) {
      content.featureIds = attributes.id.value;
    }
    for (const attributeIndex in content.attributes) {
      if (!content.attributes[attributeIndex]) {
        delete content.attributes[attributeIndex];
      }
    }
    content.vertexCount = vertexCount;
    content.byteLength = contentByteLength;
    return content;
  }
  function updateAttributesMetadata(attributes, decompressedGeometry) {
    for (const key in decompressedGeometry.loaderData.attributes) {
      const dracoAttribute = decompressedGeometry.loaderData.attributes[key];
      switch (dracoAttribute.name) {
        case "POSITION":
          attributes.position.metadata = dracoAttribute.metadata;
          break;
        case "feature-index":
          attributes.id.metadata = dracoAttribute.metadata;
          break;
        default:
          break;
      }
    }
  }
  function concatAttributes(normalizedVertexAttributes, normalizedFeatureAttributes) {
    return { ...normalizedVertexAttributes, ...normalizedFeatureAttributes };
  }
  function normalizeAttribute(attribute) {
    if (!attribute) {
      return attribute;
    }
    attribute.normalized = true;
    return attribute;
  }
  function parseHeaders(arrayBuffer, options) {
    let byteOffset = 0;
    let vertexCount = 0;
    let featureCount = 0;
    for (const { property, type } of options.store.defaultGeometrySchema.header) {
      const TypedArrayTypeHeader = getConstructorForDataFormat(type);
      switch (property) {
        case HeaderAttributeProperty.vertexCount:
          vertexCount = new TypedArrayTypeHeader(arrayBuffer, 0, 4)[0];
          byteOffset += sizeOf(type);
          break;
        case HeaderAttributeProperty.featureCount:
          featureCount = new TypedArrayTypeHeader(arrayBuffer, 4, 4)[0];
          byteOffset += sizeOf(type);
          break;
        default:
          break;
      }
    }
    return {
      vertexCount,
      featureCount,
      byteOffset
    };
  }
  function normalizeAttributes(arrayBuffer, byteOffset, vertexAttributes, attributeCount, attributesOrder) {
    const attributes = {};
    for (const attribute of attributesOrder) {
      if (vertexAttributes[attribute]) {
        const { valueType, valuesPerElement } = vertexAttributes[attribute];
        if (byteOffset + attributeCount * valuesPerElement * sizeOf(valueType) <= arrayBuffer.byteLength) {
          const buffer = arrayBuffer.slice(byteOffset);
          let value;
          if (valueType === "UInt64") {
            value = parseUint64Values(buffer, attributeCount * valuesPerElement, sizeOf(valueType));
          } else {
            const TypedArrayType = getConstructorForDataFormat(valueType);
            value = new TypedArrayType(buffer, 0, attributeCount * valuesPerElement);
          }
          attributes[attribute] = {
            value,
            type: GL_TYPE_MAP[valueType],
            size: valuesPerElement
          };
          switch (attribute) {
            case "color":
              attributes.color.normalized = true;
              break;
            case "position":
            case "region":
            case "normal":
            default:
          }
          byteOffset = byteOffset + attributeCount * valuesPerElement * sizeOf(valueType);
        } else if (attribute !== "uv0") {
          break;
        }
      }
    }
    return { attributes, byteOffset };
  }
  function parseUint64Values(buffer, elementsCount, attributeSize) {
    const values = [];
    const dataView = new DataView(buffer);
    let offset = 0;
    for (let index = 0; index < elementsCount; index++) {
      const left = dataView.getUint32(offset, true);
      const right = dataView.getUint32(offset + 4, true);
      const value = left + 2 ** 32 * right;
      values.push(value);
      offset += attributeSize;
    }
    return new Uint32Array(values);
  }
  function parsePositions(attribute, options) {
    const mbs = options.mbs;
    const value = attribute.value;
    const metadata = attribute.metadata;
    const enuMatrix = new Matrix4();
    const cartographicOrigin = new Vector3(mbs[0], mbs[1], mbs[2]);
    const cartesianOrigin = new Vector3();
    Ellipsoid.WGS84.cartographicToCartesian(cartographicOrigin, cartesianOrigin);
    Ellipsoid.WGS84.eastNorthUpToFixedFrame(cartesianOrigin, enuMatrix);
    attribute.value = offsetsToCartesians(value, metadata, cartographicOrigin);
    return enuMatrix;
  }
  function offsetsToCartesians(vertices, metadata = {}, cartographicOrigin) {
    const positions = new Float64Array(vertices.length);
    const scaleX = metadata["i3s-scale_x"] && metadata["i3s-scale_x"].double || 1;
    const scaleY = metadata["i3s-scale_y"] && metadata["i3s-scale_y"].double || 1;
    for (let i2 = 0; i2 < positions.length; i2 += 3) {
      positions[i2] = vertices[i2] * scaleX + cartographicOrigin.x;
      positions[i2 + 1] = vertices[i2 + 1] * scaleY + cartographicOrigin.y;
      positions[i2 + 2] = vertices[i2 + 2] + cartographicOrigin.z;
    }
    for (let i2 = 0; i2 < positions.length; i2 += 3) {
      Ellipsoid.WGS84.cartographicToCartesian(positions.subarray(i2, i2 + 3), scratchVector5);
      positions[i2] = scratchVector5.x;
      positions[i2 + 1] = scratchVector5.y;
      positions[i2 + 2] = scratchVector5.z;
    }
    return positions;
  }
  function getModelMatrix(positions) {
    const metadata = positions.metadata;
    const scaleX = metadata?.["i3s-scale_x"]?.double || 1;
    const scaleY = metadata?.["i3s-scale_y"]?.double || 1;
    const modelMatrix = new Matrix4();
    modelMatrix[0] = scaleX;
    modelMatrix[5] = scaleY;
    return modelMatrix;
  }
  function makePbrMaterial(materialDefinition, texture) {
    let pbrMaterial;
    if (materialDefinition) {
      pbrMaterial = {
        ...materialDefinition,
        pbrMetallicRoughness: materialDefinition.pbrMetallicRoughness ? { ...materialDefinition.pbrMetallicRoughness } : { baseColorFactor: [255, 255, 255, 255] }
      };
    } else {
      pbrMaterial = {
        pbrMetallicRoughness: {}
      };
      if (texture) {
        pbrMaterial.pbrMetallicRoughness.baseColorTexture = { texCoord: 0 };
      } else {
        pbrMaterial.pbrMetallicRoughness.baseColorFactor = [255, 255, 255, 255];
      }
    }
    pbrMaterial.alphaCutoff = pbrMaterial.alphaCutoff || 0.25;
    if (pbrMaterial.alphaMode) {
      pbrMaterial.alphaMode = pbrMaterial.alphaMode.toUpperCase();
    }
    if (pbrMaterial.emissiveFactor) {
      pbrMaterial.emissiveFactor = convertColorFormat(pbrMaterial.emissiveFactor);
    }
    if (pbrMaterial.pbrMetallicRoughness && pbrMaterial.pbrMetallicRoughness.baseColorFactor) {
      pbrMaterial.pbrMetallicRoughness.baseColorFactor = convertColorFormat(pbrMaterial.pbrMetallicRoughness.baseColorFactor);
    }
    if (texture) {
      setMaterialTexture(pbrMaterial, texture);
    }
    return pbrMaterial;
  }
  function convertColorFormat(colorFactor) {
    const normalizedColor = [...colorFactor];
    for (let index = 0; index < colorFactor.length; index++) {
      normalizedColor[index] = colorFactor[index] / 255;
    }
    return normalizedColor;
  }
  function setMaterialTexture(material, image) {
    const texture = { source: { image } };
    if (material.pbrMetallicRoughness && material.pbrMetallicRoughness.baseColorTexture) {
      material.pbrMetallicRoughness.baseColorTexture = {
        ...material.pbrMetallicRoughness.baseColorTexture,
        texture
      };
    } else if (material.emissiveTexture) {
      material.emissiveTexture = { ...material.emissiveTexture, texture };
    } else if (material.pbrMetallicRoughness && material.pbrMetallicRoughness.metallicRoughnessTexture) {
      material.pbrMetallicRoughness.metallicRoughnessTexture = {
        ...material.pbrMetallicRoughness.metallicRoughnessTexture,
        texture
      };
    } else if (material.normalTexture) {
      material.normalTexture = { ...material.normalTexture, texture };
    } else if (material.occlusionTexture) {
      material.occlusionTexture = { ...material.occlusionTexture, texture };
    }
  }
  function flattenFeatureIdsByFaceRanges(normalizedFeatureAttributes) {
    const { id, faceRange } = normalizedFeatureAttributes;
    if (!id || !faceRange) {
      return;
    }
    const featureIds = id.value;
    const range = faceRange.value;
    const featureIdsLength = range[range.length - 1] + 1;
    const orderedFeatureIndices = new Uint32Array(featureIdsLength * 3);
    let featureIndex = 0;
    let startIndex = 0;
    for (let index = 1; index < range.length; index += 2) {
      const fillId = Number(featureIds[featureIndex]);
      const endValue = range[index];
      const prevValue = range[index - 1];
      const trianglesCount = endValue - prevValue + 1;
      const endIndex = startIndex + trianglesCount * 3;
      orderedFeatureIndices.fill(fillId, startIndex, endIndex);
      featureIndex++;
      startIndex = endIndex;
    }
    normalizedFeatureAttributes.id.value = orderedFeatureIndices;
  }
  function flattenFeatureIdsByFeatureIndices(attributes, featureIds) {
    const featureIndices = attributes.id.value;
    const result = new Float32Array(featureIndices.length);
    for (let index = 0; index < featureIndices.length; index++) {
      result[index] = featureIds[featureIndices[index]];
    }
    attributes.id.value = result;
  }
  function getFeatureIdsFromFeatureIndexMetadata(featureIndex) {
    return featureIndex?.metadata?.["i3s-feature-ids"]?.intArray;
  }
  var scratchVector5, I3S_ATTRIBUTE_TYPE;
  var init_parse_i3s_tile_content = __esm({
    "src/lib/parsers/parse-i3s-tile-content.ts"() {
      init_src3();
      init_esm();
      init_esm2();
      init_src4();
      init_src6();
      init_src7();
      init_types();
      init_url_utils2();
      init_constants2();
      init_customizeColors();
      scratchVector5 = new Vector3([0, 0, 0]);
      I3S_ATTRIBUTE_TYPE = "i3s-attribute-type";
    }
  });

  // src/i3s-content-loader.ts
  async function parse4(data, options, context) {
    const { tile, _tileOptions, tileset, _tilesetOptions } = options?.i3s || {};
    const tileOptions = _tileOptions || tile;
    const tilesetOptions = _tilesetOptions || tileset;
    if (!tileOptions || !tilesetOptions) {
      return null;
    }
    return await parseI3STileContent(data, tileOptions, tilesetOptions, options, context);
  }
  var VERSION11, I3SContentLoader;
  var init_i3s_content_loader = __esm({
    "src/i3s-content-loader.ts"() {
      init_src();
      init_parse_i3s_tile_content();
      VERSION11 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      I3SContentLoader = {
        name: "I3S Content (Indexed Scene Layers)",
        id: isBrowser2 ? "i3s-content" : "i3s-content-nodejs",
        module: "i3s",
        worker: true,
        version: VERSION11,
        mimeTypes: ["application/octet-stream"],
        parse: parse4,
        extensions: ["bin"],
        options: {
          "i3s-content": {}
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/constants.js
  var INTERSECTION;
  var init_constants3 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/constants.js"() {
      INTERSECTION = {
        OUTSIDE: -1,
        INTERSECTING: 0,
        INSIDE: 1
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js
  var scratchVector6, scratchNormal2;
  var init_axis_aligned_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_constants3();
      scratchVector6 = new Vector3();
      scratchNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js
  var scratchVector7, scratchVector23, BoundingSphere;
  var init_bounding_sphere = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js"() {
      init_defineProperty();
      init_esm();
      init_mat4();
      init_constants3();
      scratchVector7 = new Vector3();
      scratchVector23 = new Vector3();
      BoundingSphere = class {
        constructor(center = [0, 0, 0], radius = 0) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "radius", void 0);
          this.radius = -0;
          this.center = new Vector3();
          this.fromCenterRadius(center, radius);
        }
        fromCenterRadius(center, radius) {
          this.center.from(center);
          this.radius = radius;
          return this;
        }
        fromCornerPoints(corner, oppositeCorner) {
          oppositeCorner = scratchVector7.from(oppositeCorner);
          this.center = new Vector3().from(corner).add(oppositeCorner).scale(0.5);
          this.radius = this.center.distance(oppositeCorner);
          return this;
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.radius === right.radius;
        }
        clone() {
          return new BoundingSphere(this.center, this.radius);
        }
        union(boundingSphere) {
          const leftCenter = this.center;
          const leftRadius = this.radius;
          const rightCenter = boundingSphere.center;
          const rightRadius = boundingSphere.radius;
          const toRightCenter = scratchVector7.copy(rightCenter).subtract(leftCenter);
          const centerSeparation = toRightCenter.magnitude();
          if (leftRadius >= centerSeparation + rightRadius) {
            return this.clone();
          }
          if (rightRadius >= centerSeparation + leftRadius) {
            return boundingSphere.clone();
          }
          const halfDistanceBetweenTangentPoints = (leftRadius + centerSeparation + rightRadius) * 0.5;
          scratchVector23.copy(toRightCenter).scale((-leftRadius + halfDistanceBetweenTangentPoints) / centerSeparation).add(leftCenter);
          this.center.copy(scratchVector23);
          this.radius = halfDistanceBetweenTangentPoints;
          return this;
        }
        expand(point) {
          const scratchPoint = scratchVector7.from(point);
          const radius = scratchPoint.subtract(this.center).magnitude();
          if (radius > this.radius) {
            this.radius = radius;
          }
          return this;
        }
        transform(transform) {
          this.center.transform(transform);
          const scale5 = getScaling(scratchVector7, transform);
          this.radius = Math.max(scale5[0], Math.max(scale5[1], scale5[2])) * this.radius;
          return this;
        }
        distanceSquaredTo(point) {
          const d = this.distanceTo(point);
          return d * d;
        }
        distanceTo(point) {
          const scratchPoint = scratchVector7.from(point);
          const delta = scratchPoint.subtract(this.center);
          return Math.max(0, delta.len() - this.radius);
        }
        intersectPlane(plane) {
          const center = this.center;
          const radius = this.radius;
          const normal = plane.normal;
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane < -radius) {
            return INTERSECTION.OUTSIDE;
          }
          if (distanceToPlane < radius) {
            return INTERSECTION.INTERSECTING;
          }
          return INTERSECTION.INSIDE;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js
  var scratchVector32, scratchOffset, scratchVectorU, scratchVectorV, scratchVectorW, scratchCorner, scratchToCenter, MATRIX3, OrientedBoundingBox;
  var init_oriented_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_bounding_sphere();
      init_constants3();
      scratchVector32 = new Vector3();
      scratchOffset = new Vector3();
      scratchVectorU = new Vector3();
      scratchVectorV = new Vector3();
      scratchVectorW = new Vector3();
      scratchCorner = new Vector3();
      scratchToCenter = new Vector3();
      MATRIX3 = {
        COLUMN0ROW0: 0,
        COLUMN0ROW1: 1,
        COLUMN0ROW2: 2,
        COLUMN1ROW0: 3,
        COLUMN1ROW1: 4,
        COLUMN1ROW2: 5,
        COLUMN2ROW0: 6,
        COLUMN2ROW1: 7,
        COLUMN2ROW2: 8
      };
      OrientedBoundingBox = class {
        constructor(center = [0, 0, 0], halfAxes = [0, 0, 0, 0, 0, 0, 0, 0, 0]) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "halfAxes", void 0);
          this.center = new Vector3().from(center);
          this.halfAxes = new Matrix3(halfAxes);
        }
        get halfSize() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          return [new Vector3(xAxis).len(), new Vector3(yAxis).len(), new Vector3(zAxis).len()];
        }
        get quaternion() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          const normXAxis = new Vector3(xAxis).normalize();
          const normYAxis = new Vector3(yAxis).normalize();
          const normZAxis = new Vector3(zAxis).normalize();
          return new Quaternion().fromMatrix3(new Matrix3([...normXAxis, ...normYAxis, ...normZAxis]));
        }
        fromCenterHalfSizeQuaternion(center, halfSize, quaternion) {
          const quaternionObject = new Quaternion(quaternion);
          const directionsMatrix = new Matrix3().fromQuaternion(quaternionObject);
          directionsMatrix[0] = directionsMatrix[0] * halfSize[0];
          directionsMatrix[1] = directionsMatrix[1] * halfSize[0];
          directionsMatrix[2] = directionsMatrix[2] * halfSize[0];
          directionsMatrix[3] = directionsMatrix[3] * halfSize[1];
          directionsMatrix[4] = directionsMatrix[4] * halfSize[1];
          directionsMatrix[5] = directionsMatrix[5] * halfSize[1];
          directionsMatrix[6] = directionsMatrix[6] * halfSize[2];
          directionsMatrix[7] = directionsMatrix[7] * halfSize[2];
          directionsMatrix[8] = directionsMatrix[8] * halfSize[2];
          this.center = new Vector3().from(center);
          this.halfAxes = directionsMatrix;
          return this;
        }
        clone() {
          return new OrientedBoundingBox(this.center, this.halfAxes);
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.halfAxes.equals(right.halfAxes);
        }
        getBoundingSphere(result = new BoundingSphere()) {
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const cornerVector = scratchVector32.copy(u).add(v).add(w);
          result.center.copy(this.center);
          result.radius = cornerVector.magnitude();
          return result;
        }
        intersectPlane(plane) {
          const center = this.center;
          const normal = plane.normal;
          const halfAxes = this.halfAxes;
          const normalX = normal.x;
          const normalY = normal.y;
          const normalZ = normal.z;
          const radEffective = Math.abs(normalX * halfAxes[MATRIX3.COLUMN0ROW0] + normalY * halfAxes[MATRIX3.COLUMN0ROW1] + normalZ * halfAxes[MATRIX3.COLUMN0ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN1ROW0] + normalY * halfAxes[MATRIX3.COLUMN1ROW1] + normalZ * halfAxes[MATRIX3.COLUMN1ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN2ROW0] + normalY * halfAxes[MATRIX3.COLUMN2ROW1] + normalZ * halfAxes[MATRIX3.COLUMN2ROW2]);
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane <= -radEffective) {
            return INTERSECTION.OUTSIDE;
          } else if (distanceToPlane >= radEffective) {
            return INTERSECTION.INSIDE;
          }
          return INTERSECTION.INTERSECTING;
        }
        distanceTo(point) {
          return Math.sqrt(this.distanceSquaredTo(point));
        }
        distanceSquaredTo(point) {
          const offset = scratchOffset.from(point).subtract(this.center);
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const uHalf = u.magnitude();
          const vHalf = v.magnitude();
          const wHalf = w.magnitude();
          u.normalize();
          v.normalize();
          w.normalize();
          let distanceSquared = 0;
          let d;
          d = Math.abs(offset.dot(u)) - uHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(v)) - vHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(w)) - wHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          return distanceSquared;
        }
        computePlaneDistances(position, direction, result = [-0, -0]) {
          let minDist = Number.POSITIVE_INFINITY;
          let maxDist = Number.NEGATIVE_INFINITY;
          const center = this.center;
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const corner = scratchCorner.copy(u).add(v).add(w).add(center);
          const toCenter = scratchToCenter.copy(corner).subtract(position);
          let mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          result[0] = minDist;
          result[1] = maxDist;
          return result;
        }
        transform(transformation) {
          this.center.transformAsPoint(transformation);
          const xAxis = this.halfAxes.getColumn(0, scratchVectorU);
          xAxis.transformAsPoint(transformation);
          const yAxis = this.halfAxes.getColumn(1, scratchVectorV);
          yAxis.transformAsPoint(transformation);
          const zAxis = this.halfAxes.getColumn(2, scratchVectorW);
          zAxis.transformAsPoint(transformation);
          this.halfAxes = new Matrix3([...xAxis, ...yAxis, ...zAxis]);
          return this;
        }
        getTransform() {
          throw new Error("not implemented");
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/plane.js
  var scratchPosition2, scratchNormal3, Plane;
  var init_plane = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/plane.js"() {
      init_defineProperty();
      init_esm();
      scratchPosition2 = new Vector3();
      scratchNormal3 = new Vector3();
      Plane = class {
        constructor(normal = [0, 0, 1], distance = 0) {
          _defineProperty(this, "normal", void 0);
          _defineProperty(this, "distance", void 0);
          this.normal = new Vector3();
          this.distance = -0;
          this.fromNormalDistance(normal, distance);
        }
        fromNormalDistance(normal, distance) {
          assert4(Number.isFinite(distance));
          this.normal.from(normal).normalize();
          this.distance = distance;
          return this;
        }
        fromPointNormal(point, normal) {
          point = scratchPosition2.from(point);
          this.normal.from(normal).normalize();
          const distance = -this.normal.dot(point);
          this.distance = distance;
          return this;
        }
        fromCoefficients(a2, b, c2, d) {
          this.normal.set(a2, b, c2);
          assert4(equals(this.normal.len(), 1));
          this.distance = d;
          return this;
        }
        clone() {
          return new Plane(this.normal, this.distance);
        }
        equals(right) {
          return equals(this.distance, right.distance) && equals(this.normal, right.normal);
        }
        getPointDistance(point) {
          return this.normal.dot(point) + this.distance;
        }
        transform(matrix4) {
          const normal = scratchNormal3.copy(this.normal).transformAsVector(matrix4).normalize();
          const point = this.normal.scale(-this.distance).transform(matrix4);
          return this.fromPointNormal(point, normal);
        }
        projectPointOntoPlane(point, result = [0, 0, 0]) {
          point = scratchPosition2.from(point);
          const pointDistance = this.getPointDistance(point);
          const scaledNormal = scratchNormal3.copy(this.normal).scale(pointDistance);
          return point.subtract(scaledNormal).to(result);
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js
  var faces, scratchPlaneCenter, scratchPlaneNormal, scratchPlane, CullingVolume;
  var init_culling_volume = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js"() {
      init_defineProperty();
      init_esm();
      init_constants3();
      init_plane();
      faces = [new Vector3([1, 0, 0]), new Vector3([0, 1, 0]), new Vector3([0, 0, 1])];
      scratchPlaneCenter = new Vector3();
      scratchPlaneNormal = new Vector3();
      scratchPlane = new Plane(new Vector3(1, 0, 0), 0);
      CullingVolume = class {
        constructor(planes = []) {
          _defineProperty(this, "planes", void 0);
          this.planes = planes;
        }
        fromBoundingSphere(boundingSphere) {
          this.planes.length = 2 * faces.length;
          const center = boundingSphere.center;
          const radius = boundingSphere.radius;
          let planeIndex = 0;
          for (const faceNormal of faces) {
            let plane0 = this.planes[planeIndex];
            let plane1 = this.planes[planeIndex + 1];
            if (!plane0) {
              plane0 = this.planes[planeIndex] = new Plane();
            }
            if (!plane1) {
              plane1 = this.planes[planeIndex + 1] = new Plane();
            }
            const plane0Center = scratchPlaneCenter.copy(faceNormal).scale(-radius).add(center);
            const plane0Distance = -faceNormal.dot(plane0Center);
            plane0.fromPointNormal(plane0Center, faceNormal);
            const plane1Center = scratchPlaneCenter.copy(faceNormal).scale(radius).add(center);
            const negatedFaceNormal = scratchPlaneNormal.copy(faceNormal).negate();
            const plane1Distance = -negatedFaceNormal.dot(plane1Center);
            plane1.fromPointNormal(plane1Center, negatedFaceNormal);
            planeIndex += 2;
          }
          return this;
        }
        computeVisibility(boundingVolume) {
          let intersect = INTERSECTION.INSIDE;
          for (const plane of this.planes) {
            const result = boundingVolume.intersectPlane(plane);
            switch (result) {
              case INTERSECTION.OUTSIDE:
                return INTERSECTION.OUTSIDE;
              case INTERSECTION.INTERSECTING:
                intersect = INTERSECTION.INTERSECTING;
                break;
              default:
            }
          }
          return intersect;
        }
        computeVisibilityWithPlaneMask(boundingVolume, parentPlaneMask) {
          assert4(Number.isFinite(parentPlaneMask), "parentPlaneMask is required.");
          if (parentPlaneMask === CullingVolume.MASK_OUTSIDE || parentPlaneMask === CullingVolume.MASK_INSIDE) {
            return parentPlaneMask;
          }
          let mask = CullingVolume.MASK_INSIDE;
          const planes = this.planes;
          for (let k = 0; k < this.planes.length; ++k) {
            const flag = k < 31 ? 1 << k : 0;
            if (k < 31 && (parentPlaneMask & flag) === 0) {
              continue;
            }
            const plane = planes[k];
            const result = boundingVolume.intersectPlane(plane);
            if (result === INTERSECTION.OUTSIDE) {
              return CullingVolume.MASK_OUTSIDE;
            } else if (result === INTERSECTION.INTERSECTING) {
              mask |= flag;
            }
          }
          return mask;
        }
      };
      _defineProperty(CullingVolume, "MASK_OUTSIDE", 4294967295);
      _defineProperty(CullingVolume, "MASK_INSIDE", 0);
      _defineProperty(CullingVolume, "MASK_INDETERMINATE", 2147483647);
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js
  var scratchPlaneUpVector, scratchPlaneRightVector, scratchPlaneNearCenter, scratchPlaneFarCenter, scratchPlaneNormal2;
  var init_perspective_off_center_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js"() {
      init_defineProperty();
      init_esm();
      init_culling_volume();
      init_plane();
      scratchPlaneUpVector = new Vector3();
      scratchPlaneRightVector = new Vector3();
      scratchPlaneNearCenter = new Vector3();
      scratchPlaneFarCenter = new Vector3();
      scratchPlaneNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js
  var init_perspective_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js"() {
      init_defineProperty();
      init_perspective_off_center_frustum();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js
  var fromPointsXMin, fromPointsYMin, fromPointsZMin, fromPointsXMax, fromPointsYMax, fromPointsZMax, fromPointsCurrentPos, fromPointsScratch, fromPointsRitterCenter, fromPointsMinBoxPt, fromPointsMaxBoxPt, fromPointsNaiveCenterScratch, volumeConstant;
  var init_bounding_sphere_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js"() {
      init_esm();
      init_bounding_sphere();
      fromPointsXMin = new Vector3();
      fromPointsYMin = new Vector3();
      fromPointsZMin = new Vector3();
      fromPointsXMax = new Vector3();
      fromPointsYMax = new Vector3();
      fromPointsZMax = new Vector3();
      fromPointsCurrentPos = new Vector3();
      fromPointsScratch = new Vector3();
      fromPointsRitterCenter = new Vector3();
      fromPointsMinBoxPt = new Vector3();
      fromPointsMaxBoxPt = new Vector3();
      fromPointsNaiveCenterScratch = new Vector3();
      volumeConstant = 4 / 3 * Math.PI;
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js
  var scratchMatrix, scratchUnitary, scratchDiagonal, jMatrix, jMatrixTranspose;
  var init_compute_eigen_decomposition = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js"() {
      init_esm();
      scratchMatrix = new Matrix3();
      scratchUnitary = new Matrix3();
      scratchDiagonal = new Matrix3();
      jMatrix = new Matrix3();
      jMatrixTranspose = new Matrix3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js
  var scratchVector24, scratchVector33, scratchVector42, scratchVector52, scratchVector62, scratchCovarianceResult, scratchEigenResult;
  var init_bounding_box_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js"() {
      init_esm();
      init_compute_eigen_decomposition();
      init_oriented_bounding_box();
      init_axis_aligned_bounding_box();
      scratchVector24 = new Vector3();
      scratchVector33 = new Vector3();
      scratchVector42 = new Vector3();
      scratchVector52 = new Vector3();
      scratchVector62 = new Vector3();
      scratchCovarianceResult = new Matrix3();
      scratchEigenResult = {
        diagonal: new Matrix3(),
        unitary: new Matrix3()
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/index.js
  var init_esm4 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/index.js"() {
      init_constants3();
      init_axis_aligned_bounding_box();
      init_bounding_sphere();
      init_oriented_bounding_box();
      init_culling_volume();
      init_plane();
      init_perspective_off_center_frustum();
      init_perspective_frustum();
      init_bounding_sphere_from_points();
      init_bounding_box_from_points();
      init_compute_eigen_decomposition();
    }
  });

  // ../tiles/src/constants.ts
  var TILE_REFINEMENT, TILE_TYPE, TILESET_TYPE;
  var init_constants4 = __esm({
    "../tiles/src/constants.ts"() {
      TILE_REFINEMENT = {
        ADD: 1,
        REPLACE: 2
      };
      TILE_TYPE = {
        EMPTY: "empty",
        SCENEGRAPH: "scenegraph",
        POINTCLOUD: "pointcloud",
        MESH: "mesh"
      };
      TILESET_TYPE = {
        I3S: "I3S",
        TILES3D: "TILES3D"
      };
    }
  });

  // ../tiles/src/index.ts
  var init_src8 = __esm({
    "../tiles/src/index.ts"() {
      init_constants4();
    }
  });

  // src/i3s-node-page-loader.ts
  async function parseNodePage(data) {
    return JSON.parse(new TextDecoder().decode(data));
  }
  async function parse5(data) {
    data = parseNodePage(data);
    return data;
  }
  var VERSION12, I3SNodePageLoader;
  var init_i3s_node_page_loader = __esm({
    "src/i3s-node-page-loader.ts"() {
      VERSION12 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      I3SNodePageLoader = {
        name: "I3S Node Page",
        id: "i3s-node-page",
        module: "i3s",
        version: VERSION12,
        mimeTypes: ["application/json"],
        parse: parse5,
        extensions: ["json"],
        options: {}
      };
    }
  });

  // src/lib/helpers/i3s-nodepages-tiles.ts
  var I3SNodePagesTiles;
  var init_i3s_nodepages_tiles = __esm({
    "src/lib/helpers/i3s-nodepages-tiles.ts"() {
      init_src3();
      init_src7();
      init_i3s_node_page_loader();
      init_parse_i3s();
      init_url_utils2();
      I3SNodePagesTiles = class {
        constructor(tileset, options) {
          this.nodePages = [];
          this.pendingNodePages = [];
          this.textureDefinitionsSelectedFormats = [];
          this.textureLoaderOptions = {};
          this.tileset = { ...tileset };
          this.nodesPerPage = tileset.nodePages?.nodesPerPage || 64;
          this.lodSelectionMetricType = tileset.nodePages?.lodSelectionMetricType;
          this.options = options;
          this.nodesInNodePages = 0;
          this.initSelectedFormatsForTextureDefinitions(tileset);
        }
        async getNodeById(id) {
          const pageIndex = Math.floor(id / this.nodesPerPage);
          if (!this.nodePages[pageIndex] && !this.pendingNodePages[pageIndex]) {
            const nodePageUrl = getUrlWithToken(`${this.tileset.url}/nodepages/${pageIndex}`, this.options.i3s?.token);
            this.pendingNodePages[pageIndex] = {
              status: "Pending",
              promise: load(nodePageUrl, I3SNodePageLoader, this.options)
            };
            this.nodePages[pageIndex] = await this.pendingNodePages[pageIndex].promise;
            this.nodesInNodePages += this.nodePages[pageIndex].nodes.length;
            this.pendingNodePages[pageIndex].status = "Done";
          }
          if (this.pendingNodePages[pageIndex].status === "Pending") {
            this.nodePages[pageIndex] = await this.pendingNodePages[pageIndex].promise;
          }
          const nodeIndex = id % this.nodesPerPage;
          return this.nodePages[pageIndex].nodes[nodeIndex];
        }
        async formTileFromNodePages(id) {
          const node3 = await this.getNodeById(id);
          const children = [];
          const childNodesPromises = [];
          for (const child of node3.children || []) {
            childNodesPromises.push(this.getNodeById(child));
          }
          const childNodes = await Promise.all(childNodesPromises);
          for (const childNode of childNodes) {
            children.push({
              id: childNode.index.toString(),
              obb: childNode.obb
            });
          }
          let contentUrl;
          let textureUrl;
          let materialDefinition;
          let textureFormat = "jpg";
          let attributeUrls = [];
          let isDracoGeometry = false;
          if (node3 && node3.mesh) {
            const { url, isDracoGeometry: isDracoGeometryResult } = node3.mesh.geometry && this.getContentUrl(node3.mesh.geometry) || { isDracoGeometry: false };
            contentUrl = url;
            isDracoGeometry = isDracoGeometryResult;
            const { textureData, materialDefinition: nodeMaterialDefinition } = this.getInformationFromMaterial(node3.mesh.material);
            materialDefinition = nodeMaterialDefinition;
            textureFormat = textureData.format || textureFormat;
            if (textureData.name) {
              textureUrl = `${this.tileset.url}/nodes/${node3.mesh.material.resource}/textures/${textureData.name}`;
            }
            if (this.tileset.attributeStorageInfo) {
              attributeUrls = generateTilesetAttributeUrls(this.tileset, node3.mesh.attribute.resource);
            }
          }
          const lodSelection = this.getLodSelection(node3);
          return normalizeTileNonUrlData({
            id: id.toString(),
            lodSelection,
            obb: node3.obb,
            contentUrl,
            textureUrl,
            attributeUrls,
            materialDefinition,
            textureFormat,
            textureLoaderOptions: this.textureLoaderOptions,
            children,
            isDracoGeometry
          });
        }
        getContentUrl(meshGeometryData) {
          let result = null;
          const geometryDefinition = this.tileset.geometryDefinitions[meshGeometryData.definition];
          let geometryIndex = -1;
          if (this.options.i3s && this.options.i3s.useDracoGeometry) {
            geometryIndex = geometryDefinition.geometryBuffers.findIndex((buffer) => buffer.compressedAttributes && buffer.compressedAttributes.encoding === "draco");
          }
          if (geometryIndex === -1) {
            geometryIndex = geometryDefinition.geometryBuffers.findIndex((buffer) => !buffer.compressedAttributes);
          }
          if (geometryIndex !== -1) {
            const isDracoGeometry = Boolean(geometryDefinition.geometryBuffers[geometryIndex].compressedAttributes);
            result = {
              url: `${this.tileset.url}/nodes/${meshGeometryData.resource}/geometries/${geometryIndex}`,
              isDracoGeometry
            };
          }
          return result;
        }
        getLodSelection(node3) {
          const lodSelection = [];
          if (this.lodSelectionMetricType === "maxScreenThresholdSQ") {
            lodSelection.push({
              metricType: "maxScreenThreshold",
              maxError: Math.sqrt(node3.lodThreshold / (Math.PI * 0.25))
            });
          }
          lodSelection.push({
            metricType: this.lodSelectionMetricType,
            maxError: node3.lodThreshold
          });
          return lodSelection;
        }
        getInformationFromMaterial(material) {
          const informationFromMaterial = { textureData: { name: null } };
          if (material) {
            const materialDefinition = this.tileset.materialDefinitions?.[material.definition];
            if (materialDefinition) {
              informationFromMaterial.materialDefinition = materialDefinition;
              const textureSetDefinitionIndex = materialDefinition?.pbrMetallicRoughness?.baseColorTexture?.textureSetDefinitionId;
              if (typeof textureSetDefinitionIndex === "number") {
                informationFromMaterial.textureData = this.textureDefinitionsSelectedFormats[textureSetDefinitionIndex] || informationFromMaterial.textureData;
              }
            }
          }
          return informationFromMaterial;
        }
        initSelectedFormatsForTextureDefinitions(tileset) {
          this.textureDefinitionsSelectedFormats = [];
          const possibleI3sFormats = this.getSupportedTextureFormats();
          const textureSetDefinitions = tileset.textureSetDefinitions || [];
          for (const textureSetDefinition of textureSetDefinitions) {
            const formats2 = textureSetDefinition && textureSetDefinition.formats || [];
            let selectedFormat = null;
            for (const i3sFormat of possibleI3sFormats) {
              const format = formats2.find((value) => value.format === i3sFormat);
              if (format) {
                selectedFormat = format;
                break;
              }
            }
            if (selectedFormat && selectedFormat.format === "ktx2") {
              this.textureLoaderOptions.basis = {
                format: selectSupportedBasisFormat(),
                containerFormat: "ktx2",
                module: "encoder"
              };
            }
            this.textureDefinitionsSelectedFormats.push(selectedFormat);
          }
        }
        getSupportedTextureFormats() {
          const formats2 = [];
          if (!this.options.i3s || this.options.i3s.useCompressedTextures) {
            const supportedCompressedFormats = getSupportedGPUTextureFormats();
            if (supportedCompressedFormats.has("etc2")) {
              formats2.push("ktx-etc2");
            }
            if (supportedCompressedFormats.has("dxt")) {
              formats2.push("dds");
            }
            formats2.push("ktx2");
          }
          formats2.push("jpg");
          formats2.push("png");
          return formats2;
        }
      };
    }
  });

  // src/lib/parsers/parse-i3s.ts
  function normalizeTileData(tile, context) {
    const url = context.url || "";
    let contentUrl;
    if (tile.geometryData) {
      contentUrl = `${url}/${tile.geometryData[0].href}`;
    }
    let textureUrl;
    if (tile.textureData) {
      textureUrl = `${url}/${tile.textureData[0].href}`;
    }
    let attributeUrls;
    if (tile.attributeData) {
      attributeUrls = generateTileAttributeUrls(url, tile);
    }
    return normalizeTileNonUrlData({
      ...tile,
      url,
      contentUrl,
      textureUrl,
      attributeUrls,
      isDracoGeometry: false
    });
  }
  function normalizeTileNonUrlData(tile) {
    const boundingVolume = {};
    let mbs = [0, 0, 0, 1];
    if (tile.mbs) {
      mbs = tile.mbs;
      boundingVolume.sphere = [
        ...Ellipsoid.WGS84.cartographicToCartesian(tile.mbs.slice(0, 3)),
        tile.mbs[3]
      ];
    } else if (tile.obb) {
      boundingVolume.box = [
        ...Ellipsoid.WGS84.cartographicToCartesian(tile.obb.center),
        ...tile.obb.halfSize,
        ...tile.obb.quaternion
      ];
      const obb = new OrientedBoundingBox().fromCenterHalfSizeQuaternion(boundingVolume.box.slice(0, 3), tile.obb.halfSize, tile.obb.quaternion);
      const boundingSphere = obb.getBoundingSphere();
      boundingVolume.sphere = [...boundingSphere.center, boundingSphere.radius];
      mbs = [...tile.obb.center, boundingSphere.radius];
    }
    const lodMetricType = tile.lodSelection?.[0].metricType;
    const lodMetricValue = tile.lodSelection?.[0].maxError;
    const transformMatrix = tile.transform;
    const type = TILE_TYPE.MESH;
    const refine = TILE_REFINEMENT.REPLACE;
    return { ...tile, mbs, boundingVolume, lodMetricType, lodMetricValue, transformMatrix, type, refine };
  }
  async function normalizeTilesetData(tileset, options, context) {
    tileset.url = context.url;
    if (tileset.nodePages) {
      tileset.nodePagesTile = new I3SNodePagesTiles(tileset, options);
      tileset.root = tileset.nodePagesTile.formTileFromNodePages(0);
    } else {
      const rootNodeUrl = getUrlWithToken(`${tileset.url}/nodes/root`, options.i3s?.token);
      tileset.root = await load(rootNodeUrl, tileset.loader, {
        ...options,
        i3s: {
          ...options.i3s,
          loadContent: false,
          isTileHeader: true,
          isTileset: false
        }
      });
    }
    tileset.basePath = tileset.url;
    tileset.type = TILESET_TYPE.I3S;
    tileset.lodMetricType = tileset.root.lodMetricType;
    tileset.lodMetricValue = tileset.root.lodMetricValue;
  }
  var init_parse_i3s = __esm({
    "src/lib/parsers/parse-i3s.ts"() {
      init_esm4();
      init_esm2();
      init_src3();
      init_src8();
      init_i3s_nodepages_tiles();
      init_url_utils2();
    }
  });

  // src/i3s-loader.ts
  async function parseI3S(data, options = {}, context) {
    const url = context.url;
    options.i3s = options.i3s || {};
    const magicNumber = getMagicNumber(data);
    if (magicNumber === SLPK_HEX) {
      throw new Error("Files with .slpk extention currently are not supported by I3SLoader");
    }
    let isTileset;
    if (options.i3s.isTileset === "auto") {
      isTileset = TILESET_REGEX.test(url);
    } else {
      isTileset = options.i3s.isTileset;
    }
    let isTileHeader;
    if (options.isTileHeader === "auto") {
      isTileHeader = TILE_HEADER_REGEX.test(url);
    } else {
      isTileHeader = options.i3s.isTileHeader;
    }
    if (isTileset) {
      data = await parseTileset(data, options, context);
    } else if (isTileHeader) {
      data = await parseTile(data, context);
    } else {
      data = await parseTileContent(data, options);
    }
    return data;
  }
  async function parseTileContent(arrayBuffer, options) {
    return await parse(arrayBuffer, I3SContentLoader, options);
  }
  async function parseTileset(data, options, context) {
    const tilesetJson = JSON.parse(new TextDecoder().decode(data));
    if (tilesetJson?.layerType === POINT_CLOUD) {
      throw new Error("Point Cloud layers currently are not supported by I3SLoader");
    }
    tilesetJson.loader = I3SLoader;
    await normalizeTilesetData(tilesetJson, options, context);
    return tilesetJson;
  }
  async function parseTile(data, context) {
    data = JSON.parse(new TextDecoder().decode(data));
    return normalizeTileData(data, context);
  }
  function getMagicNumber(data) {
    if (data instanceof ArrayBuffer) {
      return [...new Uint8Array(data, 0, 4)].map((value) => value.toString(16).padStart(2, "0")).join("");
    }
    return null;
  }
  var VERSION13, TILESET_REGEX, TILE_HEADER_REGEX, SLPK_HEX, POINT_CLOUD, I3SLoader;
  var init_i3s_loader = __esm({
    "src/i3s-loader.ts"() {
      init_src3();
      init_i3s_content_loader();
      init_parse_i3s();
      init_constants2();
      VERSION13 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      TILESET_REGEX = /layers\/[0-9]+$/;
      TILE_HEADER_REGEX = /nodes\/([0-9-]+|root)$/;
      SLPK_HEX = "504b0304";
      POINT_CLOUD = "PointCloud";
      I3SLoader = {
        name: "I3S (Indexed Scene Layers)",
        id: "i3s",
        module: "i3s",
        version: VERSION13,
        mimeTypes: ["application/octet-stream"],
        parse: parseI3S,
        extensions: ["bin"],
        options: {
          i3s: {
            token: null,
            isTileset: "auto",
            isTileHeader: "auto",
            tile: null,
            tileset: null,
            _tileOptions: null,
            _tilesetOptions: null,
            useDracoGeometry: true,
            useCompressedTextures: true,
            decodeTextures: true,
            coordinateSystem: COORDINATE_SYSTEM.METER_OFFSETS,
            colorsByAttribute: null
          }
        }
      };
    }
  });

  // src/lib/parsers/parse-zip/cd-file-header.ts
  var parseZipCDFileHeader;
  var init_cd_file_header = __esm({
    "src/lib/parsers/parse-zip/cd-file-header.ts"() {
      parseZipCDFileHeader = (headerOffset, buffer) => {
        const offsets = {
          CD_COMPRESSED_SIZE_OFFSET: 20,
          CD_UNCOMPRESSED_SIZE_OFFSET: 24,
          CD_FILE_NAME_LENGTH_OFFSET: 28,
          CD_EXTRA_FIELD_LENGTH_OFFSET: 30,
          CD_LOCAL_HEADER_OFFSET_OFFSET: 42,
          CD_FILE_NAME_OFFSET: 46
        };
        const compressedSize = buffer.getUint32(headerOffset + offsets.CD_COMPRESSED_SIZE_OFFSET, true);
        const uncompressedSize = buffer.getUint32(headerOffset + offsets.CD_UNCOMPRESSED_SIZE_OFFSET, true);
        const fileNameLength = buffer.getUint16(headerOffset + offsets.CD_FILE_NAME_LENGTH_OFFSET, true);
        const fileName = buffer.buffer.slice(headerOffset + offsets.CD_FILE_NAME_OFFSET, headerOffset + offsets.CD_FILE_NAME_OFFSET + fileNameLength);
        const extraOffset = headerOffset + offsets.CD_FILE_NAME_OFFSET + fileNameLength;
        const oldFormatOffset = buffer.getUint32(headerOffset + offsets.CD_LOCAL_HEADER_OFFSET_OFFSET, true);
        let fileDataOffset = oldFormatOffset;
        if (fileDataOffset === 4294967295) {
          let offsetInZip64Data = 4;
          if (compressedSize === 4294967295) {
            offsetInZip64Data += 8;
          }
          if (uncompressedSize === 4294967295) {
            offsetInZip64Data += 8;
          }
          fileDataOffset = buffer.getUint32(extraOffset + offsetInZip64Data, true);
        }
        const localHeaderOffset = fileDataOffset;
        return {
          compressedSize,
          uncompressedSize,
          fileNameLength,
          fileName,
          extraOffset,
          localHeaderOffset
        };
      };
    }
  });

  // src/lib/parsers/parse-zip/local-file-header.ts
  var parseZipLocalFileHeader;
  var init_local_file_header = __esm({
    "src/lib/parsers/parse-zip/local-file-header.ts"() {
      parseZipLocalFileHeader = (headerOffset, buffer) => {
        const offsets = {
          COMPRESSED_SIZE_OFFSET: 18,
          FILE_NAME_LENGTH_OFFSET: 26,
          EXTRA_FIELD_LENGTH_OFFSET: 28,
          FILE_NAME_OFFSET: 30
        };
        const fileNameLength = buffer.getUint16(headerOffset + offsets.FILE_NAME_LENGTH_OFFSET, true);
        const extraFieldLength = buffer.getUint16(headerOffset + offsets.EXTRA_FIELD_LENGTH_OFFSET, true);
        const fileDataOffset = headerOffset + offsets.FILE_NAME_OFFSET + fileNameLength + extraFieldLength;
        const compressedSize = buffer.getUint32(headerOffset + offsets.COMPRESSED_SIZE_OFFSET, true);
        return {
          fileNameLength,
          extraFieldLength,
          fileDataOffset,
          compressedSize
        };
      };
    }
  });

  // ../../node_modules/crypt/crypt.js
  var require_crypt = __commonJS({
    "../../node_modules/crypt/crypt.js"(exports, module) {
      (function() {
        var base64map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", crypt = {
          rotl: function(n2, b) {
            return n2 << b | n2 >>> 32 - b;
          },
          rotr: function(n2, b) {
            return n2 << 32 - b | n2 >>> b;
          },
          endian: function(n2) {
            if (n2.constructor == Number) {
              return crypt.rotl(n2, 8) & 16711935 | crypt.rotl(n2, 24) & 4278255360;
            }
            for (var i2 = 0; i2 < n2.length; i2++)
              n2[i2] = crypt.endian(n2[i2]);
            return n2;
          },
          randomBytes: function(n2) {
            for (var bytes = []; n2 > 0; n2--)
              bytes.push(Math.floor(Math.random() * 256));
            return bytes;
          },
          bytesToWords: function(bytes) {
            for (var words = [], i2 = 0, b = 0; i2 < bytes.length; i2++, b += 8)
              words[b >>> 5] |= bytes[i2] << 24 - b % 32;
            return words;
          },
          wordsToBytes: function(words) {
            for (var bytes = [], b = 0; b < words.length * 32; b += 8)
              bytes.push(words[b >>> 5] >>> 24 - b % 32 & 255);
            return bytes;
          },
          bytesToHex: function(bytes) {
            for (var hex = [], i2 = 0; i2 < bytes.length; i2++) {
              hex.push((bytes[i2] >>> 4).toString(16));
              hex.push((bytes[i2] & 15).toString(16));
            }
            return hex.join("");
          },
          hexToBytes: function(hex) {
            for (var bytes = [], c2 = 0; c2 < hex.length; c2 += 2)
              bytes.push(parseInt(hex.substr(c2, 2), 16));
            return bytes;
          },
          bytesToBase64: function(bytes) {
            for (var base64 = [], i2 = 0; i2 < bytes.length; i2 += 3) {
              var triplet = bytes[i2] << 16 | bytes[i2 + 1] << 8 | bytes[i2 + 2];
              for (var j = 0; j < 4; j++)
                if (i2 * 8 + j * 6 <= bytes.length * 8)
                  base64.push(base64map.charAt(triplet >>> 6 * (3 - j) & 63));
                else
                  base64.push("=");
            }
            return base64.join("");
          },
          base64ToBytes: function(base64) {
            base64 = base64.replace(/[^A-Z0-9+\/]/ig, "");
            for (var bytes = [], i2 = 0, imod4 = 0; i2 < base64.length; imod4 = ++i2 % 4) {
              if (imod4 == 0)
                continue;
              bytes.push((base64map.indexOf(base64.charAt(i2 - 1)) & Math.pow(2, -2 * imod4 + 8) - 1) << imod4 * 2 | base64map.indexOf(base64.charAt(i2)) >>> 6 - imod4 * 2);
            }
            return bytes;
          }
        };
        module.exports = crypt;
      })();
    }
  });

  // ../../node_modules/charenc/charenc.js
  var require_charenc = __commonJS({
    "../../node_modules/charenc/charenc.js"(exports, module) {
      var charenc = {
        utf8: {
          stringToBytes: function(str) {
            return charenc.bin.stringToBytes(unescape(encodeURIComponent(str)));
          },
          bytesToString: function(bytes) {
            return decodeURIComponent(escape(charenc.bin.bytesToString(bytes)));
          }
        },
        bin: {
          stringToBytes: function(str) {
            for (var bytes = [], i2 = 0; i2 < str.length; i2++)
              bytes.push(str.charCodeAt(i2) & 255);
            return bytes;
          },
          bytesToString: function(bytes) {
            for (var str = [], i2 = 0; i2 < bytes.length; i2++)
              str.push(String.fromCharCode(bytes[i2]));
            return str.join("");
          }
        }
      };
      module.exports = charenc;
    }
  });

  // ../../node_modules/is-buffer/index.js
  var require_is_buffer = __commonJS({
    "../../node_modules/is-buffer/index.js"(exports, module) {
      module.exports = function(obj) {
        return obj != null && (isBuffer3(obj) || isSlowBuffer(obj) || !!obj._isBuffer);
      };
      function isBuffer3(obj) {
        return !!obj.constructor && typeof obj.constructor.isBuffer === "function" && obj.constructor.isBuffer(obj);
      }
      function isSlowBuffer(obj) {
        return typeof obj.readFloatLE === "function" && typeof obj.slice === "function" && isBuffer3(obj.slice(0, 0));
      }
    }
  });

  // ../../node_modules/md5/md5.js
  var require_md5 = __commonJS({
    "../../node_modules/md5/md5.js"(exports, module) {
      (function() {
        var crypt = require_crypt(), utf8 = require_charenc().utf8, isBuffer3 = require_is_buffer(), bin = require_charenc().bin, md52 = function(message, options) {
          if (message.constructor == String)
            if (options && options.encoding === "binary")
              message = bin.stringToBytes(message);
            else
              message = utf8.stringToBytes(message);
          else if (isBuffer3(message))
            message = Array.prototype.slice.call(message, 0);
          else if (!Array.isArray(message) && message.constructor !== Uint8Array)
            message = message.toString();
          var m = crypt.bytesToWords(message), l2 = message.length * 8, a2 = 1732584193, b = -271733879, c2 = -1732584194, d = 271733878;
          for (var i2 = 0; i2 < m.length; i2++) {
            m[i2] = (m[i2] << 8 | m[i2] >>> 24) & 16711935 | (m[i2] << 24 | m[i2] >>> 8) & 4278255360;
          }
          m[l2 >>> 5] |= 128 << l2 % 32;
          m[(l2 + 64 >>> 9 << 4) + 14] = l2;
          var FF = md52._ff, GG = md52._gg, HH = md52._hh, II = md52._ii;
          for (var i2 = 0; i2 < m.length; i2 += 16) {
            var aa = a2, bb = b, cc = c2, dd = d;
            a2 = FF(a2, b, c2, d, m[i2 + 0], 7, -680876936);
            d = FF(d, a2, b, c2, m[i2 + 1], 12, -389564586);
            c2 = FF(c2, d, a2, b, m[i2 + 2], 17, 606105819);
            b = FF(b, c2, d, a2, m[i2 + 3], 22, -1044525330);
            a2 = FF(a2, b, c2, d, m[i2 + 4], 7, -176418897);
            d = FF(d, a2, b, c2, m[i2 + 5], 12, 1200080426);
            c2 = FF(c2, d, a2, b, m[i2 + 6], 17, -1473231341);
            b = FF(b, c2, d, a2, m[i2 + 7], 22, -45705983);
            a2 = FF(a2, b, c2, d, m[i2 + 8], 7, 1770035416);
            d = FF(d, a2, b, c2, m[i2 + 9], 12, -1958414417);
            c2 = FF(c2, d, a2, b, m[i2 + 10], 17, -42063);
            b = FF(b, c2, d, a2, m[i2 + 11], 22, -1990404162);
            a2 = FF(a2, b, c2, d, m[i2 + 12], 7, 1804603682);
            d = FF(d, a2, b, c2, m[i2 + 13], 12, -40341101);
            c2 = FF(c2, d, a2, b, m[i2 + 14], 17, -1502002290);
            b = FF(b, c2, d, a2, m[i2 + 15], 22, 1236535329);
            a2 = GG(a2, b, c2, d, m[i2 + 1], 5, -165796510);
            d = GG(d, a2, b, c2, m[i2 + 6], 9, -1069501632);
            c2 = GG(c2, d, a2, b, m[i2 + 11], 14, 643717713);
            b = GG(b, c2, d, a2, m[i2 + 0], 20, -373897302);
            a2 = GG(a2, b, c2, d, m[i2 + 5], 5, -701558691);
            d = GG(d, a2, b, c2, m[i2 + 10], 9, 38016083);
            c2 = GG(c2, d, a2, b, m[i2 + 15], 14, -660478335);
            b = GG(b, c2, d, a2, m[i2 + 4], 20, -405537848);
            a2 = GG(a2, b, c2, d, m[i2 + 9], 5, 568446438);
            d = GG(d, a2, b, c2, m[i2 + 14], 9, -1019803690);
            c2 = GG(c2, d, a2, b, m[i2 + 3], 14, -187363961);
            b = GG(b, c2, d, a2, m[i2 + 8], 20, 1163531501);
            a2 = GG(a2, b, c2, d, m[i2 + 13], 5, -1444681467);
            d = GG(d, a2, b, c2, m[i2 + 2], 9, -51403784);
            c2 = GG(c2, d, a2, b, m[i2 + 7], 14, 1735328473);
            b = GG(b, c2, d, a2, m[i2 + 12], 20, -1926607734);
            a2 = HH(a2, b, c2, d, m[i2 + 5], 4, -378558);
            d = HH(d, a2, b, c2, m[i2 + 8], 11, -2022574463);
            c2 = HH(c2, d, a2, b, m[i2 + 11], 16, 1839030562);
            b = HH(b, c2, d, a2, m[i2 + 14], 23, -35309556);
            a2 = HH(a2, b, c2, d, m[i2 + 1], 4, -1530992060);
            d = HH(d, a2, b, c2, m[i2 + 4], 11, 1272893353);
            c2 = HH(c2, d, a2, b, m[i2 + 7], 16, -155497632);
            b = HH(b, c2, d, a2, m[i2 + 10], 23, -1094730640);
            a2 = HH(a2, b, c2, d, m[i2 + 13], 4, 681279174);
            d = HH(d, a2, b, c2, m[i2 + 0], 11, -358537222);
            c2 = HH(c2, d, a2, b, m[i2 + 3], 16, -722521979);
            b = HH(b, c2, d, a2, m[i2 + 6], 23, 76029189);
            a2 = HH(a2, b, c2, d, m[i2 + 9], 4, -640364487);
            d = HH(d, a2, b, c2, m[i2 + 12], 11, -421815835);
            c2 = HH(c2, d, a2, b, m[i2 + 15], 16, 530742520);
            b = HH(b, c2, d, a2, m[i2 + 2], 23, -995338651);
            a2 = II(a2, b, c2, d, m[i2 + 0], 6, -198630844);
            d = II(d, a2, b, c2, m[i2 + 7], 10, 1126891415);
            c2 = II(c2, d, a2, b, m[i2 + 14], 15, -1416354905);
            b = II(b, c2, d, a2, m[i2 + 5], 21, -57434055);
            a2 = II(a2, b, c2, d, m[i2 + 12], 6, 1700485571);
            d = II(d, a2, b, c2, m[i2 + 3], 10, -1894986606);
            c2 = II(c2, d, a2, b, m[i2 + 10], 15, -1051523);
            b = II(b, c2, d, a2, m[i2 + 1], 21, -2054922799);
            a2 = II(a2, b, c2, d, m[i2 + 8], 6, 1873313359);
            d = II(d, a2, b, c2, m[i2 + 15], 10, -30611744);
            c2 = II(c2, d, a2, b, m[i2 + 6], 15, -1560198380);
            b = II(b, c2, d, a2, m[i2 + 13], 21, 1309151649);
            a2 = II(a2, b, c2, d, m[i2 + 4], 6, -145523070);
            d = II(d, a2, b, c2, m[i2 + 11], 10, -1120210379);
            c2 = II(c2, d, a2, b, m[i2 + 2], 15, 718787259);
            b = II(b, c2, d, a2, m[i2 + 9], 21, -343485551);
            a2 = a2 + aa >>> 0;
            b = b + bb >>> 0;
            c2 = c2 + cc >>> 0;
            d = d + dd >>> 0;
          }
          return crypt.endian([a2, b, c2, d]);
        };
        md52._ff = function(a2, b, c2, d, x, s2, t2) {
          var n2 = a2 + (b & c2 | ~b & d) + (x >>> 0) + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b;
        };
        md52._gg = function(a2, b, c2, d, x, s2, t2) {
          var n2 = a2 + (b & d | c2 & ~d) + (x >>> 0) + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b;
        };
        md52._hh = function(a2, b, c2, d, x, s2, t2) {
          var n2 = a2 + (b ^ c2 ^ d) + (x >>> 0) + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b;
        };
        md52._ii = function(a2, b, c2, d, x, s2, t2) {
          var n2 = a2 + (c2 ^ (b | ~d)) + (x >>> 0) + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b;
        };
        md52._blocksize = 16;
        md52._digestsize = 16;
        module.exports = function(message, options) {
          if (message === void 0 || message === null)
            throw new Error("Illegal argument " + message);
          var digestbytes = crypt.wordsToBytes(md52(message, options));
          return options && options.asBytes ? digestbytes : options && options.asString ? bin.bytesToString(digestbytes) : crypt.bytesToHex(digestbytes);
        };
      })();
    }
  });

  // ../compression/src/compression-worker.ts
  var VERSION14, CompressionWorker;
  var init_compression_worker = __esm({
    "../compression/src/compression-worker.ts"() {
      VERSION14 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      CompressionWorker = {
        id: "compression",
        name: "compression",
        module: "compression",
        version: VERSION14,
        options: {}
      };
    }
  });

  // ../compression/src/index.ts
  var init_src9 = __esm({
    "../compression/src/index.ts"() {
      init_compression_worker();
    }
  });

  // src/lib/parsers/parse-slpk/slpk-archieve.ts
  var import_md5, SLPKArchive;
  var init_slpk_archieve = __esm({
    "src/lib/parsers/parse-slpk/slpk-archieve.ts"() {
      init_src();
      import_md5 = __toModule(require_md5());
      init_src9();
      init_local_file_header();
      SLPKArchive = class {
        constructor(slpkArchiveBuffer, hashFile) {
          this.slpkArchive = new DataView(slpkArchiveBuffer);
          this.hashArray = this.parseHashFile(hashFile);
        }
        parseHashFile(hashFile) {
          const hashFileBuffer = Buffer.from(hashFile);
          const hashArray = [];
          for (let i2 = 0; i2 < hashFileBuffer.buffer.byteLength; i2 = i2 + 24) {
            const offsetBuffer = new DataView(hashFileBuffer.buffer.slice(hashFileBuffer.byteOffset + i2 + 16, hashFileBuffer.byteOffset + i2 + 24));
            const offset = offsetBuffer.getUint32(offsetBuffer.byteOffset, true);
            hashArray.push({
              hash: Buffer.from(hashFileBuffer.subarray(hashFileBuffer.byteOffset + i2, hashFileBuffer.byteOffset + i2 + 16)),
              offset
            });
          }
          return hashArray;
        }
        async getFile(path, mode = "raw") {
          if (mode === "http") {
            throw new Error("http mode is not supported");
          }
          const fileToDecompress = this.getFileBytes(`${path}.gz`);
          if (fileToDecompress) {
            const decompressedData = await processOnWorker(CompressionWorker, fileToDecompress, {
              compression: "gzip",
              operation: "decompress",
              _workerType: "test",
              gzip: {}
            });
            return decompressedData;
          }
          const fileWithoutCompression = this.getFileBytes(path);
          if (fileWithoutCompression) {
            return Promise.resolve(Buffer.from(fileWithoutCompression));
          }
          throw new Error("No such file in the archieve");
        }
        getFileBytes(path) {
          const nameHash = Buffer.from((0, import_md5.default)(path), "hex");
          const fileInfo = this.hashArray.find((val) => Buffer.compare(val.hash, nameHash) === 0);
          if (!fileInfo) {
            return void 0;
          }
          const localFileHeader = parseZipLocalFileHeader(this.slpkArchive.byteOffset + fileInfo?.offset, this.slpkArchive);
          const compressedFile = this.slpkArchive.buffer.slice(localFileHeader.fileDataOffset, localFileHeader.fileDataOffset + localFileHeader.compressedSize);
          return compressedFile;
        }
      };
    }
  });

  // src/lib/parsers/parse-slpk/parse-slpk.ts
  async function parseSLPK(data, options = {}) {
    const archive = new DataView(data);
    const cdFileHeaderSignature = [80, 75, 1, 2];
    const searchWindow = [
      getByteAt(archive.byteLength - 1, archive),
      getByteAt(archive.byteLength - 2, archive),
      getByteAt(archive.byteLength - 3, archive),
      void 0
    ];
    let hashCDOffset = 0;
    for (let i2 = archive.byteLength - 4; i2 > -1; i2--) {
      searchWindow[3] = searchWindow[2];
      searchWindow[2] = searchWindow[1];
      searchWindow[1] = searchWindow[0];
      searchWindow[0] = getByteAt(i2, archive);
      if (searchWindow.every((val, index) => val === cdFileHeaderSignature[index])) {
        hashCDOffset = i2;
        break;
      }
    }
    const cdFileHeader = parseZipCDFileHeader(hashCDOffset, archive);
    const textDecoder = new TextDecoder();
    if (textDecoder.decode(cdFileHeader.fileName) !== "@specialIndexFileHASH128@") {
      throw new Error("No hash file in slpk");
    }
    const localFileHeader = parseZipLocalFileHeader(cdFileHeader.localHeaderOffset, archive);
    const fileDataOffset = localFileHeader.fileDataOffset;
    const hashFile = archive.buffer.slice(fileDataOffset, fileDataOffset + localFileHeader.compressedSize);
    if (!hashFile) {
      throw new Error("No hash file in slpk");
    }
    return await new SLPKArchive(data, hashFile).getFile(options.path ?? "");
  }
  var getByteAt;
  var init_parse_slpk = __esm({
    "src/lib/parsers/parse-slpk/parse-slpk.ts"() {
      init_cd_file_header();
      init_local_file_header();
      init_slpk_archieve();
      getByteAt = (offset, buffer) => {
        return buffer.getUint8(buffer.byteOffset + offset);
      };
    }
  });

  // src/i3s-slpk-loader.ts
  var VERSION15, SLPKLoader;
  var init_i3s_slpk_loader = __esm({
    "src/i3s-slpk-loader.ts"() {
      init_parse_slpk();
      VERSION15 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      SLPKLoader = {
        name: "I3S SLPK (Scene Layer Package)",
        id: "slpk",
        module: "i3s",
        version: VERSION15,
        mimeTypes: ["application/octet-stream"],
        parse: parseSLPK,
        extensions: ["slpk"],
        options: {}
      };
    }
  });

  // src/lib/parsers/parse-i3s-building-scene-layer.ts
  async function parseBuildingSceneLayer(data, url) {
    const layer0 = JSON.parse(new TextDecoder().decode(data));
    const { sublayers } = layer0;
    return {
      header: layer0,
      sublayers: parseSublayersTree(sublayers, url)
    };
  }
  function parseSublayersTree(sublayers, url) {
    let layers = [];
    for (let index = 0; index < sublayers.length; index++) {
      const subLayer = sublayers[index];
      const { id, layerType, visibility = true, ...rest } = subLayer;
      if (layerType === OBJECT_3D_LAYER_TYPE) {
        const sublayerUrl = `${url}/sublayers/${id}`;
        layers.push({
          url: sublayerUrl,
          id,
          layerType,
          visibility,
          ...rest
        });
      }
      if (subLayer?.sublayers?.length) {
        layers = [...layers, ...parseSublayersTree(subLayer.sublayers, url)];
      }
    }
    return layers;
  }
  var OBJECT_3D_LAYER_TYPE;
  var init_parse_i3s_building_scene_layer = __esm({
    "src/lib/parsers/parse-i3s-building-scene-layer.ts"() {
      OBJECT_3D_LAYER_TYPE = "3DObject";
    }
  });

  // src/i3s-building-scene-layer-loader.ts
  async function parse6(data, options, context) {
    if (!context?.url) {
      throw new Error("Url is not provided");
    }
    return parseBuildingSceneLayer(data, context.url);
  }
  var VERSION16, I3SBuildingSceneLayerLoader;
  var init_i3s_building_scene_layer_loader = __esm({
    "src/i3s-building-scene-layer-loader.ts"() {
      init_parse_i3s_building_scene_layer();
      VERSION16 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      I3SBuildingSceneLayerLoader = {
        name: "I3S Building Scene Layer",
        id: "i3s-building-scene-layer",
        module: "i3s",
        version: VERSION16,
        mimeTypes: ["application/json"],
        parse: parse6,
        extensions: ["json"],
        options: {}
      };
    }
  });

  // src/lib/parsers/parse-arcgis-webscene.ts
  async function parseWebscene(data) {
    const layer0 = JSON.parse(new TextDecoder().decode(data));
    const { operationalLayers } = layer0;
    const { layers, unsupportedLayers } = await parseOperationalLayers(operationalLayers, true);
    if (!layers.length) {
      throw new Error(NO_AVAILABLE_SUPPORTED_LAYERS_ERROR);
    }
    return {
      header: layer0,
      layers,
      unsupportedLayers
    };
  }
  async function parseOperationalLayers(layersList, needToCheckCRS) {
    const layers = [];
    let unsupportedLayers = [];
    for (let index = 0; index < layersList.length; index++) {
      const layer = layersList[index];
      const isLayerSupported = SUPPORTED_LAYERS_TYPES.includes(layer.layerType);
      if (isLayerSupported) {
        if (needToCheckCRS && layer.layerType !== GROUP_LAYER) {
          await checkSupportedIndexCRS(layer);
          needToCheckCRS = false;
        }
        layers.push(layer);
      } else {
        unsupportedLayers.push(layer);
      }
      if (layer.layers?.length) {
        const { layers: childLayers, unsupportedLayers: childUnsupportedLayers } = await parseOperationalLayers(layer.layers, needToCheckCRS);
        layer.layers = childLayers;
        unsupportedLayers = [...unsupportedLayers, ...childUnsupportedLayers];
      }
    }
    return { layers, unsupportedLayers };
  }
  async function checkSupportedIndexCRS(layer) {
    try {
      const layerJson = await load(layer.url, JSONLoader);
      const wkid = layerJson?.spatialReference?.wkid;
      if (wkid !== SUPPORTED_WKID) {
        throw new Error(NOT_SUPPORTED_CRS_ERROR);
      }
    } catch (error) {
      throw error;
    }
  }
  var SUPPORTED_WKID, ARCGIS_SCENE_SERVER_LAYER_TYPE, BUILDING_SCENE_LAYER, INTEGRATED_MESH_LAYER, GROUP_LAYER, SUPPORTED_LAYERS_TYPES, NO_AVAILABLE_SUPPORTED_LAYERS_ERROR, NOT_SUPPORTED_CRS_ERROR;
  var init_parse_arcgis_webscene = __esm({
    "src/lib/parsers/parse-arcgis-webscene.ts"() {
      init_src3();
      SUPPORTED_WKID = 4326;
      ARCGIS_SCENE_SERVER_LAYER_TYPE = "ArcGISSceneServiceLayer";
      BUILDING_SCENE_LAYER = "BuildingSceneLayer";
      INTEGRATED_MESH_LAYER = "IntegratedMeshLayer";
      GROUP_LAYER = "GroupLayer";
      SUPPORTED_LAYERS_TYPES = [
        ARCGIS_SCENE_SERVER_LAYER_TYPE,
        INTEGRATED_MESH_LAYER,
        BUILDING_SCENE_LAYER,
        GROUP_LAYER
      ];
      NO_AVAILABLE_SUPPORTED_LAYERS_ERROR = "NO_AVAILABLE_SUPPORTED_LAYERS_ERROR";
      NOT_SUPPORTED_CRS_ERROR = "NOT_SUPPORTED_CRS_ERROR";
    }
  });

  // src/arcgis-webscene-loader.ts
  async function parse7(data) {
    return parseWebscene(data);
  }
  var VERSION17, ArcGisWebSceneLoader;
  var init_arcgis_webscene_loader = __esm({
    "src/arcgis-webscene-loader.ts"() {
      init_parse_arcgis_webscene();
      VERSION17 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      ArcGisWebSceneLoader = {
        name: "ArcGIS Web Scene Loader",
        id: "arcgis-web-scene",
        module: "i3s",
        version: VERSION17,
        mimeTypes: ["application/json"],
        parse: parse7,
        extensions: ["json"],
        options: {}
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    ArcGisWebSceneLoader: () => ArcGisWebSceneLoader,
    COORDINATE_SYSTEM: () => COORDINATE_SYSTEM,
    I3SAttributeLoader: () => I3SAttributeLoader,
    I3SBuildingSceneLayerLoader: () => I3SBuildingSceneLayerLoader,
    I3SContentLoader: () => I3SContentLoader,
    I3SLoader: () => I3SLoader,
    SLPKLoader: () => SLPKLoader,
    loadFeatureAttributes: () => loadFeatureAttributes
  });
  var init_src10 = __esm({
    "src/index.ts"() {
      init_i3s_loader();
      init_i3s_slpk_loader();
      init_i3s_content_loader();
      init_i3s_attribute_loader();
      init_i3s_building_scene_layer_loader();
      init_arcgis_webscene_loader();
      init_constants2();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src10(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
