/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.dominatorTrees;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms.Dominators;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.PrecsGraphView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.Solver;
import java.util.BitSet;
import java.util.logging.Logger;

public class DominatorView {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected Solver solver;
    protected int nbNodes;
    protected VarGraphView graph;
    protected PrecsGraphView precs;
    protected Dominators dom;
    protected BitSet[][] dominators;
    protected boolean update;

    public DominatorView(Solver solver, VarGraphView graph, PrecsGraphView precs) {
        this.solver = solver;
        this.graph = graph;
        this.precs = precs;
        this.nbNodes = graph.getNbNodes();
        this.dominators = new BitSet[this.nbNodes][this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                this.dominators[i][j] = new BitSet(this.nbNodes);
                this.dominators[i][j].set(0, this.nbNodes, true);
            }
        }
        this.dom = new Dominators(graph, precs);
        this.updateDominators();
    }

    public void updateDominators() {
        this.dominators = this.dom.computeDominators();
    }

    private void updateDoms(BitSet[][] newDoms) {
        this.update = false;
        for (int i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                int k = newDoms[i][j].nextSetBit(0);
                while (k >= 0) {
                    if (!this.dominators[i][j].get(k)) {
                        this.dominators[i][j].set(k, true);
                        this.update = true;
                    }
                    k = newDoms[i][j].nextSetBit(k + 1);
                }
                k = this.dominators[i][j].nextSetBit(0);
                while (k >= 0) {
                    if (!newDoms[i][j].get(k)) {
                        this.dominators[i][j].set(k, false);
                        this.update = true;
                    }
                    k = this.dominators[i][j].nextSetBit(k + 1);
                }
            }
        }
    }

    public BitSet[][] getDominators() {
        return this.dominators;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void showDoms(int i) {
        for (int j = 0; j < this.nbNodes; ++j) {
            if (j == i) continue;
            this.showDoms(i, j);
        }
    }

    public void showDoms(int i, int j) {
        LOGGER.info("dom[" + i + "][" + j + "] = " + this.dominators[i][j].toString());
    }
}

