/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing.trail;

import choco.kernel.memory.trailing.StoredLongVector;
import choco.kernel.memory.trailing.trail.ITrailStorage;

public class StoredLongVectorTrail
implements ITrailStorage {
    private StoredLongVector[] vectorStack;
    private int[] indexStack;
    private long[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;
    private int maxUpdates = 0;

    public StoredLongVectorTrail(int nUpdates, int nWorlds) {
        this.maxUpdates = nUpdates;
        this.vectorStack = new StoredLongVector[nUpdates];
        this.indexStack = new int[nUpdates];
        this.valueStack = new long[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void clear() {
        this.currentLevel = 0;
    }

    public void savePreviousState(StoredLongVector vect, int index, long oldValue, int oldStamp) {
        this.vectorStack[this.currentLevel] = vect;
        this.indexStack[this.currentLevel] = index;
        this.stampStack[this.currentLevel] = oldStamp;
        this.valueStack[this.currentLevel] = oldValue;
        ++this.currentLevel;
        if (this.currentLevel == this.maxUpdates) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.maxUpdates * 3 / 2;
        StoredLongVector[] tmp1 = new StoredLongVector[newCapacity];
        System.arraycopy(this.vectorStack, 0, tmp1, 0, this.vectorStack.length);
        this.vectorStack = tmp1;
        long[] tmp2 = new long[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
        int[] tmp4 = new int[newCapacity];
        System.arraycopy(this.indexStack, 0, tmp4, 0, this.indexStack.length);
        this.indexStack = tmp4;
        this.maxUpdates = newCapacity;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }

    @Override
    public void worldPush(int wi) {
        this.worldStartLevels[wi] = this.currentLevel;
    }

    @Override
    public void worldPop(int wi) {
        while (this.currentLevel > this.worldStartLevels[wi]) {
            --this.currentLevel;
            StoredLongVector v = this.vectorStack[this.currentLevel];
            v._set(this.indexStack[this.currentLevel], this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public void worldCommit(int wi) {
        int startLevel = this.worldStartLevels[wi];
        int prevWorld = wi - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredLongVector var = this.vectorStack[level];
            int idx = this.indexStack[level];
            long val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.worldStamps[idx] = prevWorld;
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.indexStack[writeIdx] = idx;
                this.vectorStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public int getSize() {
        return this.currentLevel;
    }
}

