/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.DirectByteArrayOutputStream;
import org.jpmml.model.cells.ObjectFactory;
import org.xml.sax.SAXException;

public class JAXBUtil {
    private static Schema schema = null;
    private static JAXBContext context = null;

    private JAXBUtil() {
    }

    public static PMML unmarshalPMML(Source source) throws JAXBException {
        return (PMML)JAXBUtil.unmarshal(source);
    }

    public static Object unmarshal(Source source) throws JAXBException {
        Unmarshaller unmarshaller = JAXBUtil.createUnmarshaller();
        return unmarshaller.unmarshal(source);
    }

    public static void marshalPMML(PMML pmml, Result result) throws JAXBException {
        JAXBUtil.marshal(pmml, result);
    }

    public static void marshal(Object object, Result result) throws JAXBException {
        Marshaller marshaller = JAXBUtil.createMarshaller();
        marshaller.marshal(object, result);
    }

    public static Schema getSchema() throws IOException, SAXException {
        if (schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = org.dmg.pmml.ObjectFactory.class.getResource("/pmml.xsd");
            if (url == null) {
                throw new FileNotFoundException();
            }
            schema = schemaFactory.newSchema(url);
        }
        return schema;
    }

    public static JAXBContext getContext() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])JAXBUtil.getObjectFactoryClasses());
        }
        return context;
    }

    public static void setContext(JAXBContext context) {
        JAXBUtil.context = context;
    }

    public static Class<?>[] getObjectFactoryClasses() {
        return new Class[]{org.dmg.pmml.ObjectFactory.class, org.dmg.pmml.anomaly_detection.ObjectFactory.class, org.dmg.pmml.association.ObjectFactory.class, org.dmg.pmml.baseline.ObjectFactory.class, org.dmg.pmml.bayesian_network.ObjectFactory.class, org.dmg.pmml.clustering.ObjectFactory.class, org.dmg.pmml.gaussian_process.ObjectFactory.class, org.dmg.pmml.general_regression.ObjectFactory.class, org.dmg.pmml.mining.ObjectFactory.class, org.dmg.pmml.naive_bayes.ObjectFactory.class, org.dmg.pmml.nearest_neighbor.ObjectFactory.class, org.dmg.pmml.neural_network.ObjectFactory.class, org.dmg.pmml.regression.ObjectFactory.class, org.dmg.pmml.rule_set.ObjectFactory.class, org.dmg.pmml.scorecard.ObjectFactory.class, org.dmg.pmml.sequence.ObjectFactory.class, org.dmg.pmml.support_vector_machine.ObjectFactory.class, org.dmg.pmml.text.ObjectFactory.class, org.dmg.pmml.time_series.ObjectFactory.class, org.dmg.pmml.tree.ObjectFactory.class, ObjectFactory.class};
    }

    public static Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = JAXBUtil.getContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBUtil.getContext();
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    public static <E extends PMMLObject> E clone(E object) throws JAXBException, IOException {
        return JAXBUtil.clone(JAXBUtil.getContext(), object);
    }

    public static <E extends PMMLObject> E clone(JAXBContext context, E object) throws JAXBException, IOException {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(0x100000);
        Marshaller marshaller = context.createMarshaller();
        try (DirectByteArrayOutputStream os = buffer;){
            marshaller.marshal(object, (OutputStream)os);
        }
        Unmarshaller unmarshaller = context.createUnmarshaller();
        try (InputStream is = buffer.getInputStream();){
            PMMLObject pMMLObject = (PMMLObject)unmarshaller.unmarshal(is);
            return (E)pMMLObject;
        }
    }
}

