/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.ISolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.QuickXPlain;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.InvalidSolutionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.learn.AbstractEventObserver;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.Reporting;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.loop.learn.LearnNothing;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;
import org.chocosolver.solver.search.loop.monitors.SearchMonitorList;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.loop.move.MoveSeq;
import org.chocosolver.solver.search.loop.propagate.Propagate;
import org.chocosolver.solver.search.loop.propagate.PropagateBasic;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.measure.MeasuresRecorder;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.WarmStart;
import org.chocosolver.solver.trace.IOutputFactory;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.criteria.Criterion;
import org.chocosolver.util.logger.ANSILogger;
import org.chocosolver.util.logger.Logger;

public class Solver
implements ISolver,
IMeasures,
IOutputFactory {
    protected Propagate P;
    protected Learn L;
    protected Move M;
    protected Model mModel;
    protected IObjectiveManager objectivemanager;
    protected Action action;
    protected MeasuresRecorder mMeasures;
    protected DecisionPath dpath;
    private int rootWorldIndex = 0;
    private int searchWorldIndex = 0;
    protected List<Criterion> criteria;
    private boolean defaultSearch = false;
    private boolean completeSearch = false;
    private AbstractEventObserver eventObserver;
    protected SearchMonitorList searchMonitors;
    protected PropagationEngine engine;
    protected final ContradictionException exception;
    protected ESat feasible = ESat.UNDEFINED;
    private int jumpTo;
    protected boolean stop;
    private boolean canBeRepaired = true;
    private Solution lastSol = null;
    private WarmStart warmStart = null;
    private Logger logger = new ANSILogger();

    protected Solver(Model aModel) {
        this.mModel = aModel;
        this.engine = new PropagationEngine(this.mModel);
        this.exception = new ContradictionException();
        this.eventObserver = AbstractEventObserver.SILENT_OBSERVER;
        this.objectivemanager = ObjectiveFactory.SAT();
        this.dpath = new DecisionPath(aModel.getEnvironment());
        this.action = Action.initialize;
        this.mMeasures = new MeasuresRecorder(this.mModel.getName());
        this.criteria = new ArrayList<Criterion>();
        this.mMeasures.setSearchState(SearchState.NEW);
        this.mMeasures.setBoundsManager(this.objectivemanager);
        this.searchMonitors = new SearchMonitorList();
        this.setMove(new MoveBinaryDFS());
        this.setPropagate(new PropagateBasic());
        this.setNoLearning();
    }

    public void throwsException(ICause c, Variable v, String s) throws ContradictionException {
        throw this.exception.set(c, v, s);
    }

    public ContradictionException getContradictionException() {
        return this.exception;
    }

    public boolean solve() {
        boolean satPb;
        this.mMeasures.setSearchState(SearchState.RUNNING);
        boolean bl = satPb = this.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION;
        if (this.getModel().getObjective() == null && !satPb) {
            throw new SolverException("No objective variable has been defined whereas policy implies optimization");
        }
        boolean bl2 = this.stop = !this.canBeRepaired;
        if (this.action == Action.initialize) {
            this.searchMonitors.beforeInitialize();
            boolean ok = this.initialize();
            this.searchMonitors.afterInitialize(ok);
        }
        boolean newSolutionFound = this.searchLoop();
        this.searchMonitors.beforeClose();
        this.closeSearch();
        this.searchMonitors.afterClose();
        return newSolutionFound;
    }

    public boolean searchLoop() {
        boolean solution = false;
        boolean left = true;
        Thread th = Thread.currentThread();
        block8: while (!this.stop) {
            this.stop = this.isStopCriterionMet();
            if (this.stop || th.isInterrupted()) {
                if (this.stop) {
                    this.mMeasures.setSearchState(SearchState.STOPPED);
                } else {
                    this.mMeasures.setSearchState(SearchState.KILLED);
                }
            }
            switch (this.action) {
                case initialize: {
                    throw new UnsupportedOperationException("should not initialize during search loop");
                }
                case propagate: {
                    this.propagate(left);
                    continue block8;
                }
                case fixpoint: {
                    this.fixpoint();
                    continue block8;
                }
                case extend: {
                    left = true;
                    this.extend();
                    continue block8;
                }
                case repair: {
                    left = false;
                    this.repair();
                    continue block8;
                }
                case validate: {
                    this.stop = solution = this.validate();
                    continue block8;
                }
            }
            throw new SolverException("Invalid Solver loop action " + (Object)((Object)this.action));
        }
        return solution;
    }

    protected boolean initialize() {
        AbstractStrategy<Variable> declared;
        Optional<Constraint> undeclared;
        Set instances;
        boolean ok = true;
        if (this.mModel.getSettings().checkDeclaredConstraints() && (instances = (Set)this.mModel.getHook("cinstances")) != null && (undeclared = instances.stream().filter(c -> c.getStatus() == Constraint.Status.FREE).findFirst()).isPresent()) {
            this.logger.white().println("At least one constraint is free, i.e., neither posted or reified. ).");
            instances.stream().filter(c -> c.getStatus() == Constraint.Status.FREE).limit(this.mModel.getSettings().printAllUndeclaredConstraints() ? Integer.MAX_VALUE : 1L).forEach(c -> this.logger.white().printf(String.format("%s is free\n", c), new Object[0]));
        }
        this.engine.initialize();
        this.getMeasures().setReadingTimeCount(System.nanoTime() - this.mModel.getCreationTime());
        this.mMeasures.startStopwatch();
        this.rootWorldIndex = this.mModel.getEnvironment().getWorldIndex();
        this.M.setTopDecisionPosition(0);
        this.mModel.getEnvironment().worldPush();
        try {
            if (this.mModel.getHook("H_TASKSET") != null) {
                ArrayList tset = (ArrayList)this.mModel.getHook("H_TASKSET");
                for (int i = 0; i < tset.size(); ++i) {
                    ((Task)tset.get(i)).ensureBoundConsistency();
                }
            }
            this.mMeasures.incFixpointCount();
            this.P.execute(this);
            this.action = Action.extend;
            this.mModel.getEnvironment().worldPush();
            this.searchWorldIndex = this.mModel.getEnvironment().getWorldIndex();
            this.mModel.getEnvironment().worldPush();
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.mMeasures.incFailCount();
            this.searchMonitors.onContradiction(ce);
            this.L.record(this);
            this.L.forget(this);
            this.mModel.getEnvironment().worldPop();
            this.stop = true;
            ok = false;
        }
        if (this.M.getChildMoves().size() <= 1 && this.M.getStrategy() == null) {
            if (this.getModel().getSettings().warnUser()) {
                this.logger.white().println("No search strategies defined.");
                this.logger.white().println("Set to default ones.");
            }
            this.defaultSearch = true;
            this.setSearch(this.mModel.getSettings().makeDefaultSearch(this.mModel));
        }
        if (this.completeSearch && !this.defaultSearch) {
            declared = this.M.getStrategy();
            AbstractStrategy<?> complete = this.mModel.getSettings().makeDefaultSearch(this.mModel);
            this.setSearch(declared, complete);
        }
        if (this.warmStart != null) {
            declared = this.M.getStrategy();
            this.warmStart.setStrategy(declared);
            this.setSearch(this.warmStart);
        }
        if (!this.M.init()) {
            this.mModel.getEnvironment().worldPop();
            this.feasible = ESat.FALSE;
            this.engine.flush();
            this.getMeasures().incFailCount();
            this.stop = true;
            ok = true;
        }
        this.criteria.stream().filter(c -> c instanceof ICounter).forEach(c -> ((ICounter)c).init());
        return ok;
    }

    protected void propagate(boolean left) {
        this.searchMonitors.beforeDownBranch(left);
        try {
            this.mMeasures.incFixpointCount();
            this.P.execute(this);
            this.action = Action.extend;
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.mMeasures.incFailCount();
            this.jumpTo = 1;
            this.action = Action.repair;
            this.searchMonitors.onContradiction(ce);
        }
        this.searchMonitors.afterDownBranch(left);
    }

    private void fixpoint() {
        try {
            this.mMeasures.incFixpointCount();
            this.objectivemanager.postDynamicCut();
            this.engine.propagate();
            this.action = Action.propagate;
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.jumpTo = 1;
            this.action = Action.repair;
            this.searchMonitors.onContradiction(ce);
        }
    }

    protected void extend() {
        this.searchMonitors.beforeOpenNode();
        this.mMeasures.incNodeCount();
        this.action = !this.M.extend(this) ? Action.validate : Action.propagate;
        this.searchMonitors.afterOpenNode();
    }

    protected void repair() {
        this.action = this.L.record(this) ? Action.fixpoint : Action.propagate;
        this.searchMonitors.beforeUpBranch();
        this.canBeRepaired = this.M.repair(this);
        this.searchMonitors.afterUpBranch();
        if (!this.canBeRepaired) {
            this.stop = true;
        } else {
            this.L.forget(this);
        }
    }

    private boolean validate() {
        boolean bestSolutionHasBeenUpdated;
        if (!this.getModel().getSettings().checkModel(this)) {
            throw new InvalidSolutionException("The current solution does not satisfy the checker.Either (a) the search strategy is not complete or (b) the model is not constrained enough or (c) a constraint's checker (\"isSatisfied()\") is not correct or (d) some constraints' filtering algorithm (\"propagate(...)\") is not correct.\n" + Reporting.fullReport(this.mModel), this.mModel);
        }
        this.feasible = ESat.TRUE;
        this.mMeasures.incSolutionCount();
        if (this.mModel.getResolutionPolicy() == ResolutionPolicy.SATISFACTION && this.mMeasures.getSolutionCount() == 1L) {
            this.mMeasures.updateTimeToBestSolution();
        } else if (this.mModel.getResolutionPolicy() != ResolutionPolicy.SATISFACTION && (bestSolutionHasBeenUpdated = this.objectivemanager.updateBestSolution())) {
            this.mMeasures.updateTimeToBestSolution();
        }
        this.searchMonitors.onSolution();
        this.jumpTo = 1;
        this.action = Action.repair;
        return true;
    }

    private void closeSearch() {
        if (this.mMeasures.getSearchState() == SearchState.RUNNING) {
            this.mMeasures.setSearchState(SearchState.TERMINATED);
        }
        this.feasible = ESat.FALSE;
        if (this.mMeasures.getSolutionCount() > 0L) {
            this.feasible = ESat.TRUE;
            if (this.objectivemanager.isOptimization()) {
                this.mMeasures.setObjectiveOptimal(!this.isStopCriterionMet());
            }
        } else if (this.isStopCriterionMet()) {
            this.mMeasures.setObjectiveOptimal(false);
            this.feasible = ESat.UNDEFINED;
        }
    }

    public void reset() {
        if (this.rootWorldIndex > -1) {
            this.mModel.getEnvironment().worldPopUntil(this.rootWorldIndex);
        }
        this.searchWorldIndex = 0;
        this.action = Action.initialize;
        this.mMeasures.reset();
        this.engine.reset();
        this.dpath.synchronize();
        this.objectivemanager.resetBestBounds();
        this.removeAllStopCriteria();
        this.feasible = ESat.UNDEFINED;
        this.jumpTo = 0;
        this.stop = false;
        this.canBeRepaired = true;
    }

    public void hardReset() {
        this.reset();
        this.M.removeStrategy();
        this.setMove(new MoveBinaryDFS());
        this.setPropagate(new PropagateBasic());
        this.setNoLearning();
        this.lastSol = null;
        if (this.warmStart != null) {
            this.warmStart.clearHints();
            this.warmStart = null;
        }
        this.searchMonitors.reset();
        this.defaultSearch = false;
        this.completeSearch = false;
        this.mModel.removeMinisat();
    }

    public void propagate() throws ContradictionException {
        if (!this.engine.isInitialized()) {
            this.engine.initialize();
        }
        if (this.mModel.getHook("H_TASKSET") != null) {
            ArrayList tset = (ArrayList)this.mModel.getHook("H_TASKSET");
            for (int i = 0; i < tset.size(); ++i) {
                ((Task)tset.get(i)).ensureBoundConsistency();
            }
        }
        try {
            this.engine.propagate();
        }
        finally {
            this.engine.flush();
        }
    }

    public List<Constraint> findMinimumConflictingSet(List<Constraint> conflictingSet) {
        if (this.isSolving()) {
            throw new SolverException("Minimum Conflicting Set (MCS) can't be executed during solving");
        }
        return new QuickXPlain(this.getModel()).findMinimumConflictingSet(conflictingSet);
    }

    public void restart() {
        this.searchMonitors.beforeRestart();
        this.restoreRootNode();
        this.mModel.getEnvironment().worldPush();
        this.getMeasures().incRestartCount();
        try {
            this.objectivemanager.postDynamicCut();
            this.mMeasures.incFixpointCount();
            this.P.execute(this);
            this.action = Action.extend;
        }
        catch (ContradictionException e) {
            this.stop = true;
        }
        this.searchMonitors.afterRestart();
    }

    private void restoreRootNode() {
        IEnvironment environment = this.mModel.getEnvironment();
        while (environment.getWorldIndex() > this.searchWorldIndex) {
            this.getMeasures().incBackTrackCount();
            environment.worldPop();
        }
        this.dpath.synchronize();
    }

    public boolean moveForward(Decision<?> decision) {
        if (!this.engine.isInitialized()) {
            this.engine.initialize();
        }
        if (this.getEnvironment().getWorldIndex() == 0) {
            this.getEnvironment().worldPush();
        }
        boolean success = true;
        if (decision != null) {
            this.getDecisionPath().pushDecision(decision);
            this.getEnvironment().worldPush();
            this.getDecisionPath().buildNext();
        }
        try {
            this.getDecisionPath().apply();
            this.getObjectiveManager().postDynamicCut();
            this.getEngine().propagate();
        }
        catch (ContradictionException cex) {
            this.engine.flush();
            success = false;
        }
        return success;
    }

    public boolean moveBackward() {
        this.getEnvironment().worldPop();
        boolean success = false;
        Decision head = this.dpath.getLastDecision();
        while (!success && head.getPosition() > 0) {
            if (head.hasNext()) {
                this.getEnvironment().worldPush();
                this.getDecisionPath().buildNext();
                try {
                    this.getDecisionPath().apply();
                    this.getObjectiveManager().postDynamicCut();
                    this.getEngine().propagate();
                    success = true;
                }
                catch (ContradictionException cex) {
                    this.engine.flush();
                }
            } else {
                this.dpath.synchronize();
                this.getEnvironment().worldPop();
            }
            head = this.dpath.getLastDecision();
        }
        return success;
    }

    public boolean isSolving() {
        boolean isSearching = this.getSearchState() != SearchState.NEW;
        boolean isTrailing = this.getEnvironment().getWorldIndex() > this.rootWorldIndex;
        return isSearching || isTrailing;
    }

    public Model getModel() {
        return this.mModel;
    }

    public Learn getLearner() {
        return this.L;
    }

    public Move getMove() {
        return this.M;
    }

    public Propagate getPropagate() {
        return this.P;
    }

    public IEnvironment getEnvironment() {
        return this.getModel().getEnvironment();
    }

    public DecisionPath getDecisionPath() {
        return this.dpath;
    }

    public <V extends Variable> AbstractStrategy<V> getSearch() {
        if (this.M.getChildMoves().size() > 1 && this.mModel.getSettings().warnUser()) {
            this.logger.bold().println("This search loop is based on a sequential Move, the returned strategy may not reflect the reality.");
        }
        return this.M.getStrategy();
    }

    public <V extends Variable> IObjectiveManager<V> getObjectiveManager() {
        return this.objectivemanager;
    }

    public boolean isDefaultSearchUsed() {
        return this.defaultSearch;
    }

    public boolean isSearchCompleted() {
        return this.completeSearch;
    }

    public boolean hasEndedUnexpectedly() {
        return this.mMeasures.getSearchState() == SearchState.KILLED;
    }

    public boolean isStopCriterionMet() {
        boolean ismet = false;
        for (int i = 0; i < this.criteria.size() && !ismet; ++i) {
            ismet = this.criteria.get(i).isMet();
        }
        return ismet;
    }

    public int getSearchWorldIndex() {
        return this.searchWorldIndex;
    }

    public MeasuresRecorder getMeasures() {
        return this.mMeasures;
    }

    public AbstractEventObserver getEventObserver() {
        return this.eventObserver;
    }

    public PropagationEngine getEngine() {
        return this.engine;
    }

    public ESat isFeasible() {
        return this.feasible;
    }

    public ESat isSatisfied() {
        int OK = 0;
        for (Constraint c : this.mModel.getCstrs()) {
            if (c.isEnabled()) {
                ESat satC = c.isSatisfied();
                if (ESat.FALSE == satC) {
                    if (this.getModel().getSettings().warnUser()) {
                        this.logger.bold().red().printf("FAILURE >> %s (%s)%n", new Object[]{c, satC});
                    }
                    return ESat.FALSE;
                }
                if (ESat.TRUE != satC) continue;
                ++OK;
                continue;
            }
            ++OK;
        }
        if (OK == this.mModel.getCstrs().length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public int getJumpTo() {
        return this.jumpTo;
    }

    public boolean isLearnOff() {
        return this.L instanceof LearnNothing;
    }

    public void setLearner(Learn l) {
        this.L = l;
    }

    public void setMove(Move ... m) {
        this.M = m == null ? null : (m.length == 1 ? m[0] : new MoveSeq(this.getModel(), m));
    }

    public void setPropagate(Propagate p) {
        this.P = p;
    }

    public void setObjectiveManager(IObjectiveManager<?> om) {
        this.objectivemanager = om;
        this.mMeasures.setBoundsManager(om);
    }

    public void setSearch(AbstractStrategy ... strategies) {
        if (strategies == null || strategies.length == 0) {
            throw new UnsupportedOperationException("no search strategy has been specified");
        }
        if (this.M.getChildMoves().size() > 1) {
            throw new UnsupportedOperationException("The Move declared is composed of many Moves.\nA strategy must be attached to each of them independently, and it cannot be achieved calling this method.An iteration over it child moves is needed: this.getMove().getChildMoves().");
        }
        this.M.setStrategy(strategies.length == 1 ? strategies[0] : Search.sequencer(strategies));
    }

    public void setEventObserver(AbstractEventObserver explainer) {
        this.eventObserver = explainer;
    }

    public void setEngine(PropagationEngine propagationEngine) {
        if (this.engine.isInitialized() && this.getEnvironment().getWorldIndex() != this.rootWorldIndex) {
            throw new SolverException("Illegal propagation engine modification.");
        }
        this.engine = propagationEngine;
    }

    public void makeCompleteStrategy(boolean isComplete) {
        this.completeSearch = isComplete;
    }

    public void addHint(IntVar var, int val) {
        if (this.warmStart == null) {
            this.warmStart = new WarmStart(this);
        }
        this.warmStart.addHint(var, val);
    }

    public void removeHints() {
        this.setSearch(this.warmStart.getStrategy());
        this.warmStart.clearHints();
        this.warmStart = null;
    }

    public void addStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            Collections.addAll(this.criteria, criterion);
        }
    }

    public void removeStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            for (Criterion c : criterion) {
                this.criteria.remove(c);
            }
        }
    }

    public void removeAllStopCriteria() {
        this.criteria.clear();
    }

    public SearchMonitorList getSearchMonitors() {
        return this.searchMonitors;
    }

    public void plugMonitor(ISearchMonitor sm) {
        this.searchMonitors.add(sm);
    }

    public void unplugMonitor(ISearchMonitor sm) {
        this.searchMonitors.remove(sm);
    }

    public void unplugAllSearchMonitors() {
        this.searchMonitors.reset();
    }

    public void setJumpTo(int jto) {
        this.jumpTo = jto;
    }

    public Solution defaultSolution() {
        if (this.lastSol == null) {
            this.lastSol = new Solution(this.getModel(), new Variable[0]);
            this.attach(this.lastSol);
        }
        return this.lastSol;
    }

    @Override
    public Solver ref() {
        return this;
    }

    @Override
    public String getModelName() {
        return this.getMeasures().getModelName();
    }

    @Override
    public long getTimestamp() {
        return this.getMeasures().getTimestamp();
    }

    @Override
    public float getTimeCount() {
        return this.getMeasures().getTimeCount();
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        return this.getMeasures().getTimeCountInNanoSeconds();
    }

    @Override
    public long getTimeToBestSolutionInNanoSeconds() {
        return this.getMeasures().getTimeToBestSolutionInNanoSeconds();
    }

    @Override
    public long getReadingTimeCountInNanoSeconds() {
        return this.getMeasures().getReadingTimeCountInNanoSeconds();
    }

    @Override
    public float getReadingTimeCount() {
        return this.getMeasures().getReadingTimeCount();
    }

    @Override
    public long getNodeCount() {
        return this.getMeasures().getNodeCount();
    }

    @Override
    public long getBackTrackCount() {
        return this.getMeasures().getBackTrackCount();
    }

    @Override
    public long getBackjumpCount() {
        return this.getMeasures().getBackjumpCount();
    }

    @Override
    public long getFailCount() {
        return this.getMeasures().getFailCount();
    }

    @Override
    public long getFixpointCount() {
        return this.getMeasures().getFixpointCount();
    }

    @Override
    public long getRestartCount() {
        return this.getMeasures().getRestartCount();
    }

    @Override
    public long getSolutionCount() {
        return this.getMeasures().getSolutionCount();
    }

    @Override
    public long getDecisionCount() {
        return this.getMeasures().getDecisionCount();
    }

    @Override
    public long getMaxDepth() {
        return this.getMeasures().getMaxDepth();
    }

    @Override
    public long getCurrentDepth() {
        return this.getDecisionPath().size();
    }

    @Override
    public boolean hasObjective() {
        return this.getMeasures().hasObjective();
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.getMeasures().isObjectiveOptimal();
    }

    @Override
    public Number getBestSolutionValue() {
        return this.getMeasures().getBestSolutionValue();
    }

    @Override
    public SearchState getSearchState() {
        return this.getMeasures().getSearchState();
    }

    @Override
    public IBoundsManager getBoundsManager() {
        assert (this.getMeasures().getBoundsManager() == this.objectivemanager);
        return this.getMeasures().getBoundsManager();
    }

    public Logger log() {
        return this.logger;
    }

    public void logWithANSI(boolean ansi) {
        this.logger = ansi ? new ANSILogger(this.logger) : new Logger(this.logger);
    }

    public static enum Action {
        initialize,
        propagate,
        fixpoint,
        extend,
        validate,
        repair;

    }
}

