/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;

public class BOLE
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "drift.SingleClassifierDrift -l trees.HoeffdingTree -d (DDM -n 7 -w 1.2 -o 1.95)");
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models to boost.", 10, 1, Integer.MAX_VALUE);
    public FlagOption pureBoostOption = new FlagOption("pureBoost", 'p', "Boost with weights only; no poisson.");
    public FlagOption breakVotesOption = new FlagOption("breakVotes", 'b', "Break Votes? unchecked=no, checked=yes");
    public FloatOption errorBoundOption = new FloatOption("errorBound", 'e', "Error bound percentage for allowing experts to vote.", 0.5, 0.1, 1.0);
    public FloatOption weightShiftOption = new FloatOption("weightShift", 'w', "Weight shift associated with the error bound.", 0.0, 0.0, 5.0);
    private double memberWeight;
    private double key_acc;
    private int key_position;
    private int i;
    private int j;
    private int maxAcc;
    private int minAcc;
    private int pos;
    private double lambda_d;
    private double k;
    private boolean correct;
    private boolean okay;
    private double em;
    private double Bm;
    protected Classifier[] ensemble;
    protected int[] orderPosition;
    protected double[] scms;
    protected double[] swms;

    @Override
    public String getPurposeString() {
        return "Boosting-like Online Learning Ensemble (BOLE)";
    }

    @Override
    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        this.orderPosition = new int[this.ensemble.length];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        this.i = 0;
        while (this.i < this.ensemble.length) {
            this.ensemble[this.i] = baseLearner.copy();
            this.orderPosition[this.i] = this.i;
            ++this.i;
        }
        this.scms = new double[this.ensemble.length];
        this.swms = new double[this.ensemble.length];
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        double[] acc = new double[this.ensemble.length];
        this.i = 0;
        while (this.i < this.ensemble.length) {
            acc[this.i] = this.scms[this.orderPosition[this.i]] + this.swms[this.orderPosition[this.i]];
            if (acc[this.i] != 0.0) {
                acc[this.i] = this.scms[this.orderPosition[this.i]] / acc[this.i];
            }
            ++this.i;
        }
        this.i = 1;
        while (this.i < this.ensemble.length) {
            this.key_position = this.orderPosition[this.i];
            this.key_acc = acc[this.i];
            this.j = this.i - 1;
            while (this.j >= 0 && acc[this.j] < this.key_acc) {
                this.orderPosition[this.j + 1] = this.orderPosition[this.j];
                acc[this.j + 1] = acc[this.j];
                --this.j;
            }
            this.orderPosition[this.j + 1] = this.key_position;
            acc[this.j + 1] = this.key_acc;
            ++this.i;
        }
        this.correct = false;
        this.maxAcc = 0;
        this.minAcc = this.ensemble.length - 1;
        this.lambda_d = 1.0;
        this.i = 0;
        while (this.i < this.ensemble.length) {
            if (this.correct) {
                this.pos = this.orderPosition[this.maxAcc];
                ++this.maxAcc;
            } else {
                this.pos = this.orderPosition[this.minAcc];
                --this.minAcc;
            }
            this.k = this.pureBoostOption.isSet() ? this.lambda_d : (double)MiscUtils.poisson(this.lambda_d, this.classifierRandom);
            if (this.k > 0.0) {
                Instance weightedInst = inst.copy();
                weightedInst.setWeight(inst.weight() * this.k);
                this.ensemble[this.pos].trainOnInstance(weightedInst);
            }
            if (this.ensemble[this.pos].correctlyClassifies(inst)) {
                int n = this.pos;
                this.scms[n] = this.scms[n] + this.lambda_d;
                this.lambda_d *= this.trainingWeightSeenByModel / (2.0 * this.scms[this.pos]);
                this.correct = true;
            } else {
                int n = this.pos;
                this.swms[n] = this.swms[n] + this.lambda_d;
                this.lambda_d *= this.trainingWeightSeenByModel / (2.0 * this.swms[this.pos]);
                this.correct = false;
            }
            ++this.i;
        }
    }

    protected double getEnsembleMemberWeight(int i) {
        if (this.scms[i] > 0.0 && this.swms[i] > 0.0) {
            this.em = this.swms[i] / (this.scms[i] + this.swms[i]);
            if (this.em <= this.errorBoundOption.getValue()) {
                this.Bm = this.em / (1.0 - this.em);
                this.okay = true;
                return Math.log(1.0 / this.Bm);
            }
        }
        this.okay = false;
        return 0.0;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        this.i = 0;
        while (this.i < this.ensemble.length) {
            this.memberWeight = this.getEnsembleMemberWeight(this.i) + this.weightShiftOption.getValue();
            if (this.okay) {
                DoubleVector vote = new DoubleVector(this.ensemble[this.i].getVotesForInstance(inst));
                if (vote.sumOfValues() > 0.0) {
                    vote.normalize();
                    vote.scaleValues(this.memberWeight);
                    combinedVote.addValues(vote);
                }
            } else if (this.breakVotesOption.isSet()) break;
            ++this.i;
        }
        return combinedVote.getArrayRef();
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0)};
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }
}

