/*
 * Decompiled with CFR 0.152.
 */
package OpenSourceExtensions;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class TDoubleHashSetAndArray
extends AbstractDoubleSet
implements DoubleSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private DoubleArrayList array;
    private DoubleOpenHashSet set;

    public TDoubleHashSetAndArray() {
        this(16, 0.5f);
    }

    public TDoubleHashSetAndArray(int n) {
        this(n, 0.5f);
    }

    public TDoubleHashSetAndArray(int n, float f) {
        this.array = new DoubleArrayList(n);
        this.set = new DoubleOpenHashSet(n, f);
    }

    public TDoubleHashSetAndArray(int n, float f, double d) {
        this(n, f);
    }

    public TDoubleHashSetAndArray(Collection<? extends Double> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public TDoubleHashSetAndArray(DoubleCollection doubleCollection) {
        this(doubleCollection.size());
        this.addAll(doubleCollection);
    }

    public TDoubleHashSetAndArray(double[] dArray) {
        this(dArray.length);
        int n = dArray.length;
        while (n-- > 0) {
            this.add(dArray[n]);
        }
    }

    public boolean add(double d) {
        if (d == -0.0) {
            d = 0.0;
        }
        if (this.set.add(d)) {
            this.array.add(d);
            return true;
        }
        return false;
    }

    public boolean remove(double d) {
        if (d == -0.0) {
            d = 0.0;
        }
        boolean bl = this.set.remove(d);
        boolean bl2 = this.array.rem(d);
        return bl || bl2;
    }

    public boolean contains(double d) {
        if (d == -0.0) {
            d = 0.0;
        }
        return this.set.contains(d);
    }

    public DoubleIterator iterator() {
        return this.array.iterator();
    }

    public int size() {
        return this.array.size();
    }

    public double getAtIndex(int n) {
        return this.array.getDouble(n);
    }

    public double[] toDoubleArray() {
        return this.array.toDoubleArray();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeInt(this.size());
        DoubleListIterator doubleListIterator = this.array.iterator();
        while (doubleListIterator.hasNext()) {
            objectOutput.writeDouble(doubleListIterator.nextDouble());
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        int n = objectInput.readInt();
        this.array = new DoubleArrayList(n);
        this.set = new DoubleOpenHashSet(n);
        for (int i = 0; i < n; ++i) {
            this.add(objectInput.readDouble());
        }
    }
}

