/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.IOException;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpUtil;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public abstract class RExp {
    private RPair attributes = null;

    public RExp(RPair attributes) {
        this.setAttributes(attributes);
    }

    public void write(RDataOutput output) throws IOException {
        throw new UnsupportedOperationException();
    }

    public RStringVector _class() {
        return this.getStringAttribute("class");
    }

    public RStringVector names() {
        return this.getStringAttribute("names");
    }

    public RIntegerVector dim() {
        return this.getIntegerAttribute("dim");
    }

    public RStringVector dimnames(int index) {
        RGenericVector dimnames = this.getGenericAttribute("dimnames");
        return dimnames.getStringValue(index);
    }

    public RExp getAttribute(String name) {
        return this.getAttribute(name, true);
    }

    public RExp getAttribute(String name, boolean required) {
        return this.findAttribute(name, required);
    }

    public RBooleanVector getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, true);
    }

    public RBooleanVector getBooleanAttribute(String name, boolean required) {
        return this.getVectorAttribute(RBooleanVector.class, name, required);
    }

    public RDoubleVector getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, true);
    }

    public RDoubleVector getDoubleAttribute(String name, boolean required) {
        return this.getVectorAttribute(RDoubleVector.class, name, required);
    }

    public RGenericVector getGenericAttribute(String name) {
        return this.getGenericAttribute(name, true);
    }

    public RGenericVector getGenericAttribute(String name, boolean required) {
        return this.getVectorAttribute(RGenericVector.class, name, required);
    }

    public RIntegerVector getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, true);
    }

    public RIntegerVector getIntegerAttribute(String name, boolean required) {
        return this.getVectorAttribute(RIntegerVector.class, name, required);
    }

    public RStringVector getStringAttribute(String name) {
        return this.getStringAttribute(name, true);
    }

    public RStringVector getStringAttribute(String name, boolean required) {
        return this.getVectorAttribute(RStringVector.class, name, required);
    }

    private <V extends RVector<E>, E> V getVectorAttribute(Class<V> clazz, String name, boolean required) {
        RExp rexp = this.getAttribute(name, required);
        try {
            return (V)((RVector)clazz.cast(rexp));
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Invalid '" + name + "' attribute. Expected " + RExpUtil.getVectorType(clazz) + ", got " + RExpUtil.getVectorType(rexp.getClass()));
        }
    }

    public boolean hasAttribute(String name) {
        for (RPair attributes = this.getAttributes(); attributes != null; attributes = attributes.getNext()) {
            if (!attributes.tagEquals(name)) continue;
            return true;
        }
        return false;
    }

    private RExp findAttribute(String name, boolean required) {
        for (RPair attributes = this.getAttributes(); attributes != null; attributes = attributes.getNext()) {
            if (!attributes.tagEquals(name)) continue;
            return attributes.getValue();
        }
        if (required) {
            throw new IllegalArgumentException("Missing '" + name + "' attribute");
        }
        return null;
    }

    public void addAttribute(String name, RExp rexp) {
        this.addAttribute(new RPair(new RString(name), rexp, null));
    }

    public void addAttribute(RPair pair) {
        RPair next;
        RPair attributes = this.getAttributes();
        if (attributes == null) {
            this.setAttributes(pair);
            return;
        }
        while (attributes != null && (next = attributes.getNext()) != null) {
            attributes = next;
        }
        attributes.setNext(pair);
    }

    public RPair getAttributes() {
        return this.attributes;
    }

    void setAttributes(RPair attributes) {
        this.attributes = attributes;
    }
}

