/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateFilteringResults;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateUpdateInformation;

public class MultivariateOrdinaryFilter {
    private final Initializer initializer;
    private State state;
    private MultivariateUpdateInformation updinfo;
    private IMultivariateSsf ssf;
    private ISsfMeasurements measurements;
    private ISsfDynamics dynamics;
    private IMultivariateSsfData data;

    public MultivariateOrdinaryFilter() {
        this.initializer = null;
    }

    public MultivariateOrdinaryFilter(Initializer initializer) {
        this.initializer = initializer;
    }

    protected void pred(int pos) {
        this.dynamics.TX(pos, this.state.a());
        this.dynamics.TVT(pos, this.state.P());
        this.dynamics.addV(pos, this.state.P());
    }

    protected void error(int pos) {
        int dim = this.ssf.getStateDim();
        UpdateInformation.Status[] status = new UpdateInformation.Status[this.data.getVarsCount()];
        int nv = MultivariateUpdateInformation.fillStatus(this.data, pos, status);
        if (nv > 0) {
            FastMatrix M = FastMatrix.make(dim, nv);
            FastMatrix R = FastMatrix.square(nv);
            double[] E = new double[nv];
            this.MZt(pos, status, this.state.P(), M);
            this.ZM(pos, status, M, R);
            this.addH(pos, status, R);
            SymmetricMatrix.reenforceSymmetry(R);
            SymmetricMatrix.lcholesky(R, 1.0E-9);
            LowerTriangularMatrix.solveXLt(R, M, 1.0E-9);
            int iv = 0;
            for (int i = 0; i < status.length; ++i) {
                if (status[i] == UpdateInformation.Status.MISSING) continue;
                double y = this.data.get(pos, i);
                E[iv++] = y - this.measurements.loading(i).ZX(pos, this.state.a());
            }
            this.updinfo = MultivariateUpdateInformation.builder().e(DoubleSeq.of((double[])E)).M(M).R(R).status(status).build();
        } else {
            this.updinfo = null;
        }
    }

    protected void update() {
        if (this.updinfo == null) {
            return;
        }
        int n = this.updinfo.getM().getColumnsCount();
        FastMatrix P = this.state.P();
        FastMatrix M = this.updinfo.getM();
        DoubleSeq U = this.updinfo.getU();
        for (int i = 0; i < n; ++i) {
            P.addXaXt(-1.0, M.column(i));
            this.state.a().addAY(U.get(i), M.column(i));
        }
    }

    public State getState() {
        return this.state;
    }

    private int initialize(IMultivariateSsf ssf, IMultivariateSsfData data) {
        this.data = data;
        this.ssf = ssf;
        this.measurements = ssf.measurements();
        this.dynamics = ssf.dynamics();
        this.updinfo = null;
        if (this.initializer == null) {
            this.state = State.of(ssf);
            return this.state == null ? -1 : 0;
        }
        this.state = new State(ssf.getStateDim());
        return this.initializer.initialize(this.state, ssf, data);
    }

    public boolean process(IMultivariateSsf ssf, IMultivariateSsfData data, IMultivariateFilteringResults rslts) {
        int t = this.initialize(ssf, data);
        if (t < 0) {
            return false;
        }
        if (rslts != null) {
            rslts.open(ssf, this.data);
        }
        int end = data.getObsCount();
        while (t < end) {
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Forecast);
            }
            this.error(t);
            if (rslts != null) {
                rslts.save(t, this.updinfo);
            }
            this.update();
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Concurrent);
            }
            this.pred(t++);
        }
        if (rslts != null) {
            rslts.close();
        }
        return true;
    }

    public void compute(IMultivariateSsf ssf, int t, State state, DoubleSeq x, int[] equations) {
    }

    private void ZM(int t, UpdateInformation.Status[] status, FastMatrix M, FastMatrix zm) {
        DataBlockIterator zrows = zm.rowsIterator();
        for (int i = 0; i < status.length && zrows.hasNext(); ++i) {
            if (status[i] == UpdateInformation.Status.MISSING) continue;
            this.measurements.loading(i).ZM(t, M, zrows.next());
        }
    }

    private void MZt(int t, UpdateInformation.Status[] status, FastMatrix M, FastMatrix zm) {
        DataBlockIterator zcols = zm.columnsIterator();
        for (int i = 0; i < status.length && zcols.hasNext(); ++i) {
            if (status[i] == UpdateInformation.Status.MISSING) continue;
            this.measurements.loading(i).MZt(t, M, zcols.next());
        }
    }

    private void addH(int t, UpdateInformation.Status[] status, FastMatrix F2) {
        ISsfErrors errors = this.measurements.errors();
        if (errors == null) {
            return;
        }
        if (F2.getRowsCount() == status.length) {
            errors.addH(t, F2);
        } else {
            FastMatrix H = FastMatrix.square(status.length);
            errors.H(t, H);
            DataBlock diag = H.diagonal();
            int iv = 0;
            for (int i = 0; i < status.length; ++i) {
                if (status[i] == UpdateInformation.Status.MISSING) continue;
                int jv = 0;
                for (int j = 0; j < i; ++j) {
                    if (status[j] == UpdateInformation.Status.MISSING) continue;
                    double h = H.get(i, j);
                    if (h != 0.0) {
                        F2.add(iv, jv, h);
                        F2.add(jv, iv, h);
                    }
                    ++jv;
                }
                F2.add(iv, iv, diag.get(i));
                ++iv;
            }
        }
    }

    public static interface Initializer {
        public int initialize(State var1, IMultivariateSsf var2, IMultivariateSsfData var3);
    }
}

