/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class ShiftedLoading
implements ISsfLoading {
    private final ISsfLoading loading;
    private final int shift;

    public ShiftedLoading(ISsfLoading loading, int shift) {
        this.loading = loading;
        this.shift = shift;
    }

    @Override
    public boolean isTimeInvariant() {
        return this.loading.isTimeInvariant();
    }

    @Override
    public void Z(int pos, DataBlock z) {
        this.loading.Z(pos + this.shift, z);
    }

    @Override
    public double ZX(int pos, DataBlock b) {
        return this.loading.ZX(pos + this.shift, b);
    }

    @Override
    public double ZVZ(int pos, FastMatrix V) {
        return this.loading.ZVZ(pos + this.shift, V);
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        this.loading.VpZdZ(pos + this.shift, V, d);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.loading.XpZd(pos + this.shift, x, d);
    }
}

